/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.dataview;

import gov.va.med.term.access.maint.ui.dataview.FieldDescriptor;
import gov.va.med.term.access.maint.ui.dataview.PageInfo;
import gov.va.med.term.access.maint.ui.dataview.TypeDescriptor;
import gov.va.med.term.access.maint.util.UserErrors;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class PageFunction {
    public static final Factory factory = new Factory();

    public Dictionary input(Dictionary requestInput, TypeDescriptor type) {
        return requestInput;
    }

    protected Dictionary modifyInput(Dictionary requestInput, TypeDescriptor type) {
        Dictionary result = this.clone_(requestInput);
        this.modifyInputFields(result, type, "");
        return result;
    }

    private Dictionary clone_(Dictionary dictionary) {
        Hashtable result = new Hashtable(dictionary.size());
        Enumeration e = dictionary.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            ((Dictionary)result).put(key, dictionary.get(key));
        }
        return result;
    }

    protected Object modifyInputField(FieldDescriptor field, Object value) {
        return null;
    }

    private void modifyInputFields(Dictionary input, TypeDescriptor type, String prefix) {
        FieldDescriptor[] fields = type.fields();
        int i = fields.length;
        while (--i >= 0) {
            FieldDescriptor field = fields[i];
            String name = String.valueOf(prefix) + field.name();
            if (field.isGroup()) {
                this.modifyInputFields(input, field.typeDescriptor(), String.valueOf(name) + ".");
                continue;
            }
            Object o = input.get(name);
            if (o == null || (o = this.modifyInputField(field, o)) == null) continue;
            input.put(name, o);
        }
    }

    public Object subject(TypeDescriptor prevType, Object prevSubject, String linkName, TypeDescriptor type, String serializedKey) {
        if (serializedKey == null) {
            throw new RuntimeException("Key required");
        }
        Object result = null;
        try {
            result = type.fromSerializedKey(serializedKey);
        }
        catch (Exception x) {
            throw new RuntimeException("Object not found: " + type.name() + " [" + serializedKey + "]", x);
        }
        if (result == null) {
            throw new RuntimeException("Object not found: " + type.name() + " [" + serializedKey + "]");
        }
        return result;
    }

    public boolean expectsObject() {
        return true;
    }

    public Boolean apply(PageInfo info, PageInfo prevInfo, Dictionary input, UserErrors errors) {
        return null;
    }

    public String nextPage(PageInfo info, Dictionary input, String pathInfo) {
        return null;
    }

    public abstract String title(PageInfo var1);

    public String successMessage(PageInfo info, PageInfo prevInfo) {
        return null;
    }

    static class Factory {
        private Hashtable cache_ = new Hashtable();
        static /* synthetic */ Class class$0;

        Factory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PageFunction obtain(String functionName) {
            PageFunction result;
            Hashtable hashtable = this.cache_;
            synchronized (hashtable) {
                result = (PageFunction)this.cache_.get(functionName);
                if (result == null) {
                    result = this.obtain_(functionName);
                    this.cache_.put(functionName, result);
                }
            }
            return result;
        }

        private PageFunction obtain_(String functionName) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.dataview.PageFunction");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (PageFunction)Class.forName(String.valueOf(clazz.getName()) + '_' + functionName).newInstance();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
            catch (Error x) {
                throw new RuntimeException(x);
            }
        }
    }
}

