/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.dataview;

import java.util.HashMap;

public interface FieldTransformer {
    public static final Factory factory = new Factory();

    public String transform(String var1, int var2);

    public static class Factory {
        private static final HashMap cache_ = new HashMap();
        private static final String prefix_ = "gov.va.med.term.access.maint.ui.dataview.transformers.";

        public FieldTransformer obtain(String name) {
            String fullName = prefix_ + name;
            FieldTransformer result = (FieldTransformer)cache_.get(fullName);
            if (result == null) {
                result = this.initialize(fullName);
            }
            return result;
        }

        private synchronized FieldTransformer initialize(String fullName) {
            FieldTransformer result = (FieldTransformer)cache_.get(fullName);
            if (result != null) {
                return result;
            }
            try {
                result = (FieldTransformer)Class.forName(fullName).newInstance();
                cache_.put(fullName, result);
            }
            catch (ClassNotFoundException x) {
                throw new RuntimeException("Could not find transformer " + fullName, x);
            }
            catch (InstantiationException x) {
                throw new RuntimeException("Could not instantiate transformer " + fullName, x);
            }
            catch (IllegalAccessException x) {
                throw new RuntimeException("Could not load transformer " + fullName, x);
            }
            catch (Error x) {
                throw new RuntimeException("Could not load transformer " + fullName, x);
            }
            return result;
        }
    }
}

