/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui;

import gov.va.med.term.access.maint.ui.Outputter;
import java.util.Hashtable;

public class OutputterFactory
implements Outputter.Factory {
    private Hashtable cache_ = new Hashtable();
    private String path_;
    private String defaultPackage_;

    public OutputterFactory() {
        this("outputter.", null);
    }

    public OutputterFactory(String path) {
        this(path, null);
    }

    public OutputterFactory(String path, String defaultPackage) {
        if (path.length() == 0) {
            this.path_ = "";
        } else {
            if (path.startsWith(".")) {
                path = path.substring(1);
            }
            if (!path.endsWith(".")) {
                path = String.valueOf(path) + '.';
            }
            this.path_ = path;
        }
        this.defaultPackage_ = defaultPackage == null ? null : String.valueOf(defaultPackage) + '.';
    }

    private static String simpleClassName(String className) {
        String result = className;
        int p = result.lastIndexOf(46);
        if (p >= 0) {
            result = result.substring(p + 1);
        }
        return result;
    }

    private static String packagePrefix(String className) {
        String result = className;
        int p = result.lastIndexOf(46);
        result = p >= 0 ? result.substring(0, p + 1) : "";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outputter obtain(Class subject, String name) {
        Outputter result;
        String className = subject.getName();
        Hashtable hashtable = this.cache_;
        synchronized (hashtable) {
            String entryKey = String.valueOf(className) + '^' + name;
            result = (Outputter)this.cache_.get(entryKey);
            if (result != null) {
                return result;
            }
            result = (Outputter)this.cache_.get(name);
            if (result != null) {
                return result;
            }
            result = this.outputterFor_(className, name);
            if (this.defaultPackage_ != null && result.getClass().getName().startsWith(this.defaultPackage_)) {
                this.cache_.put(name, result);
            } else {
                this.cache_.put(entryKey, result);
            }
        }
        return result;
    }

    public Outputter outputterFor_(String className, String name) {
        String packagePrefix = OutputterFactory.packagePrefix(className);
        String simpleClassName = OutputterFactory.simpleClassName(className);
        String[] path = new String[this.defaultPackage_ == null ? 2 : 3];
        path[0] = String.valueOf(packagePrefix) + this.path_ + simpleClassName + name;
        path[1] = String.valueOf(packagePrefix) + this.path_ + name;
        if (this.defaultPackage_ != null) {
            path[2] = String.valueOf(this.defaultPackage_) + name;
        }
        int i = -1;
        try {
            while (++i < path.length) {
                try {
                    return (Outputter)Class.forName(path[i]).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable x) {
            throw new RuntimeException(x);
        }
        throw new RuntimeException("Outputter not found for class " + className + " and name " + name + " : looked in " + path[0] + " and " + path[1] + (this.defaultPackage_ == null ? "" : " and " + path[2]));
    }
}

