/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui;

public class Display {
    private static final char[][][] textToHtmlMap_ = new char[][][]{new char[][]{"\"".toCharArray(), "&quot;".toCharArray()}, new char[][]{"'".toCharArray(), "&#39;".toCharArray()}, new char[][]{"<".toCharArray(), "&lt;".toCharArray()}, new char[][]{">".toCharArray(), "&gt;".toCharArray()}, new char[][]{"~".toCharArray(), "&tilde;".toCharArray()}, new char[][]{"&".toCharArray(), "&amp;".toCharArray()}};
    private static final char[] textToHtmlIndex_ = Display.initializeTextToHtmlIndex(textToHtmlMap_);

    public static final String valueOrDefault(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static final String valueOrDefault(String[] values, int offset, String defaultValue) {
        return values == null || values.length <= offset ? defaultValue : Display.valueOrDefault(values[offset], defaultValue);
    }

    public static final String nonBlank(String value, String defaultValue) {
        return value == null || value.length() == 0 ? defaultValue : value;
    }

    public static final String nonBlank(String[] values, int offset, String defaultValue) {
        return values == null || values.length <= offset ? defaultValue : Display.nonBlank(values[offset], defaultValue);
    }

    public static final String safely(String value) {
        return Display.valueOrDefault(value, "");
    }

    public static final String safely(String[] values, int offset) {
        return values == null || values.length <= offset ? "" : Display.safely(values[offset]);
    }

    public static final String safely(Object value) {
        return value == null ? "" : value.toString();
    }

    private static char[] initializeTextToHtmlIndex(char[][][] map) {
        char[] result = new char[map.length];
        int i = map.length;
        while (--i >= 0) {
            result[i] = map[i][0][0];
        }
        return result;
    }

    public static String asHtmlText(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int i = textToHtmlIndex_.length;
        while (--i >= 0) {
            if (s.indexOf(textToHtmlIndex_[i]) >= 0) break;
        }
        if (i < 0) {
            return s;
        }
        StringBuffer buf = new StringBuffer((int)(1.25 * (double)s.length()));
        int length = s.length();
        i = -1;
        while (++i < length) {
            char c = s.charAt(i);
            int j = textToHtmlIndex_.length;
            while (--j >= 0) {
                if (textToHtmlIndex_[j] != c) continue;
                buf.append(textToHtmlMap_[j][1]);
                break;
            }
            if (j >= 0) continue;
            buf.append(c);
        }
        return buf.toString();
    }

    public static String replace(String source, String from, String to) {
        int p;
        StringBuffer buf = new StringBuffer(source.length());
        int len = from.length();
        int start = 0;
        while ((p = source.indexOf(from, start)) >= 0) {
            buf.append(source.substring(start, p));
            buf.append(to);
            start = p + len;
        }
        buf.append(source.substring(start));
        return buf.toString();
    }
}

