/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.messaging.hl7.servlet;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.GenericParser;
import gov.va.med.term.access.maint.event.Event;
import gov.va.med.term.access.maint.event.Queue;
import gov.va.med.term.access.maint.messaging.hl7.Encoding;
import gov.va.med.term.access.maint.messaging.hl7.MediaType;
import gov.va.med.term.access.maint.messaging.hl7.MessageHolder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class MessageServlet
extends HttpServlet {
    protected static final Logger logger_;
    private static final GenericParser parser_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.messaging.hl7.servlet.MessageServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        parser_ = new GenericParser();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String msg = "Method GET not supported by this URL.";
        logger_.error((Object)"Method GET not supported by this URL.");
        response.sendError(400, "Method GET not supported by this URL.");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String content = null;
        try {
            Encoding expectedEncoding;
            String mimeType = request.getContentType();
            int semi = mimeType.indexOf(59);
            if (semi != -1) {
                mimeType = mimeType.substring(0, semi);
            }
            if (MediaType.xml.name.equalsIgnoreCase(mimeType)) {
                expectedEncoding = Encoding.xml;
            } else if (MediaType.er7.name.equalsIgnoreCase(mimeType)) {
                expectedEncoding = Encoding.er7;
            } else {
                StringBuffer buffer = new StringBuffer();
                buffer.append("[addr=");
                buffer.append(request.getRemoteAddr());
                buffer.append(",host=");
                buffer.append(request.getRemoteHost());
                buffer.append(",user=");
                buffer.append(request.getRemoteUser());
                buffer.append("]: ");
                buffer.append("The mime type (");
                buffer.append(mimeType);
                buffer.append(") must be one of [");
                buffer.append(MediaType.xml);
                buffer.append(',');
                buffer.append(MediaType.er7);
                buffer.append("].");
                String msg = buffer.toString();
                logger_.error((Object)msg);
                response.sendError(415, msg);
                return;
            }
            BufferedReader input = request.getReader();
            StringWriter output = new StringWriter(32768);
            char[] buffer = new char[2048];
            int count = 0;
            while ((count = input.read(buffer)) != -1) {
                output.write(buffer, 0, count);
            }
            content = output.toString();
            int length = content.length();
            if (length < 3 || content.charAt(0) != '\u000b' || content.charAt(length - 2) != '\u001c' || content.charAt(length - 1) != '\r') {
                StringBuffer msgBuffer = new StringBuffer();
                msgBuffer.append("[addr=");
                msgBuffer.append(request.getRemoteAddr());
                msgBuffer.append(",host=");
                msgBuffer.append(request.getRemoteHost());
                msgBuffer.append(",user=");
                msgBuffer.append(request.getRemoteUser());
                msgBuffer.append("]: ");
                msgBuffer.append("MLLP validation failed: ");
                msgBuffer.append(content);
                String msg = msgBuffer.toString();
                logger_.error((Object)msg);
                response.sendError(400, msg);
                return;
            }
            String encoding = parser_.getEncoding(content = content.substring(1, length - 2));
            if (encoding == null || expectedEncoding != Encoding.valueOf(encoding)) {
                StringBuffer buffer2 = new StringBuffer();
                buffer2.append("[addr=");
                buffer2.append(request.getRemoteAddr());
                buffer2.append(",host=");
                buffer2.append(request.getRemoteHost());
                buffer2.append(",user=");
                buffer2.append(request.getRemoteUser());
                buffer2.append("]: ");
                buffer2.append("The mime type (");
                buffer2.append(mimeType);
                buffer2.append(") does not match the HL7 encoding used (");
                buffer2.append(encoding);
                buffer2.append("): ");
                buffer2.append(content);
                String msg = buffer2.toString();
                logger_.error((Object)msg);
                response.sendError(400, msg);
                return;
            }
            parser_.parse(content);
            MessageHolder holder = new MessageHolder(content);
            Event event = new Event(holder);
            event.setQueue(Queue.obtainByName("inBound"));
            event.create();
            logger_.info((Object)("Received Message: " + holder.getMessage().getName() + ": " + content.length() + " characters"));
            response.setStatus(200);
            response.setContentLength(0);
        }
        catch (HL7Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[addr=");
            buffer.append(request.getRemoteAddr());
            buffer.append(",host=");
            buffer.append(request.getRemoteHost());
            buffer.append(",user=");
            buffer.append(request.getRemoteUser());
            buffer.append("]: ");
            buffer.append("HL7 encoding problem: ");
            buffer.append(content);
            String msg = buffer.toString();
            logger_.error((Object)msg, (Throwable)e);
            response.sendError(400, e.getMessage());
        }
        catch (Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[addr=");
            buffer.append(request.getRemoteAddr());
            buffer.append(",host=");
            buffer.append(request.getRemoteHost());
            buffer.append(",user=");
            buffer.append(request.getRemoteUser());
            buffer.append("]: ");
            buffer.append("Error processing inbound message: " + content);
            String msg = buffer.toString();
            logger_.error((Object)msg, (Throwable)e);
            response.sendError(500, e.getMessage());
        }
    }
}

