/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.messaging.hl7.factory;

import gov.va.med.term.access.maint.event.Event;
import gov.va.med.term.access.maint.event.EventProcessor;
import gov.va.med.term.access.maint.event.Queue;
import gov.va.med.term.access.maint.messaging.Message;
import gov.va.med.term.access.maint.messaging.Recipient;
import gov.va.med.term.access.maint.util.Transaction;
import java.io.Serializable;

public class MessageDistributor
implements EventProcessor {
    public boolean canProcess(Event event, Transaction transaction) {
        Serializable data = event.getData();
        if (!(data instanceof Message)) {
            return false;
        }
        Message message = (Message)data;
        Recipient[] recipients = message.getRecipients();
        return recipients.length != 1;
    }

    public void process(Event event, Transaction transaction) {
        if (!this.canProcess(event, transaction)) {
            throw new RuntimeException("Method should only be called if canProcess returns true.");
        }
        Message message = (Message)event.getData();
        Recipient[] recipients = message.getRecipients();
        int i = 0;
        while (i < recipients.length) {
            Recipient recipient = recipients[i];
            Message msg = (Message)message.clone();
            msg.clearRecipients();
            msg.addRecipient(recipient);
            Event e = new Event(msg);
            e.setQueue(Queue.obtainByName("outBound"));
            e.create(transaction);
            ++i;
        }
    }
}

