/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.messaging.hl7.factory;

import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.HD;
import ca.uhn.hl7v2.model.v24.datatype.MSG;
import ca.uhn.hl7v2.model.v24.datatype.RCD;
import ca.uhn.hl7v2.model.v24.datatype.TSComponentOne;
import ca.uhn.hl7v2.model.v24.group.MFN_M01_MFEZxx;
import ca.uhn.hl7v2.model.v24.message.MFN_M01;
import ca.uhn.hl7v2.model.v24.segment.MFE;
import ca.uhn.hl7v2.model.v24.segment.MFI;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.RDF;
import ca.uhn.hl7v2.model.v24.segment.RDT;
import gov.va.med.term.access.maint.messaging.Application;
import gov.va.med.term.access.maint.messaging.Message;
import gov.va.med.term.access.maint.messaging.Recipient;
import gov.va.med.term.access.maint.messaging.Topic;
import gov.va.med.term.access.maint.messaging.hl7.AttrGroupMetadata;
import gov.va.med.term.access.maint.messaging.hl7.AttributeMetadata;
import gov.va.med.term.access.maint.messaging.hl7.InstanceAction;
import gov.va.med.term.access.maint.messaging.hl7.MessageConverter;
import gov.va.med.term.access.maint.messaging.hl7.MetaType;
import gov.va.med.term.access.maint.messaging.hl7.Metadata;
import gov.va.med.term.access.maint.messaging.hl7.PublishType;
import gov.va.med.term.access.maint.messaging.hl7.TypeMetadata;
import gov.va.med.term.access.maint.messaging.hl7.UpdateType;
import gov.va.med.term.access.maint.util.FieldAccessor;
import gov.va.med.term.access.maint.util.MethodAccessor;
import gov.va.med.term.access.maint.util.Transaction;
import gov.va.med.term.access.util.Settings;
import java.io.Serializable;
import java.util.GregorianCalendar;

public class GenericMessageConverter
implements MessageConverter {
    private static final String SENDING_APPLICATION_NAMESPACE_ID;
    private static final String SENDING_APPLICATION_UNIVERSAL_ID_TYPE;
    private static final String SENDING_FACILITY_NAMESPACE_ID;
    private static final String PROCESSING_ID;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Settings settings = Settings.instance();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.messaging.hl7.factory.GenericMessageConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SENDING_APPLICATION_NAMESPACE_ID = settings.value((Class)clazz, "msh.sendingApplication.namespaceId");
        Settings settings2 = Settings.instance();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.va.med.term.access.maint.messaging.hl7.factory.GenericMessageConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SENDING_APPLICATION_UNIVERSAL_ID_TYPE = settings2.value((Class)clazz2, "msh.sendingApplication.universalIdType");
        Settings settings3 = Settings.instance();
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("gov.va.med.term.access.maint.messaging.hl7.factory.GenericMessageConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SENDING_FACILITY_NAMESPACE_ID = settings3.value((Class)clazz3, "msh.sendingFacility.namespaceId");
        Settings settings4 = Settings.instance();
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("gov.va.med.term.access.maint.messaging.hl7.factory.GenericMessageConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PROCESSING_ID = settings4.value((Class)clazz4, "msh.processingId");
    }

    public boolean canConvert(Message message, Transaction transaction) {
        return message instanceof PublishType && message.getRecipients().length == 1;
    }

    public ca.uhn.hl7v2.model.Message convert(Message message, Transaction transaction) {
        if (!this.canConvert(message, transaction)) {
            throw new RuntimeException("Method should only be called if canConvert returns true.");
        }
        if (message instanceof UpdateType) {
            return this.convert((UpdateType)message, transaction);
        }
        if (message instanceof PublishType) {
            return this.convert((PublishType)message, transaction);
        }
        throw new RuntimeException("Unsupported message type (" + message.getClass().getName() + ").");
    }

    private ca.uhn.hl7v2.model.Message convert(PublishType message, Transaction transaction) {
        Class<?> clazz = message.getClass();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("gov.va.med.term.access.maint.messaging.hl7.PublishType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.equals(clazz2)) {
            throw new IllegalArgumentException("Cannot be called with a subclass of PublishType.");
        }
        UpdateType msg = new UpdateType();
        msg.setRecipients(message.getRecipients());
        msg.setDatatype(message.getDatatype());
        msg.setAction(message.getAction());
        try {
            Object factory = FieldAccessor.get(msg.getDatatype(), "factory");
            Serializable[] instances = (Serializable[])MethodAccessor.invoke(factory, "obtain", null, null);
            int i = 0;
            while (i < instances.length) {
                msg.addUpdate(instances[i], InstanceAction.add);
                ++i;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error invoking " + msg.getDatatype().getName() + ".obtain()", e);
        }
        return this.convert(msg, transaction);
    }

    private ca.uhn.hl7v2.model.Message convert(UpdateType message, Transaction transaction) {
        try {
            String now = TSComponentOne.toHl7TSFormat((GregorianCalendar)((GregorianCalendar)GregorianCalendar.getInstance()));
            String id = String.valueOf(String.valueOf(System.currentTimeMillis())) + String.valueOf(message.hashCode());
            TypeMetadata typeMetadata = (TypeMetadata)Metadata.cache.fetch(message.getDatatype());
            MFN_M01 hl7Message = new MFN_M01();
            MSH msh = hl7Message.getMSH();
            msh.getFieldSeparator().setValue("^");
            msh.getEncodingCharacters().setValue("~|\\&");
            HD sendingApplication = msh.getSendingApplication();
            sendingApplication.getNamespaceID().setValue(SENDING_APPLICATION_NAMESPACE_ID);
            sendingApplication.getUniversalIDType().setValue(SENDING_APPLICATION_UNIVERSAL_ID_TYPE);
            HD sendingFacility = msh.getSendingFacility();
            sendingFacility.getNamespaceID().setValue(SENDING_FACILITY_NAMESPACE_ID);
            Recipient recipient = message.getRecipients()[0];
            if (recipient instanceof Application) {
                Application application = (Application)recipient;
                HD receivingApplication = msh.getReceivingApplication();
                receivingApplication.getNamespaceID().setValue(application.getReceivingApplication());
                HD receivingFacility = msh.getReceivingFacility();
                receivingFacility.getNamespaceID().setValue(application.getReceivingFacility());
            } else {
                Topic topic = (Topic)recipient;
                HD receivingFacility = msh.getReceivingFacility();
                receivingFacility.getNamespaceID().setValue(topic.getName());
            }
            msh.getDateTimeOfMessage().getTimeOfAnEvent().setValue(now);
            MSG msgType = msh.getMessageType();
            msgType.getMessageType().setValue("MFN");
            msgType.getTriggerEvent().setValue("M01");
            msgType.getMessageStructure().setValue("MFN_M01");
            msh.getMessageControlID().setValue(id);
            msh.getProcessingID().getProcessingID().setValue(PROCESSING_ID);
            msh.getVersionID().getVersionID().setValue("2.4");
            msh.getAcceptAcknowledgmentType().setValue("AL");
            msh.getApplicationAcknowledgmentType().setValue("NE");
            msh.getCountryCode().setValue("USA");
            MFI mfi = hl7Message.getMFI();
            CE masterFileIdentifier = mfi.getMasterFileIdentifier();
            CE mfid = typeMetadata.getMasterFileIdentifier();
            masterFileIdentifier.getIdentifier().setValue(mfid.getIdentifier().getValue());
            masterFileIdentifier.getText().setValue(mfid.getText().getValue());
            masterFileIdentifier.getNameOfCodingSystem().setValue(mfid.getNameOfCodingSystem().getValue());
            masterFileIdentifier.getAlternateIdentifier().setValue(mfid.getAlternateIdentifier().getValue());
            masterFileIdentifier.getAlternateText().setValue(mfid.getAlternateText().getValue());
            masterFileIdentifier.getNameOfAlternateCodingSystem().setValue(mfid.getNameOfAlternateCodingSystem().getValue());
            mfi.getFileLevelEventCode().setValue(message.getAction().toString());
            mfi.getEnteredDateTime().getTimeOfAnEvent().setValue(now);
            mfi.getEffectiveDateTime().getTimeOfAnEvent().setValue(now);
            mfi.getResponseLevelCode().setValue("NE");
            UpdateType.Update[] updates = message.getUpdates();
            int i = 0;
            while (i < updates.length) {
                UpdateType.Update update = updates[i];
                Serializable instance = update.getInstance();
                InstanceAction action = update.getAction();
                MFN_M01_MFEZxx mfeGroup = hl7Message.getMFN_M01_MFEZxx(i);
                MFE mfe = mfeGroup.getMFE();
                mfe.getRecordLevelEventCode().setValue(action.toString());
                mfe.getEffectiveDateTime().getTimeOfAnEvent().setValue(now);
                CE primaryKeyValue = typeMetadata.computePrimaryKeyValue(instance);
                mfe.getPrimaryKeyValueMFE(0).setData((Type)primaryKeyValue);
                mfe.getPrimaryKeyValueType(0).setValue(primaryKeyValue.getName());
                if (action != InstanceAction.delete) {
                    mfeGroup.addNonstandardSegment("RDF");
                    RDF rdf = (RDF)mfeGroup.get("RDF");
                    mfeGroup.addNonstandardSegment("RDT");
                    RDT rdt = (RDT)mfeGroup.get("RDT");
                    AttributeMetadata[] typeAttrs = typeMetadata.getAttributeMetadata();
                    int numAttrs = 0;
                    int j = 0;
                    while (j < typeAttrs.length) {
                        AttributeMetadata typeAttr = typeAttrs[j];
                        if (!typeAttr.isMulti()) {
                            MetaType metatype = typeAttr.getMetaType();
                            if (metatype == MetaType.attrGroup) {
                                Serializable value = (Serializable)typeAttr.getValue(instance);
                                AttrGroupMetadata attrGroupMetadata = (AttrGroupMetadata)Metadata.cache.fetch(typeAttr.getJavaType());
                                AttributeMetadata[] attrGroupAttrs = attrGroupMetadata.getAttributeMetadata();
                                int k = 0;
                                while (k < attrGroupAttrs.length) {
                                    AttributeMetadata attrGroupAttr = attrGroupAttrs[k];
                                    if (!attrGroupAttr.isMulti()) {
                                        RCD rcd = rdf.getColumnDescription(++numAttrs - 1);
                                        rcd.getSegmentFieldName().setValue(String.valueOf(typeAttr.getName()) + "." + attrGroupAttr.getName());
                                        rcd.getHL7DateType().setValue(attrGroupAttr.getHL7Type());
                                        rcd.getMaximumColumnWidth().setValue(String.valueOf(attrGroupAttr.getHL7MaxWidth()));
                                        ((Varies)rdt.getField(numAttrs, 0)).setData(attrGroupAttr.getHL7Value(value));
                                    }
                                    ++k;
                                }
                            } else {
                                RCD rcd = rdf.getColumnDescription(++numAttrs - 1);
                                rcd.getSegmentFieldName().setValue(typeAttr.getName());
                                rcd.getHL7DateType().setValue(typeAttr.getHL7Type());
                                rcd.getMaximumColumnWidth().setValue(String.valueOf(typeAttr.getHL7MaxWidth()));
                                ((Varies)rdt.getField(numAttrs, 0)).setData(typeAttr.getHL7Value(instance));
                            }
                        }
                        ++j;
                    }
                    rdf.getNumberOfColumnsPerRow().setValue(String.valueOf(numAttrs));
                }
                ++i;
            }
            return hl7Message;
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating HL7 message.", e);
        }
    }
}

