/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.messaging.hl7.factory;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.util.Terser;
import gov.va.med.term.access.maint.conversion.StringConverter;
import gov.va.med.term.access.maint.messaging.hl7.Encoding;
import gov.va.med.term.access.maint.messaging.hl7.MediaType;
import gov.va.med.term.access.maint.messaging.hl7.MessageDispatcher;
import gov.va.med.term.access.util.Settings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;

public class BusinessWareMessageDispatcher
implements MessageDispatcher {
    private static Logger logger_;
    private static final URL url_;
    private static final Encoding encoding_;
    private static final GenericParser parser_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.messaging.hl7.factory.BusinessWareMessageDispatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        url_ = BusinessWareMessageDispatcher.initializeURL();
        Settings settings = Settings.instance();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.va.med.term.access.maint.messaging.hl7.factory.BusinessWareMessageDispatcher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        encoding_ = Encoding.valueOf(settings.value((Class)clazz2, "encoding"));
        parser_ = new GenericParser();
    }

    private static URL initializeURL() {
        try {
            Settings settings = Settings.instance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("gov.va.med.term.access.maint.messaging.hl7.factory.BusinessWareMessageDispatcher");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = settings.value((Class)clazz, "url");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (URL)StringConverter.fromString(string, clazz2);
        }
        catch (StringConverter.FormatException e) {
            String msg = "Error initializing URL.";
            logger_.error((Object)"Error initializing URL.", (Throwable)e);
            throw new RuntimeException("Error initializing URL.", e);
        }
    }

    public void send(Message message) {
        try {
            HttpURLConnection connection = (HttpURLConnection)url_.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", String.valueOf(encoding_ == Encoding.xml ? MediaType.xml.name : MediaType.er7.name) + "; charset=UTF-8");
            String encodedMessage = parser_.encode(message, encoding_.toString());
            OutputStreamWriter output = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
            output.write(11);
            output.write(encodedMessage);
            output.write(28);
            output.write(13);
            output.close();
            if (connection.getResponseCode() != 200) {
                String error = this.inputStreamToString(connection.getErrorStream());
                String msg = "Error sending message (" + connection.getResponseCode() + "): message (" + connection.getResponseMessage() + "), error stream (" + error + ")";
                logger_.error((Object)msg);
                throw new RuntimeException(msg);
            }
            Terser terser = new Terser(message);
            logger_.info((Object)("Sent Message: " + terser.get("MSH-9-3") + "[ctrl_id=" + terser.get("MSH-10") + "]: " + encodedMessage.length() + " characters"));
        }
        catch (Exception e) {
            String msg = "Error sending message.";
            logger_.error((Object)"Error sending message.", (Throwable)e);
            throw new RuntimeException("Error sending message.", e);
        }
    }

    private String inputStreamToString(InputStream stream) throws IOException {
        String line;
        if (stream == null) {
            return "";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        writer.close();
        buffer.close();
        reader.close();
        return buffer.toString();
    }
}

