/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.messaging.hl7;

import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.DT;
import ca.uhn.hl7v2.model.v24.datatype.NM;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.model.v24.datatype.TSComponentOne;
import ca.uhn.hl7v2.model.v24.datatype.XCN;
import gov.va.med.term.access.maint.messaging.hl7.Metadata;
import gov.va.med.term.access.maint.messaging.hl7.TypeMetadata;
import gov.va.med.term.access.types.Day;
import gov.va.med.term.access.types.ImpreciseDate;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class ValueConverter {
    public static final String HL7_NULL = "\"\"";
    private static final SimpleDateFormat dateFormat_ = new SimpleDateFormat("yyyyMMdd");
    private static final SimpleDateFormat timestampFormat_ = new SimpleDateFormat("yyyyMMddHHmmssZ");
    private static final SimpleDateFormat timestampWithMillisFormat_ = new SimpleDateFormat("yyyyMMddHHmmss.SSSSZ");

    private ValueConverter() {
    }

    public static NM toNM(BigDecimal value) {
        try {
            String result = HL7_NULL;
            if (value != null) {
                result = value.toString();
            }
            return new NM(result);
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static ST toST(Boolean value) {
        try {
            String result = HL7_NULL;
            if (value != null) {
                result = value != false ? "1" : "0";
            }
            return new ST(result);
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static DT toDT(Day value) {
        try {
            DT result = new DT();
            if (value != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime((java.util.Date)value);
                result.setValue(DT.toHl7DTFormat((GregorianCalendar)calendar));
            } else {
                result.setValue(HL7_NULL);
            }
            return result;
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static DT toDT(Date value) {
        try {
            DT result = new DT();
            if (value != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(value);
                result.setValue(DT.toHl7DTFormat((GregorianCalendar)calendar));
            } else {
                result.setValue(HL7_NULL);
            }
            return result;
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static DT toDT(ImpreciseDate value) {
        try {
            DT result = new DT();
            if (value != null) {
                result.setValue(value.getDate());
            } else {
                result.setValue(HL7_NULL);
            }
            return result;
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static NM toNM(Double value) {
        try {
            String result = HL7_NULL;
            if (value != null) {
                result = value.toString();
            }
            return new NM(result);
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static NM toNM(Integer value) {
        try {
            String result = HL7_NULL;
            if (value != null) {
                result = value.toString();
            }
            return new NM(result);
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static NM toNM(Short value) {
        try {
            String result = HL7_NULL;
            if (value != null) {
                result = value.toString();
            }
            return new NM(result);
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static NM toNM(Long value) {
        try {
            String result = HL7_NULL;
            if (value != null) {
                result = value.toString();
            }
            return new NM(result);
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static ST toST(String value) {
        try {
            String result = HL7_NULL;
            if (value != null) {
                result = value;
            }
            return new ST(result);
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static XCN toXCN(String value) {
        try {
            XCN result = new XCN();
            if (value != null) {
                result.getIDNumber().setValue(value);
            } else {
                result.getIDNumber().setValue(HL7_NULL);
            }
            return result;
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static TS toTS(Timestamp value) {
        try {
            TS result = new TS();
            if (value != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(value);
                result.getTimeOfAnEvent().setValue(TSComponentOne.toHl7TSFormat((GregorianCalendar)calendar));
            } else {
                result.getTimeOfAnEvent().setValue(HL7_NULL);
            }
            return result;
        }
        catch (DataTypeException e) {
            throw new RuntimeException("Error converting Java type to an HL7 type.", e);
        }
    }

    public static CE toCE(Serializable value) {
        if (value == null) {
            try {
                CE ce = new CE();
                ce.getIdentifier().setValue(HL7_NULL);
                return ce;
            }
            catch (DataTypeException e) {
                throw new RuntimeException("Error converting Java type to an HL7 type.", e);
            }
        }
        TypeMetadata metadata = (TypeMetadata)Metadata.cache.fetch(value.getClass());
        return metadata.computePrimaryKeyValue(value);
    }

    public static BigDecimal toBigDecimal(NM value) {
        String strValue = value.getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        return new BigDecimal(strValue);
    }

    public static Boolean toBoolean(ST value) {
        String strValue = value.getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        return "1".equals(strValue) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Day toDay(DT value) {
        try {
            String strValue = value.getValue();
            if (HL7_NULL.equals(strValue)) {
                return null;
            }
            if (strValue.length() != 8) {
                throw new IllegalArgumentException("Date format must be YYYYMMDD (" + strValue + ").");
            }
            return new Day(dateFormat_.parse(strValue));
        }
        catch (ParseException e) {
            throw new RuntimeException("Error converting HL7 type to a Java type.", e);
        }
    }

    public static Date toDate(DT value) {
        try {
            String strValue = value.getValue();
            if (HL7_NULL.equals(strValue)) {
                return null;
            }
            if (strValue.length() != 8) {
                throw new IllegalArgumentException("Date format must be YYYYMMDD (" + strValue + ").");
            }
            return new Date(dateFormat_.parse(strValue).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException("Error converting HL7 type to a Java type.", e);
        }
    }

    public static ImpreciseDate toImpreciseDate(DT value) {
        String strValue = value.getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        return ImpreciseDate.valueOf((String)strValue);
    }

    public static Double toDouble(NM value) {
        String strValue = value.getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        return Double.valueOf(strValue);
    }

    public static Short toShort(NM value) {
        String strValue = value.getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        return Short.valueOf(strValue);
    }

    public static Integer toInteger(NM value) {
        String strValue = value.getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        return Integer.valueOf(strValue);
    }

    public static Long toLong(NM value) {
        String strValue = value.getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        return Long.valueOf(strValue);
    }

    public static String toString(ST value) {
        String strValue = value.getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        return strValue;
    }

    public static String toString(XCN value) {
        String strValue = value.getIDNumber().getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        return strValue;
    }

    public static Timestamp toTimestamp(TS value) {
        long time;
        String strValue = value.getTimeOfAnEvent().getValue();
        if (HL7_NULL.equals(strValue)) {
            return null;
        }
        try {
            java.util.Date date = timestampFormat_.parse(strValue);
            time = date.getTime();
        }
        catch (ParseException outer) {
            try {
                java.util.Date date = timestampWithMillisFormat_.parse(strValue);
                time = date.getTime();
                int start = strValue.indexOf(46) + 1;
                int end = strValue.indexOf(45);
                if (end == -1) {
                    end = strValue.indexOf(43);
                }
                int length = end - start;
                StringBuffer buffer = new StringBuffer("0000");
                buffer.replace(0, length, strValue.substring(start, end));
                String strMillis = buffer.toString();
                time -= (long)Integer.parseInt(strMillis.substring(0, length));
                time += (long)Integer.parseInt(strMillis.substring(0, 3));
            }
            catch (ParseException inner) {
                throw new RuntimeException("Error converting HL7 type to a Java type.", inner);
            }
        }
        return new Timestamp(time);
    }

    public static Serializable toSerializable(CE value) {
        try {
            String id = value.getIdentifier().getValue();
            if (HL7_NULL.equals(id)) {
                return null;
            }
            String typeName = value.getText().getValue();
            Class<?> type = Class.forName(typeName);
            TypeMetadata metadata = (TypeMetadata)Metadata.cache.fetch(type);
            return metadata.fromPrimaryKeyValue(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Error converting HL7 type to a Java type.", e);
        }
    }
}

