/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.messaging.hl7;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.GenericParser;
import gov.va.med.term.access.maint.messaging.hl7.Encoding;
import gov.va.med.term.access.maint.util.ObjectFormatter;
import java.io.Serializable;

public class MessageHolder
implements Serializable {
    private static final GenericParser parser_ = new GenericParser();
    private Encoding encoding_;
    private String encodedMessage_;
    private transient Message message_;

    public MessageHolder() {
    }

    public MessageHolder(String encodedMessage) {
        this.setMessage(encodedMessage);
    }

    public MessageHolder(Message message, Encoding encoding) {
        this.setMessage(message, encoding);
    }

    public Encoding getEncoding() {
        return this.encoding_;
    }

    public String getEncodedMessage() {
        return this.encodedMessage_;
    }

    public void setMessage(String encodedMessage) {
        this.encodedMessage_ = encodedMessage;
        this.encoding_ = null;
        this.message_ = null;
        if (this.encodedMessage_ != null) {
            this.encoding_ = Encoding.valueOf(parser_.getEncoding(encodedMessage));
        }
    }

    public void setMessage(Message message, Encoding encoding) {
        this.message_ = message;
        this.encoding_ = encoding;
        this.encodedMessage_ = null;
        if (message != null) {
            try {
                this.encodedMessage_ = parser_.encode(message, this.encoding_.toString());
            }
            catch (EncodingNotSupportedException e) {
                throw new RuntimeException("Encoding not supported (" + this.encoding_ + ").", e);
            }
            catch (HL7Exception e) {
                throw new RuntimeException("Could not convert message to XML: " + ObjectFormatter.instance().format(message), e);
            }
        }
    }

    public Message getMessage() {
        if (this.message_ == null && this.encodedMessage_ != null) {
            try {
                this.message_ = parser_.parse(this.encodedMessage_);
            }
            catch (HL7Exception e) {
                throw new RuntimeException("Could not parse the encoded message: " + this.encodedMessage_, e);
            }
        }
        return this.message_;
    }
}

