/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.messaging.factory.db;

import gov.va.med.term.access.maint.event.Event;
import gov.va.med.term.access.maint.event.Queue;
import gov.va.med.term.access.maint.factory.db.hibernate.HibernateAdapter;
import gov.va.med.term.access.maint.messaging.Recipient;
import gov.va.med.term.access.maint.messaging.hl7.InstanceAction;
import gov.va.med.term.access.maint.messaging.hl7.Metadata;
import gov.va.med.term.access.maint.messaging.hl7.TypeMetadata;
import gov.va.med.term.access.maint.messaging.hl7.UpdateType;
import gov.va.med.term.access.maint.util.Transaction;
import java.io.Serializable;

public class UpdateObserver
extends HibernateAdapter {
    private void publishChange(Object object, InstanceAction action, Transaction transaction) {
        if (!(object instanceof Serializable)) {
            return;
        }
        Serializable instance = (Serializable)object;
        TypeMetadata metadata = (TypeMetadata)Metadata.cache.fetch(instance.getClass());
        if (metadata == null) {
            return;
        }
        Recipient[] recipients = metadata.getRecipients();
        if (recipients.length == 0) {
            return;
        }
        UpdateType message = new UpdateType(instance, action);
        message.setRecipients(recipients);
        Event event = new Event(message);
        event.setQueue(Queue.obtainByName("outBound"));
        event.create(transaction);
    }

    public void postSave(Object object, Transaction transaction) {
        this.publishChange(object, InstanceAction.add, transaction);
    }

    public void postUpdate(Object object, Transaction transaction) {
        this.publishChange(object, InstanceAction.update, transaction);
    }

    public void postDelete(Object object, Transaction transaction) {
        this.publishChange(object, InstanceAction.delete, transaction);
    }
}

