/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.factory.memory;

import gov.va.med.term.access.maint.util.Transaction;

public class TransactionFactory
implements Transaction.Factory {
    public Transaction create() {
        return new MemoryTransaction();
    }

    public static class MemoryTransaction
    implements Transaction {
        private boolean wasCommitted_ = false;

        protected MemoryTransaction() {
        }

        public void commit() {
            if (this.wasCommitted_) {
                throw new IllegalStateException("Transaction already committed.");
            }
            this.wasCommitted_ = true;
        }

        public void rollback() {
            if (this.wasCommitted_) {
                throw new IllegalStateException("Transaction already committed");
            }
            throw new UnsupportedOperationException("Rollback not supported for memory based factories.");
        }

        public boolean wasCommitted() {
            return this.wasCommitted_;
        }

        public boolean wasRolledBack() {
            return false;
        }
    }
}

