/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.factory.db.hibernate;

import gov.va.med.term.access.maint.factory.db.hibernate.HibernateSession;
import gov.va.med.term.access.maint.factory.db.hibernate.TransactionState;
import gov.va.med.term.access.maint.util.Transaction;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.type.Type;
import org.apache.log4j.Logger;

public class HibernateTransaction
implements Transaction {
    private static Logger logger_;
    private Session session_;
    private net.sf.hibernate.Transaction transaction_;
    private Stack where_;
    private int level_ = 0;
    private boolean shouldCommit_ = true;
    private TransactionState state_ = null;
    private static final ThreadLocal currentTransaction_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.factory.db.hibernate.HibernateTransaction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        currentTransaction_ = new ThreadLocal();
    }

    public static Transaction create() {
        HibernateTransaction transaction = (HibernateTransaction)currentTransaction_.get();
        if (transaction == null) {
            transaction = new HibernateTransaction();
            currentTransaction_.set(transaction);
            logger_.info((Object)("Created new Transaction." + transaction));
        } else {
            logger_.info((Object)("Using existing Transaction(" + transaction + "," + transaction.level_ + "," + transaction.shouldCommit_ + "," + transaction.state_ + ")."));
        }
        transaction.begin();
        return transaction;
    }

    private static void dispose() {
        currentTransaction_.set(null);
    }

    private HibernateTransaction() {
        try {
            this.session_ = HibernateSession.openSession();
            this.transaction_ = this.session_.beginTransaction();
        }
        catch (HibernateException e) {
            try {
                if (this.session_ != null) {
                    this.session_.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException("Could not create Hibernate transaction.", e);
        }
    }

    protected void begin() {
        if (this.level_ < 0) {
            throw new IllegalStateException("Transaction in an invalid state (" + this + "," + this.level_ + "," + this.shouldCommit_ + "," + this.state_ + ").");
        }
        ++this.level_;
        if (this.state_ == null) {
            this.state_ = TransactionState.begun;
        }
        if (logger_.isInfoEnabled()) {
            if (this.where_ == null) {
                this.where_ = new Stack();
            }
            this.where_.push(new Exception("Incomplete transaction was create here:"));
        }
    }

    public void commit() {
        logger_.info((Object)("Commit requested(" + this + "," + this.level_ + "," + this.shouldCommit_ + "," + this.state_ + ")."));
        if (!this.shouldCommit_) {
            throw new IllegalStateException("Nested transaction requested the transaction be rolled back(" + this + "," + this.level_ + "," + this.shouldCommit_ + "," + this.state_ + ").");
        }
        if (this.state_ != TransactionState.begun || this.level_ < 1) {
            throw new IllegalStateException("Transaction is in the wrong state to commit (" + this + "," + this.level_ + "," + this.state_ + ").");
        }
        if (this.level_ > 1) {
            --this.level_;
            return;
        }
        try {
            this.transaction_.commit();
        }
        catch (Exception e) {
            this.shouldCommit_ = false;
            logger_.error((Object)"Commit failed.", (Throwable)e);
            throw new RuntimeException("Commit failed.", e);
        }
        --this.level_;
        this.state_ = TransactionState.committed;
        HibernateTransaction.dispose();
        try {
            this.session_.close();
        }
        catch (Exception e) {
            logger_.error((Object)"Couldn't close session.", (Throwable)e);
        }
    }

    public void rollback() {
        logger_.info((Object)("Rollback requested(" + this + "," + this.level_ + "," + this.shouldCommit_ + "," + this.state_ + ")."));
        if (this.level_ < 1) {
            throw new IllegalStateException("Transaction in the wrong state to rollback (" + this + this.level_ + "," + this.state_ + ").");
        }
        if (this.level_ > 1) {
            --this.level_;
            this.shouldCommit_ = false;
            this.state_ = TransactionState.rolledback;
            return;
        }
        Exception rollbackException = null;
        try {
            this.transaction_.rollback();
        }
        catch (Exception e) {
            rollbackException = e;
        }
        --this.level_;
        this.state_ = TransactionState.rolledback;
        HibernateTransaction.dispose();
        try {
            this.session_.close();
        }
        catch (Exception e) {
            logger_.error((Object)"Couldn't close session.", (Throwable)e);
        }
        if (rollbackException != null) {
            throw new RuntimeException("Rollback failed.", rollbackException);
        }
    }

    public boolean wasCommitted() {
        return this.state_ == TransactionState.committed;
    }

    public boolean wasRolledBack() {
        return this.state_ == TransactionState.rolledback;
    }

    public void delete(Object object) {
        try {
            this.session_.delete(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't delete object.", e);
        }
    }

    public int delete(String query) {
        try {
            return this.session_.delete(query);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't delete objects returned by query.", e);
        }
    }

    public int delete(String query, Object value, Type type) {
        try {
            return this.session_.delete(query, value, type);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't delete objects returned by query.", e);
        }
    }

    public int delete(String query, Object[] values, Type[] types) {
        try {
            return this.session_.delete(query, values, types);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't delete object returned by query.", e);
        }
    }

    public List find(String query) {
        try {
            return this.session_.find(query);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't perform query.", e);
        }
    }

    public List find(String query, Object value, Type type) {
        try {
            return this.session_.find(query, value, type);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't perform query.", e);
        }
    }

    public List find(String query, Object[] values, Type[] types) {
        try {
            return this.session_.find(query, values, types);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't perform query.", e);
        }
    }

    public List find(String query, int first, int max) {
        try {
            Query q = this.session_.createQuery(query);
            if (first != 0) {
                q.setFirstResult(first);
            }
            if (max != Integer.MAX_VALUE) {
                q.setMaxResults(max);
            }
            return q.list();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't perform query.", e);
        }
    }

    public List find(String query, Object value, Type type, int first, int max) {
        try {
            Query q = this.session_.createQuery(query);
            q.setParameter(0, value, type);
            if (first != 0) {
                q.setFirstResult(first);
            }
            if (max != Integer.MAX_VALUE) {
                q.setMaxResults(max);
            }
            return q.list();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't perform query.", e);
        }
    }

    public List find(String query, Object[] values, Type[] types, int first, int max) {
        try {
            Query q = this.session_.createQuery(query);
            int i = 0;
            while (i < values.length) {
                q.setParameter(i, values[i], types[i]);
                ++i;
            }
            if (first != 0) {
                q.setFirstResult(first);
            }
            if (max != Integer.MAX_VALUE) {
                q.setMaxResults(max);
            }
            return q.list();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't perform query.", e);
        }
    }

    public void save(Object object) {
        try {
            this.session_.save(object);
        }
        catch (HibernateException e) {
            throw new RuntimeException("Couldn't save object.", e);
        }
    }

    public void update(Object object) {
        try {
            this.session_.update(object);
        }
        catch (HibernateException e) {
            throw new RuntimeException("Couldn't update object.", e);
        }
    }

    public void finalize() throws Throwable {
        if (!this.wasCommitted() && !this.wasRolledBack() || this.level_ != 0) {
            logger_.error((Object)"Uncompleted transaction.");
            if (logger_.isInfoEnabled()) {
                Iterator i = this.where_.iterator();
                while (i.hasNext()) {
                    logger_.info((Object)"Transaction started at:", (Throwable)((Exception)i.next()));
                }
            }
        }
        super.finalize();
    }
}

