/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.event;

import gov.va.med.term.access.maint.event.Event;
import gov.va.med.term.access.maint.event.EventProcessor;
import gov.va.med.term.access.maint.event.Queue;
import gov.va.med.term.access.maint.util.ObjectFormatter;
import gov.va.med.term.access.maint.util.Task;
import gov.va.med.term.access.maint.util.Transaction;
import gov.va.med.term.access.maint.validation.FieldValidator_Integer;
import gov.va.med.term.access.maint.validation.FieldValidator_Long;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class QueueProcessor
implements Task {
    protected static Logger logger_;
    protected String queueName_;
    protected static final FieldValidator_Long maxValidator_;
    protected int max_;
    private int attempts_;
    protected EventProcessor[] processors_;
    private boolean isFixedRate_;
    protected static final FieldValidator_Long delayValidator_;
    private long delay_;
    protected static final FieldValidator_Long periodValidator_;
    private long period_;
    private Timer timer_;
    protected Task.Status status_ = Task.Status.stopped;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.event.QueueProcessor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        maxValidator_ = new FieldValidator_Long("max", FieldValidator_Integer.min(0));
        delayValidator_ = new FieldValidator_Long("delay", FieldValidator_Long.min(0L));
        periodValidator_ = new FieldValidator_Long("period", FieldValidator_Long.min(0L));
    }

    public QueueProcessor(String queueName, EventProcessor[] processors, int max, boolean isFixedRate, long delay, long period) {
        this.setQueueName(queueName);
        this.setProcessors(processors);
        this.setMax(max);
        this.setFixedRate(isFixedRate);
        this.setDelay(delay);
        this.setPeriod(period);
    }

    public String getQueueName() {
        return this.queueName_;
    }

    public void setQueueName(String queueName) {
        this.queueName_ = queueName;
    }

    public int getMax() {
        return this.max_;
    }

    public void setMax(int max) {
        String error = maxValidator_.validate(new Integer(max));
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        this.max_ = max;
    }

    public int getAttempts() {
        return this.attempts_;
    }

    public void setAttempts(int attempts) {
        this.attempts_ = attempts;
    }

    public EventProcessor[] getProcessors() {
        EventProcessor[] result = new EventProcessor[this.processors_.length];
        System.arraycopy(this.processors_, 0, result, 0, this.processors_.length);
        return result;
    }

    public void setProcessors(EventProcessor[] processors) {
        this.processors_ = new EventProcessor[processors.length];
        System.arraycopy(processors, 0, this.processors_, 0, processors.length);
    }

    public boolean isFixedRate() {
        return this.isFixedRate_;
    }

    public void setFixedRate(boolean isFixedRate) {
        this.isFixedRate_ = isFixedRate;
    }

    public long getDelay() {
        return this.delay_;
    }

    public void setDelay(long delay) {
        String error = delayValidator_.validate(new Long(delay));
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        this.delay_ = delay;
    }

    public long getPeriod() {
        return this.period_;
    }

    public void setPeriod(long period) {
        String error = periodValidator_.validate(new Long(period));
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        this.period_ = period;
    }

    public Task.Status getStatus() {
        return this.status_;
    }

    public void start() {
        logger_.info((Object)("Starting processor for " + this.queueName_ + " queue."));
        if (this.status_ == Task.Status.stopped) {
            if (this.timer_ != null) {
                throw new IllegalStateException("Timer already exists.");
            }
            this.attempts_ = 0;
            this.status_ = Task.Status.scheduled;
            this.timer_ = new Timer();
            if (this.isFixedRate_) {
                this.timer_.scheduleAtFixedRate((TimerTask)new QueueProcessorTask(), this.delay_, this.period_);
            } else {
                this.timer_.schedule((TimerTask)new QueueProcessorTask(), this.delay_, this.period_);
            }
        }
        if (this.timer_ == null) {
            throw new IllegalStateException("Timer should exist.");
        }
    }

    public void stop() {
        logger_.info((Object)("Stopping processor for " + this.queueName_ + " queue."));
        if (this.status_ != Task.Status.stopped) {
            if (this.timer_ == null) {
                throw new IllegalStateException("Timer does not exist.");
            }
            this.timer_.cancel();
            this.timer_ = null;
            this.status_ = Task.Status.stopped;
        }
        if (this.timer_ != null) {
            throw new IllegalStateException("Timer should not exist.");
        }
    }

    private class QueueProcessorTask
    extends TimerTask {
        QueueProcessorTask() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block13: {
                QueueProcessor.this.status_ = Task.Status.running;
                try {
                    Event[] pendingEvents;
                    Queue queue = Queue.obtainByName(QueueProcessor.this.queueName_);
                    int count = 0;
                    while (count < QueueProcessor.this.max_ && (pendingEvents = queue.getEvents(1)).length != 0) {
                        Exception exception2;
                        Object var9_10;
                        Transaction transaction = null;
                        try {
                            transaction = Transaction.factory.create();
                            Event event = Event.obtain(pendingEvents[0].getKey());
                            boolean processed = false;
                            int k = 0;
                            while (k < QueueProcessor.this.processors_.length) {
                                EventProcessor processor = QueueProcessor.this.processors_[k];
                                if (processor.canProcess(event, transaction)) {
                                    if (logger_.isInfoEnabled()) {
                                        logger_.info((Object)("Processing Event: Processor=" + processor + ", Event=" + ObjectFormatter.instance().format(event)));
                                    }
                                    processor.process(event, transaction);
                                    processed = true;
                                    break;
                                }
                                ++k;
                            }
                            if (!processed) {
                                throw new RuntimeException("Couldn't find an event processor for " + event.getData());
                            }
                            event.setPending(false);
                            event.update(transaction);
                            transaction.commit();
                            transaction = null;
                            ++count;
                            QueueProcessor.this.attempts_ = 0;
                        }
                        catch (Throwable throwable) {
                            var9_10 = null;
                            if (transaction == null) throw throwable;
                            try {
                                transaction.rollback();
                                throw throwable;
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        {
                            var9_10 = null;
                            if (transaction == null) continue;
                        }
                        try {}
                        catch (Exception exception2) {
                            // empty catch block
                            continue;
                        }
                        transaction.rollback();
                    }
                }
                catch (Exception e) {
                    logger_.error((Object)"Couldn't process event.", (Throwable)e);
                    QueueProcessor queueProcessor = QueueProcessor.this;
                    queueProcessor.attempts_ = queueProcessor.attempts_ + 1;
                    if (QueueProcessor.this.attempts_ < 5) break block13;
                    QueueProcessor.this.stop();
                    return;
                }
            }
            QueueProcessor.this.status_ = Task.Status.scheduled;
        }
    }
}

