/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.conversion;

import gov.va.med.term.access.maint.util.UserErrors;
import gov.va.med.term.access.util.ThreadLocale;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StringConverter {
    private static Hashtable cache_ = new Hashtable();

    private static synchronized ConversionMethod conversionMethodFor(Class datatype) {
        ConversionMethod result = (ConversionMethod)cache_.get(datatype);
        if (result == null) {
            result = ConversionMethod.conversionMethodFor(datatype);
            cache_.put(datatype, result);
        }
        return result;
    }

    public static Object fromString(String from, Class datatype, String fieldName, UserErrors errors) {
        if (from == null || from.length() == 0) {
            return null;
        }
        ConversionMethod conversionMethod = StringConverter.conversionMethodFor(datatype);
        return conversionMethod.fromString(from, fieldName, errors);
    }

    public static Object fromString(String from, Class datatype) throws FormatException {
        if (from == null || from.length() == 0) {
            return null;
        }
        ConversionMethod conversionMethod = StringConverter.conversionMethodFor(datatype);
        return conversionMethod.fromString(from);
    }

    public static boolean canConvert(Class datatype) {
        ConversionMethod conversionMethod = null;
        try {
            conversionMethod = StringConverter.conversionMethodFor(datatype);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conversionMethod != null;
    }

    public static class ConversionNotSupportedException
    extends RuntimeException {
        public ConversionNotSupportedException(String message) {
            super(message);
        }
    }

    public static class FormatException
    extends Exception {
        public FormatException(String message) {
            super(message);
        }
    }

    private static abstract class ConversionMethod {
        private static final Class[] parameterTypes_;
        private Class datatype_;
        private String datatypeName_;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;
        static /* synthetic */ Class class$6;
        static /* synthetic */ Class class$7;
        static /* synthetic */ Class class$8;

        static {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            parameterTypes_ = classArray;
        }

        static ConversionMethod conversionMethodFor(Class datatype) {
            ConversionMethod result = null;
            result = datatype.isInterface() ? ConversionMethod.initFromInterface(datatype) : ConversionMethod.initFromClass(datatype);
            if (result == null) {
                throw new ConversionNotSupportedException("No obvious way to obtain a " + datatype.getName() + " from a String");
            }
            return result;
        }

        private static Class getWrapperClass(Class primitiveClass) {
            if (Boolean.TYPE.equals(primitiveClass)) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (Byte.TYPE.equals(primitiveClass)) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (Character.TYPE.equals(primitiveClass)) {
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.lang.Character");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (Short.TYPE.equals(primitiveClass)) {
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (Integer.TYPE.equals(primitiveClass)) {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (Long.TYPE.equals(primitiveClass)) {
                Class<?> clazz = class$6;
                if (clazz == null) {
                    try {
                        clazz = class$6 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (Float.TYPE.equals(primitiveClass)) {
                Class<?> clazz = class$7;
                if (clazz == null) {
                    try {
                        clazz = class$7 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            if (Double.TYPE.equals(primitiveClass)) {
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = class$8 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            throw new IllegalArgumentException("Class must represent a primitive type: " + primitiveClass.getName());
        }

        private static ConversionMethod initFromClass(Class datatype) {
            try {
                Method method;
                if (datatype.isPrimitive()) {
                    datatype = ConversionMethod.getWrapperClass(datatype);
                }
                if (Modifier.isStatic((method = datatype.getMethod("valueOf", parameterTypes_)).getModifiers())) {
                    return new ConversionMethod_StaticMethod(datatype, method);
                }
            }
            catch (Exception method) {
                // empty catch block
            }
            try {
                Constructor ctor = datatype.getConstructor(parameterTypes_);
                return new ConversionMethod_Constructor(datatype, ctor);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static ConversionMethod initFromInterface(Class datatype) {
            try {
                Field fFactory = datatype.getField("factory");
                Class<?> cFactory = fFactory.getType();
                Method method = cFactory.getMethod("obtainFromKeyString", parameterTypes_);
                Object factory = fFactory.get(null);
                return new ConversionMethod_Factory(datatype, method, factory);
            }
            catch (Exception exception) {
                return null;
            }
        }

        protected ConversionMethod(Class datatype) {
            this.datatype_ = datatype;
            this.datatypeName_ = datatype.getName();
        }

        protected String message() {
            ResourceBundle bundle2;
            String result = null;
            Locale locale = ThreadLocale.get();
            try {
                bundle2 = ResourceBundle.getBundle("gov.va.med.term.access.maint.conversion.messages", locale);
                result = bundle2.getString(this.datatypeName_);
            }
            catch (MissingResourceException bundle2) {
                // empty catch block
            }
            if (result == null) {
                try {
                    bundle2 = ResourceBundle.getBundle(String.valueOf(ConversionMethod.packagePrefix(this.datatypeName_)) + ".messages", locale);
                    result = bundle2.getString(this.datatypeName_);
                }
                catch (MissingResourceException bundle3) {
                    // empty catch block
                }
            }
            if (result == null) {
                try {
                    bundle2 = ResourceBundle.getBundle("gov.va.med.term.access.maint.conversion.messages", locale);
                    result = bundle2.getString("default");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return result == null ? "Invalid value." : result;
        }

        private static String packagePrefix(String className) {
            int p = className.lastIndexOf(46);
            className = p >= 0 ? className.substring(0, p) : null;
            return className;
        }

        Object fromString(String inputValue, String fieldName, UserErrors errors) {
            try {
                return this.convert(inputValue);
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (InvocationTargetException x) {
                errors.put(inputValue, fieldName, this.message());
                return null;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        Object fromString(String inputValue) throws FormatException {
            try {
                return this.convert(inputValue);
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (InvocationTargetException x) {
                if (x.getTargetException() instanceof RuntimeException) {
                    throw (RuntimeException)x.getTargetException();
                }
                throw new FormatException(this.message());
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        protected abstract Object convert(String var1) throws Exception;
    }

    private static class ConversionMethod_Constructor
    extends ConversionMethod {
        private Constructor constructor_;

        public ConversionMethod_Constructor(Class datatype, Constructor constructor) {
            super(datatype);
            this.constructor_ = constructor;
        }

        protected Object convert(String inputValue) throws Exception {
            Object[] arguments = new Object[]{inputValue};
            return this.constructor_.newInstance(arguments);
        }
    }

    private static class ConversionMethod_StaticMethod
    extends ConversionMethod {
        private Method converter_;

        public ConversionMethod_StaticMethod(Class datatype, Method converter) {
            super(datatype);
            this.converter_ = converter;
        }

        protected Object convert(String inputValue) throws Exception {
            Object[] arguments = new Object[]{inputValue};
            return this.converter_.invoke(null, arguments);
        }
    }

    private static class ConversionMethod_Factory
    extends ConversionMethod {
        private Method converter_;
        private Object factory_;

        public ConversionMethod_Factory(Class datatype, Method converter, Object factory) {
            super(datatype);
            this.converter_ = converter;
            this.factory_ = factory;
        }

        protected Object convert(String inputValue) throws Exception {
            Object[] arguments = new Object[]{inputValue};
            return this.converter_.invoke(this.factory_, arguments);
        }
    }
}

