/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.conversion;

import gov.va.med.term.access.maint.conversion.StringConverter;
import gov.va.med.term.access.maint.ui.dataview.TypeDescriptor;
import gov.va.med.term.access.maint.util.UserErrors;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Input {
    private static Hashtable cache_ = new Hashtable();
    static /* synthetic */ Class class$0;

    private static Storer find(Storer[] storers, String fieldName) {
        int first = 0;
        int last = storers.length - 1;
        while (first <= last) {
            int middle = (first + last) / 2;
            int compare = storers[middle].compareTo(fieldName);
            if (compare < 0) {
                first = middle + 1;
                continue;
            }
            if (compare > 0) {
                last = middle - 1;
                continue;
            }
            return storers[middle];
        }
        return null;
    }

    private static synchronized Storer storerFor(Class c, String fieldName) {
        Storer[] storers = (Storer[])cache_.get(c);
        if (storers == null) {
            storers = Input.analyze(c);
            cache_.put(c, storers);
        }
        if (fieldName.startsWith("is") && fieldName.length() > 2 && Character.isUpperCase(fieldName.charAt(2))) {
            StringBuffer result = new StringBuffer(fieldName.length() - 2);
            result.append(Character.toLowerCase(fieldName.charAt(2)));
            result.append(fieldName.substring(3));
            fieldName = result.toString();
        } else if ((fieldName.startsWith("can") || fieldName.startsWith("has")) && fieldName.length() > 3 && Character.isUpperCase(fieldName.charAt(3))) {
            StringBuffer result = new StringBuffer(fieldName.length() - 3);
            result.append(Character.toLowerCase(fieldName.charAt(3)));
            result.append(fieldName.substring(4));
            fieldName = result.toString();
        }
        return Input.find(storers, fieldName);
    }

    private static Storer[] analyze(Class c) {
        Method[] methods = c.getMethods();
        Vector<Storer> vResult = new Vector<Storer>();
        int i = methods.length;
        while (--i >= 0) {
            if (!Input.isMutator(methods[i])) continue;
            vResult.addElement(new Storer(methods[i]));
        }
        Object[] result = new Storer[vResult.size()];
        vResult.copyInto(result);
        Arrays.sort(result);
        return result;
    }

    private static boolean isMutator(Method method) {
        String name = method.getName();
        return name.startsWith("set") && name.length() > 3 && Character.isUpperCase(name.charAt(3)) && method.getParameterTypes().length == 1;
    }

    private static Method accessorFor(Class c, String fieldName) {
        Method result = null;
        try {
            String accessorName = "get" + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            result = c.getMethod(accessorName, null);
        }
        catch (Exception x) {
            try {
                result = c.getMethod(fieldName, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static Object access(Object subject, String fieldName) {
        Method accessor = Input.accessorFor(subject.getClass(), fieldName);
        if (accessor == null) {
            return null;
        }
        try {
            Object result = accessor.invoke(subject, null);
            if (result == null) {
                Storer storer = Input.storerFor(subject.getClass(), fieldName);
                if (storer == null) {
                    throw new RuntimeException("No mutator for field '" + fieldName + "' in class " + subject.getClass());
                }
                Class attributeClass = storer.datatype();
                TypeDescriptor descriptor = TypeDescriptor.factory.obtain(attributeClass);
                result = descriptor.newInstance();
                storer.store(subject, result);
            }
            return result;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public static boolean transfer(Dictionary from, Object to, UserErrors errors) {
        boolean result = true;
        Enumeration e = from.keys();
        while (e.hasMoreElements()) {
            boolean storeResult;
            Object value;
            Storer storer;
            int p;
            String inputFieldName;
            Object currentTo = to;
            String fieldName = inputFieldName = e.nextElement().toString();
            while (currentTo != null && (p = fieldName.indexOf(46)) > 0) {
                currentTo = Input.access(currentTo, fieldName.substring(0, p));
                fieldName = fieldName.substring(p + 1);
            }
            if (currentTo == null || (storer = Input.storerFor(currentTo.getClass(), fieldName)) == null || (value = from.get(inputFieldName)) == null) continue;
            if (value.getClass().isArray()) {
                storeResult = storer.store(currentTo, (String[])value, inputFieldName, errors);
                result &= storeResult;
                continue;
            }
            Class<?> clazz = value.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                storeResult = storer.store(currentTo, (String)value, inputFieldName, errors);
                result &= storeResult;
                continue;
            }
            throw new RuntimeException("Input value not a string: " + inputFieldName + " (" + value.getClass() + ")");
        }
        return result;
    }

    private static class Storer
    implements Comparable {
        private Method mutator_;
        private String fieldName_;
        private Class datatype_;

        public int compareTo(Object o) {
            return this.fieldName_.compareTo(((Storer)o).fieldName_);
        }

        public int compareTo(String s) {
            return this.fieldName_.compareTo(s);
        }

        public String fieldName() {
            return this.fieldName_;
        }

        public Class datatype() {
            return this.datatype_;
        }

        public Storer(Method mutator) {
            this.mutator_ = mutator;
            this.fieldName_ = this.fieldName(mutator.getName());
            this.datatype_ = mutator.getParameterTypes()[0];
        }

        public boolean store(Object to, String[] value, String fieldName, UserErrors errors) {
            throw new RuntimeException("Array input not accepted yet");
        }

        public boolean store(Object to, String value, String fieldName, UserErrors errors) {
            Object convertedValue;
            if ((value = value.trim()).length() == 0) {
                convertedValue = null;
            } else {
                convertedValue = StringConverter.fromString(value, this.datatype_, fieldName, errors);
                if (convertedValue == null) {
                    return false;
                }
            }
            this.store(to, convertedValue);
            return true;
        }

        public void store(Object object, Object value) {
            Object[] arguments = new Object[]{value};
            try {
                this.mutator_.invoke(object, arguments);
            }
            catch (InvocationTargetException x) {
                throw new RuntimeException(x.getTargetException());
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        private String fieldName(String mutatorName) {
            StringBuffer result = new StringBuffer(mutatorName.length());
            result.append(Character.toLowerCase(mutatorName.charAt(3)));
            if (mutatorName.length() > 4) {
                result.append(mutatorName.substring(4));
            }
            return result.toString();
        }
    }
}

