/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.command;

import gov.va.med.term.access.maint.command.Command;
import gov.va.med.term.access.maint.conversion.Input;
import gov.va.med.term.access.maint.factory.db.hibernate.HibernateSession;
import gov.va.med.term.access.maint.util.Maintainable;
import gov.va.med.term.access.maint.util.Transaction;
import gov.va.med.term.access.maint.util.UserErrors;
import java.util.Dictionary;

public class Update
implements Command {
    public boolean apply(Object subject, Dictionary newValues, UserErrors errors) {
        Transaction transaction = Transaction.factory.create();
        try {
            boolean result = this.apply_(subject, newValues, errors);
            if (result) {
                transaction.commit();
            } else {
                transaction.rollback();
            }
            return result;
        }
        catch (RuntimeException x) {
            transaction.rollback();
            throw x;
        }
        catch (Throwable t) {
            transaction.rollback();
            throw new RuntimeException(t);
        }
    }

    private boolean apply_(Object subject, Dictionary newValues, UserErrors errors) {
        Maintainable object = (Maintainable)subject;
        Maintainable clone = (Maintainable)object.clone();
        Input.transfer(newValues, clone, errors);
        clone.validateForUpdate(object, errors);
        if (errors.isEmpty()) {
            if (!this.hibernateInUse()) {
                clone.update();
                object.copy(clone);
            } else {
                Object backup = object.clone();
                object.copy(clone);
                try {
                    object.update();
                }
                catch (Exception x) {
                    object.copy(backup);
                }
            }
            return true;
        }
        return false;
    }

    private boolean hibernateInUse() {
        return HibernateSession.isActive();
    }
}

