/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.command;

import gov.va.med.term.access.maint.command.Command;
import gov.va.med.term.access.maint.conversion.Input;
import gov.va.med.term.access.maint.util.Maintainable;
import gov.va.med.term.access.maint.util.Transaction;
import gov.va.med.term.access.maint.util.UserErrors;
import java.util.Dictionary;

public class Create
implements Command {
    public boolean apply(Object subject, Dictionary newValues, UserErrors errors) {
        Transaction transaction = Transaction.factory.create();
        try {
            boolean result = this.apply_(subject, newValues, errors);
            if (result) {
                transaction.commit();
            } else {
                transaction.rollback();
            }
            return result;
        }
        catch (RuntimeException x) {
            transaction.rollback();
            throw x;
        }
        catch (Throwable t) {
            transaction.rollback();
            throw new RuntimeException(t);
        }
    }

    private boolean apply_(Object subject, Dictionary newValues, UserErrors errors) {
        Maintainable object = (Maintainable)subject;
        Input.transfer(newValues, object, errors);
        object.validateForCreate(errors);
        if (errors.isEmpty()) {
            object.create();
            return true;
        }
        return false;
    }
}

