/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external;

import gov.va.med.caip.client.factory.BusinessDelegateFactory;
import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;
import gov.va.med.esr.service.external.demographics.DemographicsChangeSummary;
import gov.va.med.esr.service.external.demographics.DemographicsChangeType;
import gov.va.med.esr.service.external.demographics.DemographicsService;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EligibilitySummary;
import gov.va.med.esr.service.external.person.EntityKeyFactory;
import gov.va.med.esr.service.external.person.PersonFinderFactory;
import gov.va.med.esr.service.external.person.PersonService;
import gov.va.med.esr.service.external.person.VPIDEntityKey;
import gov.va.med.esr.service.external.person.ejb.PersonServiceHome;
import gov.va.med.esr.service.external.person.ejb.RemotePersonService;
import java.util.Properties;
import javax.naming.InitialContext;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weblogic.rmi.extensions.PortableRemoteObject;

public class TestCAIPClientToESR
extends TestCase {
    private static final String PSD_DELEGATE_ID = "ESRDemographicsService";
    private static final String PSIM_DELEGATE_ID = "ESRPersonService";
    private static final String INVALID_VPID = "intentionallyBadVPIDSoItWillFailOnESRServer";
    private static final String VALID_VPID = "0000001004230528V674248000000";
    private static final String VALID_DFN = "44212";
    private static final String VALID_STATION_NUMBER = "442";
    private static final String VALID_ADDRESS_ID = "109698";
    private static final String VALID_PHONE_ID = "112441";
    private static final String ACCOUNT_NAME = "user1";
    private static final String REQUEST_NAME = "request_financials_only";
    private static final String TEST_VPID = "intentionallyBadVPIDSoItWillFailOnESRServer";
    static /* synthetic */ Class class$gov$va$med$esr$service$external$TestCAIPClientToESR;
    static /* synthetic */ Class class$gov$va$med$esr$service$external$person$PersonService;

    public void testAbilityToGetDelegateForPSD() throws Exception {
        DemographicsService delegate = (DemographicsService)this.getDelegate(PSD_DELEGATE_ID);
        TestCAIPClientToESR.assertNotNull((Object)delegate);
    }

    public void testAbilityToGetDelegateForPSIM() throws Exception {
        PersonService delegate = (PersonService)this.getDelegate(PSIM_DELEGATE_ID);
        TestCAIPClientToESR.assertNotNull((Object)delegate);
    }

    public void testGetEligibilitySummary() throws Exception {
        System.setProperty("myCaipConfig.xml", "D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_Dev02\\vobs\\HECMS_common\\config\\shared\\caip\\local\\caipConfig.xml");
        System.setProperty("DSKey.store", "D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_3.1_ST\\vobs\\HECMS_common\\config\\shared\\caip\\caipService.jks");
        PersonService delegate = (PersonService)this.getDelegate(PSIM_DELEGATE_ID);
        EligibilitySummary es = delegate.getEligibilitySummary(EntityKeyFactory.createVPIDEntityKey(VALID_VPID));
        System.out.println("EligibilitySummary: " + es);
    }

    public void testEESummary() throws Exception {
        System.setProperty("myCaipConfig.xml", "D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_Dev02\\vobs\\HECMS_common\\config\\shared\\caip\\local\\caipConfig.xml");
        System.setProperty("DSKey.store", "D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_3.1_ST\\vobs\\HECMS_common\\config\\shared\\caip\\caipService.jks");
        EntityFinder entityFinder = PersonFinderFactory.createVPIDFinder(VALID_VPID, ACCOUNT_NAME, REQUEST_NAME);
        Boolean test = new Boolean(null);
        System.out.println("EligibilitySummary Test: " + test);
        PersonService delegate = (PersonService)this.getDelegate(PSIM_DELEGATE_ID);
        EESummary ee = delegate.getEESummary(entityFinder);
        System.out.println("EligibilitySummary: " + ee);
    }

    public void testDemographicsChange() throws Exception {
        DemographicsService delegate = (DemographicsService)this.getDelegate(PSD_DELEGATE_ID);
        VPIDEntityKey vpid = EntityKeyFactory.createVPIDEntityKey("intentionallyBadVPIDSoItWillFailOnESRServer");
        DemographicsChangeSummary summary = new DemographicsChangeSummary(vpid);
        DemographicsChangeEvent event = new DemographicsChangeEvent(DemographicsChangeType.OTHER_CHANGE);
        event.setEntityKey(EntityKeyFactory.createEntityKey("notUsed"));
        summary.addChangeEvent(event);
        event = new DemographicsChangeEvent(DemographicsChangeType.DATE_OF_DEATH_CHANGE);
        summary.addChangeEvent(event);
        DemographicsChangeEvent addressEvent = new DemographicsChangeEvent(DemographicsChangeType.ADDRESS_CHANGE);
        addressEvent.setEntityKey(EntityKeyFactory.createEntityKey(VALID_ADDRESS_ID));
        summary.addChangeEvent(addressEvent);
        event = new DemographicsChangeEvent(DemographicsChangeType.PHONE_CHANGE);
        event.setEntityKey(EntityKeyFactory.createEntityKey(VALID_PHONE_ID));
        summary.addChangeEvent(event);
        delegate.notifyOfDemographicsChange(summary);
        boolean hadExpectedFailure = false;
        addressEvent.setEntityKey(null);
        try {
            delegate.notifyOfDemographicsChange(summary);
        }
        catch (ESRException e) {
            hadExpectedFailure = true;
        }
        TestCAIPClientToESR.assertTrue((boolean)hadExpectedFailure);
    }

    public void testLinkEvent() throws Exception {
        PersonService delegate = (PersonService)this.getDelegate(PSIM_DELEGATE_ID);
        VPIDEntityKey vpid1 = EntityKeyFactory.createDeprecatedVPIDEntityKey("intentionallyBadVPIDSoItWillFailOnESRServer");
        VPIDEntityKey vpid2 = EntityKeyFactory.createVPIDEntityKey("intentionallyBadVPIDSoItWillFailOnESRServer");
        delegate.link(vpid1, vpid2);
    }

    public void testMoveEvent() throws Exception {
        PersonService delegate = (PersonService)this.getDelegate(PSIM_DELEGATE_ID);
        VPIDEntityKey fromVpid = EntityKeyFactory.createVPIDEntityKey("intentionallyBadVPIDSoItWillFailOnESRServer");
        VPIDEntityKey toVpid = EntityKeyFactory.createVPIDEntityKey("intentionallyBadVPIDSoItWillFailOnESRServer");
        delegate.move(VALID_DFN, VALID_STATION_NUMBER, fromVpid, toVpid);
    }

    private Object getDelegate(String delegateId) throws Exception {
        return BusinessDelegateFactory.getBusinessDelegate((String)delegateId);
    }

    public static Test suite() {
        return new TestSuite(class$gov$va$med$esr$service$external$TestCAIPClientToESR == null ? (class$gov$va$med$esr$service$external$TestCAIPClientToESR = TestCAIPClientToESR.class$("gov.va.med.esr.service.external.TestCAIPClientToESR")) : class$gov$va$med$esr$service$external$TestCAIPClientToESR);
    }

    public static void main(String[] args) {
        System.setProperty("myCaipConfig.xml", "D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_3.1_ST\\vobs\\HECMS_common\\config\\shared\\caip\\local\\caipConfig.xml");
        System.setProperty("DSKey.store", "D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_3.1_ST\\vobs\\HECMS_common\\config\\shared\\caip\\caipService.jks");
        TestRunner.run((Test)TestCAIPClientToESR.suite());
    }

    public void testESR() throws Exception {
        String initialContextFactory = "weblogic.jndi.WLInitialContextFactory";
        String localContextURL = "t3://DNS   app18.aac.DNS   :7302";
        Properties p = new Properties();
        p.put("java.naming.factory.initial", initialContextFactory);
        p.put("java.naming.provider.url", localContextURL);
        p.put("java.naming.security.principal", "esrsvcusr");
        p.put("java.naming.security.credentials", "esrsvcusr");
        InitialContext ctx = new InitialContext(p);
        Object obj = ctx.lookup("ejb/PersonServiceBean");
        PersonServiceHome pHome = (PersonServiceHome)PortableRemoteObject.narrow((Object)obj, (Class)(class$gov$va$med$esr$service$external$person$PersonService == null ? (class$gov$va$med$esr$service$external$person$PersonService = TestCAIPClientToESR.class$("gov.va.med.esr.service.external.person.PersonService")) : class$gov$va$med$esr$service$external$person$PersonService));
        RemotePersonService remote = pHome.create();
        VPIDEntityKey vpid1 = EntityKeyFactory.createDeprecatedVPIDEntityKey("intentionallyBadVPIDSoItWillFailOnESRServer");
        VPIDEntityKey vpid2 = EntityKeyFactory.createVPIDEntityKey("intentionallyBadVPIDSoItWillFailOnESRServer");
        remote.link(vpid1, vpid2);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

