/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.ConfidentialAddressCategory;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.PreferredLanguage;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.service.external.DemographicSummaryFactory;
import gov.va.med.esr.service.external.person.AddressInfo;
import gov.va.med.esr.service.external.person.AssociationInfo;
import gov.va.med.esr.service.external.person.BaseAddressInfo;
import gov.va.med.esr.service.external.person.ContactInfo;
import gov.va.med.esr.service.external.person.DemographicInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EmailInfo;
import gov.va.med.esr.service.external.person.EmploymentInfo;
import gov.va.med.esr.service.external.person.InsuranceInfo;
import gov.va.med.esr.service.external.person.PhoneInfo;
import gov.va.med.esr.service.external.person.RelationInfo;
import gov.va.med.esr.service.external.person.SSNInfo;
import gov.va.med.esr.service.external.person.SensitivityInfo;
import gov.va.med.esr.service.external.person.collections.AddressCollection;
import gov.va.med.esr.service.external.person.collections.ConfidentialAddressCategoryCollection;
import gov.va.med.esr.service.external.person.collections.EmailCollection;
import gov.va.med.esr.service.external.person.collections.PhoneCollection;
import gov.va.med.esr.service.external.person.collections.RaceCollection;
import gov.va.med.esr.service.external.person.collections.SSNCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DemographicSummaryFactoryImpl
implements DemographicSummaryFactory {
    public static final String CONTACT_METHOD_TYPE_CODE = "08";
    private PreferredFacilityService preferredFacilityService = null;

    @Override
    public void applyDemographicsInfo(Person person, EESummary eeSummary) {
        PhoneInfo[] phones;
        EmailInfo[] emails;
        DemographicInfo demographicInfo = new DemographicInfo();
        ContactInfo contactInfo = new ContactInfo();
        this.buildBaseFields(person, demographicInfo);
        AddressInfo[] addresses = this.buildAddress(person);
        if (addresses != null) {
            contactInfo.setAddresses(new AddressCollection(addresses));
        }
        if ((emails = this.applyEmailData(person)) != null && emails.length > 0) {
            contactInfo.setEmails(new EmailCollection(emails));
        }
        if ((phones = this.buildPhones(person.getPhones())) != null && phones.length > 0) {
            contactInfo.setPhones(new PhoneCollection(phones));
        }
        demographicInfo.setContactInfo(contactInfo);
        this.buildBaseFields(person, demographicInfo);
        eeSummary.setDemographics(demographicInfo);
        this.buildSensitivityInfo(person, eeSummary);
    }

    private void buildBaseFields(Person person, DemographicInfo demographicInfo) {
        Set races;
        PreferredFacility pf = this.getPreferredFacilityService().getMostRecentPreferredFacility(person);
        if (pf != null && pf.getFacility() != null && pf.getFacility().getSiteNumberAndName() != null) {
            demographicInfo.setPreferredFacility(pf.getFacility().getSiteNumberAndName());
        }
        if (pf != null && pf.getAssignmentDate() != null) {
            demographicInfo.setAssignmentDate(pf.getAssignmentDate());
        }
        if (pf != null && pf.getUnassignmentDate() != null) {
            demographicInfo.setAssignmentDate(pf.getUnassignmentDate());
        }
        if (person.getClaimFolderLocation() != null) {
            demographicInfo.setClaimFolderLocation(person.getClaimFolderLocation().getSiteNumberAndName());
        }
        demographicInfo.setClaimFolderNumber(person.getClaimFolderNumber());
        demographicInfo.setAppointmentRequestDate(person.getAppointmentRequestDate());
        demographicInfo.setAppointmentRequestResponse(person.getAppointmentRequestResponse());
        PreferredLanguage pl = person.getPreferredLanguage();
        if (pl != null) {
            demographicInfo.setPreferredLanguage(pl.getLanguage().getCodeAndDescription());
            demographicInfo.setPreferredLanguageEntryDate(pl.getLanguageEntryDate());
        }
        if ((races = person.getRaces()) != null) {
            String[] raceInfos = new String[races.size()];
            Iterator raceIter = races.iterator();
            int i = 0;
            while (raceIter.hasNext()) {
                Race race = (Race)raceIter.next();
                raceInfos[i] = race.getRaceType().getName();
                ++i;
            }
            if (raceInfos != null && raceInfos.length > 0) {
                demographicInfo.setRaces(new RaceCollection(raceInfos));
            }
        }
        if (person.getMaritalStatus() != null) {
            demographicInfo.setMaritalStatus(person.getMaritalStatus().getName());
        }
        if (person.getReligion() != null) {
            demographicInfo.setReligion(person.getReligion().getName());
        }
        if (person.getEthnicity() != null && person.getEthnicity().getEthnicityType() != null) {
            demographicInfo.setEthnicity(person.getEthnicity().getEthnicityType().getName());
        }
    }

    @Override
    public String[] buildConfidentialAddressCategories(Person person) {
        Set categories = person.getConfidentialAddressCategories();
        if (categories == null) {
            return null;
        }
        String[] categoryList = new String[categories.size()];
        Iterator categoryItr = categories.iterator();
        int i = 0;
        while (categoryItr.hasNext()) {
            String val;
            ConfidentialAddressCategory category = (ConfidentialAddressCategory)categoryItr.next();
            categoryList[i] = val = category.getType() != null ? category.getType().getDescription() : null;
            ++i;
        }
        return categoryList;
    }

    @Override
    public AddressInfo[] buildAddress(Person person) {
        Set addressSet = person.getAddresses();
        if (addressSet == null) {
            return null;
        }
        AddressInfo[] addressInfoArray = new AddressInfo[addressSet.size()];
        Iterator itr = addressSet.iterator();
        int i = 0;
        while (itr != null && itr.hasNext()) {
            String[] confidentialAddressTypes;
            AddressInfo addressInfo;
            Address address = (Address)itr.next();
            addressInfoArray[i] = addressInfo = this.buildAddressInfo(address);
            if (address.getType() != null && AddressType.CODE_CONFIDENTIAL_ADDRESS.getCode().equals(address.getType().getCode()) && (confidentialAddressTypes = this.buildConfidentialAddressCategories(person)) != null) {
                addressInfo.setConfidentialAddressCategories(new ConfidentialAddressCategoryCollection(confidentialAddressTypes));
            }
            if (address.getType() != null && (AddressType.CODE_PERMANENT_ADDRESS.getCode().equals(address.getType().getCode()) || AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getCode().equals(address.getType().getCode()))) {
                addressInfo.setContactMethodType(CONTACT_METHOD_TYPE_CODE);
                addressInfo.setContactMethodReportDate(address.getModifiedOn());
            }
            ++i;
        }
        return addressInfoArray;
    }

    @Override
    public AddressInfo buildAddressInfo(Address address) {
        if (address == null) {
            return null;
        }
        AddressInfo addressInfo = new AddressInfo();
        addressInfo.setLine1(address.getInternalLine1());
        addressInfo.setLine2(address.getInternalLine2());
        addressInfo.setLine3(address.getInternalLine3());
        addressInfo.setPostalCode(address.getPostalCode());
        addressInfo.setZipCode(address.getZipCode());
        addressInfo.setZipPlus4(address.getZipPlus4());
        addressInfo.setCity(address.getCity());
        addressInfo.setState(address.getState());
        addressInfo.setProvinceCode(address.getProvince());
        addressInfo.setCounty(address.getCounty());
        addressInfo.setCountry(address.getCountry());
        addressInfo.setAddressChangeDateTime(address.getChangeDate());
        addressInfo.setAddressChangeEffectiveDate(address.getStartDate() != null ? address.getStartDate().getStandardFormat() : null);
        addressInfo.setEndDate(address.getEndDate() != null ? address.getEndDate().getStandardFormat() : null);
        if (address.getChangeSite() != null) {
            addressInfo.setAddressChangeSite(address.getChangeSite().getSiteNumberAndName() != null ? address.getChangeSite().getSiteNumberAndName() : null);
        }
        if (address.getChangeSource() != null) {
            addressInfo.setAddressChangeSource(address.getChangeSource().getDescription() != null ? address.getChangeSource().getDescription() : null);
        }
        if (address.getType() != null) {
            addressInfo.setAddressTypeCode(address.getType().getCode() != null ? address.getType().getName() : null);
        }
        if (address.getBadAddressReason() != null) {
            addressInfo.setBadAddressReason(address.getBadAddressReason().getName());
        }
        addressInfo.setPhoneNumber(address.getPhoneNumber());
        return addressInfo;
    }

    private EmailInfo[] applyEmailData(Person person) {
        Set emails = person.getEmails();
        if (emails == null) {
            return null;
        }
        EmailInfo[] emailInfos = new EmailInfo[emails.size()];
        Iterator emailIter = emails.iterator();
        int i = 0;
        while (emailIter.hasNext()) {
            Email email = (Email)emailIter.next();
            EmailInfo emailInfo = new EmailInfo();
            if (email.getType() != null) {
                emailInfo.setType(email.getType().getDescription());
            }
            emailInfo.setAddress(email.getAddress());
            if (email.getSiteOfChange() != null) {
                emailInfo.setSiteOfChange(email.getSiteOfChange().getSiteNumberAndName());
            }
            if (email.getSourceOfChange() != null) {
                emailInfo.setSourceOfChange(email.getSourceOfChange().getDescription());
            }
            emailInfos[i] = emailInfo;
            ++i;
        }
        return emailInfos;
    }

    @Override
    public AssociationInfo[] buildContacts(Person person) {
        Set associationSet = person.getAllAssociations();
        AssociationInfo[] eeAssociationInfo = new AssociationInfo[associationSet.size()];
        Iterator itr = associationSet != null ? associationSet.iterator() : null;
        int i = 0;
        while (itr != null && itr.hasNext()) {
            Name name;
            AssociationInfo associationInfo = new AssociationInfo();
            Association contact = (Association)itr.next();
            if (contact.getType() != null) {
                associationInfo.setContactType(contact.getType() != null ? contact.getType().getDescription() : null);
            }
            if ((name = contact.getRepresentativeName()) != null) {
                associationInfo.setFamilyName(name.getFamilyName() != null ? name.getFamilyName() : null);
                associationInfo.setGivenName(name.getGivenName() != null ? name.getGivenName() : null);
                associationInfo.setMiddleName(name.getMiddleName() != null ? name.getMiddleName() : null);
                associationInfo.setSuffix(name.getSuffix());
                associationInfo.setPrefix(name.getPrefix());
            }
            associationInfo.setRelationship(contact.getRelationship() != null ? contact.getRelationship() : null);
            Address contactAddress = contact.getAddress();
            if (contactAddress != null) {
                BaseAddressInfo baseAddressInfo = new BaseAddressInfo();
                baseAddressInfo.setLine1(contactAddress.getInternalLine1());
                baseAddressInfo.setLine2(contactAddress.getInternalLine2());
                baseAddressInfo.setLine3(contactAddress.getInternalLine3());
                baseAddressInfo.setPostalCode(contactAddress.getPostalCode());
                baseAddressInfo.setZipCode(contactAddress.getZipCode());
                baseAddressInfo.setZipPlus4(contactAddress.getZipPlus4());
                baseAddressInfo.setCity(contactAddress.getCity());
                baseAddressInfo.setState(contactAddress.getState());
                associationInfo.setAddress(baseAddressInfo);
            }
            associationInfo.setOrganizationName(contact.getOrganizationName());
            associationInfo.setPrimaryPhone(contact.getPrimaryPhone());
            associationInfo.setAlternatePhone(contact.getAlternatePhone());
            associationInfo.setLastUpdateDate(contact.getLastUpdateDate());
            eeAssociationInfo[i] = associationInfo;
            ++i;
        }
        return eeAssociationInfo;
    }

    @Override
    public RelationInfo[] buildRelations(Person person) {
        Set relationSet = person.getRelations();
        if (relationSet == null) {
            return null;
        }
        ArrayList<RelationInfo> relList = new ArrayList<RelationInfo>();
        Iterator itr = relationSet.iterator();
        int i = 0;
        while (itr != null && itr.hasNext()) {
            Relation relation = (Relation)itr.next();
            RelationInfo relationInfo = this.populateRelationInfo(relation, new RelationInfo());
            relList.add(relationInfo);
            ++i;
        }
        return relList.toArray(new RelationInfo[relList.size()]);
    }

    @Override
    public RelationInfo populateRelationInfo(Relation relation, RelationInfo relationInfo) {
        if (relation == null) {
            return null;
        }
        Name name = relation.getName();
        if (name != null) {
            relationInfo.setFamilyName(name.getFamilyName());
            relationInfo.setGivenName(name.getGivenName());
            relationInfo.setMiddleName(name.getMiddleName());
            relationInfo.setPrefix(name.getPrefix());
            relationInfo.setSuffix(name.getSuffix());
        }
        relationInfo.setDob(relation.getDob() != null ? relation.getDob().getStandardFormat() : null);
        relationInfo.setGender(relation.getGender() != null ? relation.getGender().getName() : null);
        relationInfo.setStartDate(relation.getStartDate() != null ? relation.getStartDate().getStandardFormat() : null);
        relationInfo.setEndDate(relation.getEndDate());
        relationInfo.setRelationship(relation.getRelationship() != null ? relation.getRelationship().getDescription() : null);
        Set ssnSet = relation.getSsns();
        if (ssnSet != null && ssnSet.size() > 0) {
            SSNInfo[] eeDependSSNInfo = new SSNInfo[ssnSet.size()];
            Iterator ssnItr = ssnSet != null ? ssnSet.iterator() : null;
            int count = 0;
            while (ssnItr != null && ssnItr.hasNext()) {
                SSN ssn = (SSN)ssnItr.next();
                SSNInfo ssnInfo = new SSNInfo();
                ssnInfo.setSsnText(ssn.getFormattedSsnText());
                ssnInfo.setSourceOfChange(ssn.getSourceOfChange() != null ? ssn.getSourceOfChange().getCode() : null);
                ssnInfo.setSsaMessage(ssn.getSsaMessage() != null ? ssn.getSsaMessage().getDescription() : null);
                ssnInfo.setPseudoSSNReason(ssn.getPseudoSSNReason() != null ? ssn.getPseudoSSNReason().getDescription() : null);
                ssnInfo.setSsaReceivedDate(ssn.getSsaReceivedDate());
                ssnInfo.setSsaSentDate(ssn.getSsaSentDate());
                ssnInfo.setSsaVerificationDate(ssn.getSsaVerificationDate());
                ssnInfo.setSsaVerificationStatus(ssn.getSsaVerificationStatus() != null ? ssn.getSsaVerificationStatus().getDescription() : null);
                ssnInfo.setType(ssn.getType() != null ? ssn.getType().getName() : null);
                eeDependSSNInfo[count] = ssnInfo;
                ++count;
            }
            if (eeDependSSNInfo != null && eeDependSSNInfo.length > 0) {
                relationInfo.setSsns(new SSNCollection(eeDependSSNInfo));
            }
        }
        relationInfo.setEndDate(relation.getEndDate());
        return relationInfo;
    }

    @Override
    public InsuranceInfo[] buildInsurance(Person person) {
        Set insuranceSet = person.getInsurances();
        if (insuranceSet == null) {
            return null;
        }
        InsuranceInfo[] eeInsuranceInfo = new InsuranceInfo[insuranceSet.size()];
        Iterator itr = insuranceSet.iterator();
        int count = 0;
        while (itr != null && itr.hasNext()) {
            InsurancePolicy insurance = (InsurancePolicy)itr.next();
            InsuranceInfo insuranceInfo = new InsuranceInfo();
            insuranceInfo.setCompanyName(insurance.getCompanyName());
            insuranceInfo.setGroupNumber(insurance.getGroupNumber());
            insuranceInfo.setGroupName(insurance.getGroupName());
            insuranceInfo.setPolicyHolderName(insurance.getSubscriber() != null ? insurance.getSubscriber().getName() : null);
            insuranceInfo.setInsuredRelationship(insurance.getSubscriber() != null ? (insurance.getSubscriber().getRelationship() != null ? insurance.getSubscriber().getRelationship().getDescription() : null) : null);
            Address insAddress = insurance.getAddress();
            AddressInfo insAddressInfo = this.buildAddressInfo(insAddress);
            if (insAddressInfo != null) {
                insAddressInfo.setContactMethodType(CONTACT_METHOD_TYPE_CODE);
                insAddressInfo.setContactMethodReportDate(insAddress.getModifiedOn());
            }
            insuranceInfo.setInsAddress(insAddressInfo);
            HashSet<Phone> insurancePhones = new HashSet<Phone>();
            Phone insBusPhone = insurance.getBusinessPhone();
            Phone insFax = insurance.getFax();
            Phone insPreCerftPhone = insurance.getPreCertificationPhone();
            if (insBusPhone != null) {
                insurancePhones.add(insBusPhone);
            }
            if (insFax != null) {
                insurancePhones.add(insFax);
            }
            if (insPreCerftPhone != null) {
                insurancePhones.add(insPreCerftPhone);
            }
            if (insurancePhones.size() > 0) {
                insuranceInfo.setInsurancePhones(new PhoneCollection(this.buildPhones(insurancePhones)));
            }
            if (insurance instanceof PrivateInsurance) {
                if (((PrivateInsurance)insurance).getPolicyEffectiveDate() != null) {
                    String policyEffectiveDate = ((PrivateInsurance)insurance).getPolicyEffectiveDate().getStandardFormat();
                    insuranceInfo.setPolicyEffectiveDate(policyEffectiveDate);
                }
                if (((PrivateInsurance)insurance).getPolicyExpirationDate() != null) {
                    String policyExpirationDate = ((PrivateInsurance)insurance).getPolicyExpirationDate().getStandardFormat();
                    insuranceInfo.setPolicyExpirationDate(policyExpirationDate);
                }
                insuranceInfo.setPolicyNumber(((PrivateInsurance)insurance).getPolicyNumber());
            } else if (insurance instanceof Medicare) {
                Medicare medicare = (Medicare)insurance;
                String groupName = medicare.getGroupName();
                String groupNumber = medicare.getGroupNumber();
                if (groupName != null && groupName.equalsIgnoreCase("PART A") || groupNumber != null && groupNumber.equalsIgnoreCase("PART A")) {
                    String partAEffectiveDate = null;
                    if (medicare != null && medicare.getPartAEffectiveDate() != null) {
                        partAEffectiveDate = medicare.getPartAEffectiveDate().getStandardFormat();
                    }
                    insuranceInfo.setPartAEffectiveDate(partAEffectiveDate);
                    insuranceInfo.setEnrolledInPartA(medicare.getEnrolledInPartA());
                } else if (groupName != null && groupName.equalsIgnoreCase("PART B") || groupNumber != null && groupNumber.equalsIgnoreCase("PART B")) {
                    String partBEffectiveDate = null;
                    if (medicare != null && medicare.getPartBEffectiveDate() != null) {
                        partBEffectiveDate = medicare.getPartBEffectiveDate().getStandardFormat();
                    }
                    insuranceInfo.setPartBEffectiveDate(partBEffectiveDate);
                    insuranceInfo.setEnrolledInPartB(medicare.getEnrolledInPartB());
                }
                insuranceInfo.setPolicyNumber(medicare.getMedicareClaimNumber());
            }
            insuranceInfo.setPlanType(insurance.getInsurancePlan() != null ? (insurance.getInsurancePlan().getPlanType() != null ? insurance.getInsurancePlan().getPlanType().getDescription() : null) : null);
            insuranceInfo.setInsuranceMappingTypeName(insurance.getInsurancePlan() != null ? (insurance.getInsurancePlan().getPlanType() != null ? insurance.getInsurancePlan().getPlanType().getName() : null) : null);
            if (insurance.getInsuranceSiteUploadStatus() != null) {
                insuranceInfo.setInsuranceSiteUploadStatus(insurance.getInsuranceSiteUploadStatus() != null ? insurance.getInsuranceSiteUploadStatus().getDescription() : null);
            }
            insuranceInfo.setLastEditedDate(insurance.getModifiedOn());
            insuranceInfo.setReasonInsuranceNotUploaded(insurance.getReasonInsuranceNotUploaded() != null ? insurance.getReasonInsuranceNotUploaded().getDescription() : null);
            if (insurance.getInsurancePlan() != null) {
                insuranceInfo.setPreadmitCertification(insurance.getInsurancePlan().getPrecertificationRequired());
            }
            eeInsuranceInfo[count] = insuranceInfo;
            ++count;
        }
        return eeInsuranceInfo;
    }

    @Override
    public EmploymentInfo buildEmployment(Person person) {
        Employment employment = person.getEmployment();
        return this.buildEmployment(employment);
    }

    @Override
    public EmploymentInfo buildEmployment(Employment employment) {
        if (employment == null) {
            return null;
        }
        EmploymentInfo employmentInfo = new EmploymentInfo();
        if (employment != null) {
            employmentInfo.setEmployerName(employment.getEmployerName());
            employmentInfo.setEmployerPhone(employment.getEmployerPhone());
            employmentInfo.setOccupation(employment.getOccupation());
            employmentInfo.setEmploymentStatus(employment.getEmploymentStatus() != null ? employment.getEmploymentStatus().getDescription() : null);
            if (employment.getRetirementDate() != null) {
                employmentInfo.setRetirementDate(employment.getRetirementDate().toString());
            }
            Address empAddress = employment.getEmployerAddress();
            employmentInfo.setEmployerAddress(this.buildAddressInfo(empAddress));
        }
        return employmentInfo;
    }

    private void buildSensitivityInfo(Person person, EESummary summary) {
        SensitivityInfo sensitivityInfo = new SensitivityInfo();
        sensitivityInfo.setSensitivityChangeDate(person.getSensitivityChangeDate());
        sensitivityInfo.setSensityFlag(person.getSensitiveRecord());
        if (person.getSensitivityChangeSite() != null) {
            sensitivityInfo.setSensitivityChangeSite(person.getSensitivityChangeSite().getSiteNumberAndName());
        }
        if (person.getSensitivityChangeSource() != null) {
            sensitivityInfo.setSensitivityChangeSource(person.getSensitivityChangeSource().getDescription());
        }
        summary.setSensitivityInfo(sensitivityInfo);
    }

    private PhoneInfo[] buildPhones(Set phones) {
        if (phones == null) {
            return null;
        }
        PhoneInfo[] phoneInfos = new PhoneInfo[phones.size()];
        Iterator phoneItr = phones.iterator();
        int i = 0;
        while (phoneItr.hasNext()) {
            Phone phone = (Phone)phoneItr.next();
            PhoneInfo pInfo = new PhoneInfo();
            pInfo.setPhoneNumber(phone.getPhoneNumber());
            pInfo.setPhoneNumberReportDate(phone.getModifiedOn());
            if (phone.getType() != null) {
                pInfo.setType(phone.getType().getDescription());
            }
            phoneInfos[i] = pInfo;
            ++i;
        }
        return phoneInfos;
    }

    public PreferredFacilityService getPreferredFacilityService() {
        return this.preferredFacilityService;
    }

    public void setPreferredFacilityService(PreferredFacilityService preferredFacilityService) {
        this.preferredFacilityService = preferredFacilityService;
    }
}

