/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.external.DemographicSummaryFactory;
import gov.va.med.esr.service.external.FinancialsSummaryFactory;
import gov.va.med.esr.service.external.person.AddressInfo;
import gov.va.med.esr.service.external.person.AssetInfo;
import gov.va.med.esr.service.external.person.BeneficiaryTravelInfo;
import gov.va.med.esr.service.external.person.DebitInfo;
import gov.va.med.esr.service.external.person.DependentFinancialsInfo;
import gov.va.med.esr.service.external.person.DependentInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EmploymentInfo;
import gov.va.med.esr.service.external.person.ExpenseInfo;
import gov.va.med.esr.service.external.person.FinancialStatementInfo;
import gov.va.med.esr.service.external.person.FinancialsInfo;
import gov.va.med.esr.service.external.person.HardshipInfo;
import gov.va.med.esr.service.external.person.IncomeInfo;
import gov.va.med.esr.service.external.person.IncomeTestInfo;
import gov.va.med.esr.service.external.person.IncomeTestStatusInfo;
import gov.va.med.esr.service.external.person.SignatureImageInfo;
import gov.va.med.esr.service.external.person.SpouseFinancialsInfo;
import gov.va.med.esr.service.external.person.SpouseInfo;
import gov.va.med.esr.service.external.person.collections.AssetCollection;
import gov.va.med.esr.service.external.person.collections.BeneficiaryTravelCollection;
import gov.va.med.esr.service.external.person.collections.DependentFinancialsCollection;
import gov.va.med.esr.service.external.person.collections.ExpenseCollection;
import gov.va.med.esr.service.external.person.collections.IncomeCollection;
import gov.va.med.esr.service.external.person.collections.IncomeTestStatusCollection;
import gov.va.med.esr.service.external.person.collections.SpouseFinancialsCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FinancialsSummaryFactoryImpl
implements FinancialsSummaryFactory {
    private PersonHelperService personHelperService = null;
    private DemographicSummaryFactory demographicSummaryFactory = null;

    public DemographicSummaryFactory getDemographicSummaryFactory() {
        return this.demographicSummaryFactory;
    }

    public void setDemographicSummaryFactory(DemographicSummaryFactory demographicSummaryFactory) {
        this.demographicSummaryFactory = demographicSummaryFactory;
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public void applyFinancialsInfo(Person person, EESummary eeSummary) {
        BeneficiaryTravelInfo[] beneficiaryTravels;
        FinancialsInfo financialsInfo = new FinancialsInfo();
        IncomeTestInfo incomeTest = this.getIncomeTestInfo(person);
        if (incomeTest != null) {
            financialsInfo.setIncomeTest(incomeTest);
        }
        if (incomeTest != null && incomeTest.getIncomeYear() != null) {
            FinancialStatementInfo fStatement = this.getFinancialStatement(person, incomeTest.getIncomeYear());
            financialsInfo.setFinancialStatement(fStatement);
        }
        if ((beneficiaryTravels = this.prepareBeneficiaryTravel(person)) != null && beneficiaryTravels.length > 0) {
            financialsInfo.setBeneficiaryTravels(new BeneficiaryTravelCollection(beneficiaryTravels));
        }
        eeSummary.setFinancialsInfo(financialsInfo);
    }

    private BeneficiaryTravelInfo[] prepareBeneficiaryTravel(Person person) {
        Map travels = person.getBeneficiaryTravels();
        if (travels == null || travels.size() <= 0) {
            return null;
        }
        BeneficiaryTravelInfo[] beneficiaryTravels = new BeneficiaryTravelInfo[travels.size()];
        Iterator travelIter = travels.values().iterator();
        int i = 0;
        while (travelIter.hasNext()) {
            BeneficiaryTravel travel = (BeneficiaryTravel)travelIter.next();
            BeneficiaryTravelInfo travelInfo = new BeneficiaryTravelInfo();
            travelInfo.setDateCertified(travel.getDateCertified());
            travelInfo.setAmountCertified(travel.getAmountCertified());
            travelInfo.setEligible(travel.getEligible());
            beneficiaryTravels[i] = travelInfo;
            ++i;
        }
        return beneficiaryTravels;
    }

    public SignatureImageInfo[] buildSignatures(Person person) {
        Set signatures = person.getSignatureImages();
        if (signatures == null) {
            return null;
        }
        Iterator sigIter = signatures.iterator();
        SignatureImageInfo[] sigInfos = new SignatureImageInfo[signatures.size()];
        int i = 0;
        while (sigIter.hasNext()) {
            SignatureImage sig = (SignatureImage)sigIter.next();
            SignatureImageInfo sigInfo = new SignatureImageInfo();
            sigInfo.setDateIndex(sig.getDateIndex());
            sigInfo.setIncomeYear(sig.getIncomeYear());
            sigInfos[i] = sigInfo;
        }
        return sigInfos;
    }

    public IncomeTestInfo getIncomeTestInfo(Person person) {
        IncomeTestStatus testStatus;
        Map incomeTestsMap = person.getIncomeTests();
        if (incomeTestsMap == null) {
            return null;
        }
        IncomeTest currIncomeTest = this.personHelperService.getCurrentIncomeTest(person);
        if (currIncomeTest == null) {
            return null;
        }
        IncomeTestInfo incomeTestInfo = new IncomeTestInfo();
        if (currIncomeTest.getHardship() != null) {
            Hardship hardShip = currIncomeTest.getHardship();
            HardshipInfo hardshipInfo = new HardshipInfo();
            hardshipInfo.setHardshipGranted(hardShip.getHardshipGranted());
            hardshipInfo.setReviewDate(hardShip.getReviewDate());
            hardshipInfo.setEffectiveDate(hardShip.getEffectiveDate());
            hardshipInfo.setSiteGrantingHardship(hardShip.getSiteGrantingHardship() != null ? hardShip.getSiteGrantingHardship().getSiteNumberAndName() : null);
            hardshipInfo.setReason(hardShip.getReason());
            incomeTestInfo.setHardshipInfo(hardshipInfo);
        }
        incomeTestInfo.setIncomeYear(currIncomeTest.getIncomeYear());
        incomeTestInfo.setDiscloseFinancialInformation(currIncomeTest.getDiscloseFinancialInformation());
        incomeTestInfo.setAgreesToPayDeductible(currIncomeTest.getAgreesToPayDeductible());
        incomeTestInfo.setEffectiveDate(currIncomeTest.getEffectiveDate());
        incomeTestInfo.setTotalNumberOfDependents(currIncomeTest.getTotalNumberOfDependents());
        incomeTestInfo.setPreviousYearThresholdApplies(currIncomeTest.getPreviousYearThresholdApplies());
        incomeTestInfo.setPrimaryIncomeTest(currIncomeTest.getPrimaryIncomeTest());
        incomeTestInfo.setFutureTest(currIncomeTest.getFutureTest());
        incomeTestInfo.setIncomeTestsource(currIncomeTest.getSource() != null ? currIncomeTest.getSource().getDescription() : null);
        incomeTestInfo.setIncomeTestType(currIncomeTest.getType() != null ? currIncomeTest.getType().getDescription() : null);
        incomeTestInfo.setThresholdA(currIncomeTest.getThresholdA());
        incomeTestInfo.setGmtThresholdAmount(currIncomeTest.getGmtThresholdAmount());
        incomeTestInfo.setSiteConductingTest(currIncomeTest.getSiteConductingTest() != null ? currIncomeTest.getSiteConductingTest().getSiteNumberAndName() : null);
        incomeTestInfo.setAdjudicationDate(currIncomeTest.getAdjudicationDate());
        incomeTestInfo.setIvmTestCompletionDate(currIncomeTest.getIVMTestCompletionDate());
        incomeTestInfo.setIncomeVerificationStatus(currIncomeTest.getIncomeVerificationStatus() != null ? currIncomeTest.getIncomeVerificationStatus().getCode() : null);
        incomeTestInfo.setIncomeVerificationStatusDate(currIncomeTest.getIncomeVerificationStatusDate());
        incomeTestInfo.setRefusedToSign(currIncomeTest.getRefusedToSign());
        incomeTestInfo.setReasonMTNoLongerRequired(currIncomeTest.getReasonMTNoLongerRequired());
        incomeTestInfo.setDateMTNoLongerRequired(currIncomeTest.getDateMTNoLongerRequired());
        incomeTestInfo.setTotalIncome(currIncomeTest.getTotalIncome());
        incomeTestInfo.setNetIncome(currIncomeTest.getNetIncome());
        incomeTestInfo.setDeductibleExpenses(currIncomeTest.getDeductibleExpenses());
        incomeTestInfo.setNetWorth(currIncomeTest.getNetWorth());
        incomeTestInfo.setComments(currIncomeTest.getComments());
        incomeTestInfo.setNetworthThreshold(currIncomeTest.getNetworthThreshold());
        incomeTestInfo.setPensionThreshold(currIncomeTest.getPensionThreshold());
        incomeTestInfo.setChildIncomeExclusionThreshold(currIncomeTest.getChildIncomeExclusionThreshold());
        incomeTestInfo.setCadAdjusted(currIncomeTest.getCadAdjusted());
        if (currIncomeTest.getStatuses() != null && (testStatus = currIncomeTest.getIncomeTestStatus(currIncomeTest.getType())) != null) {
            IncomeTestStatusInfo itsInfo = new IncomeTestStatusInfo();
            itsInfo.setCompletedDate(testStatus.getCompletedDate());
            itsInfo.setDeterminedStatus(testStatus.getDeterminedStatus() != null ? testStatus.getDeterminedStatus().getDescription() : null);
            itsInfo.setLastEditedDate(testStatus.getLastEditedDate());
            itsInfo.setStatus(testStatus.getStatus() != null ? testStatus.getStatus().getDescription() : null);
            itsInfo.setIncomeTestType(testStatus.getType() != null ? testStatus.getType().getDescription() : null);
            IncomeTestStatusInfo[] statuses = new IncomeTestStatusInfo[]{itsInfo};
            if (statuses != null && statuses.length > 0) {
                incomeTestInfo.setStatuses(new IncomeTestStatusCollection(statuses));
            }
        }
        return incomeTestInfo;
    }

    public FinancialStatementInfo getFinancialStatement(Person person, Integer incomeYear) {
        FinancialStatementInfo fStatementInfo = new FinancialStatementInfo();
        FinancialStatement statement = person.getFinancialStatement(incomeYear);
        if (statement != null) {
            Debt debt;
            ExpenseInfo[] expenses;
            AssetInfo[] assests;
            IncomeInfo[] incomes;
            fStatementInfo.setMarriedLastCalendarYear(statement.getMarriedLastCalendarYear());
            fStatementInfo.setNumberOfDependentChildren(statement.getNumberOfDependentChildren());
            fStatementInfo.setContributionToSpouse(statement.getContributionToSpouse());
            DependentFinancialsInfo[] dFins = this.getDependentFinInfo(statement);
            if (dFins != null) {
                fStatementInfo.setDependentFinancialsList(new DependentFinancialsCollection(dFins));
            }
            if ((incomes = this.getIncomeInfo(statement.getIncome())) != null && incomes.length > 0) {
                fStatementInfo.setIncomes(new IncomeCollection(incomes));
            }
            if ((assests = this.getAssetInfo(statement.getAssets())) != null) {
                fStatementInfo.setAssets(new AssetCollection(assests));
            }
            if ((expenses = this.getEexpensesInfo(statement.getExpenses())) != null && expenses.length > 0) {
                fStatementInfo.setExpenses(new ExpenseCollection(expenses));
            }
            if ((debt = statement.getDebt()) != null) {
                DebitInfo debitInfo = new DebitInfo();
                debitInfo.setAmount(debt.getAmount());
                fStatementInfo.setDebits(debitInfo);
            }
            fStatementInfo.setIncomeYear(incomeYear);
            SpouseFinancialsInfo[] sFins = this.getSpouseFinInfo(statement);
            if (sFins != null && sFins.length > 0) {
                fStatementInfo.setSpouseFinancialsList(new SpouseFinancialsCollection(sFins));
            }
        }
        return fStatementInfo;
    }

    private DependentFinancialsInfo[] getDependentFinInfo(FinancialStatement statement) {
        if (statement == null || statement.getDependentFinancials() == null || statement.getDependentFinancials().size() == 0) {
            return null;
        }
        Set dependentFinanSet = statement.getDependentFinancials();
        Iterator itr = dependentFinanSet != null ? dependentFinanSet.iterator() : null;
        int count = 0;
        DependentFinancialsInfo[] dependentFinInfoArray = new DependentFinancialsInfo[dependentFinanSet.size()];
        while (itr != null && itr.hasNext()) {
            Debt debt;
            ExpenseInfo[] expenses;
            AssetInfo[] assets;
            DependentFinancials dependentFinancials = (DependentFinancials)itr.next();
            DependentFinancialsInfo dependentFinInfo = new DependentFinancialsInfo();
            if (dependentFinancials.getReportedOn() != null && dependentFinancials.getReportedOn().getRelationship() != null) {
                dependentFinInfo.setDependentInfo(this.buildDependent(dependentFinancials.getReportedOn()));
            }
            dependentFinInfo.setAmountContributedToSupport(dependentFinancials.getAmountContributedToSupport());
            dependentFinInfo.setAttendedSchool(dependentFinancials.getAttendedSchool());
            dependentFinInfo.setHasIncome(dependentFinancials.getHasIncome());
            dependentFinInfo.setContributedToSupport(dependentFinancials.getContributedToSupport());
            dependentFinInfo.setIncapableOfSelfSupport(dependentFinancials.getIncapableOfSelfSupport());
            dependentFinInfo.setIncomeAvailableToPatient(dependentFinancials.getIncomeAvailableToPatient());
            IncomeInfo[] incomes = this.getIncomeInfo(dependentFinancials.getIncome());
            if (incomes != null && incomes.length > 0) {
                dependentFinInfo.setIncomes(new IncomeCollection(incomes));
            }
            if ((assets = this.getAssetInfo(dependentFinancials.getAssets())) != null) {
                dependentFinInfo.setAssets(new AssetCollection(assets));
            }
            if ((expenses = this.getEexpensesInfo(dependentFinancials.getExpenses())) != null && expenses.length > 0) {
                dependentFinInfo.setExpenses(new ExpenseCollection(expenses));
            }
            if ((debt = dependentFinancials.getDebt()) != null) {
                DebitInfo dependentDebitInfo = new DebitInfo();
                dependentDebitInfo.setAmount(debt.getAmount());
                dependentFinInfo.setDebits(dependentDebitInfo);
            }
            dependentFinInfo.setIncomeYear(dependentFinancials.getIncomeYear());
            dependentFinInfo.setLivedWithPatient(dependentFinancials.getLivedWithPatient());
            dependentFinInfoArray[count] = dependentFinInfo;
            ++count;
        }
        return dependentFinInfoArray;
    }

    private SpouseFinancialsInfo[] getSpouseFinInfo(FinancialStatement statement) {
        if (statement == null || statement.getSpouseFinancials() == null || statement.getSpouseFinancials().size() == 0) {
            return null;
        }
        Set spousetFinanSet = statement.getSpouseFinancials();
        Iterator itr = spousetFinanSet != null ? spousetFinanSet.iterator() : null;
        int count = 0;
        SpouseFinancialsInfo[] spouseFinInfoArray = new SpouseFinancialsInfo[spousetFinanSet.size()];
        while (itr != null && itr.hasNext()) {
            Debt debt;
            ExpenseInfo[] expenses;
            AssetInfo[] assests;
            IncomeInfo[] incomes;
            SpouseFinancials spouseFinancials = (SpouseFinancials)itr.next();
            SpouseFinancialsInfo spouseFinInfo = new SpouseFinancialsInfo();
            spouseFinInfo.setLivedWithPatient(spouseFinancials.getLivedWithPatient());
            spouseFinInfo.setValidDependent(spouseFinancials.getValidDependent());
            spouseFinInfo.setIncomeYear(spouseFinancials.getIncomeYear());
            if (spouseFinancials.getReportedOn() != null) {
                spouseFinInfo.setSpouse(this.buildSpouse(spouseFinancials.getReportedOn()));
            }
            if ((incomes = this.getIncomeInfo(spouseFinancials.getIncome())) != null && incomes.length > 0) {
                spouseFinInfo.setIncomes(new IncomeCollection(incomes));
            }
            if ((assests = this.getAssetInfo(spouseFinancials.getAssets())) != null) {
                spouseFinInfo.setAssets(new AssetCollection(assests));
            }
            if ((expenses = this.getEexpensesInfo(spouseFinancials.getExpenses())) != null && expenses.length > 0) {
                spouseFinInfo.setExpenses(new ExpenseCollection(expenses));
            }
            if ((debt = spouseFinancials.getDebt()) != null) {
                DebitInfo dependentDebitInfo = new DebitInfo();
                dependentDebitInfo.setAmount(debt.getAmount());
                spouseFinInfo.setDebits(dependentDebitInfo);
            }
            spouseFinInfoArray[count] = spouseFinInfo;
            ++count;
        }
        return spouseFinInfoArray;
    }

    private IncomeInfo[] getIncomeInfo(Map incomeMap) {
        Set incomeKeys;
        if (incomeMap == null || incomeMap.isEmpty()) {
            return null;
        }
        IncomeInfo[] incomeInfoArray = new IncomeInfo[incomeMap.size()];
        Set set = incomeKeys = incomeMap != null ? incomeMap.keySet() : null;
        if (incomeKeys != null) {
            Iterator incomeIter = incomeKeys.iterator();
            int incomeCount = 0;
            while (incomeIter.hasNext()) {
                IncomeType incomeType = (IncomeType)incomeIter.next();
                if (incomeType == null) continue;
                Income income = (Income)incomeMap.get(incomeType);
                IncomeInfo incomeInfo = new IncomeInfo();
                incomeInfo.setAmount(income.getAmount());
                incomeInfo.setType(income.getType().getDescription());
                incomeInfoArray[incomeCount] = incomeInfo;
                ++incomeCount;
            }
        }
        return incomeInfoArray;
    }

    private AssetInfo[] getAssetInfo(Map assetsMap) {
        Set assetKeys;
        if (assetsMap == null || assetsMap.isEmpty()) {
            return null;
        }
        AssetInfo[] assetInfoArray = new AssetInfo[assetsMap.size()];
        Set set = assetKeys = assetsMap != null ? assetsMap.keySet() : null;
        if (assetKeys != null) {
            Iterator assetIter = assetKeys.iterator();
            int assetCount = 0;
            while (assetIter.hasNext()) {
                AssetType assetType = (AssetType)assetIter.next();
                if (assetType == null) continue;
                Asset asset = (Asset)assetsMap.get(assetType);
                AssetInfo assetInfo = new AssetInfo();
                assetInfo.setAmount(asset.getAmount());
                assetInfo.setAssetType(asset.getType().getDescription());
                assetInfoArray[assetCount] = assetInfo;
                ++assetCount;
            }
        }
        return assetInfoArray;
    }

    private ExpenseInfo[] getEexpensesInfo(Map expensesMap) {
        Set expenseKeys;
        if (expensesMap == null || expensesMap.isEmpty()) {
            return null;
        }
        ExpenseInfo[] expenseInfoArray = new ExpenseInfo[expensesMap.size()];
        Set set = expenseKeys = expensesMap != null ? expensesMap.keySet() : null;
        if (expenseKeys != null) {
            Iterator expenseIter = expenseKeys.iterator();
            int expenseCount = 0;
            while (expenseIter.hasNext()) {
                ExpenseType expenseType = (ExpenseType)expenseIter.next();
                if (expenseType == null) continue;
                Expense expense = (Expense)expensesMap.get(expenseType);
                ExpenseInfo expenseInfo = new ExpenseInfo();
                expenseInfo.setAmount(expense.getAmount());
                expenseInfo.setExpenseType(expense.getType().getDescription());
                expenseInfoArray[expenseCount] = expenseInfo;
                ++expenseCount;
            }
        }
        return expenseInfoArray;
    }

    public DependentInfo buildDependent(Dependent dependent) {
        if (dependent == null) {
            return null;
        }
        DependentInfo dependentInfo = new DependentInfo();
        dependentInfo = (DependentInfo)this.demographicSummaryFactory.populateRelationInfo((Relation)dependent, dependentInfo);
        return dependentInfo;
    }

    public SpouseInfo buildSpouse(Spouse spouse) {
        if (spouse == null) {
            return null;
        }
        SpouseInfo spouseInfo = new SpouseInfo();
        spouseInfo = (SpouseInfo)this.demographicSummaryFactory.populateRelationInfo((Relation)spouse, spouseInfo);
        spouseInfo.setMaidenName(spouse.getMaidenName());
        Address address = spouse.getAddress();
        AddressInfo addressinfo = this.demographicSummaryFactory.buildAddressInfo(address);
        spouseInfo.setAddress(addressinfo);
        Employment employment = spouse.getEmployment();
        EmploymentInfo employmentInfo = this.demographicSummaryFactory.buildEmployment(employment);
        spouseInfo.setEmployment(employmentInfo);
        return spouseInfo;
    }
}

