/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.lookup.Diagnosis;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.external.EnrollmentDeterminationFactory;
import gov.va.med.esr.service.external.ServiceConnectionAwardFactory;
import gov.va.med.esr.service.external.person.CDConditionInfo;
import gov.va.med.esr.service.external.person.CDProcedureInfo;
import gov.va.med.esr.service.external.person.CancelDeclineInfo;
import gov.va.med.esr.service.external.person.CatastrophicDisabilityInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EligibilityInfo;
import gov.va.med.esr.service.external.person.EnrollmentDeterminationInfo;
import gov.va.med.esr.service.external.person.IneligibilityFactorInfo;
import gov.va.med.esr.service.external.person.MilitarySexualTraumaInfo;
import gov.va.med.esr.service.external.person.MonetaryBenefitAwardInfo;
import gov.va.med.esr.service.external.person.MonetaryBenefitInfo;
import gov.va.med.esr.service.external.person.NoseThroatRadiumInfo;
import gov.va.med.esr.service.external.person.ServiceConnectionAwardInfo;
import gov.va.med.esr.service.external.person.SpecialFactorsInfo;
import gov.va.med.esr.service.external.person.collections.CDConditionCollection;
import gov.va.med.esr.service.external.person.collections.CDDiagnosisCollection;
import gov.va.med.esr.service.external.person.collections.CDProcedureCollection;
import gov.va.med.esr.service.external.person.collections.EligibilityCollection;
import gov.va.med.esr.service.external.person.collections.MonetaryBenefitCollection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EnrollmentDeterminationFactoryimpl
implements EnrollmentDeterminationFactory {
    private ServiceConnectionAwardFactory serviceConnectionAwardFactory;
    static /* synthetic */ Class class$gov$va$med$esr$common$model$ee$MilitarySexualTrauma;
    static /* synthetic */ Class class$gov$va$med$esr$common$model$ee$NoseThroatRadium;

    public ServiceConnectionAwardFactory getServiceConnectionAwardFactory() {
        return this.serviceConnectionAwardFactory;
    }

    public void setServiceConnectionAwardFactory(ServiceConnectionAwardFactory serviceConnectionAwardFactory) {
        this.serviceConnectionAwardFactory = serviceConnectionAwardFactory;
    }

    public void applyEnrollmentDeterminationInfo(Person person, EESummary summary) {
        NoseThroatRadiumInfo noseThroatRadiumInfo;
        MilitarySexualTraumaInfo militarySexualTraumaInfo;
        CancelDeclineInfo cancelDeclineInfo;
        EligibilityInfo[] otherEligibilities;
        EligibilityInfo[] secEligibilities;
        EligibilityInfo[] primaryEligibilities;
        EnrollmentDetermination ed = person.getEnrollmentDetermination();
        if (ed == null) {
            return;
        }
        EnrollmentDeterminationInfo edInfo = new EnrollmentDeterminationInfo();
        this.setBaseFields(person, edInfo);
        HashSet<Eligibility> pEligibilitySet = new HashSet<Eligibility>();
        if (ed.getPrimaryEligibility() != null) {
            pEligibilitySet.add(ed.getPrimaryEligibility());
        }
        if ((primaryEligibilities = this.getEligibilities(pEligibilitySet)) != null && primaryEligibilities.length == 1) {
            edInfo.setPrimaryEligibility(primaryEligibilities[0]);
        }
        if ((secEligibilities = this.getEligibilities(ed.getSecondaryEligibilities())) != null && secEligibilities.length > 0) {
            edInfo.setSecondaryEligibilities(new EligibilityCollection(secEligibilities));
        }
        if ((otherEligibilities = this.getEligibilities(ed.getOtherEligibilities())) != null && otherEligibilities.length > 0) {
            edInfo.setOtherEligibilities(new EligibilityCollection(otherEligibilities));
        }
        ServiceConnectionAwardInfo serviceConnectionAwardInfo = this.serviceConnectionAwardFactory.buildServiceConnectionAward(person);
        edInfo.setServiceConnectionAward(serviceConnectionAwardInfo);
        IneligibilityFactorInfo ineligibilityFactorInfo = this.buildIneligibilityFactor(person);
        if (ineligibilityFactorInfo != null) {
            edInfo.setIneligibilityFactor(ineligibilityFactorInfo);
        }
        if ((cancelDeclineInfo = this.buildCancelDecline(person)) != null) {
            edInfo.setCancelDeclineInfo(cancelDeclineInfo);
        }
        if ((militarySexualTraumaInfo = this.applyMilitarySexualTrauma(person)) != null) {
            edInfo.setMilitarySexualTraumaInfo(militarySexualTraumaInfo);
        }
        if ((noseThroatRadiumInfo = this.buildNSTData(person)) != null) {
            edInfo.setNoseThroatRadiumInfo(noseThroatRadiumInfo);
        }
        SpecialFactorsInfo specialFactorsInfo = this.applySpecialFactors(person);
        edInfo.setSpecialFactors(specialFactorsInfo);
        edInfo.setMonetaryBenefitAwardInfo(this.applyMonetaryBenefitAward(person));
        edInfo.setCatastrophicDisabilityInfo(this.applyCatastrophicDisabilityInf(person));
        summary.setEnrollmentDeterminationInfo(edInfo);
    }

    private void setBaseFields(Person person, EnrollmentDeterminationInfo enrollmentDeterminationInfo) {
        enrollmentDeterminationInfo.setApplicationDate(person.getApplication() != null ? person.getApplication().getApplicationDate() : null);
        enrollmentDeterminationInfo.setUserEnrolleeValidThrough(person.getUserEnrolleeValidThrough());
        enrollmentDeterminationInfo.setUserEnrolleeSite(person.getUserEnrolleeSite() != null ? person.getUserEnrolleeSite().getSiteNumberAndName() : null);
        enrollmentDeterminationInfo.setEligibleForMedicaid(person.getMedicaidFactor() != null ? person.getMedicaidFactor().getEligibleForMedicaid() : null);
        EnrollmentDetermination ed = person.getEnrollmentDetermination();
        if (ed.getPriorityGroup() != null) {
            enrollmentDeterminationInfo.setPriorityGroup(ed.getPriorityGroup().getDescription());
        }
        if (ed.getPrioritySubGroup() != null) {
            enrollmentDeterminationInfo.setPrioritySubGroup(ed.getPrioritySubGroup().getDescription());
        }
        if (ed.getCalculationSource() != null) {
            enrollmentDeterminationInfo.setCalculationSource(ed.getCalculationSource().getDescription());
        }
        if (ed.getEnrollmentStatus() != null) {
            enrollmentDeterminationInfo.setEnrollmentStatus(ed.getEnrollmentStatus().getName());
        }
        enrollmentDeterminationInfo.setEnrollmentDate(ed.getEffectiveDate());
        enrollmentDeterminationInfo.setEndDate(ed.getEndDate());
        if (ed.getFacilityReceived() != null) {
            enrollmentDeterminationInfo.setFacilityReceived(ed.getFacilityReceived().getSiteNumberAndName());
        }
        enrollmentDeterminationInfo.setEnrollmentDate(ed.getEnrollmentDate());
        enrollmentDeterminationInfo.setEndDate(ed.getEndDate());
        enrollmentDeterminationInfo.setVeteran(person.getVeteran());
    }

    private EligibilityInfo[] getEligibilities(Set eligibilities) {
        if (eligibilities == null && eligibilities.size() <= 0) {
            return null;
        }
        Iterator eligIterator = eligibilities.iterator();
        EligibilityInfo[] eInfos = new EligibilityInfo[eligibilities.size()];
        int i = 0;
        while (eligIterator.hasNext()) {
            Eligibility e = (Eligibility)eligIterator.next();
            EligibilityInfo eInfo = new EligibilityInfo();
            if (e.getType() != null) {
                eInfo.setType(e.getType().getDescription());
            }
            eInfo.setIndicator(e.getIndicator());
            eInfos[i] = eInfo;
            ++i;
        }
        return eInfos;
    }

    private IneligibilityFactorInfo buildIneligibilityFactor(Person person) {
        IneligibilityFactor ieFactor = person.getIneligibilityFactor();
        if (ieFactor == null) {
            return null;
        }
        IneligibilityFactorInfo iefInfo = new IneligibilityFactorInfo();
        iefInfo.setFacilityReceived(ieFactor.getFacilityReceived() != null ? ieFactor.getFacilityReceived().getSiteNumberAndName() : null);
        iefInfo.setIneligibleDate(ieFactor.getIneligibleDate());
        iefInfo.setReason(ieFactor.getReason());
        iefInfo.setVaroDecision(ieFactor.getVaroDecision());
        return iefInfo;
    }

    private CancelDeclineInfo buildCancelDecline(Person person) {
        CancelDecline cd = person.getCancelDecline();
        if (cd == null) {
            return null;
        }
        CancelDeclineInfo cdInfo = new CancelDeclineInfo();
        cdInfo.setCancelDeclineIndicator(cd.getCancelDeclineIndicator());
        cdInfo.setReason(cd.getReason() != null ? cd.getReason().getDescription() : null);
        cdInfo.setRemarks(cd.getRemarks());
        return cdInfo;
    }

    private MilitarySexualTraumaInfo applyMilitarySexualTrauma(Person person) {
        MilitarySexualTrauma mst = (MilitarySexualTrauma)this.getClinicalDetermination(class$gov$va$med$esr$common$model$ee$MilitarySexualTrauma == null ? (class$gov$va$med$esr$common$model$ee$MilitarySexualTrauma = EnrollmentDeterminationFactoryimpl.class$("gov.va.med.esr.common.model.ee.MilitarySexualTrauma")) : class$gov$va$med$esr$common$model$ee$MilitarySexualTrauma, person);
        if (mst == null) {
            return null;
        }
        MilitarySexualTraumaInfo mstInfo = new MilitarySexualTraumaInfo();
        mstInfo.setDeterminationFacility(mst.getDeterminationFacility() != null ? mst.getDeterminationFacility().getSiteNumberAndName() : null);
        mstInfo.setStatus(mst.getStatus() != null ? mst.getStatus().getDescription() : null);
        mstInfo.setStatusChangeDate(mst.getStatusChangeDate());
        return mstInfo;
    }

    private NoseThroatRadiumInfo buildNSTData(Person person) {
        NoseThroatRadium ntr = (NoseThroatRadium)this.getClinicalDetermination(class$gov$va$med$esr$common$model$ee$NoseThroatRadium == null ? (class$gov$va$med$esr$common$model$ee$NoseThroatRadium = EnrollmentDeterminationFactoryimpl.class$("gov.va.med.esr.common.model.ee.NoseThroatRadium")) : class$gov$va$med$esr$common$model$ee$NoseThroatRadium, person);
        if (ntr == null) {
            return null;
        }
        NoseThroatRadiumInfo ntrinfo = new NoseThroatRadiumInfo();
        ntrinfo.setVerificationDate(ntr.getVerificationDate());
        if (ntr.getVerificationMethod() != null) {
            ntrinfo.setVerificationMethod(ntr.getVerificationMethod().getDescription());
        }
        if (ntr.getVerificationFacility() != null) {
            ntrinfo.setVerificationFacility(ntr.getVerificationFacility().getSiteNumberAndName());
        }
        if (ntr.getDeterminationFacility() != null) {
            ntrinfo.setDeterminationFacility(ntr.getDeterminationFacility().getSiteNumberAndName());
        }
        if (ntr.getReceivingTreatment() != null) {
            ntrinfo.setReceivingTreatment(ntr.getReceivingTreatment().toString());
        }
        ntrinfo.setFromAviatorServiceBefore1955(ntr.getFromAviatorServiceBefore1955());
        ntrinfo.setFromSubmarinerServiceBefore1965(ntr.getFromSubmarinerServiceBefore1965());
        ntrinfo.setDiagnosedWithCancer(ntr.getDiagnosedWithCancer());
        ntrinfo.setDiagnosisVerifiedDate(ntr.getDiagnosisVerifiedDate());
        return ntrinfo;
    }

    private SpecialFactorsInfo applySpecialFactors(Person person) {
        Set specialFactors = person.getSpecialFactors();
        if (specialFactors == null) {
            return null;
        }
        SpecialFactorsInfo specialFactorInfo = new SpecialFactorsInfo();
        Iterator sfIterator = specialFactors.iterator();
        while (sfIterator.hasNext()) {
            EnvironmentalContaminationExposure ec;
            SpecialFactor sf = (SpecialFactor)sfIterator.next();
            if (sf instanceof AgentOrangeExposure) {
                AgentOrangeExposure ao = (AgentOrangeExposure)sf;
                if (ao.getAgentOrangeExposureIndicator() != null) {
                    specialFactorInfo.setAgentOrangeInd(ao.getAgentOrangeExposureIndicator().toBoolean());
                }
                if (ao.getLocation() == null) continue;
                specialFactorInfo.setAgentOrangeLocation(ao.getLocation().getDescription());
                continue;
            }
            if (sf instanceof RadiationExposure) {
                RadiationExposure re = (RadiationExposure)sf;
                if (re.getRadiationExposureIndicator() != null) {
                    specialFactorInfo.setRadiationExposureInd(re.getRadiationExposureIndicator().toBoolean());
                }
                if (re.getExposureMethod() == null) continue;
                specialFactorInfo.setRadiationExposureMethod(re.getExposureMethod().getDescription());
                continue;
            }
            if (!(sf instanceof EnvironmentalContaminationExposure) || (ec = (EnvironmentalContaminationExposure)sf).getEnvironmentalContaminationExposureIndicator() == null) continue;
            specialFactorInfo.setEnvContaminantsInd(ec.getEnvironmentalContaminationExposureIndicator().toBoolean());
        }
        return specialFactorInfo;
    }

    private MonetaryBenefitAwardInfo applyMonetaryBenefitAward(Person person) {
        MonetaryBenefitAward mAward = person.getMonetaryBenefitAward();
        if (mAward == null) {
            return null;
        }
        MonetaryBenefitAwardInfo mAwardInfo = new MonetaryBenefitAwardInfo();
        mAwardInfo.setCheckAmount(mAward.getCheckAmount());
        Set mBenefits = mAward.getMonetaryBenefits();
        int setSize = 0;
        Iterator mBenefitsItr = null;
        if (mBenefits != null) {
            mBenefitsItr = mBenefits.iterator();
            setSize = mBenefits.size();
        }
        MonetaryBenefitInfo[] mBenefitInfos = new MonetaryBenefitInfo[setSize];
        int i = 0;
        while (mBenefitsItr != null && mBenefitsItr.hasNext()) {
            MonetaryBenefit mBenefit = (MonetaryBenefit)mBenefitsItr.next();
            MonetaryBenefitInfo mBenefitInfo = new MonetaryBenefitInfo();
            if (mBenefit.getMonetaryBenefitIndicator() != null) {
                mBenefitInfo.setMonetaryBenefitIndicator(mBenefit.getMonetaryBenefitIndicator().toBoolean());
            }
            mBenefitInfo.setType(mBenefit.getType() != null ? mBenefit.getType().getDescription() : null);
            mBenefitInfos[i] = mBenefitInfo;
            ++i;
        }
        if (mBenefitInfos != null && mBenefitInfos.length > 0) {
            mAwardInfo.setMonetaryBenefits(new MonetaryBenefitCollection(mBenefitInfos));
        }
        return mAwardInfo;
    }

    private CatastrophicDisabilityInfo applyCatastrophicDisabilityInf(Person person) {
        int i;
        CatastrophicDisability cd = person.getCatastrophicDisability();
        if (cd == null) {
            return null;
        }
        CatastrophicDisabilityInfo cdInfo = new CatastrophicDisabilityInfo();
        cdInfo.setReviewDate(cd.getReviewDate());
        cdInfo.setDeterminedBy(cd.getDeterminedBy());
        if (cd.getDeterminationFacility() != null) {
            cdInfo.setDeterminationFacility(cd.getDeterminationFacility().getSiteNumberAndName());
        }
        cdInfo.setDecisionDate(cd.getDecisionDate());
        if (cd.getDeterminationMethod() != null) {
            cdInfo.setDeterminationMethod(cd.getDeterminationMethod().getDescription());
        }
        cdInfo.setVeteranRequestedCDReviewDate(cd.getVeteranRequestedCDReviewDate());
        cdInfo.setVeteranWasNotifiedCDDate(cd.getVeteranWasNotifiedCDDate());
        cdInfo.setCatastrophicallyDisabled(cd.getCatastrophicallyDisabled());
        if (cd.getDiagnoses() != null) {
            Set diagnoses = cd.getDiagnoses();
            String[] diagArr = new String[diagnoses.size()];
            Iterator diagIter = diagnoses.iterator();
            i = 0;
            while (diagIter.hasNext()) {
                String d;
                CDDiagnosis cdDiagnosis = (CDDiagnosis)diagIter.next();
                Diagnosis diagnosis = cdDiagnosis.getDiagnosis();
                diagArr[i] = d = diagnosis.getDescription();
                ++i;
            }
            if (diagArr != null && diagArr.length > 0) {
                cdInfo.setDiagnoses(new CDDiagnosisCollection(diagArr));
            }
        }
        if (cd.getProcedures() != null) {
            Set procedures = cd.getProcedures();
            Iterator procedureItr = procedures.iterator();
            CDProcedureInfo[] procedureArr = new CDProcedureInfo[procedures.size()];
            i = 0;
            while (procedureItr.hasNext()) {
                CDProcedure p = (CDProcedure)procedureItr.next();
                CDProcedureInfo pInfo = new CDProcedureInfo();
                if (p.getProcedure() != null) {
                    pInfo.setProcedure(p.getProcedure().getDescription());
                }
                if (p.getAffectedExtremity() != null) {
                    pInfo.setAffectedExtremity(p.getAffectedExtremity().getDescription());
                }
                procedureArr[i] = pInfo;
                ++i;
            }
            if (procedureArr != null && procedureArr.length > 0) {
                cdInfo.setCdProcedures(new CDProcedureCollection(procedureArr));
            }
        }
        if (cd.getConditions() != null) {
            Set conditions = cd.getConditions();
            Iterator conditionsItr = conditions.iterator();
            CDConditionInfo[] conditionArr = new CDConditionInfo[conditions.size()];
            i = 0;
            while (conditionsItr.hasNext()) {
                CDCondition c = (CDCondition)conditionsItr.next();
                CDConditionInfo cInfo = new CDConditionInfo();
                if (c.getCondition() != null) {
                    cInfo.setCondition(c.getCondition().getName());
                }
                if (c.getPermanentIndicator() != null) {
                    cInfo.setPermanentIndicator(c.getPermanentIndicator().toBoolean());
                }
                cInfo.setScore(c.getScore());
                conditionArr[i] = cInfo;
                ++i;
            }
            if (conditionArr != null) {
                cdInfo.setCdConditions(new CDConditionCollection(conditionArr));
            }
        }
        return cdInfo;
    }

    public ClinicalDetermination getClinicalDetermination(Class classObject, Person person) {
        if (person == null) {
            return null;
        }
        Set clinicalDeterminations = person.getClinicalDeterminations();
        ClinicalDetermination clinicalDetermination = null;
        if (clinicalDeterminations != null && clinicalDeterminations.size() > 0) {
            Iterator iterClinicalDeterminations = clinicalDeterminations.iterator();
            while (iterClinicalDeterminations.hasNext()) {
                ClinicalDetermination temp = (ClinicalDetermination)iterClinicalDeterminations.next();
                if (temp == null || !temp.getClass().isAssignableFrom(classObject)) continue;
                clinicalDetermination = temp;
                break;
            }
        }
        return clinicalDetermination;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

