/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.trigger;

import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.CommonTriggerIdentity;
import gov.va.med.esr.service.trigger.PersonTrigger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonTriggerIdentity
extends CommonTriggerIdentity {
    private static final long serialVersionUID = 566526298204871099L;
    private Set applicableDataTypes = null;
    private boolean isIdMAddressPhoneUpdate = false;

    public PersonTriggerIdentity() {
    }

    public PersonTriggerIdentity(PersonTriggerIdentity triggerIdentity) {
        super((CommonTrigger.DestinationType)triggerIdentity.getDestinationType(), (CommonTrigger.TargetType)triggerIdentity.getTargetType(), (CommonTrigger.DispatchType)triggerIdentity.getDispatchType());
        this.applicableDataTypes = triggerIdentity.getApplicableDataTypes();
    }

    public PersonTriggerIdentity(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType, CommonTrigger.DispatchType dispatchType, PersonTrigger.DataType dataType) {
        super(destinationType, targetType, dispatchType);
        this.applicableDataTypes = new HashSet(1);
        this.applicableDataTypes.add(dataType);
    }

    public PersonTriggerIdentity(CommonTrigger.DestinationType destinationType, CommonTrigger.TargetType targetType, CommonTrigger.DispatchType dispatchType, Set applicableDataTypes) {
        super(destinationType, targetType, dispatchType);
        this.applicableDataTypes = applicableDataTypes;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("applicableDataTypes", (Object)this.applicableDataTypes);
    }

    protected String buildName() {
        return super.buildName() + "-" + this.buildApplicationDataTypesString();
    }

    private String buildApplicationDataTypesString() {
        StringBuffer buf = new StringBuffer();
        if (this.applicableDataTypes != null) {
            Iterator itr = this.applicableDataTypes.iterator();
            while (itr.hasNext()) {
                buf.append(((PersonTrigger.DataType)((Object)itr.next())).getName());
            }
        } else {
            buf.append("NO_DATATYPE");
        }
        return buf.toString();
    }

    public Set getApplicableDataTypes() {
        return this.applicableDataTypes;
    }

    public void setApplicableDataTypes(Set applicableDataTypes) {
        this.applicableDataTypes = applicableDataTypes;
    }

    public boolean matchTriggerCriteria(PersonTriggerIdentity data) {
        boolean matchTriggerCriteria = false;
        if (this.getTargetType().equals((Object)data.getTargetType()) && this.getDispatchType().equals((Object)data.getDispatchType()) && this.applicableDataTypes.containsAll(data.getApplicableDataTypes())) {
            matchTriggerCriteria = true;
        }
        return matchTriggerCriteria;
    }

    public boolean isIdMAddressPhoneUpdate() {
        return this.isIdMAddressPhoneUpdate;
    }

    public void setIdMAddressPhoneUpdate(boolean isIdMAddressPhoneUpdate) {
        this.isIdMAddressPhoneUpdate = isIdMAddressPhoneUpdate;
    }
}

