/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import com.thoughtworks.xstream.XStream;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AddressChangeSource;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.AuthenticationLevel;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.EmailSourceOfChange;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.InsuredRelationship;
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneSourceOfChange;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VOAApplicationStatus;
import gov.va.med.esr.common.model.lookup.VOAFormType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.FullyQualifiedIdentity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.esr.common.model.person.VOAResubmissionData;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;
import gov.va.med.esr.common.persistent.ee.VoaFileAttachmentDAO;
import gov.va.med.esr.common.persistent.person.VOAApplicationDAO;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.VOAApplicationService;
import gov.va.med.esr.service.VOASearchCriteria;
import gov.va.med.esr.service.VOASearchResultBean;
import gov.va.med.esr.service.WorkflowService;
import gov.va.med.esr.service.impl.AbstractHistoricalInfoServiceImpl;
import gov.va.med.esr.service.impl.AddProxyPreferredFacilityException;
import gov.va.med.esr.service.impl.IdMSearchInfo;
import gov.va.med.esr.service.impl.IdmWebServiceDelegate;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.esr.service.trigger.BulletinTriggerEvent;
import gov.va.med.esr.service.trigger.VOATriggerEvent;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.ps.model.PatientIdentifier;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.exception.ExceptionUtils;

public class VOAApplicationServiceImpl
extends AbstractHistoricalInfoServiceImpl
implements VOAApplicationService {
    private static final long serialVersionUID = 8936807483114587339L;
    private static final Object PENDING_CAT_EDIT = "PCE";
    private static VAFacility VOA_VA_FACILITY = null;
    private VOAApplicationDAO voaApplicationDAO = null;
    private VoaFileAttachmentDAO voaFileAttachmentDAO = null;
    private TriggerRouter triggerRouter = null;
    private IdmWebServiceDelegate idmServiceDelegate = null;
    private PersonService personService = null;
    private SystemParameterService systemParameterService = null;
    private MessagingService messagingService = null;
    private WorkflowService workflowService = null;
    private CommsEmailBulletinService bulletinService;
    private InsuredRelationship INSURED_RELATIONSHIP_VETERAN = null;
    public static final String TXT_1010EZ = "1010EZ";
    public static final String TXT_1010EZR = "1010EZR";
    public static final String TXT_1010HS = "1010HS";
    public static final String TXT_1010SH = "1010SH";
    public static final String TXT_1010CG = "1010CG";
    public static final String TXT_21526EZ = "21526EZ";
    public static final Character VOA_IND_1 = Character.valueOf('1');
    public static final Character VOA_IND_2 = Character.valueOf('2');

    public VOAApplicationDAO getVoaApplicationDAO() {
        return this.voaApplicationDAO;
    }

    public void setVoaApplicationDAO(VOAApplicationDAO voaApplicationDAO) {
        this.voaApplicationDAO = voaApplicationDAO;
    }

    public VoaFileAttachmentDAO getVoaFileAttachmentDAO() {
        return this.voaFileAttachmentDAO;
    }

    public void setVoaFileAttachmentDAO(VoaFileAttachmentDAO voaFileAttachmentDAO) {
        this.voaFileAttachmentDAO = voaFileAttachmentDAO;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    public IdmWebServiceDelegate getIdmServiceDelegate() {
        return this.idmServiceDelegate;
    }

    public void setIdmServiceDelegate(IdmWebServiceDelegate idmServiceDelegate) {
        this.idmServiceDelegate = idmServiceDelegate;
    }

    @Override
    public PersonService getPersonService() {
        return this.personService;
    }

    @Override
    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Override
    public CommsEmailBulletinService getBulletinService() {
        return this.bulletinService;
    }

    @Override
    public void setBulletinService(CommsEmailBulletinService bulletinService) {
        this.bulletinService = bulletinService;
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    @Override
    public VOAApplication save(VOAApplication app) throws ServiceException {
        try {
            Validate.notNull((Object)((Object)app), (String)"A VOA Application input must not be null.");
            this.voaApplicationDAO.saveObject((Object)app);
            return app;
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to persist a VOAApplication", (Throwable)e);
        }
    }

    @Override
    public List findVoaAttachmentByPersonId(BigDecimal personId) throws ServiceException {
        try {
            return this.voaFileAttachmentDAO.findVoaAttachmentByPersonId(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List findVoaAttachmentByApplicationId(BigDecimal applicationId) throws ServiceException {
        try {
            return this.voaFileAttachmentDAO.findVoaAttachmentByApplicationId(applicationId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateAttachmentAttributes(VoaFileAttachment attachment) throws ServiceException {
        try {
            this.voaFileAttachmentDAO.updateAttachmentAttributes(attachment);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateVoaAttachmentWithPersonId(String msgControlId, BigDecimal personId) throws ServiceException {
        try {
            this.voaFileAttachmentDAO.updateVoaAttachmentWithPersonId(msgControlId, personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void forwardVOAApplication(BigDecimal applicationId, Person person) throws ServiceException {
        Validate.notNull((Object)applicationId, (String)"VOA application id must not be null");
        Validate.notNull((Object)((Object)person), (String)"Incoming Person must not be null");
        this.getTriggerRouter().processTriggerEvent((TriggerEvent)new VOATriggerEvent(applicationId, person));
    }

    @Override
    public VOAApplication findVoaApplicationByApplicationId(BigDecimal applicationId) throws ServiceException {
        Validate.notNull((Object)applicationId, (String)"VOA application id must not be null");
        try {
            return this.voaApplicationDAO.getByApplicationId(applicationId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List findByFQID(String fqid) throws ServiceException {
        try {
            return this.voaApplicationDAO.getByFQID(fqid);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public VOAApplication updateVOAApplication(VOAApplication app) throws ServiceException {
        Validate.notNull((Object)((Object)app), (String)"VOA application must not be null");
        try {
            this.getVoaApplicationDAO().update((Object)app);
        }
        catch (DAOException de) {
            throw new ServiceException((Throwable)de);
        }
        return app;
    }

    private void removeOrphanedVOAApplication(VOAApplication app) throws ServiceException {
        Validate.notNull((Object)((Object)app), (String)"VOA application must not be null");
        try {
            List pendingSubmissions = this.getVoaApplicationDAO().findByNamedQuery("VOAApplication_GetOrphanedApps", app.getFullQualifiedId());
            for (int i = 0; i < pendingSubmissions.size(); ++i) {
                VOAApplication orphan = (VOAApplication)((Object)pendingSubmissions.get(i));
                orphan.setApplicationStatus((VOAApplicationStatus)this.getLookupService().getByCode(VOAApplicationStatus.class, VOAApplicationStatus.FORM_PROCESSED_SUCCESSFUL));
                this.getVoaApplicationDAO().saveObject((Object)orphan);
            }
        }
        catch (DAOException de) {
            throw new ServiceException((Throwable)de);
        }
    }

    @Override
    public boolean isDSLogonLevel2(VOAApplication app) {
        return app.getAuthenticationLevel() != null && !AuthenticationLevel.ANONYMOUS.getCode().equals(app.getAuthenticationLevel().getCode()) && !AuthenticationLevel.DS_LOGON_LEVEL_1.getCode().equals(app.getAuthenticationLevel().getCode());
    }

    @Override
    public Person processVoaApplication(BigDecimal applicationId, Person incoming) throws ServiceException {
        Validate.notNull((Object)applicationId, (String)"VOA application id must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        VOAApplication app = null;
        try {
            app = this.getVoaApplicationDAO().getByApplicationId(applicationId);
        }
        catch (DAOException de) {
            this.logger.error((Object)("VOA Process failed due to exception: (submission id=" + (app != null ? app.getEntityKey().getKeyValueAsString() : null) + "): " + ExceptionUtils.getFullStackTrace((Throwable)de)));
            if (app != null) {
                app.setApplicationStatus((VOAApplicationStatus)this.getLookupService().getByCode(VOAApplicationStatus.class, VOAApplicationStatus.FORM_SUBMISSION_FAILED));
                app.setErrorText("VOA Process failed due to exception: " + ExceptionUtils.getRootCause((Throwable)de));
                this.updateVOAApplication(app);
            }
            throw new ServiceException((Throwable)de);
        }
        if (app == null) {
            this.logger.error((Object)("Get null VOAApplication with applicationId= " + applicationId));
            return null;
        }
        app.setApplicationStatus((VOAApplicationStatus)this.getLookupService().getByCode(VOAApplicationStatus.class, VOAApplicationStatus.FORM_PROCESSING_IN_PROGRESS));
        this.updateVOAApplication(app);
        if (VOA_VA_FACILITY == null) {
            VOA_VA_FACILITY = this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_MHV.getCode());
        }
        if (this.isDSLogonLevel2(app)) {
            return this.processDSLogonLevel2(app, incoming);
        }
        return this.processAnonymousLevel1(app, incoming);
    }

    private void setVeteranIndicator(VOAApplication app, Person incoming) {
        incoming.setVeteran(Boolean.TRUE);
    }

    public void processEnrollment(Boolean vetIndicator) {
    }

    private List<PatientIdentifier> getCorrelationsFromCompositeCall(PersonIdentityTraits traits, IdMSearchInfo searchInfo) throws ServiceException {
        Set traitsSet = this.idmServiceDelegate.searchWithCompositeCall(traits, searchInfo);
        if (traitsSet == null || traitsSet.size() == 0) {
            return null;
        }
        return ((PersonIdentityTraits)((Object)traitsSet.iterator().next())).getAllCorrelations();
    }

    private void sendPersonNotFoundEmail(VOAApplication app, Person person) {
        BulletinTriggerEvent bulletinTriggerEvent = new BulletinTriggerEvent(BulletinTrigger.DataType.Person_Not_Found_for_Veteran_submitted_in_VOA);
        if (!StringUtils.isEmpty((String)app.getFullQualifiedId())) {
            bulletinTriggerEvent.addField("FULLY_QUALIFIED_ID", app.getFullQualifiedId());
        }
        if (app.getIdentityType() != null) {
            bulletinTriggerEvent.addField("Name", app.getIdentityType().getName());
        }
        bulletinTriggerEvent.addField("VOA_ENROLLMENT_APP_ID", app.getEntityKey().getKeyValueAsString());
        bulletinTriggerEvent.setPersonId(person.getPersonEntityKey());
        if (this.bulletinService != null) {
            HashMap<String, String> bulletinData = new HashMap<String, String>();
            bulletinData.put("FULLY_QUALIFIED_ID", app.getFullQualifiedId());
            bulletinData.put("Name", app.getIdentityType().getName());
            bulletinData.put("VOA_ENROLLMENT_APP_ID", app.getEntityKey().getKeyValueAsString());
            String formType = this.convertFormType(app);
            try {
                this.getTriggerRouter().processTriggerEvent((TriggerEvent)bulletinTriggerEvent);
                this.bulletinService.sendVOAWorkflowEmailBulletin(BulletinTrigger.DataType.Person_Not_Found_for_Veteran_submitted_in_VOA_WORKFLOW, bulletinData, null, formType);
            }
            catch (ServiceException ex) {
                this.logger.error((Object)("VOA processAnonymousLevel1 Person not found from MVI - cannot send email notification for appId= " + app.getEntityKey().getKeyValueAsString() + "\nError Message: " + ex.getMessage()));
            }
        }
    }

    public String convertFormType(VOAApplication app) {
        String formType = null;
        formType = app.getFormType().getCode().equals(VOAFormType.VOA_FORM_1010EZ.getCode()) ? TXT_1010EZ : (app.getFormType().getCode().equals(VOAFormType.VOA_FORM_1010EZR.getCode()) ? TXT_1010EZR : (app.getFormType().getCode().equals(VOAFormType.VOA_FORM_1010HS.getCode()) ? TXT_1010HS : (app.getFormType().getCode().equals(VOAFormType.VOA_FORM_1010SH.getCode()) ? TXT_1010SH : (app.getFormType().getCode().equals(VOAFormType.VOA_FORM_1010CG.getCode()) ? TXT_1010CG : (app.getFormType().getCode().equals(VOAFormType.VOA_FORM_21526EZ.getCode()) ? TXT_21526EZ : " - Unknown Form")))));
        return formType;
    }

    private Person processAnonymousLevel1(VOAApplication app, Person incoming) throws ServiceException {
        String[] ids;
        Validate.notNull((Object)((Object)app), (String)"VOA application must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        Person incomingCopy = incoming;
        this.setVeteranIndicator(app, incoming);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Populated Person after procesVOASvc: " + incoming.toString()));
            if (incoming != null) {
                this.logger.debug((Object)("income test after coming to voaSvc: " + (Object)((Object)incoming.getIncomeTest(Calendar.getInstance().get(1) - 1))));
            }
        }
        PersonIdentityTraits traits = null;
        List<PatientIdentifier> correlations = null;
        IdMSearchInfo searchInfo = new IdMSearchInfo();
        searchInfo.setExtendedSearch(true);
        searchInfo.setDataEntererExtension("SSN= " + app.getSsn());
        searchInfo.setDataEntererFamilyName(app.getLastName());
        searchInfo.setDataEntererGivenName(app.getFirstName());
        correlations = !StringUtils.isEmpty((String)app.getFullQualifiedId()) && app.getFullQualifiedId().split("\\^").length == 4 ? ((traits = this.idmServiceDelegate.searchWithCompositeCall(new FullyQualifiedIdentity((ids = app.getFullQualifiedId().split("\\^"))[0], ids[1], ids[2], ids[3]), false, searchInfo)) == null ? this.getCorrelationsFromCompositeCall(incoming.getIdentityTraits(), searchInfo) : traits.getAllCorrelations()) : this.getCorrelationsFromCompositeCall(incoming.getIdentityTraits(), searchInfo);
        this.setVoaDefaults(incoming, app);
        BigDecimal personId = null;
        if (correlations == null || correlations.size() == 0) {
            if (StringUtils.isEmpty((String)searchInfo.getSearchToken())) {
                throw new ServiceException("Procoess Anonymous & Level 1 VOA application: Add Person Explicitly with empty search token");
            }
            searchInfo.setAddPersonExplicit(true);
            incoming.setVOAIndicator(VOA_IND_2);
            this.getPersonService().addPersonExplicit(incoming, searchInfo);
            incoming.setJustAdded(true);
            personId = (BigDecimal)incoming.getEntityKey().getKeyValue();
        } else {
            String vpid = VPIDEntityKeyImpl.getLongVPID(this.getICN(correlations));
            incoming.setVPIDValue(vpid);
            PatientIdentifier esrCorr = this.get200ESRCorrelation(correlations);
            Person adrPerson = null;
            if (esrCorr == null) {
                this.getPersonService().addESRCorrelation(incoming);
                PersonEntityKey personKey = null;
                try {
                    personKey = this.getPersonService().getPersonIdByVPID(incoming.getVPIDEntityKey());
                    if (personKey == null) {
                        personKey = this.getPersonService().addPersonStub(incoming.getVPIDEntityKey(), incoming.getVeteran(), incoming.getVOAIndicator());
                        this.getVoaApplicationDAO().flush();
                    }
                }
                catch (DAOException ex) {
                    throw new ServiceException("insert into PS_PERSON_VPID failed: ", (Throwable)ex);
                }
                personId = (BigDecimal)personKey.getKeyValue();
                adrPerson = this.getPersonService().getPersonWithoutIdentityTraits(incoming.getVPIDEntityKey());
                if (adrPerson != null) {
                    this.logger.info((Object)("adr person is :" + adrPerson.toString()));
                }
                if (adrPerson == null) {
                    this.logger.error((Object)("Cannot process person. onFile person not found for vpid= " + incoming.getVPIDEntityKey().getKeyValueAsString()));
                    return null;
                }
            } else {
                adrPerson = this.getPersonService().getPersonWithoutIdentityTraits(incoming.getVPIDEntityKey());
                if (adrPerson == null) {
                    this.logger.error((Object)("Cannot process person. onFile person not found for vpid= " + incoming.getVPIDEntityKey().getKeyValueAsString()));
                    return null;
                }
                if (adrPerson != null) {
                    personId = new BigDecimal(adrPerson.getEntityKey().getKeyValueAsString());
                }
                if (PENDING_CAT_EDIT.equals(esrCorr.getIdState())) {
                    this.setVOAFormPending(app, incoming, "Pending Catastrophic Edit (PCE), vpid= " + esrCorr.getIdentity());
                    this.getWorkflowService().autoCreateCase(incoming, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "Identity Trait Updates are pending for the person on the VOA submitted form.");
                    return null;
                }
                incomingCopy = this.updateESRCorrelationIfNeeded(incoming, adrPerson);
                if (incoming.getPreferredFacilities() != null && incoming.getPreferredFacilities().size() > 0) {
                    PreferredFacility facility = (PreferredFacility)((Object)incoming.getPreferredFacilities().iterator().next());
                    facility.setPerson(null);
                    incomingCopy.addPreferredFacility(facility);
                }
            }
            incoming.setIdentifier(personId);
            if (!VOA_IND_2.equals(adrPerson.getVOAIndicator())) {
                incoming.setVOAIndicator(VOA_IND_1);
                try {
                    this.getPersonService().addPreferredFacilityCorrelation(incomingCopy, correlations);
                }
                catch (ServiceException ex) {
                    this.setVOAFormPending(app, incoming, "Request for VOA Proxy Preferred Facility Patient Record Create Failed due to exception: " + ex.getMessage());
                    this.getWorkflowService().autoCreateCase(incoming, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "Request for VOA Proxy Preferred Facility Patient Record Create Failed");
                    return null;
                }
            }
        }
        this.processRadiationExposure(incoming);
        return this.processCommonVOA(app, incoming, correlations, true);
    }

    @Override
    public Person getOnFilePersonPersonForAnonymousPerson(VOAApplication app, Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)app), (String)"VOA application must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        PersonIdentityTraits traits = null;
        List<PatientIdentifier> correlations = null;
        IdMSearchInfo searchInfo = new IdMSearchInfo();
        searchInfo.setExtendedSearch(true);
        searchInfo.setDataEntererExtension("SSN= " + app.getSsn());
        searchInfo.setDataEntererFamilyName(app.getLastName());
        searchInfo.setDataEntererGivenName(app.getFirstName());
        if (!StringUtils.isEmpty((String)app.getFullQualifiedId()) && app.getFullQualifiedId().split("\\^").length == 4) {
            this.logger.info((Object)"FQID is present");
            String[] ids = app.getFullQualifiedId().split("\\^");
            this.logger.info((Object)("IDs : " + ids.toString()));
            traits = this.idmServiceDelegate.searchWithCompositeCall(new FullyQualifiedIdentity(ids[0], ids[1], ids[2], ids[3]), false, searchInfo);
            if (traits == null) {
                this.logger.info((Object)"MVI composite search returned no traits");
                correlations = this.getCorrelationsFromCompositeCall(incoming.getIdentityTraits(), searchInfo);
            } else {
                this.logger.info((Object)"MVI composite search returned traits, now retrieving correlations");
                correlations = traits.getAllCorrelations();
            }
        } else {
            this.logger.info((Object)"No FQID present, MVI composite search performed by traits.");
            correlations = this.getCorrelationsFromCompositeCall(incoming.getIdentityTraits(), searchInfo);
        }
        Person adrPerson = null;
        if (correlations == null || correlations.size() == 0) {
            this.logger.info((Object)"no correlations found");
            adrPerson = null;
        } else {
            String vpid = VPIDEntityKeyImpl.getLongVPID(this.getICN(correlations));
            this.logger.info((Object)("correlations found, vpid is : " + vpid));
            incoming.setVPIDValue(vpid);
            PatientIdentifier esrCorr = this.get200ESRCorrelation(correlations);
            if (esrCorr == null) {
                this.logger.info((Object)("no ESR correlations found for this vpid: " + vpid));
                adrPerson = null;
            } else {
                this.logger.info((Object)("ESR correlations found for this vpid: " + vpid));
                adrPerson = this.getPersonService().getPersonWithoutIdentityTraits(incoming.getVPIDEntityKey());
                if (adrPerson == null) {
                    this.logger.error((Object)("Cannot process person. onFile person not found for vpid= " + incoming.getVPIDEntityKey().getKeyValueAsString()));
                    return null;
                }
                return adrPerson;
            }
        }
        return adrPerson;
    }

    @Override
    public Person getOnFilePersonForPersonWithDSLogon(VOAApplication app, Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)app), (String)"VOA application must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        if (StringUtils.isEmpty((String)app.getFullQualifiedId())) {
            this.logger.error((Object)"VOA LOA2+ Aplication with empty fully qualified identifier");
            return null;
        }
        List correlations = this.idmServiceDelegate.getCorrelationsByFullyQualifiedIdentifier(app.getFullQualifiedId());
        if (correlations == null || correlations.size() == 0) {
            return null;
        }
        String vpid = VPIDEntityKeyImpl.getLongVPID(this.getICN(correlations));
        incoming.setVPIDValue(vpid);
        PatientIdentifier esrCorr = this.get200ESRCorrelation(correlations);
        Person adrPerson = null;
        if (esrCorr == null) {
            this.logger.info((Object)"no esr correlation found - person not known to ES");
            return null;
        }
        adrPerson = this.getPersonService().getPersonWithoutIdentityTraits(incoming.getVPIDEntityKey());
        if (adrPerson == null) {
            this.logger.error((Object)("Cannot process person. onFile person not found for vpid= " + incoming.getVPIDEntityKey().getKeyValueAsString()));
            return null;
        }
        return adrPerson;
    }

    private Person processDSLogonLevel2(VOAApplication app, Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)app), (String)"VOA application must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        if (StringUtils.isEmpty((String)app.getFullQualifiedId())) {
            this.logger.error((Object)"VOA LOA2+ Aplication with empty fully qualified identifier");
            return null;
        }
        Person incomingCopy = incoming;
        List correlations = this.idmServiceDelegate.getCorrelationsByFullyQualifiedIdentifier(app.getFullQualifiedId());
        if (correlations == null || correlations.size() == 0) {
            this.setVOAFormPending(app, incoming, "Person not found from MVI with FQID= " + app.getFullQualifiedId());
            this.sendPersonNotFoundEmail(app, incoming);
            return null;
        }
        String vpid = VPIDEntityKeyImpl.getLongVPID(this.getICN(correlations));
        incoming.setVPIDValue(vpid);
        BigDecimal personId = null;
        PatientIdentifier esrCorr = this.get200ESRCorrelation(correlations);
        this.setVoaDefaults(incoming, app);
        Person adrPerson = null;
        if (esrCorr == null) {
            this.getPersonService().addESRCorrelation(incoming);
            PersonEntityKey personKey = null;
            try {
                personKey = this.getPersonService().getPersonIdByVPID(incoming.getVPIDEntityKey());
                if (personKey == null) {
                    personKey = this.getPersonService().addPersonStub(incoming.getVPIDEntityKey());
                    this.getVoaApplicationDAO().flush();
                }
            }
            catch (DAOException ex) {
                throw new ServiceException("insert into PS_PERSON_VPID failed: ", (Throwable)ex);
            }
            personId = (BigDecimal)personKey.getKeyValue();
            adrPerson = this.getPersonService().getPersonWithoutIdentityTraits(incoming.getVPIDEntityKey());
            if (adrPerson == null) {
                this.logger.error((Object)("Cannot process person. onFile person not found for vpid= " + incoming.getVPIDEntityKey().getKeyValueAsString()));
                return null;
            }
            incoming.setIdentifier(personId);
        } else {
            adrPerson = this.getPersonService().getPersonWithoutIdentityTraits(incoming.getVPIDEntityKey());
            if (adrPerson == null) {
                this.logger.error((Object)("Cannot process person. onFile person not found for vpid= " + incoming.getVPIDEntityKey().getKeyValueAsString()));
                return null;
            }
            personId = new BigDecimal(adrPerson.getEntityKey().getKeyValueAsString());
            incoming.setIdentifier(personId);
            if (PENDING_CAT_EDIT.equals(esrCorr.getIdState())) {
                this.setVOAFormPending(app, incoming, "Pending Catastrophic Edit (PCE), vpid= " + esrCorr.getIdentity());
                this.getWorkflowService().autoCreateCase(incoming, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "Identity Trait Updates are pending for the person on the VOA submitted form.");
                return null;
            }
            incomingCopy = this.updateESRCorrelationIfNeeded(incoming, adrPerson);
            if (incoming.getPreferredFacilities() != null && incoming.getPreferredFacilities().size() > 0) {
                PreferredFacility facility = (PreferredFacility)((Object)incoming.getPreferredFacilities().iterator().next());
                facility.setPerson(null);
                incomingCopy.addPreferredFacility(facility);
            }
        }
        incoming.setVeteran(Boolean.TRUE);
        try {
            this.getPersonService().addPreferredFacilityCorrelation(incomingCopy, correlations);
        }
        catch (ServiceException ex) {
            this.setVOAFormPending(app, incoming, "Request for VOA Proxy Preferred Facility Patient Record Create Failed due to exception: " + ex.getMessage());
            this.getWorkflowService().autoCreateCase(incoming, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "Request for VOA Proxy Preferred Facility Patient Record Create Failed");
            return null;
        }
        this.processRadiationExposure(incoming);
        return this.processCommonVOA(app, incoming, correlations, false);
    }

    private boolean hasANewPreferredFacility(Person incoming, List<PatientIdentifier> correlations) {
        if (incoming.getPreferredFacility() == null || incoming.getPreferredFacilities().size() == 0) {
            return false;
        }
        if (correlations == null || correlations.size() == 0) {
            return true;
        }
        String PF = ((PreferredFacility)((Object)incoming.getPreferredFacilities().iterator().next())).getFacility().getStationNumber();
        if (PF == null) {
            return false;
        }
        HashSet stationNumbers = new HashSet();
        Iterator<PatientIdentifier> it = correlations.iterator();
        PatientIdentifier pid = null;
        while (it.hasNext()) {
            pid = it.next();
            if (!PF.equals(pid.getStationNumber())) continue;
            return false;
        }
        return true;
    }

    private Person processCommonVOA(VOAApplication app, Person incoming, List<PatientIdentifier> correlations, boolean isAnonymousLOA1) throws ServiceException {
        Validate.notNull((Object)incoming.getPersonEntityKey(), (String)"Incoming Person here must have person id not null");
        BigDecimal personId = (BigDecimal)incoming.getPersonEntityKey().getKeyValue();
        app.setPersonId(personId);
        this.updateVOAApplication(app);
        if (app.getFileAttachments() != null && app.getFileAttachments().size() > 0) {
            for (VoaFileAttachment att : app.getFileAttachments()) {
                att.setPersonId(personId);
            }
            this.getWorkflowService().autoCreateCase(incoming, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "VOA Attached Evidence Provided by Applicant.");
        }
        VAFacility sendingFacility = VOA_VA_FACILITY;
        VerificationInfo info = new VerificationInfo();
        info.setSiteNumber(sendingFacility.getCode());
        CampLejeuneVerification cl = (CampLejeuneVerification)incoming.getSpecialFactorByType(CampLejeuneVerification.class);
        if (cl != null) {
            cl.setRegistrationDate(new ImpreciseDate(app.getCreatedOn()));
        }
        Person result = null;
        try {
            result = this.getMessagingService().processVOA(incoming, sendingFacility, info, isAnonymousLOA1, correlations);
        }
        catch (AddProxyPreferredFacilityException aex) {
            this.logger.error((Object)("Request for VOA Proxy Preferred Facility Patient Record Create Failed due to exception: (submission id=" + app.getEntityKey().getKeyValueAsString() + "): " + ExceptionUtils.getFullStackTrace((Throwable)aex)));
            this.setVOAFormPending(app, incoming, "Request for VOA Proxy Preferred Facility Patient Record Create Failed due to exception: " + ExceptionUtils.getRootCause((Throwable)aex));
            return null;
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("VOA Process submission failed due to exception: (submission id=" + app.getEntityKey().getKeyValueAsString() + "): " + ExceptionUtils.getFullStackTrace((Throwable)ex)));
            app.setApplicationStatus((VOAApplicationStatus)this.getLookupService().getByCode(VOAApplicationStatus.class, VOAApplicationStatus.FORM_SUBMISSION_FAILED));
            app.setErrorText("VOA Process submission failed due to exception: " + ExceptionUtils.getCause((Throwable)ex));
            this.updateVOAApplication(app);
            return null;
        }
        catch (Throwable t) {
            this.logger.error((Object)("Throwable exception during VOA Process submission: (submission id=" + app.getEntityKey().getKeyValueAsString() + "): " + ExceptionUtils.getFullStackTrace((Throwable)t)));
            app.setErrorText("Throwable exception during VOA Process submission: " + ExceptionUtils.getFullStackTrace((Throwable)t));
            this.updateVOAApplication(app);
            return null;
        }
        if (result.getEnrollmentDetermination() == null && result.getEnrollmentDeterminations().size() == 0) {
            this.setVOAFormPending(app, incoming, "The information for the person on the VOA submitted form was not accepted.");
            this.getWorkflowService().autoCreateCase(incoming, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "The information for the person on the VOA submitted form was not accepted.");
            return null;
        }
        app.setApplicationStatus((VOAApplicationStatus)this.getLookupService().getByCode(VOAApplicationStatus.class, VOAApplicationStatus.FORM_PROCESSED_SUCCESSFUL));
        this.updateVOAApplication(app);
        if (app.getFullQualifiedId() != null) {
            this.removeOrphanedVOAApplication(app);
        }
        if (incoming.getEmails() != null && incoming.getEmails().size() > 0) {
            String[] toList = new String[incoming.getEmails().size()];
            int i = 0;
            Iterator it = incoming.getEmails().iterator();
            while (it.hasNext()) {
                toList[i] = ((Email)((Object)it.next())).getAddress();
                ++i;
            }
            if (this.bulletinService != null) {
                Hashtable<String, Object> bulletinData = new Hashtable<String, Object>();
                bulletinData.put("FirstName", incoming.getLegalName().getGivenName());
                bulletinData.put("LastName", incoming.getLegalName().getFamilyName());
                bulletinData.put("PreferredFacility", incoming.getPreferredFacility().getDescription());
                bulletinData.put("SubmissionTime", app.getCreatedOn());
                bulletinData.put("SubmissionId", app.getEntityKey().getKeyValueAsString());
                try {
                    this.bulletinService.sendEmailBulletinTo(BulletinTrigger.DataType.Initial_Submission_Confirmation, bulletinData, toList);
                }
                catch (Exception mex) {
                    this.logger.error((Object)("VOA end of process - cannot send email notification for appId= " + app.getEntityKey().getKeyValueAsString() + "\nError Message: " + mex.getMessage()));
                }
            }
        }
        return result;
    }

    private void setVOAFormPending(VOAApplication app, Person incoming, String errorTxt) throws ServiceException {
        app.setApplicationStatus((VOAApplicationStatus)this.getLookupService().getByCode(VOAApplicationStatus.class, VOAApplicationStatus.FORM_PROCESSING_PENDING));
        app.setErrorText(errorTxt);
        VOAResubmissionData data = app.getVOAResubmissionData();
        if (data == null) {
            data = new VOAResubmissionData();
            data.setVoaApplicationId((BigDecimal)app.getEntityKey().getKeyValue());
            app.setVOAResubmissionData(data);
        }
        try {
            data.setApplicationData(this.serializeXML(incoming));
        }
        catch (SQLException se) {
            throw new ServiceException("processVoaApplication failed when setVOAFormPending - unable to serialize Person object. Submission id = " + app.getEntityKey().getKeyValueAsString(), (Throwable)se);
        }
        if (incoming.getEntityKey() != null) {
            app.setPersonId((BigDecimal)incoming.getEntityKey().getKeyValue());
        }
        this.updateVOAApplication(app);
    }

    private Person updateESRCorrelationIfNeeded(Person incoming, Person adrPerson) throws ServiceException {
        PersonIdentityTraits esrTraits = this.getPersonService().getESRCorrelation(incoming.getVPIDEntityKey());
        if (esrTraits == null) {
            throw new ServiceException("Process VOA application - 200ESR Person Traits does not exist for vpid = " + incoming.getVPIDEntityKey().getKeyValue());
        }
        boolean isUpdated = false;
        Person adrPersonCopy = (Person)((Object)adrPerson.clone());
        Name esrName = esrTraits.getLegalName();
        if (esrName != null) {
            adrPersonCopy.setLegalName(esrName);
        }
        if (esrTraits.getNames() != null && (esrName = Name.getNameOfType(esrTraits.getNames(), NameType.ALIAS_NAME.getName())) != null) {
            adrPersonCopy.setAliasName(esrName);
        }
        if (!StringUtils.isEmpty((String)esrTraits.getMothersMaidenName())) {
            adrPersonCopy.setMothersMaidenName(esrTraits.getMothersMaidenName());
        }
        if (esrTraits.getSsn() != null) {
            if (adrPersonCopy.getOfficialSsn() != null) {
                adrPersonCopy.removeSsn(adrPersonCopy.getOfficialSsn());
            }
            adrPersonCopy.addSsn(esrTraits.getSsn());
        }
        if (!StringUtils.isEmpty((String)esrTraits.getDateOfDeathText())) {
            DeathRecord deathRecord = new DeathRecord();
            Date date = this.stringToDate(esrTraits.getDateOfDeathText(), "yyyyMMdd");
            ImpreciseDate dateWithTime = ImpreciseDateUtils.createImpreciseDateWithoutTime(date);
            String impreciseString = dateWithTime.toStandardFormat();
            if (impreciseString.length() > 8) {
                impreciseString = impreciseString.substring(0, 8);
            }
            ImpreciseDate dateWithoutTime = new ImpreciseDate(impreciseString);
            deathRecord.setDeathDate(dateWithoutTime);
            deathRecord.setDeathReportDate(new Date());
            deathRecord.setLazarusDate(null);
            deathRecord.setDataSource(this.getLookupService().getDeathDataSourceByCode(DeathDataSource.CODE_DEATH_CERT_ON_FILE.getCode()));
            deathRecord.setFacilityReceived(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
            adrPersonCopy.setDeathRecord(deathRecord);
        }
        if (esrTraits.getGender() != null) {
            adrPersonCopy.setGender(esrTraits.getGender());
        }
        if (esrTraits.getBirthRecord() != null) {
            adrPersonCopy.setBirthRecord(esrTraits.getBirthRecord());
        }
        Address newAddr = incoming.getPermanentAddress();
        Address oldAddr = adrPerson.getPermanentAddress();
        if (newAddr != null) {
            Address newAddrCopy;
            if (oldAddr == null) {
                isUpdated = true;
                newAddrCopy = (Address)newAddr.clone();
                newAddrCopy.setPerson(null);
                adrPersonCopy.addAddress(newAddrCopy);
            } else if (!StringUtils.isEmpty((String)newAddr.getLine1()) && !newAddr.getLine1().equalsIgnoreCase(oldAddr.getLine1()) || !StringUtils.isEmpty((String)newAddr.getLine2()) && !newAddr.getLine2().equalsIgnoreCase(oldAddr.getLine2()) || !StringUtils.isEmpty((String)newAddr.getLine3()) && !newAddr.getLine3().equalsIgnoreCase(oldAddr.getLine3()) || !StringUtils.isEmpty((String)newAddr.getCity()) && !newAddr.getCity().equalsIgnoreCase(oldAddr.getCity()) || !StringUtils.isEmpty((String)newAddr.getState()) && !newAddr.getState().equalsIgnoreCase(oldAddr.getState()) || !StringUtils.isEmpty((String)newAddr.getZipCode()) && !newAddr.getZipCode().equalsIgnoreCase(oldAddr.getZipCode()) || !StringUtils.isEmpty((String)newAddr.getCountry()) && !newAddr.getCountry().equalsIgnoreCase(oldAddr.getCountry())) {
                isUpdated = true;
                adrPersonCopy.removeAddress(oldAddr);
                newAddrCopy = (Address)newAddr.clone();
                newAddrCopy.setPerson(null);
                adrPersonCopy.addAddress(newAddrCopy);
            }
        }
        if (!(incoming.getHomePhone() == null || StringUtils.isEmpty((String)incoming.getHomePhone().getPhoneNumber()) || adrPerson.getHomePhone() != null && incoming.getHomePhone().getPhoneNumber().equalsIgnoreCase(adrPerson.getHomePhone().getPhoneNumber()))) {
            isUpdated = true;
            if (adrPerson.getHomePhone() != null) {
                adrPersonCopy.removePhone(adrPerson.getHomePhone());
            }
            Phone homePhoneCopy = (Phone)((Object)incoming.getHomePhone().clone());
            homePhoneCopy.setPerson(null);
            adrPersonCopy.addPhone(homePhoneCopy);
        }
        if (isUpdated) {
            this.getPersonService().updateProfileForESRCorrelation(adrPersonCopy);
        }
        return adrPersonCopy;
    }

    private PatientIdentifier get200ESRCorrelation(List correlations) {
        if (correlations == null || correlations.size() == 0) {
            return null;
        }
        PatientIdentifier pid2 = null;
        for (PatientIdentifier pid2 : correlations) {
            if (!"200ESR".equals(pid2.getStationNumber())) continue;
            return pid2;
        }
        return null;
    }

    private String getICN(List correlations) {
        if (correlations == null || correlations.size() == 0) {
            return null;
        }
        PatientIdentifier pid2 = null;
        for (PatientIdentifier pid2 : correlations) {
            if (!"200M".equals(pid2.getStationNumber())) continue;
            return pid2.getIdentity();
        }
        return null;
    }

    private void setVoaDefaults(Person incoming, VOAApplication app) throws ServiceException {
        Integer prevCalendarYear;
        Object it;
        AgentOrangeExposure aoe;
        Set associations;
        Set emails;
        Set phones;
        Date appLogDate = app.getCreatedOn();
        Address addr = incoming.getPermanentAddress();
        Address address = incoming.getPermanentAddress();
        if (address != null) {
            address.setChangeDate(appLogDate);
            address.setChangeSource(this.getLookupService().getAddressChangeSourceByCode(AddressChangeSource.CODE_VAMC.getName()));
            address.setChangeSite(incoming.getPreferredFacility());
        }
        if ((phones = incoming.getPhones()) != null && phones.size() > 0) {
            for (Phone ph : phones) {
                ph.setChangeDate(appLogDate);
                ph.setSourceOfChange(this.getLookupService().getPhoneSourceOfChangeByCode(PhoneSourceOfChange.CODE_VAMC.getName()));
                ph.setSiteOfChange(incoming.getPreferredFacility());
            }
        }
        if ((emails = incoming.getEmails()) != null && emails.size() > 0) {
            for (Email em : emails) {
                em.setChangeDate(appLogDate);
                em.setSourceOfChange(this.getLookupService().getEmailSourceOfChangeByCode(EmailSourceOfChange.CODE_VAMC.getName()));
                em.setSiteOfChange(incoming.getPreferredFacility());
            }
        }
        if ((associations = incoming.getAssociations()) != null && associations.size() > 0) {
            Association assoc2 = null;
            for (Association assoc2 : associations) {
                assoc2.setLastUpdateDate(appLogDate);
            }
        }
        if ((aoe = incoming.getAgentOrangeExposure()) != null && aoe.getAgentOrangeExposureIndicator() != null && Indicator.YES.getCode().equals(aoe.getAgentOrangeExposureIndicator().getCode())) {
            aoe.setLocation(this.getLookupService().getAgentOrangeExposureLocationByCode(AgentOrangeExposureLocation.CODE_VIETNAM.getCode()));
        }
        if (Boolean.TRUE.equals(incoming.getAppointmentRequestResponse())) {
            incoming.setAppointmentRequestDate(appLogDate);
        }
        if (incoming.getInsurances() != null && incoming.getMedicareInsurances() != null && incoming.getMedicareInsurances().size() > 0) {
            Medicare mc = (Medicare)incoming.getMedicareInsurances().iterator().next();
            mc.setReportSite(VOA_VA_FACILITY);
        }
        if (incoming.getPrivateInsurances() != null && incoming.getPrivateInsurances().size() > 0) {
            if (this.INSURED_RELATIONSHIP_VETERAN == null) {
                this.INSURED_RELATIONSHIP_VETERAN = this.getLookupService().getInsuredRelationshipByCode(InsuredRelationship.CODE_VETERAN.getCode());
            }
            PrivateInsurance ins = null;
            it = incoming.getPrivateInsurances().iterator();
            while (it.hasNext()) {
                ins = (PrivateInsurance)it.next();
                InsuranceSubscriber sub = ins.getSubscriber() == null ? new InsuranceSubscriber() : ins.getSubscriber();
                sub.setRelationship(this.INSURED_RELATIONSHIP_VETERAN);
            }
        }
        if (incoming.getMedicaidFactor() != null) {
            incoming.getMedicaidFactor().setLastUpdateDate(appLogDate);
        }
        if ((it = incoming.getIncomeTest(prevCalendarYear = new Integer(Calendar.getInstance().get(1) - 1))) != null) {
            ((IncomeTest)((Object)it)).setSendForAdjudication(Boolean.FALSE);
            ((IncomeTest)((Object)it)).setAgreesToPayDeductible(Boolean.TRUE);
        }
        MaritalStatus status = incoming.getMaritalStatus();
        FinancialStatement stmt = incoming.getFinancialStatement(prevCalendarYear);
        Boolean marritedLastYear = false;
        if (status != null && (MaritalStatus.CODE_MARRIED.getCode().equals(status.getCode()) || MaritalStatus.CODE_SEPARATED.getCode().equals(status.getCode()) || MaritalStatus.CODE_DIVORCED.getCode().equals(status.getCode()) || MaritalStatus.CODE_WIDOWED.getCode().equals(status.getCode())) && stmt != null && stmt.getSpouseFinancials() != null && stmt.getSpouseFinancials().size() != 0) {
            for (SpouseFinancials spf : stmt.getSpouseFinancials()) {
                if (spf.getReportedOn() == null || spf.getReportedOn().getMarriageDate() == null || spf.getReportedOn().getMarriageDate().compareTo(new ImpreciseDate("1/1/" + prevCalendarYear)) >= 0) continue;
                marritedLastYear = true;
                break;
            }
        }
        if (stmt != null) {
            stmt.setMarriedLastCalendarYear(marritedLastYear);
        }
    }

    @Override
    public void resubmit(List applicationIds) throws ServiceException {
        List voaApps = this.find(applicationIds);
        for (VOAApplication voaApp : voaApps) {
            this.resubmitVoaApplication(voaApp);
        }
    }

    public List find(List applicationIds) throws ServiceException {
        ArrayList<VOAApplication> voaApps = new ArrayList<VOAApplication>();
        try {
            for (BigDecimal appId : applicationIds) {
                VOAApplication voaApp = this.getVoaApplicationDAO().getByApplicationId(appId);
                if (voaApp == null) continue;
                voaApps.add(voaApp);
            }
        }
        catch (DAOException e) {
            throw new ServiceException("VOA Application retrieval Failed ", (Throwable)e);
        }
        return voaApps;
    }

    @Override
    public List getResubmissionVOAApplications() throws ServiceException {
        List lst = null;
        try {
            lst = this.getVoaApplicationDAO().getVOAResubmissionApplications();
        }
        catch (DAOException dex) {
            throw new ServiceException("Error getting Resubmission VOA form list", (Throwable)dex);
        }
        return lst;
    }

    @Override
    public void resubmitVoaApplication(VOAApplication voaApp) throws ServiceException {
        Validate.notNull((Object)((Object)voaApp), (String)"Resubmission VOAApplication must not be null");
        Validate.notNull((Object)voaApp.getEntityKey(), (String)"Resubmission VOAApplication id must not be null");
        Validate.notNull((Object)((Object)voaApp.getVOAResubmissionData()), (String)"Resubmission VOAApplication Data must not be null");
        Validate.notNull((Object)voaApp.getEntityKey(), (String)"Resubmission VOAApplication id must not be null");
        if (voaApp.getVOAResubmissionData() == null || voaApp.getVOAResubmissionData().getApplicationData() == null) {
            throw new ServiceException("Resubmit VoaApplication failed with empty resubmission data. Submission id = " + voaApp.getEntityKey().getKeyValueAsString());
        }
        BigDecimal appId = (BigDecimal)voaApp.getEntityKey().getKeyValue();
        Person person = null;
        try {
            person = this.deserializeXML(voaApp.getVOAResubmissionData().getApplicationData());
        }
        catch (SQLException se) {
            throw new ServiceException("Resubmit VoaApplication failed: can not serialize person object. Submission id = " + voaApp.getEntityKey().getKeyValueAsString(), (Throwable)se);
        }
        voaApp.setApplicationStatus((VOAApplicationStatus)this.getLookupService().getByCode(VOAApplicationStatus.class, VOAApplicationStatus.FORM_RESUBMITTED));
        voaApp.getVOAResubmissionData().setApplicationData(null);
        try {
            this.getVoaApplicationDAO().update((Object)voaApp);
            this.getVoaApplicationDAO().flush();
        }
        catch (DAOException ex) {
            throw new ServiceException("Update VOA Resubmition failed: ", (Throwable)ex);
        }
        this.forwardVOAApplication(appId, person);
    }

    public List search(SearchQueryInfo searchQueryInfo) throws ServiceException {
        return this.searchPendingSubmissions(searchQueryInfo);
    }

    @Override
    public List searchPendingSubmissions(SearchQueryInfo searchQueryInfo) throws ServiceException {
        List pendingSubmissions = null;
        try {
            VOASearchCriteria searchCriteria = (VOASearchCriteria)searchQueryInfo;
            List applicationIds = null;
            if (applicationIds != null && applicationIds.size() > 0) {
                searchCriteria.setApplicationIds(applicationIds);
            }
            pendingSubmissions = this.getVoaApplicationDAO().find(searchCriteria);
            for (int i = 0; pendingSubmissions != null && i < pendingSubmissions.size(); ++i) {
                VOASearchResultBean voaBean = (VOASearchResultBean)pendingSubmissions.get(i);
                BigDecimal applicationId = voaBean.getApplicationId();
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Pending Submissions Search Failed", (Throwable)e);
        }
        return pendingSubmissions;
    }

    private void processRadiationExposure(Person incoming) throws ServiceException {
        RadiationExposure rexp = incoming.getRadiationExposure();
        if (rexp != null && rexp.getRadiationExposureIndicator() != null && Indicator.YES.getCode().equals(rexp.getRadiationExposureIndicator().getCode())) {
            this.getWorkflowService().autoCreateCase(incoming, this.getLookupService().getFunctionalGroupByCode(FunctionalGroup.EE.getCode()), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_VETERANS_ONLINE_APPLICATION.getCode()), null, "Radiation Exposure Indicated");
        }
    }

    private String serializeXML(Person p) throws SQLException {
        if (p == null) {
            return null;
        }
        return new XStream().toXML((Object)p);
    }

    private Person deserializeXML(String xml) throws SQLException {
        if (xml == null) {
            return null;
        }
        return (Person)((Object)new XStream().fromXML(xml));
    }

    public Date stringToDate(String string, String dateFormatStr) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(dateFormatStr);
            date = dateFormat.parse(string);
        }
        catch (Exception ex) {
            this.logger.error((Object)"Exception @stringToDate  :", (Throwable)ex);
        }
        return date;
    }
}

