/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.model.security.UserLastLoginInfo;
import gov.va.med.esr.common.model.security.UserLogin;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.common.persistent.security.SecurityDAO;
import gov.va.med.esr.service.PasswordChangeHistory;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.impl.AccountAlreadyLockedException;
import gov.va.med.fw.model.BaseEntityKey;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.security.AccountLockedException;
import gov.va.med.fw.security.InsufficientPrivilegesException;
import gov.va.med.fw.security.InvalidPasswordException;
import gov.va.med.fw.security.InvalidSecurityCodeException;
import gov.va.med.fw.security.PasswordChangeNotAllowedException;
import gov.va.med.fw.security.PasswordEncryptionService;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.SecurityService;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.ui.security.ChangePasswordInfo;
import gov.va.med.fw.util.StringUtils;
import java.security.Principal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.acegisecurity.GrantedAuthorityImpl;
import org.apache.commons.lang.Validate;

public class SecurityServiceImpl
extends AbstractRuleAwareServiceImpl
implements SecurityService {
    protected static final long DAY_MILLISECONDS = 86400000L;
    private SecurityDAO securityDAO = null;
    private SystemParameterService systemParameterService = null;
    private PasswordEncryptionService passwordEncryptionService = null;
    private int passwordChangeWarningDays = 15;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.securityDAO, (String)"SecurityDAO is required");
        Validate.notNull((Object)this.systemParameterService, (String)"SystemParameterService is required");
        this.validateNotLess(this.passwordChangeWarningDays, 1, "passwordChangeWarningDays must be greater than 0 ");
    }

    private void validateNotLess(int property, int value, String message) {
        if (property < value) {
            throw new IllegalArgumentException(message);
        }
    }

    public SecurityDAO getSecurityDAO() {
        return this.securityDAO;
    }

    public void setSecurityDAO(SecurityDAO securityDAO) {
        this.securityDAO = securityDAO;
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    public PasswordEncryptionService getPasswordEncryptionService() {
        return this.passwordEncryptionService;
    }

    public void setPasswordEncryptionService(PasswordEncryptionService passwordEncryptionService) {
        this.passwordEncryptionService = passwordEncryptionService;
    }

    public int getPasswordChangeWarningDays() {
        return this.passwordChangeWarningDays;
    }

    public void setPasswordChangeWarningDays(int passwordChangeWarningDays) {
        this.passwordChangeWarningDays = passwordChangeWarningDays;
    }

    public UserPrincipal getUserById(EntityKey userId) throws ServiceException {
        try {
            ESRUserPrincipalImpl user = (ESRUserPrincipalImpl)this.securityDAO.getUserById(userId);
            if (user != null) {
                this.checkVersionNumbers(userId, user.getEntityKey());
                return user;
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Error finding user with id " + userId + ".", (Throwable)e);
        }
        return null;
    }

    public Subject authenticate(String username, String password) throws LoginException {
        ESRUserPrincipal userPrincipal = this.authenticateUser(username, password);
        try {
            Map systemProps = this.getSystemProperties();
            this.onLoginSuccess((ESRUserPrincipalImpl)userPrincipal, systemProps);
        }
        catch (DAOException e1) {
            this.logger.error((Object)"Exception updating user logon status information.", (Throwable)e1);
        }
        catch (ServiceException e2) {
            this.logger.error((Object)"Exception updating user logon status information.", (Throwable)e2);
        }
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)((Object)userPrincipal));
        return subject;
    }

    private ESRUserPrincipal authenticateUser(String username, String password) throws LoginException {
        ESRUserPrincipalImpl userPrincipal = null;
        HashMap systemProps = null;
        try {
            userPrincipal = this.getUserByName(username);
            systemProps = this.getSystemProperties();
        }
        catch (ServiceException e) {
            LoginException ex = new LoginException("Error authenticating user " + username + ". Reason: " + e.toString());
            ex.initCause(e);
            throw ex;
        }
        if (userPrincipal == null) {
            throw new FailedLoginException("User Account for " + username + " Does Not Exist.");
        }
        if (systemProps == null) {
            systemProps = new HashMap();
        }
        this.lockInactiveUser(userPrincipal);
        if (this.isAccountLocked(userPrincipal)) {
            throw new AccountAlreadyLockedException("User account for " + username + " is locked.");
        }
        if (!this.isAuthorizedToLogin(userPrincipal)) {
            throw new InsufficientPrivilegesException(username + " does not have Login to System Capability");
        }
        return userPrincipal;
    }

    private void lockInactiveUser(ESRUserPrincipalImpl userPrincipal) {
        if (userPrincipal.getLockDate() == null) {
            Calendar ayearAgo = Calendar.getInstance();
            ayearAgo.setTime(this.getCurrentDate());
            ayearAgo.add(1, -1);
            Date lastLoginDate = userPrincipal.getSuccessfulLoginDate();
            Date lastModified = userPrincipal.getModifiedOn();
            if (lastLoginDate != null && lastLoginDate.before(ayearAgo.getTime()) && lastModified.before(ayearAgo.getTime())) {
                userPrincipal.setLockDate(lastLoginDate);
                try {
                    this.securityDAO.update(userPrincipal);
                }
                catch (DAOException el) {
                    this.logger.error((Object)("Exception updating account lock information." + el.getMessage()));
                }
            }
        }
    }

    private boolean verifyPassword(String clearText, String dbPassword) {
        if (StringUtils.isEmpty((String)clearText) || StringUtils.isEmpty((String)dbPassword)) {
            return false;
        }
        try {
            if (dbPassword.equals(this.getPasswordEncryptionService().encryptPassword(clearText)) || dbPassword.equals(clearText)) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Password Compare error " + e));
        }
        return false;
    }

    public void lockAccount(EntityKey userId) throws ServiceException {
        ESRUserPrincipalImpl userPrincipal = this.getUserPrincipal(userId);
        this.setLockProperties(userPrincipal);
        try {
            this.securityDAO.update(userPrincipal);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to lock a user account", (Throwable)e);
        }
    }

    public void unlockAccount(EntityKey userId) throws ServiceException {
        ESRUserPrincipalImpl userPrincipal = this.getUserPrincipal(userId);
        this.resetLockProperties(userPrincipal);
        try {
            this.securityDAO.update(userPrincipal);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to unlock a user account", (Throwable)e);
        }
    }

    public void enableAccount(EntityKey userId) throws ServiceException {
        ESRUserPrincipalImpl userPrincipal = this.getUserPrincipal(userId);
        userPrincipal.setInActiveDate(null);
        try {
            this.securityDAO.update(userPrincipal);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to enable a user account", (Throwable)e);
        }
    }

    public void disableAccount(EntityKey userId) throws ServiceException {
        ESRUserPrincipalImpl userPrincipal = this.getUserPrincipal(userId);
        userPrincipal.setInActiveDate(this.getCurrentDate());
        try {
            this.securityDAO.update(userPrincipal);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to disable a user account", (Throwable)e);
        }
    }

    public void changePassword(ChangePasswordInfo changePasswordInfo) throws LoginException, ServiceException {
        Validate.notNull((Object)changePasswordInfo, (String)"ChangePasswordInfo can not be null");
        String username = changePasswordInfo.getUserID();
        String password = changePasswordInfo.getPassword();
        String newPassword = changePasswordInfo.getNewPassword();
        Validate.notNull((Object)username, (String)"user name can not be null");
        Validate.notNull((Object)password, (String)"password can not be null");
        Validate.notNull((Object)newPassword, (String)"new password can not be null");
        ESRUserPrincipalImpl userPrincipal = null;
        try {
            userPrincipal = (ESRUserPrincipalImpl)this.authenticateUser(username, password);
            this.validatePasswordReuse(userPrincipal, newPassword);
        }
        catch (CredentialExpiredException ex) {
            userPrincipal = this.getUserByName(username);
        }
        catch (LoginException ex) {
            throw ex;
        }
        this.resetPasswordProperties(userPrincipal, this.getPasswordEncryptionService().encryptPassword(newPassword));
        try {
            this.securityDAO.updatePassword(userPrincipal);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while changing password. Reason: ", (Throwable)ex);
        }
    }

    public void resetPassword(String username, String password) throws ServiceException {
        try {
            ESRUserPrincipalImpl userPrincipal = this.getUserByName(username);
            this.resetPasswordProperties(userPrincipal, password);
            this.securityDAO.update(userPrincipal);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while resetting the password.", (Throwable)ex);
        }
    }

    private void resetPasswordProperties(ESRUserPrincipalImpl userPrincipal, String password) {
        userPrincipal.setPassword(password);
        userPrincipal.setPasswordChangeDate(this.getCurrentDate());
        userPrincipal.setFailAttemptCount(0);
        userPrincipal.setPasswordExpireDate(null);
    }

    private void onLoginSuccess(ESRUserPrincipalImpl userPrincipal, Map props) throws DAOException {
        Date current = this.getCurrentDate();
        if (userPrincipal.getInitialLoginDate() == null) {
            userPrincipal.setInitialLoginDate(current);
        }
        if (userPrincipal.getSignatureVerified() == null || Boolean.FALSE.equals(userPrincipal.getSignatureVerified())) {
            userPrincipal.setSignatureVerified(Boolean.TRUE);
        }
        this.resetLockProperties(userPrincipal);
        this.logUserLogin(userPrincipal, current, null);
    }

    private void setPasswordWarningProperties(ESRUserPrincipalImpl userPrincipal, Map props) {
        int daysRemaining;
        Date passwordExpireDate;
        long now = this.getCurrentDate().getTime();
        long passwordChangeTime = userPrincipal.getPasswordChangeDate().getTime();
        long activeDays = (now - passwordChangeTime) / 86400000L;
        int nonWarningDays = this.getPasswordActiveDays(props) - this.passwordChangeWarningDays;
        int accountExpiryDays = this.getPasswordActiveDays(props) + this.getPasswordExpireDays(props);
        if (activeDays >= (long)nonWarningDays && activeDays < (long)accountExpiryDays) {
            userPrincipal.setPasswordChangeWarningDays(true);
            userPrincipal.setDaysRemainingToExpirePassword(this.getPasswordActiveDays(props) - (int)activeDays);
        }
        if ((passwordExpireDate = userPrincipal.getPasswordExpireDate()) != null && passwordExpireDate.after(this.getCurrentDate()) && (daysRemaining = (int)((passwordExpireDate.getTime() - now) / 86400000L)) <= this.passwordChangeWarningDays) {
            userPrincipal.setPasswordChangeWarningDays(true);
            userPrincipal.setDaysRemainingToExpirePassword(daysRemaining);
        }
    }

    private void onLoginFailed(ESRUserPrincipalImpl userPrincipal, int noOfFailedAttemptsToLock) throws DAOException, AccountLockedException {
        boolean lock = false;
        int failedAttemptCount = userPrincipal.getFailAttemptCount() + 1;
        userPrincipal.setFailAttemptCount(failedAttemptCount);
        if (failedAttemptCount >= noOfFailedAttemptsToLock) {
            userPrincipal.setLockDate(this.getCurrentDate());
            lock = true;
        }
        this.logUserLogin(userPrincipal, null, this.getCurrentDate());
        if (lock) {
            throw new AccountLockedException("User account for " + userPrincipal.getName() + " has been locked.");
        }
    }

    private void logUserLogin(ESRUserPrincipalImpl userPrincipal, Date passLoginDate, Date failedLoginDate) throws DAOException {
        UserLogin userLogin = new UserLogin(userPrincipal, passLoginDate, failedLoginDate);
        this.securityDAO.updateAndLog(userPrincipal, userLogin);
    }

    private boolean isPasswordExpired(ESRUserPrincipal userPrincipal, int passwordActiveDays) {
        Date passwordExpireDate = userPrincipal.getPasswordExpireDate();
        if (passwordExpireDate != null && passwordExpireDate.before(this.getCurrentDate())) {
            return true;
        }
        Date passwordChangeDate = userPrincipal.getPasswordChangeDate();
        if (passwordChangeDate == null) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.getCurrentDate());
        calendar.add(5, -passwordActiveDays);
        return passwordChangeDate.getTime() < calendar.getTimeInMillis();
    }

    private boolean isAccountLocked(ESRUserPrincipal userPrincipal) {
        Date lockDate = userPrincipal.getLockDate();
        return lockDate != null && lockDate.before(this.getCurrentDate());
    }

    private boolean isAccountDisabled(ESRUserPrincipal userPrincipal) {
        return userPrincipal.getInActiveDate() != null;
    }

    private boolean isAccountExpired(ESRUserPrincipal userPrincipal, int passwordActiveDays, int passwordExpireDays) {
        Date passwordChangeDate = userPrincipal.getPasswordChangeDate();
        Date passwordExpireDate = userPrincipal.getPasswordExpireDate();
        if (passwordChangeDate == null) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.getCurrentDate());
        calendar.add(5, -(passwordActiveDays + passwordExpireDays));
        if (passwordChangeDate.getTime() < calendar.getTimeInMillis()) {
            return true;
        }
        if (passwordExpireDate != null) {
            calendar.setTime(this.getCurrentDate());
            calendar.add(5, -passwordExpireDays);
            if (passwordExpireDate.getTime() < calendar.getTimeInMillis()) {
                return true;
            }
        }
        return false;
    }

    private boolean isPasswordSuspended(ESRUserPrincipal userPrincipal) {
        Date suspendDate = userPrincipal.getPasswordSuspendDate();
        return suspendDate != null && suspendDate.before(this.getCurrentDate());
    }

    private void setLockProperties(ESRUserPrincipalImpl userPrincipal) {
        userPrincipal.setLockDate(this.getCurrentDate());
        userPrincipal.setFailAttemptCount(0);
    }

    private void resetLockProperties(ESRUserPrincipalImpl userPrincipal) {
        userPrincipal.setFailAttemptCount(0);
    }

    public void verifySecurityCode(String userName, String securityCode) throws LoginException {
        ESRUserPrincipalImpl userPrincipal = null;
        try {
            userPrincipal = this.getUserByName(userName);
            if (userPrincipal == null) {
                throw new FailedLoginException("Invalid username name: " + userName);
            }
            if (!this.isSecurityCodeValid(userPrincipal, securityCode)) {
                throw new InvalidSecurityCodeException("Valid Security is required for authentication. userid:" + userName);
            }
        }
        catch (ServiceException e) {
            LoginException ex = new LoginException("Error authenticating user " + userName + ". Reason: " + e.toString());
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean isSecurityCodeValid(ESRUserPrincipalImpl user, String securityCode) {
        if (this.isSecurityCodeRequired(user)) {
            if (StringUtils.isEmpty((String)securityCode)) {
                return false;
            }
            return StringUtils.equals((String)user.getAgreementSignatureCode(), (String)securityCode);
        }
        return true;
    }

    public boolean isSecurityCodeRequired(ESRUserPrincipalImpl user) {
        boolean validate = false;
        if (user.getSignatureVerified() == null || Boolean.FALSE.equals(user.getSignatureVerified()) || user.getInitialLoginDate() == null || user.getSuccessfulLoginDate() == null) {
            validate = true;
        } else {
            int currentYear = Calendar.getInstance().get(1);
            Calendar nextLogin = Calendar.getInstance();
            nextLogin.clear();
            nextLogin.setTime(user.getInitialLoginDate());
            int initialLoginYear = nextLogin.get(1);
            if (currentYear > initialLoginYear) {
                nextLogin.add(1, currentYear - nextLogin.get(1));
                Date lastLogindate = user.getSuccessfulLoginDate();
                Date currentDate = new Date();
                if (currentDate.after(nextLogin.getTime()) && lastLogindate.before(nextLogin.getTime())) {
                    validate = true;
                }
            }
        }
        return validate;
    }

    private boolean isAuthorizedToLogin(UserPrincipal userPrincipal) {
        return userPrincipal.getAuthorities().contains(new GrantedAuthorityImpl(Capability.LOGIN_INTO_SYSTEM.getName()));
    }

    private boolean isAdministartor(UserPrincipal userPrincipal) {
        if (userPrincipal == null) {
            return false;
        }
        return userPrincipal.getAuthorities().contains(new GrantedAuthorityImpl(Capability.ADMINISTRATOR.getName()));
    }

    private ESRUserPrincipalImpl getUserPrincipal(EntityKey userId) throws ServiceException {
        Validate.notNull((Object)userId, (String)"User identifier can not be NULL.");
        try {
            return (ESRUserPrincipalImpl)this.securityDAO.getUserById(userId);
        }
        catch (DAOException e) {
            throw new ServiceException("No user exists with a user identifier " + userId, (Throwable)e);
        }
    }

    protected ESRUserPrincipalImpl getUserByName(String username) throws ServiceException {
        Validate.notNull((Object)username, (String)"User name can not be NULL.");
        ESRUserPrincipalImpl user = null;
        try {
            user = (ESRUserPrincipalImpl)this.securityDAO.findUserByUsername(username);
            if (user != null) {
                UserLastLoginInfo lastLoginInfo = this.getSecurityDAO().getUserLastLoginInfo(user.getEntityKey());
                user.setUserLastLoginInfo(lastLoginInfo);
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while locating the user " + username + " Reason: ", (Throwable)ex);
        }
        return user;
    }

    protected Map getSystemProperties() throws ServiceException {
        List properties = this.getSystemParameterService().findAll();
        HashMap<String, String> propMap = new HashMap<String, String>();
        for (int i = 0; i < properties.size(); ++i) {
            SystemParameter par = (SystemParameter)properties.get(i);
            propMap.put(par.getName(), par.getValue());
        }
        return propMap;
    }

    private int getNoOfFailedAttemptsToLock(Map propMap) {
        String value = (String)propMap.get("Failed Attempts");
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 3;
        }
    }

    private int getPasswordActiveDays(Map propMap) {
        String value = (String)propMap.get("Password Active Days");
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 90;
        }
    }

    private int getPasswordExpireDays(Map propMap) {
        String value = (String)propMap.get("Password Expired Days");
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 120;
        }
    }

    protected Date getCurrentDate() {
        return new Date();
    }

    public void validatePasswordReuse(ESRUserPrincipalImpl userPrincipal, String newPassword) throws LoginException {
        try {
            UserPrincipal loggedInUser;
            List changeHistory = this.getSecurityDAO().getPasswordChangeHistory(userPrincipal.getEntityKey());
            String encryptedNewPassword = this.getPasswordEncryptionService().encryptPassword(newPassword);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.getCurrentDate());
            calendar.add(5, -3);
            SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
            UserPrincipal userPrincipal2 = loggedInUser = securityContext != null ? securityContext.getUserPrincipal() : null;
            if (!(this.isAdministartor(loggedInUser) || userPrincipal.getName().equalsIgnoreCase(securityContext.getUserName()) && this.isAdministartor(userPrincipal) || changeHistory.size() <= 0)) {
                PasswordChangeHistory pwdChangeHistory = (PasswordChangeHistory)changeHistory.get(0);
                if (userPrincipal.getName().equalsIgnoreCase(pwdChangeHistory.getPasswordChangedBy()) && calendar.getTime().before(pwdChangeHistory.getPasswordChangeTime())) {
                    throw new PasswordChangeNotAllowedException("Password can not be changed within 3 days");
                }
            }
            for (int i = 0; i < changeHistory.size(); ++i) {
                PasswordChangeHistory pwdHistory = (PasswordChangeHistory)changeHistory.get(i);
                if (!encryptedNewPassword.equals(pwdHistory.getPassword()) && !newPassword.equals(pwdHistory.getPassword()) || i >= 4) continue;
                throw new InvalidPasswordException("Password is reused: Same password exists in the system  " + pwdHistory.getPasswordChangeTime().toString());
            }
        }
        catch (DAOException e) {
            throw new LoginException("Error while retrieving the password history");
        }
        catch (ServiceException se) {
            throw new LoginException("Error while encrypting the passwords");
        }
    }

    protected void checkVersionNumbers(EntityKey incomingKey, EntityKey onfileKey) throws ServiceException {
        BaseEntityKey incoming = (BaseEntityKey)incomingKey;
        BaseEntityKey onfile = (BaseEntityKey)onfileKey;
        if (incoming.getVersion() != null && onfile.getVersion() != null && incoming.getVersion().intValue() != onfile.getVersion().intValue()) {
            throw new ServiceOptimisticLockException("Version number specified does not match on file version number", null, null);
        }
    }
}

