/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.financials.RelaxationPercentage;
import gov.va.med.esr.common.persistent.financials.RelaxationPercentageDAO;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.service.RelaxationPercentageService;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.batchprocess.BatchProcessDetail;
import gov.va.med.fw.batchprocess.BatchProcessInvoker;
import gov.va.med.fw.batchprocess.BatchProcessService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.scheduling.SchedulingService;
import gov.va.med.fw.security.LoginManager;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class RelaxationPercentageServiceImpl
extends AbstractComponent
implements RelaxationPercentageService {
    private static final long serialVersionUID = 6530216441579427869L;
    private static final String ERROR_MESSAGE_NEW_VAL_LESS_THAN_OLD = "errors.relaxationPercentage.newValueLessThanOldValue";
    private static final String ERROR_MESSAGE_NEW_VAL_LESS_THAN_CURRENT_INCOME_YEAR = "errors.relaxationPercentage.newValueLessThanCurrentYear";
    private RelaxationPercentageDAO relaxationPercentageDAO;
    private LoginManager loginManager;
    private HistoryDAO historyDAO = null;
    private BatchProcessInvoker invoker;
    private SchedulingService schedulingService;
    private BatchProcessService batchProcessService;

    @Override
    public RelaxationPercentage getRelaxationPercentageByIncomeYear(int incomeYear) throws ServiceException {
        try {
            return this.relaxationPercentageDAO.getRelaxationPercentageByIncomeYear(incomeYear);
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public List getAllRelaxationPercentages() {
        return this.relaxationPercentageDAO.findAll();
    }

    @Override
    public void addRelaxationPercentage(BigDecimal value) throws ServiceException {
        int currentYear = Calendar.getInstance().get(1);
        RelaxationPercentage rp = null;
        try {
            rp = this.relaxationPercentageDAO.getRelaxationPercentageByIncomeYear(currentYear);
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
        if (rp != null) {
            throw new ValidationServiceException("A " + RelaxationPercentage.class.getName() + " was already defined with the income year = " + currentYear);
        }
        try {
            rp = this.relaxationPercentageDAO.getRelaxationPercentageByIncomeYear(currentYear - 1);
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
        if (value.compareTo(rp.getValue()) == -1) {
            ValidationMessages validationMessages = new ValidationMessages();
            validationMessages.add(new ValidationMessage(ERROR_MESSAGE_NEW_VAL_LESS_THAN_CURRENT_INCOME_YEAR));
            throw new ValidationServiceException(validationMessages);
        }
        RelaxationPercentage newRp = new RelaxationPercentage(value, currentYear);
        try {
            this.relaxationPercentageDAO.saveObject((Object)newRp);
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void updateRelaxationPercentage(int incomeYear, BigDecimal value, boolean retroactiveProcess, BatchProcessDetail batchProcessDetail) throws ServiceException {
        RelaxationPercentage rp = null;
        try {
            rp = this.relaxationPercentageDAO.getRelaxationPercentageByIncomeYear(incomeYear);
        }
        catch (DAOException e) {
            throw new ServiceException((Throwable)e);
        }
        if (rp == null) {
            throw new ServiceException("No " + RelaxationPercentage.class.getName() + " was defined with the income year = " + incomeYear);
        }
        if (value.compareTo(rp.getValue()) == -1) {
            ValidationMessages validationMessages = new ValidationMessages();
            validationMessages.add(new ValidationMessage(ERROR_MESSAGE_NEW_VAL_LESS_THAN_OLD));
            throw new ValidationServiceException(validationMessages);
        }
        for (int updateIncomeYear = incomeYear; rp != null && updateIncomeYear < incomeYear + 50; ++updateIncomeYear) {
            rp.setValue(value);
            try {
                this.relaxationPercentageDAO.saveObject((Object)rp);
                rp = this.relaxationPercentageDAO.getRelaxationPercentageByIncomeYear(updateIncomeYear);
                continue;
            }
            catch (DAOException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        if (retroactiveProcess) {
            Object[] invocationArgs = new String[]{new Integer(incomeYear).toString()};
            this.invoker.invokeBatchProcessWithEvent(batchProcessDetail, invocationArgs);
        }
    }

    @Override
    public Set getRelaxationPercentageHistoryChangeTimes() throws ServiceException {
        try {
            return this.historyDAO.getHistoryChangeTimes(null);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getRelaxationPercentageHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.historyDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.relaxationPercentageDAO);
        Validate.notNull((Object)this.loginManager);
        Validate.notNull((Object)this.historyDAO);
    }

    public void setRelaxationPercentageDAO(RelaxationPercentageDAO relaxationPercentageDAO) {
        this.relaxationPercentageDAO = relaxationPercentageDAO;
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    public void setHistoryDAO(HistoryDAO historyDAO) {
        this.historyDAO = historyDAO;
    }

    public BatchProcessService getBatchProcessService() {
        return this.batchProcessService;
    }

    public void setBatchProcessService(BatchProcessService batchProcessService) {
        this.batchProcessService = batchProcessService;
    }

    public BatchProcessInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(BatchProcessInvoker invoker) {
        this.invoker = invoker;
    }

    public SchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    public void setSchedulingService(SchedulingService schedulingService) {
        this.schedulingService = schedulingService;
    }
}

