/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.SHADDocument;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PersonLockedReason;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryLoadStatistics;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.common.persistent.registry.RegistryDAO;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.LoadRegistryResult;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.RegistrySearchCriteria;
import gov.va.med.esr.service.RegistrySearchResultBean;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.esr.service.impl.AbstractHistoricalInfoServiceImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.VersionedEntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.service.MultipleRecordsFoundException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.ServiceOptimisticLockException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class RegistryServiceImpl
extends AbstractHistoricalInfoServiceImpl
implements RegistryService {
    private static final long serialVersionUID = 2120843322370727312L;
    private static final String VETERAN_ALREADY_HAS_REGISTRY_DATA = "VETERAN_ALREADY_HAS_REGISTRY_DATA";
    private static final String MULTIPLE_PERSON_RECORDS_FOUND = "MULTIPLE_PERSON_RECORDS_FOUND";
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    private String eligibilityEnrollmentServiceName = null;
    private RegistryDAO registryDAO;
    private Map historyDAOs;
    private TriggerRouter triggerRouter;

    @Override
    public Registry getRegistryById(EntityKey entityKey, RegistryType registryType) throws ServiceException {
        try {
            Integer incomingVersion;
            Registry onFileRegistry = this.registryDAO.getById(entityKey, registryType);
            Integer n = incomingVersion = entityKey instanceof VersionedEntityKey ? ((VersionedEntityKey)entityKey).getVersion() : null;
            if (onFileRegistry != null && incomingVersion != null && !incomingVersion.equals(onFileRegistry.getVersion())) {
                throw new ServiceOptimisticLockException("Version number specified in EntityKey does not match on file Registry", null, (AbstractKeyedEntity)onFileRegistry);
            }
            return onFileRegistry;
        }
        catch (DAOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    @Override
    public List search(SearchQueryInfo searchCriteria) throws ServiceException {
        List list = null;
        try {
            list = this.registryDAO.find(searchCriteria);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get the Registry matching the criteria", (Throwable)ex);
        }
        return list;
    }

    @Override
    public void updateRegistry(Registry registry) throws ServiceException {
        Validate.notNull((Object)((Object)registry), (String)"Registry cannot be null");
        Validate.notNull((Object)((Object)registry.getRegistryTrait()), (String)"RegistryTrait() cannot be null");
        try {
            EntityKey registryKey = registry.getEntityKey();
            RegistryType registryType = registry.getRegistryTrait().getRegistryType();
            Registry registryOnFile = null;
            if (registryKey != null) {
                registryOnFile = this.getRegistryById(registry.getEntityKey(), registryType);
                this.ensureEntityChanged((AbstractEntity)registry, (AbstractEntity)registryOnFile);
            } else {
                RegistryTrait onFileTrait = this.registryDAO.getRegistryTrait(registry);
                if (onFileTrait == null) {
                    registryOnFile = this.createNewRegistry(registryType);
                } else {
                    ValidationMessages messages = new ValidationMessages();
                    ValidationMessage msg = new ValidationMessage(VETERAN_ALREADY_HAS_REGISTRY_DATA, (Object)registryType.getDescription());
                    messages.add(msg);
                    throw new ValidationServiceException(messages);
                }
            }
            registryOnFile = this.getRegistryRuleService().manageRegistry(registry, registryOnFile);
            Person person = null;
            try {
                if (registryOnFile.getPerson() == null && (person = this.findMatchingPerson(registryOnFile)) != null) {
                    ValidationMessages messages = new ValidationMessages();
                    ValidationMessage msg = new ValidationMessage(VETERAN_ALREADY_HAS_REGISTRY_DATA, (Object)registryType.getDescription());
                    messages.add(msg);
                    throw new ValidationServiceException(messages);
                }
            }
            catch (MultipleRecordsFoundException ex) {
                ValidationMessages messages = new ValidationMessages();
                ValidationMessage msg = new ValidationMessage(MULTIPLE_PERSON_RECORDS_FOUND, (Object)registryType.getDescription());
                messages.add(msg);
                throw new ValidationServiceException(messages);
            }
            Person personOnFile = registryOnFile.getPerson();
            if (personOnFile != null) {
                personOnFile = this.getEligibilityEnrollmentService().assessEEImpact(personOnFile, false);
                this.getPersonService().save(personOnFile);
            } else {
                this.registryDAO.save(registryOnFile);
            }
        }
        catch (DAOException ex) {
            throw new ServiceException((Throwable)ex);
        }
    }

    @Override
    public LoadRegistryResult processRegistry(Registry registry) throws ServiceException {
        Validate.notNull((Object)((Object)registry), (String)"Registry cannot be null");
        Validate.notNull((Object)((Object)registry.getRegistryTrait()), (String)"RegistryTrait() cannot be null");
        LoadRegistryResult loadRegistryResult = new LoadRegistryResult();
        try {
            boolean exactMatch = false;
            boolean exactMatchSameEpisode = false;
            boolean ambiguousMatch = false;
            boolean exactMatchDifferentEpisode = false;
            Registry registryOnFile = this.findExactMatch(registry);
            if (registryOnFile == null) {
                RegistryType registryType = registry.getRegistryTrait().getRegistryType();
                registryOnFile = this.createNewRegistry(registryType);
            } else {
                exactMatch = true;
                if (this.isSameEpisodeMatch(registry, registryOnFile)) {
                    exactMatchSameEpisode = true;
                } else {
                    exactMatchDifferentEpisode = true;
                }
            }
            ambiguousMatch = this.isAmbiguousMatch(registry);
            loadRegistryResult.setAmbiguousMatch(ambiguousMatch);
            loadRegistryResult.setExactMatch(exactMatch);
            loadRegistryResult.setExactMatchSameEpisode(exactMatchSameEpisode);
            loadRegistryResult.setExactMatchDifferentEpisode(exactMatchDifferentEpisode);
            registryOnFile = this.getRegistryRuleService().processRegistry(registry, registryOnFile, loadRegistryResult);
            if (exactMatchDifferentEpisode || !ambiguousMatch && loadRegistryResult.isNewRegistry()) {
                try {
                    Person personOnFile;
                    if (registryOnFile.getPerson() == null) {
                        Person person = this.findMatchingPerson(registryOnFile);
                        if (person != null) {
                            RegistryType registryType = registry.getRegistryTrait().getRegistryType();
                            if (registryType.isPurpleHeart()) {
                                person.setPurpleHeart((PurpleHeart)registryOnFile);
                            } else if (registryType.isPrisonerOfWar()) {
                                person.setPrisonerOfWar((PrisonerOfWar)registryOnFile);
                            } else if (registryType.isSHAD()) {
                                person.setShad((SHAD)registryOnFile);
                            }
                        } else {
                            loadRegistryResult.setExceptionType((ReportExceptionType)this.getLookupService().getByCode(ReportExceptionType.class, ReportExceptionType.P1));
                        }
                    }
                    if ((personOnFile = registryOnFile.getPerson()) != null) {
                        personOnFile = this.getEligibilityEnrollmentService().assessEEImpact(personOnFile, false);
                        this.getPersonService().save(personOnFile);
                        this.getTriggerRouter().processTriggerEvent(this.getTriggerEvent(personOnFile.getPersonEntityKey()));
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Triggering ORUZ11 message for person ID " + registry.getPerson().getPersonEntityKey().getKeyValue() + " in " + this.getBeanName()));
                        }
                    } else {
                        this.registryDAO.save(registryOnFile);
                    }
                }
                catch (MultipleRecordsFoundException ex) {
                    loadRegistryResult.setExceptionType((ReportExceptionType)this.getLookupService().getByCode(ReportExceptionType.class, ReportExceptionType.P2));
                    loadRegistryResult.setNewRegistry(false);
                    loadRegistryResult.setExactMatchDifferentEpisode(false);
                }
            }
            loadRegistryResult.setResultRegistry(registryOnFile);
        }
        catch (DAOException ex) {
            throw new ServiceException((Throwable)ex);
        }
        return loadRegistryResult;
    }

    @Override
    public RegistryLoadStatistics getMostRecentRegistrySummaryByType(RegistryType registryType) throws ServiceException {
        try {
            return this.getRegistryDAO().getMostRecentRegistrySummaryByType(registryType);
        }
        catch (DAOException e) {
            throw new ServiceException("Could not rerieve MostRecentRegistrySummary By Registry Type " + registryType.getCode());
        }
    }

    private Registry createNewRegistry(RegistryType registryType) {
        Registry registry = null;
        if (StringUtils.equals((String)registryType.getCode(), (String)RegistryType.CODE_PH_REGISTRY.getCode())) {
            registry = new PurpleHeart();
        } else if (StringUtils.equals((String)registryType.getCode(), (String)RegistryType.CODE_POW_REGISTRY.getCode())) {
            registry = new PrisonerOfWar();
        } else if (StringUtils.equals((String)registryType.getCode(), (String)RegistryType.CODE_SHAD_REGISTRY.getCode())) {
            registry = new SHAD();
        }
        if (registry != null) {
            registry.setRegistryTrait(new RegistryTrait());
        }
        return registry;
    }

    private Registry findExactMatch(Registry registry) throws ServiceException, DAOException {
        Registry exactMatch = null;
        RegistrySearchCriteria queryCriteria = new RegistrySearchCriteria();
        if (registry.getRegistryTrait() != null) {
            if (StringUtils.equals((String)registry.getRegistryTrait().getRegistryType().getCode(), (String)RegistryType.CODE_POW_REGISTRY.getCode())) {
                PrisonerOfWar pow = (PrisonerOfWar)registry;
                exactMatch = this.getRegistryDAO().getPOWRegistryByIcn(pow.getIcn());
            }
            if (exactMatch == null) {
                queryCriteria.setSsn(registry.getRegistryTrait().getSsn());
                queryCriteria.setLastName(registry.getRegistryTrait().getLastName());
                queryCriteria.setFirstName(registry.getRegistryTrait().getFirstName());
                queryCriteria.setRegistryType(registry.getRegistryTrait().getRegistryType());
                exactMatch = this.getRegistryFromQueryCriteria(queryCriteria);
            }
            if (exactMatch == null) {
                queryCriteria.setSsn(registry.getRegistryTrait().getSsn());
                queryCriteria.setLastName(registry.getRegistryTrait().getLastName());
                queryCriteria.setRegistryType(registry.getRegistryTrait().getRegistryType());
                exactMatch = this.getRegistryFromQueryCriteria(queryCriteria);
            }
            if (exactMatch == null) {
                queryCriteria.setSsn(registry.getRegistryTrait().getSsn());
                queryCriteria.setFirstName(registry.getRegistryTrait().getFirstName());
                queryCriteria.setRegistryType(registry.getRegistryTrait().getRegistryType());
                exactMatch = this.getRegistryFromQueryCriteria(queryCriteria);
            }
        }
        return exactMatch;
    }

    private Registry getRegistryFromQueryCriteria(RegistrySearchCriteria queryCriteria) throws MaxRecordsExceededException, DAOException {
        Registry exactMatch = null;
        List matchedregistryData = this.registryDAO.find(queryCriteria);
        if (matchedregistryData != null & matchedregistryData.size() == 1) {
            RegistrySearchResultBean searchResult = (RegistrySearchResultBean)matchedregistryData.iterator().next();
            exactMatch = this.getRegistryDAO().getById(searchResult.getEntityKey(), searchResult.getRegistryType());
        }
        return exactMatch;
    }

    private boolean isAmbiguousMatch(Registry incomingRegistry) throws ServiceException, DAOException {
        if (incomingRegistry == null) {
            return false;
        }
        boolean isAmbiguousMatch = false;
        List matchedregistryData = null;
        if (incomingRegistry.getRegistryTrait() != null && !StringUtils.isEmpty((String)incomingRegistry.getRegistryTrait().getSsn())) {
            RegistrySearchCriteria queryCriteria = new RegistrySearchCriteria();
            queryCriteria.setSsn(incomingRegistry.getRegistryTrait().getSsn());
            queryCriteria.setRegistryType(incomingRegistry.getRegistryTrait().getRegistryType());
            matchedregistryData = this.registryDAO.find(queryCriteria);
        }
        RegistryTrait incomingRegistryTrait = incomingRegistry.getRegistryTrait();
        if (matchedregistryData != null && !matchedregistryData.isEmpty()) {
            for (RegistrySearchResultBean searchResult : matchedregistryData) {
                Registry matchedRegistry = this.getRegistryDAO().getById(searchResult.getEntityKey(), searchResult.getRegistryType());
                RegistryTrait matchedRegistryTrait = matchedRegistry.getRegistryTrait();
                if (this.isNameEqual(matchedRegistryTrait.getLastName(), incomingRegistryTrait.getLastName()) || this.isNameEqual(matchedRegistryTrait.getFirstName(), incomingRegistryTrait.getFirstName()) || matchedRegistryTrait.getDeathDate() != null && incomingRegistry != null && matchedRegistryTrait.getDeathDate().equals((Object)incomingRegistryTrait.getDeathDate())) continue;
                isAmbiguousMatch = true;
                break;
            }
        }
        return isAmbiguousMatch;
    }

    private boolean isNameEqual(String trait1, String trait2) {
        return trait1 != null && trait2 != null && StringUtils.equalsIgnoreCase((String)trait1, (String)trait2);
    }

    private boolean isSameEpisodeMatch(Registry incoming, Registry onFile) {
        boolean isSameEpisodeMatch = false;
        if (incoming.getRegistryTrait() != null) {
            RegistryType registryType = incoming.getRegistryTrait().getRegistryType();
            if (StringUtils.equals((String)registryType.getCode(), (String)RegistryType.CODE_PH_REGISTRY.getCode())) {
                isSameEpisodeMatch = this.isPurpleHeartDocumentMatch(incoming, onFile);
            } else if (StringUtils.equals((String)registryType.getCode(), (String)RegistryType.CODE_POW_REGISTRY.getCode())) {
                isSameEpisodeMatch = this.isPrisonerOfWarEpisodeMatch(incoming, onFile);
            } else if (StringUtils.equals((String)registryType.getCode(), (String)RegistryType.CODE_SHAD_REGISTRY.getCode())) {
                isSameEpisodeMatch = this.isSHADDocumentMatch(incoming, onFile);
            }
        }
        return isSameEpisodeMatch;
    }

    private boolean isSHADDocumentMatch(Registry incoming, Registry onFile) {
        SHADDocument episode;
        boolean isSameEpisodeMatch = false;
        SHAD incomingRegistry = (SHAD)incoming;
        SHAD onFileRegistry = (SHAD)onFile;
        SHADDocument sHADDocument = episode = incomingRegistry.getDocuments() == null || incomingRegistry.getDocuments().isEmpty() ? null : (SHADDocument)((Object)incomingRegistry.getDocuments().iterator().next());
        if (onFileRegistry.getDocuments() != null && !onFileRegistry.getDocuments().isEmpty()) {
            for (SHADDocument currrentDocument : onFileRegistry.getDocuments()) {
                if (!this.getMergeRuleService().getMatchRuleService().match((AbstractEntity)episode, (AbstractEntity)currrentDocument)) continue;
                isSameEpisodeMatch = true;
                break;
            }
        }
        return isSameEpisodeMatch;
    }

    private boolean isPrisonerOfWarEpisodeMatch(Registry incoming, Registry onFile) {
        POWEpisode episode;
        boolean isSameEpisodeMatch = false;
        PrisonerOfWar incomingRegistry = (PrisonerOfWar)incoming;
        PrisonerOfWar onFileRegistry = (PrisonerOfWar)onFile;
        POWEpisode pOWEpisode = episode = incomingRegistry.getEpisodes() == null || incomingRegistry.getEpisodes().isEmpty() ? null : (POWEpisode)((Object)incomingRegistry.getEpisodes().iterator().next());
        if (onFileRegistry.getEpisodes() != null && !onFileRegistry.getEpisodes().isEmpty()) {
            for (POWEpisode currrentDocument : onFileRegistry.getEpisodes()) {
                if (!this.getMergeRuleService().getMatchRuleService().match((AbstractEntity)episode, (AbstractEntity)currrentDocument)) continue;
                isSameEpisodeMatch = true;
                break;
            }
        }
        return isSameEpisodeMatch;
    }

    private boolean isPurpleHeartDocumentMatch(Registry incoming, Registry onFile) {
        PurpleHeartDocument episode;
        boolean isSameEpisodeMatch = false;
        PurpleHeart incomingRegistry = (PurpleHeart)incoming;
        PurpleHeart onFileRegistry = (PurpleHeart)onFile;
        PurpleHeartDocument purpleHeartDocument = episode = incomingRegistry.getDocuments() == null || incomingRegistry.getDocuments().isEmpty() ? null : (PurpleHeartDocument)incomingRegistry.getDocuments().iterator().next();
        if (onFileRegistry.getDocuments() != null && !onFileRegistry.getDocuments().isEmpty()) {
            for (PurpleHeartDocument currrentDocument : onFileRegistry.getDocuments()) {
                if (!this.getMergeRuleService().getMatchRuleService().match((AbstractEntity)episode, (AbstractEntity)currrentDocument)) continue;
                isSameEpisodeMatch = true;
                break;
            }
        }
        return isSameEpisodeMatch;
    }

    private Person findMatchingPerson(Registry registry) throws ServiceException {
        RegistryTrait trait = registry.getRegistryTrait();
        PersonIdentityTraits personIdentityTraits = new PersonIdentityTraits();
        if (trait.getSsn() != null) {
            SSN ssn = new SSN();
            ssn.setSsnText(trait.getSsn());
            personIdentityTraits.setSsn(ssn);
        }
        if (trait.getLastName() != null || trait.getFirstName() != null) {
            Name name = new Name();
            name.setFamilyName(trait.getLastName());
            name.setGivenName(trait.getFirstName());
            name.setType(this.getLookupService().getNameTypeByCode(NameType.LEGAL_NAME.getCode()));
            personIdentityTraits.addName(name);
        }
        try {
            Set identityTraits = this.getPsDelegateService().attendedSearch(personIdentityTraits, false);
            if (identityTraits != null) {
                if (identityTraits.size() == 1) {
                    PersonIdentityTraits piTraits = (PersonIdentityTraits)((Object)identityTraits.iterator().next());
                    Person person = this.getPersonService().find(piTraits);
                    this.getPersonService().checkAndAddESRCorrelation(person);
                    PersonLockedReason lockedReason = person.getPersonLockedReason();
                    if (person != null && (lockedReason == null || lockedReason != null && !PersonLockedReason.PERSON_NO_ENROLLMENT_DETERMINATION.getReason().equals(lockedReason.getReason()))) {
                        return person;
                    }
                } else if (identityTraits.size() > 1) {
                    throw new MultipleRecordsFoundException("Multiple person records found for Registry criteria ");
                }
            }
        }
        catch (MaxRecordsExceededException maxEx) {
            throw new MultipleRecordsFoundException("Multiple person records found for Registry criteria", (Exception)((Object)maxEx));
        }
        return null;
    }

    @Override
    public Set getHistoryChangeTimes(EntityKey entityKey) throws ServiceException {
        try {
            HistoryDAO historyDAO = this.getHistoryDAO(entityKey.getEntityClass().getName());
            return historyDAO.getHistoryChangeTimes(entityKey);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            HistoryDAO historyDAO = this.getHistoryDAO(event.getEntityKey().getEntityClass().getName());
            return historyDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Registry getMatchingRegistry(RegistrySearchCriteria registrySearchCriteria) throws ServiceException {
        Registry registry = null;
        List registryData = this.search(registrySearchCriteria);
        if (registryData != null && registryData.size() == 1) {
            RegistrySearchResultBean searchResult = (RegistrySearchResultBean)registryData.get(0);
            registry = this.getRegistryById(searchResult.getEntityKey(), searchResult.getRegistryType());
        } else if (registryData != null && registryData.size() > 1) {
            throw new ServiceException("More than one matching record found for the given registry search creiteria.");
        }
        return registry;
    }

    @Override
    public RegistrySearchCriteria getRegistrySearchCriteria(Person person, String registryType) throws ServiceException {
        RegistrySearchCriteria query = new RegistrySearchCriteria();
        SSN ssn = person.getOfficialSsn();
        query.setSsn(ssn != null ? ssn.getFormattedSsnText() : null);
        Name name = person.getLegalName();
        if (name != null) {
            query.setLastName(name.getFamilyName());
            query.setFirstName(name.getGivenName());
        }
        query.setRegistryType((RegistryType)this.getLookupService().getByCode(RegistryType.class, registryType));
        return query;
    }

    @Override
    public void linkPersonRegistry(Registry incoming, Registry onFile, Person incomingPerson, Person onFilePerson, RegistryType registryType, boolean isFromUI) throws ServiceException {
        this.getRegistryRuleService().linkPersonRegistry(incoming, onFile, incomingPerson, onFilePerson, registryType, isFromUI);
    }

    @Override
    public void linkPersonRegistries(Person incoming, Person onFile, boolean isFromUI) throws ServiceException {
        if (onFile == null) {
            return;
        }
        RegistryType phRegType = this.getRegistryType(RegistryType.CODE_PH_REGISTRY.getCode());
        this.linkPersonRegistry(incoming.getPurpleHeart(), onFile.getPurpleHeart(), incoming, onFile, phRegType, isFromUI);
        RegistryType powRegType = this.getRegistryType(RegistryType.CODE_POW_REGISTRY.getCode());
        this.linkPersonRegistry(incoming.getPrisonerOfWar(), onFile.getPrisonerOfWar(), incoming, onFile, powRegType, isFromUI);
        RegistryType shadRegType = this.getRegistryType(RegistryType.CODE_SHAD_REGISTRY.getCode());
        this.linkPersonRegistry(incoming.getShad(), onFile.getShad(), incoming, onFile, shadRegType, isFromUI);
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() throws ServiceException {
        if (this.eligibilityEnrollmentService == null) {
            this.eligibilityEnrollmentService = this.eligibilityEnrollmentServiceName != null ? (EligibilityEnrollmentService)this.getComponent(this.eligibilityEnrollmentServiceName) : null;
        }
        return this.eligibilityEnrollmentService;
    }

    public String getEligibilityEnrollmentServiceName() {
        return this.eligibilityEnrollmentServiceName;
    }

    public void setEligibilityEnrollmentServiceName(String eligibilityEnrollmentServiceName) {
        this.eligibilityEnrollmentServiceName = eligibilityEnrollmentServiceName;
    }

    public RegistryDAO getRegistryDAO() {
        return this.registryDAO;
    }

    public void setRegistryDAO(RegistryDAO registryDAO) {
        this.registryDAO = registryDAO;
    }

    public Map getHistoryDAOs() {
        return this.historyDAOs;
    }

    public void setHistoryDAOs(Map historyDAOs) {
        this.historyDAOs = historyDAOs;
    }

    private HistoryDAO getHistoryDAO(String entityClassName) {
        return (HistoryDAO)this.getHistoryDAOs().get(entityClassName);
    }

    private RegistryType getRegistryType(String registryType) throws ServiceException {
        return (RegistryType)this.getLookupService().getByCode(RegistryType.class, registryType);
    }

    private TriggerEvent getTriggerEvent(PersonEntityKey key) {
        PersonTriggerEvent triggerEvent = new PersonTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.NOTIFY, PersonTrigger.DataType.ELIGIBILITY);
        triggerEvent.setPersonId(key);
        return triggerEvent;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }
}

