/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.persistent.lookup.LookupsDAO;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.service.AbstractComponent;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class PreloadLookupDataServiceImpl
extends AbstractComponent
implements Runnable {
    private Map daoMap = null;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.daoMap, (String)"Missing required lookup dao map");
    }

    @Override
    public void run() {
        for (Object key : this.daoMap.keySet()) {
            Object value = this.daoMap.get(key);
            if (!(value instanceof LookupsDAO)) continue;
            try {
                Class<?> lookupClass = Class.forName(key.toString());
                List lookupList = ((LookupsDAO)value).findAll(lookupClass);
                for (Object obj : lookupList) {
                    if (!(obj instanceof AbstractLookup)) continue;
                    ((LookupsDAO)value).getByCode(lookupClass, ((AbstractLookup)obj).getCode());
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to preload data for " + key), (Throwable)e);
            }
        }
    }

    public Map getDaoMap() {
        return this.daoMap;
    }

    public void setDaoMap(Map daoMap) {
        this.daoMap = daoMap;
    }
}

