/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.MilitaryInfoProcessor;
import gov.va.med.esr.service.MilitaryInfoService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.trigger.ProcessTriggerEvent;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.util.InvalidConfigurationException;

public class MilitaryInfoProcessorImpl
extends AbstractComponent
implements MilitaryInfoProcessor {
    private static final long serialVersionUID = -4721117129644782023L;
    public static final String HEC_RECORD_CREATE_AUDIT_ID = "HecRecordProcess";
    private PersonService personService = null;
    private MilitaryInfoService militaryService = null;

    @Override
    public void processHecRecordTrigger(TriggerEvent triggerEvent) throws ServiceException {
        ProcessTriggerEvent event = (ProcessTriggerEvent)triggerEvent;
        SecurityContextHelper.getSecurityContext().setLogicalName(HEC_RECORD_CREATE_AUDIT_ID);
        Person person = this.getPerson(event);
        this.getMilitaryService().processSeeding(person);
        this.getMilitaryService().processMSDSLogicForCLV(person);
    }

    private Person getPerson(ProcessTriggerEvent triggerEvent) throws ServiceException {
        try {
            Person person = null;
            PersonEntityKey key = triggerEvent.getPersonId();
            if (key != null) {
                person = this.getPersonService().getPerson(key);
            }
            return person;
        }
        catch (ServiceException e) {
            throw new ServiceException("Error retrieving a person from the ProcessTriggerEvent", (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        if (this.personService == null) {
            throw new InvalidConfigurationException("personService must be set on " + this.getClass().getName());
        }
        if (this.militaryService == null) {
            throw new InvalidConfigurationException("militaryInfoService must be set on " + this.getClass().getName());
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public MilitaryInfoService getMilitaryService() {
        return this.militaryService;
    }

    public void setMilitaryService(MilitaryInfoService militaryService) {
        this.militaryService = militaryService;
    }
}

