/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.messaging.ArchivedMessageLogEntry;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.messaging.xml.XmlFormatter;
import gov.va.med.esr.service.MessageFormatterService;
import gov.va.med.fw.hl7.constants.SegmentConstants;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.util.builder.BuilderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageFormatterServiceImpl
implements MessageFormatterService {
    Map formatterMap = null;
    private static Log logger = LogFactory.getLog(MessageFormatterServiceImpl.class);

    public Map getFormatterMap() {
        return this.formatterMap;
    }

    public void setFormatterMap(Map formatterMap) {
        this.formatterMap = formatterMap;
    }

    @Override
    public String getFormattedMessage(MessageLogEntry message) throws BuilderException {
        XmlFormatter formatter = (XmlFormatter)((Object)this.formatterMap.get(message.getType().getCode()));
        String messageBody = message.getBody();
        String formattedMessage = null;
        String reformattedMessageBody = null;
        reformattedMessageBody = this.reformMessageBody(messageBody);
        if (messageBody != null) {
            formattedMessage = formatter.build(reformattedMessageBody);
        }
        return formattedMessage;
    }

    @Override
    public String getFormattedMessage(ArchivedMessageLogEntry message) throws BuilderException {
        XmlFormatter formatter = (XmlFormatter)((Object)this.formatterMap.get(message.getType().getCode()));
        String messageBody = message.getBody();
        String formattedMessage = null;
        String reformattedMessageBody = null;
        reformattedMessageBody = this.reformMessageBody(messageBody);
        if (messageBody != null) {
            formattedMessage = formatter.build(reformattedMessageBody);
        }
        return formattedMessage;
    }

    public String reformMessageBody(String messageBody) throws BuilderException {
        StringBuffer reformattedMessageBody = new StringBuffer();
        try {
            BufferedReader reader = new BufferedReader(new StringReader(messageBody));
            String currentLine = null;
            List<String> segmentsList = Arrays.asList(SegmentConstants.HL7_SEGMENTS_LIST);
            boolean isSegmentStarted = false;
            String workingSegment = null;
            while ((currentLine = reader.readLine()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Segment: " + currentLine));
                }
                if (StringUtils.trim((String)currentLine).length() >= 3 && segmentsList.contains(currentLine.subSequence(0, 3)) && !isSegmentStarted && currentLine.charAt(3) == '^') {
                    isSegmentStarted = true;
                    workingSegment = currentLine;
                    continue;
                }
                if (StringUtils.trim((String)currentLine).length() >= 3 && segmentsList.contains(currentLine.subSequence(0, 3)) && isSegmentStarted && currentLine.charAt(3) == '^') {
                    workingSegment = workingSegment + '\n';
                    reformattedMessageBody.append(workingSegment);
                    isSegmentStarted = true;
                    workingSegment = currentLine;
                    continue;
                }
                if (StringUtils.trim((String)currentLine).length() >= 3 && (segmentsList.contains(currentLine.subSequence(0, 3)) || !isSegmentStarted || currentLine.charAt(3) == '^')) continue;
                workingSegment = workingSegment + currentLine;
            }
            reformattedMessageBody.append(workingSegment + '\n');
        }
        catch (IOException e) {
            throw new BuilderException("Invalid message body to build:  " + messageBody + " " + e.getMessage(), (Throwable)e);
        }
        return reformattedMessageBody.toString();
    }
}

