/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.messaging.MsdsErrorLogEntry;
import gov.va.med.esr.common.model.messaging.MsdsMessageLogEntry;
import gov.va.med.esr.common.model.messaging.MsdsMessagePayloadEntry;
import gov.va.med.esr.common.persistent.messaging.MsdsErrorLogEntryDAO;
import gov.va.med.esr.common.persistent.messaging.MsdsMessageLogEntryDAO;
import gov.va.med.esr.common.persistent.messaging.MsdsMessagePayloadEntryDAO;
import gov.va.med.esr.service.LogTransmissionService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UniqueIdentifierGenerator;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import org.apache.commons.lang.Validate;

public class LogTransmissionServiceImpl
extends AbstractComponent
implements LogTransmissionService {
    private MsdsMessageLogEntryDAO msdsMessageLogEntryDAO = null;
    private MsdsMessagePayloadEntryDAO msdsMessagePayloadEntryDAO = null;
    private MsdsErrorLogEntryDAO msdsErrorLogEntryDAO = null;
    private LookupService lookupService = null;
    private UniqueIdentifierGenerator generator = null;
    private static final long serialVersionUID = 7440299997017245373L;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.msdsMessageLogEntryDAO, (String)"A msdsMessageLogEntry DAO must be configured");
        Validate.notNull((Object)this.lookupService, (String)"A lookup service must be configured");
    }

    public void setMsdsMessageLogEntryDAO(MsdsMessageLogEntryDAO msdsMessageLogEntryDAO) {
        this.msdsMessageLogEntryDAO = msdsMessageLogEntryDAO;
    }

    protected MsdsMessageLogEntryDAO getMsdsMessageLogEntryDAO() {
        return this.msdsMessageLogEntryDAO;
    }

    public void setMsdsMessagePayloadEntryDAO(MsdsMessagePayloadEntryDAO msdsMessagePayloadEntryDAO) {
        this.msdsMessagePayloadEntryDAO = msdsMessagePayloadEntryDAO;
    }

    protected MsdsMessagePayloadEntryDAO getMsdsMessagePayloadEntryDAO() {
        return this.msdsMessagePayloadEntryDAO;
    }

    public void setMsdsErrorLogEntryDAO(MsdsErrorLogEntryDAO msdsErrorLogEntryDAO) {
        this.msdsErrorLogEntryDAO = msdsErrorLogEntryDAO;
    }

    protected MsdsErrorLogEntryDAO getMsdsErrorLogEntryDAO() {
        return this.msdsErrorLogEntryDAO;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setGenerator(UniqueIdentifierGenerator generator) {
        this.generator = generator;
    }

    public UniqueIdentifierGenerator getGenerator() {
        return this.generator;
    }

    @Override
    public String generateControlIdentifier() throws ServiceException {
        return this.generator.generate().toString();
    }

    @Override
    public MsdsMessageLogEntry logMessage(MsdsMessageLogEntry entry) throws ServiceException {
        try {
            MsdsMessageLogEntry cachedEntry = null;
            if (entry.getEntityKey() == null) {
                EntityKey key = this.msdsMessageLogEntryDAO.insertObject((Object)entry);
                if (key != null) {
                    cachedEntry = (MsdsMessageLogEntry)((Object)this.msdsMessageLogEntryDAO.getByKey(key));
                }
            } else {
                cachedEntry = (MsdsMessageLogEntry)((Object)this.msdsMessageLogEntryDAO.getByKey(entry.getEntityKey()));
                this.msdsMessageLogEntryDAO.saveObject((Object)cachedEntry);
                this.msdsMessageLogEntryDAO.flush();
            }
            return cachedEntry;
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to log message ", (Throwable)ex);
        }
    }

    @Override
    public void logMessagePayload(MsdsMessageLogEntry entry, String request, String response) throws ServiceException {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("LogTransmissionServiceImpl logMessagePayload : entry: " + (Object)((Object)entry)));
            }
            if (entry != null && entry.getEntityKey() != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("LogTransmissionServiceImpl logMessagePayload : entry.getEntityKey(): " + entry.getEntityKey()));
                }
                MsdsMessagePayloadEntry cachedEntry = this.msdsMessagePayloadEntryDAO.find(entry);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("LogTransmissionServiceImpl logMessagePayload : cachedEntry found by entry: " + (Object)((Object)cachedEntry)));
                }
                if (cachedEntry == null) {
                    cachedEntry = new MsdsMessagePayloadEntry();
                    cachedEntry.setMsdsMessageLogId((BigDecimal)entry.getEntityKey().getKeyValue());
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("LogTransmissionServiceImpl logMessagePayload : new cachedEntry: " + (Object)((Object)cachedEntry)));
                    }
                }
                if (request != null) {
                    cachedEntry.setRequest(request);
                }
                if (response != null) {
                    cachedEntry.setResponse(response);
                }
                this.msdsMessagePayloadEntryDAO.saveObject((Object)cachedEntry);
                this.msdsMessagePayloadEntryDAO.flush();
            }
        }
        catch (Exception ex) {
            throw new ServiceException("Failed to log message payload ", (Throwable)ex);
        }
    }

    @Override
    public void logMessage(MsdsErrorLogEntry error) throws ServiceException {
        try {
            if (error.getEntityKey() == null) {
                this.msdsErrorLogEntryDAO.saveObject((Object)error);
            } else {
                MsdsMessageLogEntry cachedEntry = (MsdsMessageLogEntry)((Object)this.msdsErrorLogEntryDAO.getByKey(error.getEntityKey()));
                this.msdsErrorLogEntryDAO.saveObject((Object)cachedEntry);
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to log message ", (Throwable)ex);
        }
    }

    @Override
    public MsdsMessageLogEntry getMessageLogEntryById(BigDecimal id) throws ServiceException {
        MsdsMessageLogEntry mle = null;
        try {
            mle = this.msdsMessageLogEntryDAO.getById(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry by id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public MsdsMessageLogEntry getMessageLogEntry(BigDecimal id) throws ServiceException {
        MsdsMessageLogEntry mle = null;
        try {
            mle = this.msdsMessageLogEntryDAO.getByControlId(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry by id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public boolean findCountCompletion(EntityKey personId) throws ServiceException {
        try {
            Integer count = this.getMsdsMessageLogEntryDAO().findCompleteCount(personId);
            return count > 2;
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to Retrieve the Site that last trsmitted the Message", (Throwable)e);
        }
    }

    @Override
    public MsdsMessageLogEntry getClockEntry(EntityKey personId) throws ServiceException {
        MsdsMessageLogEntry mle = null;
        try {
            mle = this.getMsdsMessageLogEntryDAO().findClockSetEntry(personId);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry by id " + personId, (Throwable)e);
        }
        return mle;
    }
}

