/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.InsuranceService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class InsuranceServiceImpl
extends AbstractRuleAwareServiceImpl
implements InsuranceService {
    private static final long serialVersionUID = 1165939113034552584L;

    @Override
    public ValidationMessages updateInsurance(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person result = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)result);
        this.validateEnrollmentDetermination(result);
        Set policies = incoming.getInsurances();
        VAFacility hec = this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getCode());
        ValidationMessages messages = this.getInsuranceRuleService().manageInsurancePolicies(policies, result, hec);
        messages = this.prepareForAfterAdvice(incoming, messages);
        this.getPersonService().save(result);
        return messages;
    }

    private ValidationMessages prepareForAfterAdvice(Person incoming, ValidationMessages messages) {
        if (messages == null) {
            messages = new ValidationMessages();
        }
        incoming.setChangeEvent("INSURANCE", "INSURANCE");
        return messages;
    }
}

