/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.ee.HealthBenefitProfile;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.service.HealthBenefitPlanService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class HealthBenefitPlanServiceImpl
extends AbstractRuleAwareServiceImpl
implements HealthBenefitPlanService {
    private static final long serialVersionUID = 4204326579293875215L;
    private HistoryDAO healthBenefitPlanHistoryDAO = null;

    @Override
    public Set getHealthBenefitPlanHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.healthBenefitPlanHistoryDAO.getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getHealthBenefitPlanHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.healthBenefitPlanHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Person updateHealthBenefitPlan(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person result = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        Validate.notNull((Object)((Object)result), (String)"A veteran on file must not be null.");
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)result);
        this.validateEnrollmentDetermination(result);
        this.getEnrollmentRuleService().manageHealthBenefitProfile(incoming, result);
        this.getEventRuleService().manageMessageEvents(result);
        result = this.getPersonService().save(result);
        return result;
    }

    @Override
    public Person processHealthBenefitProfile(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        HealthBenefitProfile clonedHBP = (HealthBenefitProfile)((Object)incoming.getHealthBenefitProfile().clone());
        Person result = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        this.getEnrollmentRuleService().processHealthBenefitProfile(incoming, result);
        if (!AbstractEntity.matchesDomainValues((AbstractEntity)clonedHBP, (AbstractEntity)result.getHealthBenefitProfile())) {
            this.getEventRuleService().manageMessageEvents(result);
        }
        result = this.getPersonService().save(result);
        return result;
    }

    public HistoryDAO getHealthBenefitPlanHistoryDAO() {
        return this.healthBenefitPlanHistoryDAO;
    }

    public void setHealthBenefitPlanHistoryDAO(HistoryDAO healthBenefitPlanHistoryDAO) {
        this.healthBenefitPlanHistoryDAO = healthBenefitPlanHistoryDAO;
    }
}

