/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.GMTThreshold;
import gov.va.med.esr.common.model.financials.InProcessFinancialInfo;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeThreshold;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.persistent.history.FinancialsHistoryDAO;
import gov.va.med.esr.common.rule.service.impl.RuleValidationMessage;
import gov.va.med.esr.service.EEResultInfo;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.FinancialsHelperService;
import gov.va.med.esr.service.FinancialsService;
import gov.va.med.esr.service.IVMFinancialInfo;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.service.impl.AbstractHistoricalInfoServiceImpl;
import gov.va.med.esr.service.impl.FinancialsChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class FinancialsServiceImpl
extends AbstractHistoricalInfoServiceImpl
implements FinancialsService {
    private static final long serialVersionUID = -6546285562247192047L;
    private FinancialsHistoryDAO financialsHistoryDAO;
    private FinancialsHistoryDAO dependentHistoryDAO;
    private FinancialsHelperService financialsHelperService = null;
    private MessagingService messagingService = null;
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    private TriggerRouter triggerRouter = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.financialsHelperService, (String)"FinancialsHelperService is required");
        Validate.notNull((Object)this.messagingService, (String)"MessagingService is required");
        Validate.notNull((Object)this.triggerRouter, (String)"TriggerRouter is required");
        Validate.notNull((Object)this.eligibilityEnrollmentService, (String)"EligibilityEnrollmentService is required");
    }

    public FinancialsHelperService getFinancialsHelperService() {
        return this.financialsHelperService;
    }

    public void setFinancialsHelperService(FinancialsHelperService financialsHelperService) {
        this.financialsHelperService = financialsHelperService;
    }

    public FinancialsHistoryDAO getDependentHistoryDAO() {
        return this.dependentHistoryDAO;
    }

    public void setDependentHistoryDAO(FinancialsHistoryDAO dependentHistoryDAO) {
        this.dependentHistoryDAO = dependentHistoryDAO;
    }

    public FinancialsHistoryDAO getFinancialsHistoryDAO() {
        return this.financialsHistoryDAO;
    }

    public void setFinancialsHistoryDAO(FinancialsHistoryDAO financialsHistoryDAO) {
        this.financialsHistoryDAO = financialsHistoryDAO;
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    @Override
    public Person updateInProcess(Integer incomeYear, Person incoming) throws ServiceException {
        return this.updateInProcess(incomeYear, incoming, true);
    }

    @Override
    public Person convertOrReverseESRIncomeTest(Person incoming, IVMFinancialInfo ivmFinancialInfo) throws ServiceException {
        Validate.notNull((Object)ivmFinancialInfo, (String)"An IVM Financials Info object must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson(incoming.getPersonEntityKey());
        onFile = this.getFinancialInfoRuleService().processIVMFinancials(incoming, onFile, ivmFinancialInfo);
        this.getEligibilityEnrollmentService().assessEEImpact(onFile, true);
        this.getEventRuleService().processMessageEventsForIVM(onFile);
        this.getEventRuleService().manageHandBookEvents(onFile);
        onFile.setInProcessFinancial(ivmFinancialInfo.getIncomeYear(), null);
        this.getCommunicationRuleService().triggerAutomaticLetters(onFile, ivmFinancialInfo);
        return personService.save(onFile);
    }

    @Override
    public IncomeTest findConversionBaseTest(IncomeTest incomeTest) throws ServiceException {
        try {
            return this.getFinancialsHistoryDAO().findConversionBaseTest(incomeTest);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List getIncomeTestStatusesForIVMReversal(Serializable key) throws ServiceException {
        try {
            return this.getFinancialsHistoryDAO().getIncomeTestStatusesForIVMReversal(key);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Person updateInProcess(Integer incomeYear, Person incoming, boolean savePerson) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"A income year must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson(incoming.getPersonEntityKey());
        InProcessFinancialInfo inProcessFinancial = incoming.getInProcessFinancial(incomeYear);
        if (inProcessFinancial == null) {
            onFile.setInProcessFinancial(incomeYear, null);
        } else {
            this.validateFinancialsUpdate(incomeYear, onFile);
            InProcessFinancialInfo onFileInprocess = onFile.getInProcessFinancial(incomeYear);
            if (onFileInprocess != null) {
                onFileInprocess.setInProcessData(inProcessFinancial.getInProcessData());
            } else {
                onFileInprocess = new InProcessFinancialInfo();
                onFileInprocess.setIncomeYear(incomeYear);
                onFileInprocess.setInProcessData(inProcessFinancial.getInProcessData());
                onFile.setInProcessFinancial(incomeYear, onFileInprocess);
            }
        }
        if (savePerson) {
            return personService.save(onFile);
        }
        return onFile;
    }

    @Override
    public void validateFinancialsUpdate(Integer incomeYear, Person onFile) throws ServiceException {
        if (!this.canFinancialsBeAdded(incomeYear, onFile) && !this.canFinancialsBeUpdated(incomeYear, onFile)) {
            ValidationMessages validationMessages = new ValidationMessages();
            validationMessages.add(new ValidationMessage(RuleValidationMessage.INCOME_TEST_CANNOT_BE_ADDED_OR_EDITED.getCode()));
            throw new ValidationServiceException(validationMessages);
        }
    }

    @Override
    public Person updateFinancialAssessment(Integer incomeYear, Person incoming) throws ServiceException {
        PersonService personService = this.getPersonService();
        Person result = personService.getPerson(incoming.getPersonEntityKey());
        EEResultInfo info = new EEResultInfo();
        result = this.assessFinancialImpactImpl(incomeYear, incoming, result, info);
        this.getEligibilityEnrollmentService().assessEEImpact(result, false);
        this.getEventRuleService().handleCommonPostEvents(result, true, info.isZ10Sent());
        result.setInProcessFinancial(incomeYear, null);
        return personService.save(result);
    }

    @Override
    public Person assessFinancialImpact(Integer incomeYear, Person incoming) throws ServiceException {
        return this.assessFinancialImpactImpl(incomeYear, incoming, null, null);
    }

    public Person assessFinancialImpactImpl(Integer incomeYear, Person incoming, Person result, EEResultInfo info) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"A income year must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        PersonService personService = this.getPersonService();
        if (result == null) {
            result = personService.getPerson(incoming.getPersonEntityKey());
        }
        Person onFile = (Person)((Object)result.clone());
        this.validateEnrollmentDetermination(onFile);
        VAFacility hec = this.getHECFacility();
        result = this.getFinancialInfoRuleService().manageFinancialAssessment(incomeYear, hec, incoming, result, info);
        this.ensureEntityChanged((AbstractEntity)result, (AbstractEntity)onFile);
        return result;
    }

    @Override
    public Person updateSpouseFinancials(Integer incomeYear, SpouseFinancials spouseFinancials, Person incoming) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"An income year must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        this.validateInProcessFinancials(incomeYear, incoming);
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson(incoming.getPersonEntityKey());
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.validateEnrollmentDetermination(onFile);
        FinancialStatement stmt = incoming.getFinancialStatement(incomeYear);
        FinancialStatement onFileStmt = onFile.getFinancialStatement(incomeYear);
        if (spouseFinancials.getEntityKey() != null && stmt.getSpouseFinancialsByEntityKey(spouseFinancials.getEntityKey()) == null) {
            onFileStmt.removeSpouseFinancials(spouseFinancials);
        } else {
            onFile = this.getFinancialInfoRuleService().manageSpouseInfo(incomeYear, spouseFinancials, incoming, onFile);
        }
        this.getCommunicationRuleService().triggerAutomaticLetters(onFile, null, "S");
        return personService.save(onFile);
    }

    @Override
    public Person activateSpouse(Integer incomeYear, SpouseFinancials spouseFinancials, Person incoming) throws ServiceException {
        Spouse onFileSpouse;
        Validate.notNull((Object)incomeYear, (String)"An income year must not be null");
        Validate.notNull((Object)((Object)spouseFinancials), (String)"A spouse financials must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        this.validateInProcessFinancials(incomeYear, incoming);
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson(incoming.getPersonEntityKey());
        FinancialStatement onFileStmt = onFile.getFinancialStatement(incomeYear);
        SpouseFinancials onFileSpouseFinancials = onFileStmt.getSpouseFinancialsByEntityKey(spouseFinancials.getEntityKey());
        Spouse spouse = onFileSpouse = onFileSpouseFinancials != null ? onFileSpouseFinancials.getReportedOn() : null;
        if (onFileSpouse != null && onFileSpouse.getEndDate() != null) {
            onFileSpouse.setEndDate(null);
            onFile = personService.save(onFile);
        }
        return onFile;
    }

    @Override
    public Person updateDependentFinancials(Integer incomeYear, DependentFinancials dependentFinancials, Person incoming) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"An income year must not be null");
        Validate.notNull((Object)((Object)dependentFinancials), (String)"A dependent financial must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        this.validateInProcessFinancials(incomeYear, incoming);
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson(incoming.getPersonEntityKey());
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.validateEnrollmentDetermination(onFile);
        FinancialStatement stmt = incoming.getFinancialStatement(incomeYear);
        FinancialStatement onFileStmt = onFile.getFinancialStatement(incomeYear);
        if (dependentFinancials.getEntityKey() != null && stmt.getDependentFinancialsByEntityKey(dependentFinancials.getEntityKey()) == null) {
            onFileStmt.removeDependentFinancials(dependentFinancials);
        } else {
            onFile = this.getFinancialInfoRuleService().manageDependentFinancialInfo(incomeYear, dependentFinancials, incoming, onFile);
        }
        this.getCommunicationRuleService().triggerAutomaticLetters(onFile, null, "D");
        return personService.save(onFile);
    }

    @Override
    public Person updateDependents(Integer incomeYear, Person incoming) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"An income year must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        this.validateInProcessFinancials(incomeYear, incoming);
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson(incoming.getPersonEntityKey());
        this.validateEnrollmentDetermination(onFile);
        FinancialStatement stmt = incoming.getFinancialStatement(incomeYear);
        FinancialStatement onFileStmt = onFile.getFinancialStatement(incomeYear);
        if (stmt == null) {
            onFile.setFinancialStatement(incomeYear, null);
        } else {
            if (onFileStmt == null) {
                onFileStmt = new FinancialStatement();
                onFileStmt.setIncomeYear(incomeYear);
                onFile.setFinancialStatement(incomeYear, onFileStmt);
            }
            this.getMergeRuleService().mergeFinancialStatement(stmt, onFileStmt);
        }
        return this.getPersonService().save(onFile);
    }

    @Override
    public Person updatePendingAdjudicationStatus(Integer incomeYear, Person incoming, MeansTestStatus status) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"An income year must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Validate.notNull((Object)((Object)status), (String)"A new MeansTestStatus must not be null");
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson(incoming.getPersonEntityKey());
        this.validateEnrollmentDetermination(onFile);
        Validate.notNull((Object)((Object)onFile.getIncomeTest(incomeYear)), (String)"IncomeTest for adjudication can not be null");
        onFile = this.getFinancialInfoRuleService().managePendingAdjudicationStatus(incomeYear, incoming, onFile, status);
        this.getEligibilityEnrollmentService().assessEEImpact(onFile, false);
        this.getEventRuleService().handleCommonPostEvents(onFile, true);
        return personService.save(onFile);
    }

    protected void validateInProcessFinancials(Integer incomeYear, Person incoming) throws ValidationServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null.");
        if (incoming.getInProcessFinancial(incomeYear) != null) {
            ValidationMessages validationMessages = new ValidationMessages();
            validationMessages.add(new ValidationMessage(RuleValidationMessage.FINANCIALS_INPROCESS_STATE.getCode()));
            throw new ValidationServiceException(validationMessages);
        }
    }

    @Override
    public Person processFutureDatedTestFlag(PersonEntityKey personKey, Integer incomeYear) throws ServiceException {
        Validate.notNull((Object)personKey, (String)"A PersonKey must not be null");
        Validate.notNull((Object)incomeYear, (String)"An income year must not be null");
        PersonService personService = this.getPersonService();
        Person result = personService.getPerson(personKey);
        IncomeTest test = result.getIncomeTest(incomeYear);
        if (test != null && Boolean.TRUE.equals(test.getFutureTest())) {
            test.setFutureTest(Boolean.FALSE);
            this.getEnrollmentRuleService().calculateEEForExpireMTBatchJob(result, incomeYear);
            this.getEventRuleService().handleCommonPostEvents(result, false);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Future Dated test effective. E&E executed.");
            }
            IncomeYearTriggerEvent incomeYearTriggerEvent = IncomeYearTriggerEvent.notifyVistaForFinancial(incomeYear);
            incomeYearTriggerEvent.setPersonId(personKey);
            incomeYearTriggerEvent.setIdentityTraits(result != null ? result.getIdentityTraits() : null);
            this.getTriggerRouter().processTriggerEvent((TriggerEvent)incomeYearTriggerEvent);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Future Dated test effective. Z10 triggered.");
            }
            return personService.save(result);
        }
        return result;
    }

    @Override
    public GMTThreshold getGMTThreshold(Integer incomeYear, String zipCode) throws ServiceException {
        return this.getGMTThreshold(incomeYear, zipCode, 0);
    }

    @Override
    public GMTThreshold getGMTThreshold(Integer incomeYear, String zipCode, int extraDependents) throws ServiceException {
        String fipsCode = this.getLookupService().getFipsCode(zipCode);
        if (fipsCode == null) {
            throw new ServiceException("No fips code is located with a given zip code " + zipCode);
        }
        return this.getFinancialsHelperService().calculateGMTThresholds(incomeYear, fipsCode, extraDependents);
    }

    @Override
    public IncomeThreshold getIncomeThreshold(Integer incomeYear) throws ServiceException {
        return this.getIncomeThreshold(incomeYear, 0);
    }

    @Override
    public IncomeThreshold getIncomeThreshold(Integer incomeYear, int extraDependents) throws ServiceException {
        return this.getFinancialsHelperService().calculateIncomeThresholds(incomeYear, extraDependents);
    }

    @Override
    public boolean canFinancialsBeAdded(Integer incomeYear, Person person) throws ServiceException {
        return this.financialsHelperService.isAllowedtoAddMeansTest(person, incomeYear) || this.financialsHelperService.isAllowedtoAddPharmacyCopayTest(person, incomeYear) || this.financialsHelperService.isAllowedtoAddTest(person, incomeYear);
    }

    @Override
    public boolean canFinancialsBeUpdated(Integer incomeYear, Person person) throws ServiceException {
        return this.financialsHelperService.isAllowedtoEditTest(person, incomeYear);
    }

    @Override
    public boolean canNetWorthBeUpdated(Integer incomeYear, Person person) throws ServiceException {
        return this.financialsHelperService.isAllowedtoEditNetWorth(person, incomeYear);
    }

    @Override
    public Person getHistoricalFeeBasisInfo(EntityKey key) throws ServiceException {
        return null;
    }

    @Override
    public Set getFinancialAssessmentHistoryChangeTimes(EntityKey entityKey, Integer incomeYear) throws ServiceException {
        try {
            return this.financialsHistoryDAO.getHistoryChangeTimes(entityKey, incomeYear);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getFinancialAssessmentHistoryByChangeTime(FinancialsChangeEvent changeEvent) throws ServiceException {
        try {
            return this.financialsHistoryDAO.getHistoryByChangeTime(changeEvent);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set getDependentHistoryChangeTimes(EntityKey entityKey, Integer incomeYear) throws ServiceException {
        try {
            return this.dependentHistoryDAO.getHistoryChangeTimes(entityKey, incomeYear);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getDependentHistoryByChangeTime(FinancialsChangeEvent changeEvent) throws ServiceException {
        try {
            return this.dependentHistoryDAO.getHistoryByChangeTime(changeEvent);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Person updatePersonSignature(Person incoming) throws ServiceException {
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson(incoming.getPersonEntityKey());
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.validateEnrollmentDetermination(onFile);
        Map dfns = this.getDfns(incoming, onFile);
        this.getFinancialInfoRuleService().managePersonSignatures(incoming.getSignatureImages(), onFile, dfns);
        return personService.save(onFile);
    }

    @Override
    public Person processPersonSignature(Person incoming) throws ServiceException {
        PersonService personService = this.getPersonService();
        Person onFile = personService.getPerson(incoming.getPersonEntityKey());
        Map dfns = this.getDfns(incoming, onFile);
        this.getFinancialInfoRuleService().processPersonSignatures(incoming.getSignatureImages(), onFile, dfns);
        return personService.save(onFile);
    }

    private Map getDfns(Person incoming, Person onFile) throws ServiceException {
        HashMap<VAFacility, String> dfns = new HashMap<VAFacility, String>();
        Set images = incoming.getSignatureImages();
        for (SignatureImage si : images) {
            SiteIdentity siteIdentity;
            if (si.getSiteSubmittingImage() == null || (siteIdentity = this.getMessagingService().getIdentity(onFile, si.getSiteSubmittingImage())) == null || siteIdentity.getDfn() == null) continue;
            dfns.put(si.getSiteSubmittingImage(), siteIdentity.getDfn());
        }
        return dfns;
    }

    private VAFacility getHECFacility() throws UnknownLookupTypeException, UnknownLookupCodeException {
        return this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName());
    }
}

