/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.GMTThreshold;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.IncomeThreshold;
import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.model.lookup.PseudoSSNReason;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.rule.parameter.EmploymentInputParameter;
import gov.va.med.esr.common.rule.service.impl.RuleValidationMessage;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.service.FinancialsHelperService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.ScheduledTaskService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FinancialsHelperServiceImpl
extends AbstractComponent
implements FinancialsHelperService {
    protected Log logger = LogFactory.getLog(this.getClass());
    private static final String DEFAULT_DAY_MONTH_YEAR_VALUE = "00";
    private static final BigDecimal twentyPercent = new BigDecimal(0.2);
    private static final BigDecimal MEDICAL_DEDUCATION_PERCENT = new BigDecimal(0.05);
    public static final String[] mtNotRequiredPrimaryEligibilityCodes = new String[]{EligibilityType.AID_AND_ATTENDANCE.getName(), EligibilityType.HOUSEBOUND.getName(), EligibilityType.NSC_VA_PENSION.getName(), EligibilityType.PRISONER_OF_WAR.getName(), EligibilityType.PURPLE_HEART_RECIPIENT.getName(), EligibilityType.WORLD_WAR_I.getName(), EligibilityType.MEXICAN_BORDER_WAR.getName(), EligibilityType.HUMANTARIAN_EMERGENCY.getName(), EligibilityType.TRICARE_CHAMPUS.getName(), EligibilityType.SHARING_AGREEMENT.getName(), EligibilityType.ALLIED_VETERAN.getName(), EligibilityType.CHAMPVA.getName(), EligibilityType.EMPLOYEE.getName(), EligibilityType.COLLATERAL_OF_VETERAN.getName(), EligibilityType.OTHER_FEDERAL_AGENCY.getName(), EligibilityType.REIMBURSABLE_INSURANCE.getName()};
    public static final String[] mtNotRequiredSecondaryEligibilityCodes = new String[]{EligibilityType.AID_AND_ATTENDANCE.getName(), EligibilityType.HOUSEBOUND.getName(), EligibilityType.NSC_VA_PENSION.getName(), EligibilityType.PRISONER_OF_WAR.getName(), EligibilityType.PURPLE_HEART_RECIPIENT.getName(), EligibilityType.WORLD_WAR_I.getName(), EligibilityType.MEXICAN_BORDER_WAR.getName()};
    public static final String[] pharmacyCopayApplicablePrimEligCodes = new String[]{EligibilityType.SERVICE_CONNECTED_50_TO_100_PERCENT.getName(), EligibilityType.AID_AND_ATTENDANCE.getName(), EligibilityType.HOUSEBOUND.getName(), EligibilityType.NSC_VA_PENSION.getName(), EligibilityType.PRISONER_OF_WAR.getName(), EligibilityType.HUMANTARIAN_EMERGENCY.getName(), EligibilityType.TRICARE_CHAMPUS.getName(), EligibilityType.SHARING_AGREEMENT.getName(), EligibilityType.ALLIED_VETERAN.getName(), EligibilityType.CHAMPVA.getName(), EligibilityType.EMPLOYEE.getName(), EligibilityType.COLLATERAL_OF_VETERAN.getName(), EligibilityType.OTHER_FEDERAL_AGENCY.getName(), EligibilityType.REIMBURSABLE_INSURANCE.getName()};
    public static final String[] pharmacyCopayApplicableSecEligiCodes = new String[]{EligibilityType.AID_AND_ATTENDANCE.getName(), EligibilityType.HOUSEBOUND.getName(), EligibilityType.NSC_VA_PENSION.getName(), EligibilityType.PRISONER_OF_WAR.getName()};
    private PersonHelperService personHelperService;
    private LookupService lookupService;
    private ScheduledTaskService scheduledTaskService;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.lookupService, (String)"Lookup Service is required.");
        Validate.notNull((Object)this.personHelperService, (String)"Person Helper Service is required.");
        Validate.notNull((Object)this.scheduledTaskService, (String)"Scheduled Task Service is required.");
    }

    @Override
    public void updatePseudoSsnClock(Person person, FinancialStatement fStmt) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"Person can not be null");
        if (fStmt == null) {
            this.handleClock(false, person, "S");
            this.handleClock(false, person, "D");
            return;
        }
        boolean startClock = false;
        Set spouseFinancials = fStmt.getSpouseFinancials();
        for (SpouseFinancials sf : spouseFinancials) {
            if (!this.shouldTriggerPseudoSSnClock(sf.getReportedOn())) continue;
            startClock = true;
            break;
        }
        this.handleClock(startClock, person, "S");
        startClock = false;
        for (DependentFinancials df : fStmt.getDependentFinancials()) {
            if (!this.shouldTriggerPseudoSSnClock(df.getReportedOn())) continue;
            startClock = true;
            break;
        }
        this.handleClock(startClock, person, "D");
    }

    @Override
    public void updateSpouseEmployment(Employment incomingSpouseEmployment, Employment onFileSpouseEmployment) {
        EmploymentInputParameter employmentInput = new EmploymentInputParameter();
        if (incomingSpouseEmployment != null && onFileSpouseEmployment != null && incomingSpouseEmployment.getEmploymentStatus() != null) {
            if (EmploymentStatus.CODE_UNKNOWN.getCode().equals(incomingSpouseEmployment.getEmploymentStatus().getCode()) || EmploymentStatus.CODE_NOT_EMPLOYED.getCode().equals(incomingSpouseEmployment.getEmploymentStatus().getCode())) {
                employmentInput.removeEmployment(onFileSpouseEmployment);
            }
            if (!EmploymentStatus.CODE_RETIRED.getCode().equals(incomingSpouseEmployment.getEmploymentStatus().getCode())) {
                employmentInput.removeDateOfRetirement(onFileSpouseEmployment);
            }
        }
    }

    private void handleClock(boolean clockReqd, Person person, String type) throws ServiceException {
        if (clockReqd) {
            this.getScheduledTaskService().startPseudoSSNReasonClock(person, type);
        } else {
            this.getScheduledTaskService().cancelPseudoSSNReasonClock(person, type);
        }
    }

    private boolean shouldTriggerPseudoSSnClock(Relation relation) {
        if (relation == null) {
            return false;
        }
        SSN ssn = relation.getOfficialSsn();
        SSN pseudoSsn = relation.getPseudoSsn();
        return pseudoSsn != null && pseudoSsn.getSsnText() != null && PseudoSSNReason.CODE_FOLLOWUP_REQD.getCode().equals(this.getCode((Lookup)pseudoSsn.getPseudoSSNReason())) && (ssn == null || StringUtils.isEmpty((String)ssn.getSsnText()));
    }

    @Override
    public void adjudicateIncomeTest(IncomeTest currentTest, MeansTestStatus status) throws ServiceException {
        String currentStatusCode;
        Validate.notNull((Object)((Object)currentTest), (String)"IncomeTest can not be null.");
        IncomeTestStatus currentITStatus = currentTest.getIncomeTestStatus();
        MeansTestStatus currentStatus = currentITStatus == null ? null : currentITStatus.getStatus();
        String string = currentStatusCode = currentStatus == null ? null : currentStatus.getCode();
        if (MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode().equals(currentStatusCode)) {
            this.validateAdjudicationUpdate(currentTest);
            currentITStatus.setStatus(status);
            currentITStatus.setDeterminedStatus(status);
            Date now = new Date();
            currentTest.setAdjudicationDate(now);
            currentITStatus.setLastEditedDate(now);
            currentTest.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_HEC.getCode()));
            currentTest.setSiteConductingTest(null);
        }
    }

    private void validateAdjudicationUpdate(IncomeTest test) throws ServiceException {
        if (this.isTestOlderThan365Days(test)) {
            ValidationMessages validationMessages = new ValidationMessages();
            validationMessages.add(new ValidationMessage(RuleValidationMessage.INCOME_TEST_CANNOT_BE_EDITED.getCode()));
            throw new ValidationServiceException(validationMessages);
        }
    }

    @Override
    public void processSsn(FinancialStatement stmt) throws ServiceException {
        Validate.notNull((Object)((Object)stmt), (String)"FinancialStatement must not be null");
        for (RelationFinancials df : stmt.getSpouseFinancials()) {
            if (df == null || ((SpouseFinancials)df).getReportedOn() == null) continue;
            this.processSsn(((SpouseFinancials)df).getReportedOn());
        }
        for (RelationFinancials df : stmt.getDependentFinancials()) {
            if (df == null || ((DependentFinancials)df).getReportedOn() == null) continue;
            this.processSsn(((DependentFinancials)df).getReportedOn());
        }
    }

    @Override
    public void processSsn(Relation relation) throws UnknownLookupTypeException, UnknownLookupCodeException {
        Validate.notNull((Object)((Object)relation), (String)"Relation must not be null");
        SSN ssn = SSN.getSSNOfType(relation.getSsns(), SSNType.CODE_ACTIVE.getCode());
        SSN pseudoSsn = SSN.getSSNOfType(relation.getSsns(), SSNType.CODE_PSEUDO.getCode());
        if (ssn == null || StringUtils.isEmpty((String)ssn.getSsnText())) {
            if (pseudoSsn == null) {
                pseudoSsn = new SSN();
                pseudoSsn.setType(this.getLookupService().getSSNTypeByCode(SSNType.CODE_PSEUDO.getCode()));
                relation.addSsn(pseudoSsn);
            }
            if (pseudoSsn.getPseudoSSNReason() == null) {
                pseudoSsn.setPseudoSSNReason(this.getLookupService().getPseudoSSNReasonByCode(PseudoSSNReason.CODE_FOLLOWUP_REQD.getCode()));
            }
            if (StringUtils.isEmpty((String)pseudoSsn.getSsnText())) {
                pseudoSsn.setSsnText(this.generatePseudoSSn(relation.getName(), relation.getDob()));
            }
            return;
        }
        SSAVerificationStatus ssaStatus = this.lookupService.getSSAVerificationStatusByCode(SSAVerificationStatus.NEW_RECORD.getName());
        this.setSSAVerificationStatus(relation.getOfficialSsn(), ssaStatus);
        Iterator iter = relation.getOtherSsns().iterator();
        while (iter.hasNext()) {
            this.setSSAVerificationStatus((SSN)((Object)iter.next()), ssaStatus);
        }
    }

    private void setSSAVerificationStatus(SSN ssn, SSAVerificationStatus ssaStatus) throws UnknownLookupTypeException, UnknownLookupCodeException {
        if (ssn != null && ssn.getSsaVerificationStatus() == null) {
            ssn.setSsaVerificationStatus(ssaStatus);
        }
    }

    private String generatePseudoSSn(Name name, ImpreciseDate dob) {
        String firstName = name == null ? null : name.getGivenName();
        String middleName = name == null ? null : name.getMiddleName();
        String lastName = name == null ? null : name.getFamilyName();
        char firstInitial = firstName == null || firstName.length() < 1 ? (char)' ' : (char)firstName.charAt(0);
        char middleInitial = middleName == null || middleName.length() < 1 ? (char)' ' : (char)middleName.charAt(0);
        char lastInitial = lastName == null || lastName.length() < 1 ? (char)' ' : (char)lastName.charAt(0);
        StringBuffer pseudoSsn = new StringBuffer();
        pseudoSsn.append(this.getNameInitialMapping(firstInitial));
        pseudoSsn.append(this.getNameInitialMapping(middleInitial));
        pseudoSsn.append(this.getNameInitialMapping(lastInitial));
        String dateStr = dob == null ? null : dob.getStandardFormat();
        String day = dateStr == null || dateStr.length() < 8 ? DEFAULT_DAY_MONTH_YEAR_VALUE : dateStr.substring(6, 8);
        String month = dateStr == null || dateStr.length() < 6 ? DEFAULT_DAY_MONTH_YEAR_VALUE : dateStr.substring(4, 6);
        String year = dateStr == null || dateStr.length() < 4 ? DEFAULT_DAY_MONTH_YEAR_VALUE : dateStr.substring(2, 4);
        pseudoSsn.append(month);
        pseudoSsn.append(day);
        pseudoSsn.append(year);
        return pseudoSsn.toString();
    }

    private String getNameInitialMapping(char firstInitial) {
        String value = "0";
        switch (String.valueOf(firstInitial).toUpperCase().charAt(0)) {
            case 'A': 
            case 'B': 
            case 'C': {
                value = "1";
                break;
            }
            case 'D': 
            case 'E': 
            case 'F': {
                value = "2";
                break;
            }
            case 'G': 
            case 'H': 
            case 'I': {
                value = "3";
                break;
            }
            case 'J': 
            case 'K': 
            case 'L': {
                value = "4";
                break;
            }
            case 'M': 
            case 'N': 
            case 'O': {
                value = "5";
                break;
            }
            case 'P': 
            case 'Q': 
            case 'R': {
                value = "6";
                break;
            }
            case 'S': 
            case 'T': 
            case 'U': {
                value = "7";
                break;
            }
            case 'V': 
            case 'W': 
            case 'X': {
                value = "8";
                break;
            }
            case 'Y': 
            case 'Z': {
                value = "9";
                break;
            }
            default: {
                value = "0";
            }
        }
        return value;
    }

    @Override
    public boolean isActiveRelation(Relation relation, Integer incomeYear) {
        if (relation.getStartDate() == null) {
            return false;
        }
        Calendar yearStart = Calendar.getInstance();
        yearStart.set(incomeYear, 0, 1, 0, 0, 0);
        Calendar yearEnd = Calendar.getInstance();
        yearEnd.set(incomeYear, 11, 31, 23, 59, 59);
        Date startDate = ImpreciseDateUtils.getDateWithDefault(relation.getStartDate());
        Date endDate = relation.getEndDate();
        return startDate.compareTo(yearEnd.getTime()) <= 0 && (endDate == null || endDate.compareTo(yearStart.getTime()) >= 0);
    }

    @Override
    public boolean isActiveSpouseForVistaTransmission(SpouseFinancials spouseFinancials) {
        if (spouseFinancials == null) {
            return false;
        }
        if (spouseFinancials.isActive()) {
            return true;
        }
        boolean isActive = false;
        FinancialStatement financialStatement = spouseFinancials.getFinancialStatement();
        SpouseFinancials activeSpouseFinancials = financialStatement.getActiveSpouseFinancials();
        Integer incomeYear = spouseFinancials.getIncomeYear();
        Spouse spouse = spouseFinancials.getReportedOn();
        Date endDate = spouse.getEndDate();
        Date incomeYearStartDate = DateUtils.getYearStartDate((int)incomeYear);
        Date incomeYearEndDate = DateUtils.getYearEndDate((int)incomeYear);
        if (endDate == null || endDate.compareTo(incomeYearStartDate) >= 0 && endDate.compareTo(incomeYearEndDate) <= 0 && activeSpouseFinancials == null) {
            isActive = true;
        } else if (endDate.compareTo(incomeYearEndDate) >= 0 && activeSpouseFinancials == null) {
            isActive = true;
        }
        return isActive;
    }

    @Override
    public boolean isActiveDependentForVistaTransmission(DependentFinancials dependentFinancials) {
        if (dependentFinancials == null) {
            return false;
        }
        boolean isActive = false;
        Dependent dependent = dependentFinancials.getReportedOn();
        if (dependent != null) {
            Integer incomeYear = dependentFinancials.getIncomeYear();
            Date endDate = dependent.getEndDate();
            Date incomeYearStartDate = DateUtils.getYearStartDate((int)incomeYear);
            isActive = endDate == null || endDate.compareTo(incomeYearStartDate) >= 0;
        }
        return isActive;
    }

    @Override
    public SpouseFinancials getActiveSpouseFinancialsForVistaTransmission(Person person, Integer incomeYear) {
        Set allSpouseFinancials;
        FinancialStatement financialStatement = person.getFinancialStatement(incomeYear);
        if (financialStatement != null && (allSpouseFinancials = financialStatement.getSpouseFinancials()) != null) {
            for (SpouseFinancials spouseFinancials : allSpouseFinancials) {
                if (!this.isActiveSpouseForVistaTransmission(spouseFinancials)) continue;
                return spouseFinancials;
            }
        }
        return null;
    }

    @Override
    public GMTThreshold calculateGMTThresholds(Integer incomeYear, String fipsCode, int extraDependents) throws ServiceException {
        List gmtThresholds = this.getLookupService().getGMTThreshold(incomeYear, fipsCode);
        if (gmtThresholds != null && gmtThresholds.size() > 0) {
            GMTThreshold gmtThreshold = (GMTThreshold)((Object)gmtThresholds.get(0));
            this.calculateThresholds(gmtThreshold, extraDependents);
            return gmtThreshold;
        }
        return null;
    }

    @Override
    public IncomeThreshold calculateIncomeThresholds(Integer incomeYear, int extraDependents) throws ServiceException {
        int dependentCount = 7 + extraDependents;
        return this.calculateIncomeThresholds(incomeYear, new Integer(dependentCount));
    }

    @Override
    public IncomeThreshold calculateIncomeThresholds(Integer incomeYear, Integer numberOfDependents) throws ServiceException {
        int dependentCount = numberOfDependents != null || numberOfDependents < 7 ? numberOfDependents : 7;
        IncomeThreshold it = this.getLookupService().getIncomeThreshold(incomeYear);
        if (it != null) {
            this.setMTThresholds(it, dependentCount);
            this.setPensionThresholds(it, dependentCount);
            this.setMedicalExpDeductibles(incomeYear, it, dependentCount);
            this.setGMTInpatientCopayments(it);
        }
        return it;
    }

    private void setGMTInpatientCopayments(IncomeThreshold it) {
        it.setGmtInpatient90DayCopay(this.get20Percent(it.getNinetyDayHospitalCopay()));
        it.setGmtInpatientAdd90DayCopay(this.get20Percent(it.getAdd90DayHospitalDeductible()));
        it.setGmtInpatientPerDiem(this.get20Percent(it.getInpatientPerDiem()));
    }

    private BigDecimal get20Percent(BigDecimal amount) {
        return amount == null ? null : amount.multiply(twentyPercent);
    }

    private void setMTThresholds(IncomeThreshold it, int dependentCount) {
        BigDecimal mtThreshold0Dependent = this.getNotNull(it.getExemptAmount());
        BigDecimal mtThreshold1Dependent = this.getNotNull(it.getDependent());
        it.setMeansTestThresholdValue(0, mtThreshold0Dependent);
        it.setMeansTestThresholdValue(1, mtThreshold1Dependent);
        BigDecimal addDependentThreshold = this.getNotNull(it.getAddDependentThreshold());
        for (int i = 1; i < dependentCount; ++i) {
            BigDecimal mtThreshold = mtThreshold1Dependent.add(addDependentThreshold.multiply(new BigDecimal(i)));
            it.setMeansTestThresholdValue(i + 1, mtThreshold);
        }
    }

    private void setPensionThresholds(IncomeThreshold it, int dependentCount) {
        BigDecimal pensionThreshold0Dependent = this.getNotNull(it.getPensionThreshold());
        BigDecimal pensionThreshold1Dependent = this.getNotNull(it.getPension1Dependent());
        it.setPensionThresholdValue(0, pensionThreshold0Dependent);
        it.setPensionThresholdValue(1, pensionThreshold1Dependent);
        BigDecimal addDependentPension = this.getNotNull(it.getAddDependentPension());
        for (int i = 1; i < dependentCount; ++i) {
            BigDecimal pensionThreshold = pensionThreshold1Dependent.add(addDependentPension.multiply(new BigDecimal(i)));
            it.setPensionThresholdValue(i + 1, pensionThreshold);
        }
    }

    private void setMedicalExpDeductibles(Integer incomeYear, IncomeThreshold it, int dependentCount) throws ServiceException {
        Integer prevYear = new Integer(incomeYear - 1);
        IncomeThreshold prevYearIt = this.getLookupService().getIncomeThreshold(prevYear);
        if (prevYearIt != null) {
            this.setPensionThresholds(prevYearIt, dependentCount);
            for (int i = 0; i <= dependentCount; ++i) {
                BigDecimal pensionThreshold = prevYearIt.getPensionThresholdValue(i);
                BigDecimal deductibleAmount = pensionThreshold.multiply(MEDICAL_DEDUCATION_PERCENT);
                it.setMedicalDeductiblesValue(i, deductibleAmount);
            }
        }
    }

    private void calculateThresholds(GMTThreshold gmtThreshold, int extraDependents) {
        BigDecimal amountFor4 = this.getNotNull(gmtThreshold.getThresholdValue(3));
        BigDecimal amountFor8 = this.getNotNull(gmtThreshold.getThresholdValue(7));
        for (int d = 1; d <= extraDependents; ++d) {
            double excessAmount = (double)d * amountFor4.doubleValue() * 0.08;
            BigDecimal extraDependentAmount = amountFor8.add(new BigDecimal(excessAmount));
            Integer extraDependentThreshold = this.roundTo50(extraDependentAmount);
            gmtThreshold.setThresholdValue(7 + d, new BigDecimal(extraDependentThreshold));
        }
    }

    private Integer roundTo50(BigDecimal amount) {
        return new Integer((int)(Math.floor((amount.doubleValue() + 25.0) / 50.0) * 50.0));
    }

    @Override
    public boolean isSubjectToMeansTest(Person person) throws ServiceException {
        boolean subjectToMeansTest = true;
        String primaryEligibilityCode = this.getPrimaryEligibilityCode(person);
        subjectToMeansTest = Boolean.TRUE.equals(this.getMilitaryDisabilityIndicator(person)) ? false : (Boolean.TRUE.equals(this.getDischargeDueToDisabilityIndicator(person)) ? false : (Boolean.TRUE.equals(this.isEligibleForMedicaid(person)) ? false : (Boolean.TRUE.equals(this.getCatastrophicallyDisabledIndicator(person)) ? false : (EligibilityType.SC_LESS_THAN_50_PERCENT.getName().equals(primaryEligibilityCode) && this.getServiceConnectionAwardPercentNonNull(person) == 0 && this.getTotalCheckAmount(person).doubleValue() > 0.0 ? false : (EligibilityType.SERVICE_CONNECTED_50_TO_100_PERCENT.getName().equals(primaryEligibilityCode) ? false : (EligibilityType.SC_LESS_THAN_50_PERCENT.getName().equals(primaryEligibilityCode) && this.getServiceConnectionAwardPercentNonNull(person) > 0 ? false : (StringUtils.contains((String[])mtNotRequiredPrimaryEligibilityCodes, (String)primaryEligibilityCode) ? false : this.isSubjectToMeansTestSecondaryEligibility(person))))))));
        return subjectToMeansTest;
    }

    @Override
    public boolean isSubjectToMeansTestForBatchProcess(Person person) throws ServiceException {
        this.getPrimaryEligibilityCode(person);
        return this.isSubjectToMeansTestSecondaryEligibility(person);
    }

    private boolean isSubjectToMeansTestSecondaryEligibility(Person person) {
        List secondaryEligCodes = this.getSecondaryEligibilityCodes(person);
        for (String code : secondaryEligCodes) {
            if (!StringUtils.contains((String[])mtNotRequiredSecondaryEligibilityCodes, (String)code)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPhramacyCoPayApplicable(Person person) {
        boolean primaryCopayApplicable = true;
        String primaryEligibilityCode = this.getPrimaryEligibilityCode(person);
        List secondaryEligCodes = this.getSecondaryEligibilityCodes(person);
        if (Boolean.TRUE.equals(this.getCatastrophicallyDisabledIndicator(person))) {
            primaryCopayApplicable = false;
        } else if (EligibilityType.SC_LESS_THAN_50_PERCENT.getName().equals(primaryEligibilityCode) && this.getServiceConnectionAwardPercentNonNull(person) == 0) {
            for (String code : secondaryEligCodes) {
                if (!StringUtils.contains((String[])pharmacyCopayApplicableSecEligiCodes, (String)code)) continue;
                primaryCopayApplicable = false;
            }
        } else if (EligibilityType.SERVICE_CONNECTED_50_TO_100_PERCENT.getName().equals(primaryEligibilityCode) && this.getServiceConnectionAwardPercentNonNull(person) == 0) {
            primaryCopayApplicable = false;
        } else if (StringUtils.contains((String[])pharmacyCopayApplicablePrimEligCodes, (String)primaryEligibilityCode)) {
            primaryCopayApplicable = false;
        } else if (EligibilityType.SC_LESS_THAN_50_PERCENT.getName().equals(primaryEligibilityCode) && this.getServiceConnectionAwardPercentNonNull(person) > 0) {
            boolean contains;
            List benefitTypeCodes = this.getMonetaryBenefitTypeCodes(person);
            boolean bl = contains = benefitTypeCodes.contains(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName()) || benefitTypeCodes.contains(MonetaryBenefitType.CODE_HOUSEBOUND.getName()) || benefitTypeCodes.contains(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName());
            if (this.isUnemployable(person).booleanValue() && !contains) {
                primaryCopayApplicable = false;
            }
        }
        return primaryCopayApplicable;
    }

    @Override
    public boolean isMeansTestPermitted(Person person) {
        boolean containsSubBenefitTypes;
        List secondaryEligibilityCodes = this.getSecondaryEligibilityCodes(person);
        List benefitTypeCodes = this.getMonetaryBenefitTypeCodes(person);
        boolean containsAllBenefitTypes = benefitTypeCodes.contains(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName()) || benefitTypeCodes.contains(MonetaryBenefitType.CODE_HOUSEBOUND.getName()) || benefitTypeCodes.contains(MonetaryBenefitType.CODE_VA_PENSION.getName()) || benefitTypeCodes.contains(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getName());
        boolean bl = containsSubBenefitTypes = benefitTypeCodes.contains(MonetaryBenefitType.CODE_AID_AND_ATTENDANCE.getName()) || benefitTypeCodes.contains(MonetaryBenefitType.CODE_HOUSEBOUND.getName()) || benefitTypeCodes.contains(MonetaryBenefitType.CODE_VA_PENSION.getName());
        if (EligibilityType.SC_LESS_THAN_50_PERCENT.getName().equals(this.getPrimaryEligibilityCode(person)) && this.getServiceConnectionAwardPercentNonNull(person) == 0) {
            if (!containsSubBenefitTypes && this.getTotalCheckAmount(person).intValue() > 0 && benefitTypeCodes.contains(MonetaryBenefitType.CODE_DISABILITY_COMPENSATION.getName())) {
                return true;
            }
            if (!containsAllBenefitTypes && secondaryEligibilityCodes.contains(EligibilityType.WORLD_WAR_I.getName()) && this.getTotalCheckAmount(person).intValue() == 0) {
                return true;
            }
            if (this.getInEligibleDate(person) != null) {
                return true;
            }
        }
        if (EligibilityType.WORLD_WAR_I.getName().equals(this.getPrimaryEligibilityCode(person)) && this.getServiceConnectionAwardPercent(person) == null && this.getTotalCheckAmount(person).intValue() == 0 && !containsAllBenefitTypes) {
            return true;
        }
        return EligibilityType.NSC.getName().equals(this.getPrimaryEligibilityCode(person)) && this.getInEligibleDate(person) != null;
    }

    private Date getInEligibleDate(Person person) {
        IneligibilityFactor ief = person.getIneligibilityFactor();
        return ief != null ? ief.getIneligibleDate() : null;
    }

    @Override
    public boolean isHardShipGranted(Person person) {
        Hardship hardShip = FinancialsHelperServiceImpl.getHardship(this.getCurrentIncomeTest(person));
        if (hardShip != null && hardShip.getHardshipGranted() != null) {
            return hardShip.getHardshipGranted();
        }
        return false;
    }

    @Override
    public boolean isHardShipGranted(Person person, Integer incomeYear) {
        Hardship hardShip = FinancialsHelperServiceImpl.getHardship(person.getIncomeTest(incomeYear));
        if (hardShip != null && hardShip.getHardshipGranted() != null) {
            return hardShip.getHardshipGranted();
        }
        return false;
    }

    @Override
    public boolean isAllowedtoEditTest(Person person, Integer incomeYear) throws ServiceException {
        if (person.isDeceased() || this.isHardShipGranted(person, incomeYear)) {
            return false;
        }
        IncomeTest test = person.getIncomeTest(incomeYear);
        IncomeTestSource source = test == null ? null : test.getSource();
        String sourceCode = source == null ? null : source.getCode();
        boolean ivmTest = IncomeTestSource.CODE_IVM.getCode().equals(sourceCode);
        if (ivmTest || this.isTestOlderThan365Days(test)) {
            return false;
        }
        return this.isSubjectToMeansTest(person) || this.isMeansTestPermitted(person) || this.isPhramacyCoPayApplicable(person);
    }

    @Override
    public boolean isAllowedtoAddMeansTest(Person person, Integer incomeYear) throws ServiceException {
        if (person.isDeceased()) {
            return false;
        }
        return this.isSubjectToMeansTest(person);
    }

    @Override
    public boolean isAllowedtoAddPharmacyCopayTest(Person person, Integer incomeYear) throws ServiceException {
        boolean isRxCopayAllowed;
        if (person.isDeceased()) {
            return false;
        }
        IncomeTest test = this.getCurrentIncomeTest(person);
        boolean bl = isRxCopayAllowed = !this.isSubjectToMeansTest(person) && this.isPhramacyCoPayApplicable(person);
        if (test != null && !this.isTestOlderThan365Days(test) && isRxCopayAllowed) {
            return true;
        }
        return test == null && isRxCopayAllowed;
    }

    @Override
    public boolean isAllowedtoAddTest(Person person, Integer incomeYear) throws ServiceException {
        if (person.isDeceased()) {
            return false;
        }
        IncomeTest test = this.getCurrentIncomeTest(person);
        return test == null && !this.isSubjectToMeansTest(person) && this.isMeansTestPermitted(person);
    }

    @Override
    public boolean isAllowedtoEditNetWorth(Person person, Integer incomeYear) throws ServiceException {
        return !CommonDateUtils.isIncomeYear2009OrLatter(incomeYear);
    }

    public boolean isNonPrimaryType(String type) {
        return IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST.getName().equals(type) || IncomeTestType.CODE_LTC_CO_PAY_TEST.getName().equals(type);
    }

    private boolean isTestOlderThan365Days(IncomeTest test) {
        return test == null ? false : this.isBefore(this.addYearToDate(test.getEffectiveDate()), new Date());
    }

    public Date addYearToDate(Date currentDate) {
        if (currentDate == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(1, 1);
        if (calendar.get(2) == 1 && calendar.get(5) == 29) {
            calendar.set(5, 28);
        }
        return calendar.getTime();
    }

    private BigDecimal getTotalCheckAmount(Person person) {
        MonetaryBenefitAward mba = person.getMonetaryBenefitAward();
        BigDecimal checkAmt = mba == null ? null : mba.getCheckAmount();
        return this.getNotNull(checkAmt);
    }

    private String getPrimaryEligibilityCode(Person person) {
        Eligibility eligibility;
        EnrollmentDetermination enrollDet = person.getEnrollmentDetermination();
        if (enrollDet != null && (eligibility = enrollDet.getPrimaryEligibility()) != null) {
            return eligibility.getType().getCode();
        }
        return null;
    }

    private List getSecondaryEligibilityCodes(Person person) {
        ArrayList<String> codes = new ArrayList<String>();
        EnrollmentDetermination enrollDet = person.getEnrollmentDetermination();
        if (enrollDet != null) {
            Set eligibilities = enrollDet.getSecondaryEligibilities();
            for (Eligibility eligibility : eligibilities) {
                codes.add(eligibility.getType().getCode());
            }
        }
        return codes;
    }

    private Boolean isUnemployable(Person person) {
        ServiceConnectionAward svcConnAwd = person.getServiceConnectionAward();
        if (svcConnAwd != null) {
            return this.getNotNull(svcConnAwd.getUnemployable());
        }
        return Boolean.FALSE;
    }

    private Integer getServiceConnectionAwardPercentNonNull(Person person) {
        return this.getNotNull(this.getServiceConnectionAwardPercent(person));
    }

    private Integer getServiceConnectionAwardPercent(Person person) {
        ServiceConnectionAward svcConnAwd = person.getServiceConnectionAward();
        return svcConnAwd != null ? svcConnAwd.getServiceConnectedPercentage() : null;
    }

    private Boolean isEligibleForMedicaid(Person person) {
        MedicaidFactor ma = person.getMedicaidFactor();
        return ma != null ? this.getNotNull(ma.isEligibleForMedicaid()) : Boolean.FALSE;
    }

    private Boolean getDischargeDueToDisabilityIndicator(Person person) {
        MilitaryService ms = person.getMilitaryService();
        return ms != null ? this.getNotNull(ms.getDischargeDueToDisability()) : Boolean.FALSE;
    }

    private Boolean getMilitaryDisabilityIndicator(Person person) {
        MilitaryService ms = person.getMilitaryService();
        return ms != null ? this.getNotNull(ms.getDisabilityRetirementIndicator()) : Boolean.FALSE;
    }

    private Boolean getCatastrophicallyDisabledIndicator(Person person) {
        CatastrophicDisability catdisability = person.getCatastrophicDisability();
        return catdisability != null ? this.getNotNull(catdisability.isCatastrophicallyDisabled()) : Boolean.FALSE;
    }

    private List getMonetaryBenefitTypeCodes(Person person) {
        Set benefits;
        ArrayList<String> codes = new ArrayList<String>();
        MonetaryBenefitAward award = person.getMonetaryBenefitAward();
        if (award != null && (benefits = award.getMonetaryBenefits()) != null) {
            for (MonetaryBenefit benefit : benefits) {
                MonetaryBenefitType type = benefit.getType();
                Indicator ind = benefit.getMonetaryBenefitIndicator();
                if (type == null || ind == null || !Indicator.YES.getCode().equals(ind.getCode())) continue;
                codes.add(type.getCode());
            }
        }
        return codes;
    }

    private static Hardship getHardship(IncomeTest incomeTest) {
        Hardship hardship = incomeTest != null ? incomeTest.getHardship() : null;
        return hardship;
    }

    public boolean isBefore(Date value, Date upper) {
        boolean compare = false;
        if (value != null && upper != null) {
            boolean bl = compare = value.before(upper);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(" Upper bound: " + upper));
            this.logger.debug((Object)(" Returned value: " + compare));
        }
        return compare;
    }

    protected BigDecimal getNotNull(BigDecimal bd) {
        return bd == null ? new BigDecimal(0) : bd;
    }

    protected Integer getNotNull(Integer bd) {
        return bd == null ? new Integer(0) : bd;
    }

    protected BigDecimal convert(Integer intValue) {
        return intValue == null ? new BigDecimal(0) : new BigDecimal(intValue);
    }

    protected Boolean getNotNull(Boolean value) {
        return value == null ? Boolean.FALSE : value;
    }

    protected String getCode(Lookup lookup) {
        return lookup == null ? null : lookup.getCode();
    }

    @Override
    public IncomeTest getCurrentIncomeTest(Person person) {
        return this.getPersonHelperService().getCurrentIncomeTest(person);
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public ScheduledTaskService getScheduledTaskService() {
        return this.scheduledTaskService;
    }

    public void setScheduledTaskService(ScheduledTaskService scheduledTaskService) {
        this.scheduledTaskService = scheduledTaskService;
    }
}

