/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.SSNVerification;
import gov.va.med.esr.common.model.person.SSNVerificationDetail;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.persistent.demographic.AddressDAO;
import gov.va.med.esr.common.persistent.demographic.ConfidentialAddressCategoryDAO;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.common.persistent.person.SSNVerificationDetailDAO;
import gov.va.med.esr.common.rule.service.ContactInfoRuleService;
import gov.va.med.esr.common.rule.service.DemographicRuleService;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.common.util.MailingAddressHelper;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;
import gov.va.med.esr.service.external.demographics.DemographicsChangeSummary;
import gov.va.med.esr.service.external.demographics.DemographicsChangeType;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.esr.service.trigger.ProcessTriggerEvent;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.security.Principal;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.util.ObjectUtils;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.Session;

public class DemographicServiceImpl
extends AbstractRuleAwareServiceImpl
implements DemographicService {
    private static final String INCOMETEST_UPD_LASTEDITEDDATE_QRY = "SSNVerificationResponseProcess.updateIncomeTestLastEditedDate";
    private static final long serialVersionUID = -8047918583913683311L;
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;
    private HistoryDAO addressHistoryDAO = null;
    private HistoryDAO insuranceHistoryDAO = null;
    private HistoryDAO demographicHistoryDAO = null;
    private DAOOperations genericDAO;
    private SSNVerificationDetailDAO ssnVerificationDetailDAO;
    private AddressDAO addressDAO = null;
    private TriggerRouter triggerRouter = null;
    private ConfidentialAddressCategoryDAO confidentialAddressCategoryDAO = null;

    @Override
    public Set getAddressHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.addressHistoryDAO.getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getAddressHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.addressHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set getInsuranceHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.insuranceHistoryDAO.getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getInsuranceHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.insuranceHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set getDemographicHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.demographicHistoryDAO.getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getDemographicHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.demographicHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set getIdentityTraitsChangeTimes(EntityKey vpidKey) throws ServiceException {
        return this.doGetIdentityTraitsChangeTimes(vpidKey, false);
    }

    private Set doGetIdentityTraitsChangeTimes(EntityKey vpidKey, boolean onlyGetTraitsThatESRSubmitted) throws ServiceException {
        List traitList = this.getTraitHistory(CommonEntityKeyFactory.createVPIDEntityKey(vpidKey.getKeyValueAsString()), onlyGetTraitsThatESRSubmitted);
        HashSet<ChangeEvent> changeEventSet = new HashSet<ChangeEvent>();
        for (PersonIdentityTraits traits : traitList) {
            changeEventSet.add(new ChangeEvent(traits.getAuditInfo().getChangeDate(), (EntityKey)traits.getVpid()));
        }
        return changeEventSet;
    }

    @Override
    public HistoricalInfo getIdentityTraitsHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        return this.doGetIdentityTraitsHistoryByChangeTime(event, false);
    }

    private HistoricalInfo doGetIdentityTraitsHistoryByChangeTime(ChangeEvent event, boolean onlyGetTraitsThatESRSubmitted) throws ServiceException {
        List traitList = this.getTraitHistory((VPIDEntityKey)event.getEntityKey(), onlyGetTraitsThatESRSubmitted);
        Person currentPerson = new Person();
        Person previousPerson = new Person();
        currentPerson.setPreviousVersion((AbstractVersionedEntity)previousPerson);
        PersonIdentityTraits currentTraits = null;
        PersonIdentityTraits previousTraits = null;
        for (int i = traitList.size() - 1; i >= 0 && previousTraits == null; --i) {
            PersonIdentityTraits traits = (PersonIdentityTraits)((Object)traitList.get(i));
            if (currentTraits == null && traits.getAuditInfo().getChangeDate().equals(event.getTimeStamp())) {
                currentTraits = traits;
                continue;
            }
            if (previousTraits != null || currentTraits == null) continue;
            previousTraits = traits;
        }
        if (currentTraits != null) {
            currentPerson.setIdentityTraits(currentTraits);
            currentPerson.setModifiedOn(currentTraits.getAuditInfo().getChangeDate());
            currentPerson.setModifiedBy((Principal)new ESRUserPrincipalImpl(currentTraits.getAuditInfo().getChangeUser()));
        }
        if (previousTraits != null) {
            previousPerson.setIdentityTraits(previousTraits);
            previousPerson.setModifiedOn(previousTraits.getAuditInfo().getChangeDate());
            previousPerson.setModifiedBy((Principal)new ESRUserPrincipalImpl(previousTraits.getAuditInfo().getChangeUser()));
        }
        return new HistoricalInfo(event, (AbstractVersionedEntity)currentPerson);
    }

    @Override
    public SSNVerification updateRequestSSNVerificationData(SSNVerification ssnVerification, List newSSNVerificationDetails, String updatedQueryString, Object[] spouseDependentsSSNIds) throws ServiceException {
        try {
            if (updatedQueryString != null) {
                this.getGenericDAO().bulkUpdate(updatedQueryString, spouseDependentsSSNIds);
            }
            this.getGenericDAO().saveObject((Object)ssnVerification);
            for (int i = 0; newSSNVerificationDetails != null && i < newSSNVerificationDetails.size(); ++i) {
                this.getGenericDAO().saveObject(newSSNVerificationDetails.get(i));
            }
        }
        catch (DAOException e) {
            throw new ServiceException("Error updating Request SSN Verification data ", (Throwable)e);
        }
        return ssnVerification;
    }

    @Override
    public Person updateDemographicInformation(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person result = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey(), incoming.getIdentityTraits());
        Validate.notNull((Object)((Object)result), (String)"A veteran on file must not be null.");
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)result);
        this.validateEnrollmentDetermination(result);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DemographicRuleSvcImpl updateDemoInfo before change : incoming: " + (Object)((Object)incoming)));
        }
        this.getDemographicRuleService().manageDemographicInfo(incoming, result);
        this.getEligibilityEnrollmentService().assessEEImpact(result, false);
        this.getEventRuleService().manageMessageEvents(result);
        this.getEventRuleService().manageHandBookEvents(result);
        this.addPersonChangeEventsForAdvice(result);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("DemographicRuleSvcImpl updateDemoInfo at save : incoming: " + (Object)((Object)result)));
        }
        result = this.getPersonService().save(result);
        return result;
    }

    private void addPersonChangeEventsForAdvice(Person result) throws ServiceException {
        this.getEventRuleService().addPersonChangeEventsForAdvice(result);
    }

    @Override
    public Person processDemographicInformation(VAFacility sendingFacility, Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person result = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        this.getDemographicRuleService().processDemographicInfo(sendingFacility, incoming, result, false, "N");
        this.getPersonService().save(result);
        return result;
    }

    @Override
    public Person updateSSNVerificationResponse(SSASSNVerificationData incoming) throws ServiceException {
        SSASSNVerificationData resultSSNVerificationData = new SSASSNVerificationData();
        SSNVerificationDetail ssnVerificationDetail = this.getSSNVerificationDetail(incoming);
        Person person = null;
        SSN ssn = null;
        Relation relation = null;
        if (ssnVerificationDetail != null) {
            incoming.setHECInternalIdMatched(true);
            incoming.setSsnVerificationForSpouseOrDependent(ssnVerificationDetail.getSsnId() != null);
            if (incoming.isSsnVerificationForSpouseOrDependent()) {
                incoming.setSsnId(String.valueOf(ssnVerificationDetail.getSsnId()));
                try {
                    EntityKey entityKey = CommonEntityKeyFactory.createSSNEntityKey(String.valueOf(ssnVerificationDetail.getSsnId()));
                    ssn = (SSN)((Object)this.getGenericDAO().getByKey(entityKey));
                }
                catch (DAOException e) {
                    throw new ServiceException("Could not get SSN for SSN ID " + ssnVerificationDetail.getSsnId(), (Throwable)e);
                }
                if (ssn == null) {
                    throw new ServiceException("No SSN exists for SSN ID " + ssnVerificationDetail.getSsnId());
                }
                relation = ssn.getRelation();
                if (Relationship.CODE_SPOUSE.getCode().equals(relation.getRelationship().getCode())) {
                    incoming.setSsnVerificationForSpouse(true);
                } else {
                    incoming.setSsnVerificationForDependent(true);
                }
                person = this.getPersonService().getPerson(relation.getPerson().getPersonEntityKey());
            } else {
                person = this.getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(ssnVerificationDetail.getPersonId()));
            }
        }
        if (ssn == null) {
            throw new ServiceException("No SSN exists for SSN ID " + (ssnVerificationDetail != null ? ssnVerificationDetail.getSsnId() : null));
        }
        this.getDemographicRuleService().processSSNVerificationResponse(incoming, person, resultSSNVerificationData, relation);
        if (person != null && person.isVOAOnly()) {
            SSAVerificationStatus ssaVerificationStatus = resultSSNVerificationData.getSsaVerificationStatus();
            if (!incoming.isSsnVerificationForSpouseOrDependent() && ssaVerificationStatus != null && SSAVerificationStatus.VERIFIED.getCode().equals(ssaVerificationStatus.getCode())) {
                this.getEventRuleService().processMessageEvents(person);
            }
        }
        if (person != null && incoming.isHECInternalIdMatched()) {
            IncomeTest incomeTest = person.getIncomeTest(person.getLatestIncomeYear());
            Date editedDate = Calendar.getInstance().getTime();
            if (incoming.isSsnVerificationForSpouseOrDependent()) {
                try {
                    ssn.setSsaMessage(resultSSNVerificationData.getSsaMessage());
                    ssn.setSsaVerificationStatus(resultSSNVerificationData.getSsaVerificationStatus());
                    ssn.setSsaVerificationDate(editedDate);
                    ssn.setSsaReceivedDate(editedDate);
                    this.getGenericDAO().saveObject((Object)ssn);
                    if (incomeTest != null) {
                        this.updateIncomeTestLastEditedDate(incomeTest, editedDate);
                    }
                    this.logger.info((Object)("Updated Spouse/Dependent SSN for ID " + ssn.getEntityKey().getKeyValueAsString()));
                }
                catch (DAOException e) {
                    throw new ServiceException("Could not save SSN", (Throwable)e);
                }
            } else {
                PersonIdentityTraits traits = this.getPsDelegateService().extractIdentityTraits(person);
                SSN veteranSsn = traits.getSsn();
                veteranSsn.setSsaMessage(resultSSNVerificationData.getSsaMessage());
                veteranSsn.setSsaVerificationStatus(resultSSNVerificationData.getSsaVerificationStatus());
                veteranSsn.setSsaVerificationDate(editedDate);
                veteranSsn.setSsaReceivedDate(editedDate);
                if (incomeTest != null) {
                    this.updateIncomeTestLastEditedDate(incomeTest, editedDate);
                }
                this.getPersonService().updateProfileForESRCorrelation(person);
            }
        }
        return person;
    }

    @Override
    public void updateIncomeTestLastEditedDate(IncomeTest incomeTest, Date lastEditedDate) throws ServiceException {
        if (incomeTest == null || incomeTest.getStatuses() == null) {
            return;
        }
        Set statuses = incomeTest.getStatuses();
        try {
            for (IncomeTestStatus status : statuses) {
                HashMap<String, Comparable<Date>> contextData = new HashMap<String, Comparable<Date>>();
                contextData.put("lastEditedDate", lastEditedDate);
                contextData.put("itdetailid", new BigDecimal(status.getEntityKey().getKeyValueAsString()));
                AbstractDAOAction callback = new AbstractDAOAction(contextData){

                    public Object execute(Session session) {
                        Query query = session.getNamedQuery(DemographicServiceImpl.INCOMETEST_UPD_LASTEDITEDDATE_QRY);
                        query.setParameter("lastEditedDate", (Object)((Date)this.getContextData().get("lastEditedDate")));
                        query.setParameter("itdetailid", (Object)((BigDecimal)this.getContextData().get("itdetailid")));
                        return new Integer(query.executeUpdate());
                    }
                };
                Integer updateCount = (Integer)this.getGenericDAO().execute(callback);
                if (updateCount >= 1 || !this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("Income Test Lasted Updated did not update =" + status.getEntityKey().getKeyValueAsString()));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception Income Test Lasted Updated Date", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public Person updateContactInformation(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person result = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)result);
        this.validateEnrollmentDetermination(result);
        Address incomingPermAddress = incoming.getPermanentAddress();
        Address onFilePermAddress = result.getPermanentAddress();
        if (this.isAddressDataChanged(incomingPermAddress, onFilePermAddress)) {
            incomingPermAddress.setChangeDate(new Date(this.getTimestampManager().getTransactionTimestamp().getTime()));
        }
        ContactInfoRuleService contactInfoRuleService = this.getContactInfoRuleService();
        contactInfoRuleService.manageAddresses(incoming.getAddresses(), result);
        contactInfoRuleService.manageElectronicAddresses(incoming.getEmails(), result);
        contactInfoRuleService.managePhones(incoming.getPhones(), result);
        contactInfoRuleService.manageHandBookForBadAddressText(incoming.getAddresses(), result);
        result = this.getPersonService().save(result);
        return result;
    }

    @Override
    public void saveAddress(Address onFileAddress) throws ServiceException {
        try {
            this.getGenericDAO().saveObject((Object)onFileAddress);
            this.getGenericDAO().flush();
        }
        catch (Exception e) {
            throw new ServiceException("Error saving Address ", (Throwable)e);
        }
    }

    private void resetSSNVerificationStatus(Person incoming, Person onFile) throws ServiceException {
        if (incoming.getPersonEntityKey() != null) {
            PersonIdentityTraits onFileTraits = onFile.getIdentityTraits();
            PersonIdentityTraits incomingTraits = incoming.getIdentityTraits();
            if (!incomingTraits.equals((Object)onFileTraits)) {
                String incomingSSAVerificationStatusCode;
                boolean shouldResetSSAVerificationStatus = false;
                SSN incomingSSN = incomingTraits.getSsn();
                SSN onFileSSN = onFileTraits.getSsn();
                String incomingSSNText = incomingSSN != null ? incomingSSN.getSsnText() : "";
                String onFileSSNText = onFileSSN != null ? onFileSSN.getSsnText() : "";
                String onFileSSAVerificationStatusCode = onFileSSN != null && onFileSSN.getSsaVerificationStatus() != null ? onFileSSN.getSsaVerificationStatus().getCode() : "";
                boolean traitsChanged = false;
                String string = incomingSSAVerificationStatusCode = incomingSSN != null && incomingSSN.getSsaVerificationStatus() != null ? incomingSSN.getSsaVerificationStatus().getCode() : "";
                if (!onFileSSNText.equals(incomingSSNText) && !StringUtils.isEmpty((String)incomingSSNText)) {
                    shouldResetSSAVerificationStatus = true;
                    traitsChanged = true;
                } else if (ObjectUtils.didObjectChange((Object)onFileTraits.getLegalName(), (Object)incomingTraits.getLegalName()) && ObjectUtils.didObjectChange((Object)((Object)onFileTraits.getBirthRecord()), (Object)((Object)incomingTraits.getBirthRecord())) && SSAVerificationStatus.VERIFIED.getCode().equals(onFileSSAVerificationStatusCode)) {
                    shouldResetSSAVerificationStatus = true;
                    traitsChanged = true;
                } else if ((ObjectUtils.didObjectChange((Object)onFileTraits.getLegalName(), (Object)incomingTraits.getLegalName()) || ObjectUtils.didObjectChange((Object)((Object)onFileTraits.getBirthRecord()), (Object)((Object)incomingTraits.getBirthRecord()))) && SSAVerificationStatus.INVALID_PER_SSA.getCode().equals(onFileSSAVerificationStatusCode)) {
                    shouldResetSSAVerificationStatus = true;
                    traitsChanged = true;
                }
                if (ObjectUtils.didObjectChange((Object)((Object)onFileTraits.getGender()), (Object)((Object)incomingTraits.getGender()))) {
                    traitsChanged = true;
                }
                if (shouldResetSSAVerificationStatus) {
                    incomingSSN.setSsaVerificationStatus(this.getLookupService().getSSAVerificationStatusByCode(SSAVerificationStatus.NEW_RECORD.getName()));
                    incomingSSN.setSsaVerificationDate(null);
                    incomingSSN.setSsaMessage(null);
                    this.getHelperService().addToSSNVerificationQueue(onFile);
                }
                this.getPersonService().updateProfileForESRCorrelation(incoming);
                if (traitsChanged || ObjectUtils.didObjectChange((Object)onFileSSAVerificationStatusCode, (Object)incomingSSAVerificationStatusCode)) {
                    onFile.setChangeEvent("IDENTITY_TRAITS", "IDENTITY_TRAITS");
                }
            }
        }
    }

    @Override
    public Person updateIdentityTraits(Person incoming) throws ServiceException {
        Person result = this.getPersonService().getPersonWithCompositeCall(incoming.getIdentityTraits().getVpid());
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)result);
        this.resetSSNVerificationStatus(incoming, result);
        this.validateEnrollmentDetermination(result);
        this.getDemographicRuleService().manageIdentityTraits(incoming, result);
        this.getEligibilityEnrollmentService().assessEEImpact(result, false);
        this.getEventRuleService().manageHandBookEvents(result);
        if ("N".equals(result.getIdentityTraits().has200ESRCorrelation())) {
            this.getPersonService().addESRCorrelation(result);
        }
        return this.getPersonService().save(result);
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }

    public HistoryDAO getAddressHistoryDAO() {
        return this.addressHistoryDAO;
    }

    public void setAddressHistoryDAO(HistoryDAO addressHistoryDAO) {
        this.addressHistoryDAO = addressHistoryDAO;
    }

    public HistoryDAO getDemographicHistoryDAO() {
        return this.demographicHistoryDAO;
    }

    public void setDemographicHistoryDAO(HistoryDAO demographicHistoryDAO) {
        this.demographicHistoryDAO = demographicHistoryDAO;
    }

    public DAOOperations getGenericDAO() {
        return this.genericDAO;
    }

    public void setGenericDAO(DAOOperations genericDAO) {
        this.genericDAO = genericDAO;
    }

    public SSNVerificationDetailDAO getSsnVerificationDetailDAO() {
        return this.ssnVerificationDetailDAO;
    }

    public void setSsnVerificationDetailDAO(SSNVerificationDetailDAO ssnVerificationDetailDAO) {
        this.ssnVerificationDetailDAO = ssnVerificationDetailDAO;
    }

    public AddressDAO getAddressDAO() {
        return this.addressDAO;
    }

    public void setAddressDAO(AddressDAO addressDAO) {
        this.addressDAO = addressDAO;
    }

    public ConfidentialAddressCategoryDAO getConfidentialAddressCategoryDAO() {
        return this.confidentialAddressCategoryDAO;
    }

    public void setConfidentialAddressCategoryDAO(ConfidentialAddressCategoryDAO confidentialAddressCategoryDAO) {
        this.confidentialAddressCategoryDAO = confidentialAddressCategoryDAO;
    }

    @Override
    public void processExternalDemographicsChange(DemographicsChangeSummary changeSummary) throws ServiceException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("ESR received an external demographics change event: " + changeSummary));
        }
        VPIDEntityKey vpid = CommonEntityKeyFactory.createVPIDEntityKey(changeSummary.getVpid());
        Person person = this.getPersonService().getPersonWithCompositeCall(vpid);
        this.getDemographicRuleService().processExternalDemographicChanges(changeSummary.getChangeEvents(), person);
        if (this.requiresEECalculation(changeSummary.getChangeEvents())) {
            this.getEligibilityEnrollmentService().assessEEImpact(person, false);
            EventRuleService eventRuleService = this.getEventRuleService();
            eventRuleService.manageMessageEvents(person);
            eventRuleService.managePersonEvents(person);
            eventRuleService.manageHandBookEvents(person);
        }
        if ("N".equalsIgnoreCase(person.getIdentityTraits().has200ESRCorrelation())) {
            this.getPersonService().addESRCorrelation(person);
        }
        this.getPersonService().save(person);
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    @Override
    public List getPersonAddresses(PersonEntityKey key) throws ServiceException {
        if (key == null) {
            return null;
        }
        List lst = null;
        try {
            AddressDAO addrDAO = this.getAddressDAO();
            lst = addrDAO.getPersonAddresses(new BigDecimal(key.getKeyValueAsString()));
        }
        catch (DAOException dex) {
            throw new ServiceException(dex.getMessage(), (Throwable)dex);
        }
        return lst;
    }

    public List getConfAddrCategoriesByPersonId(PersonEntityKey key) throws ServiceException {
        if (key == null) {
            return null;
        }
        List lst = null;
        try {
            ConfidentialAddressCategoryDAO confidentialAddressCategoryDAO = this.getConfidentialAddressCategoryDAO();
            lst = confidentialAddressCategoryDAO.getConfAddCategoriesByPersonId(new BigDecimal(key.getKeyValueAsString()));
        }
        catch (DAOException dex) {
            throw new ServiceException(dex.getMessage(), (Throwable)dex);
        }
        return lst;
    }

    @Override
    public Address getLetterAddress(Person person) throws ServiceException {
        if (person == null || person.getAddresses() == null || person.getAddresses().size() == 0) {
            return null;
        }
        return MailingAddressHelper.selectAddressForMailing(person.getAddresses());
    }

    @Override
    public Address getUpdatedLetterAddress(CommsLogEntry log) throws ServiceException {
        if (log == null || log.getPersonId() == null) {
            return null;
        }
        List addrLst = this.getPersonAddresses(CommonEntityKeyFactory.createPersonIdEntityKey(log.getPersonId().toString()));
        List confidentialAddressCategoryList = this.getConfAddrCategoriesByPersonId(CommonEntityKeyFactory.createPersonIdEntityKey(log.getPersonId().toString()));
        Address latestAddr = MailingAddressHelper.selectAddressForMailing(confidentialAddressCategoryList, addrLst);
        if (latestAddr == null || this.isLetterAddressSame(latestAddr, log)) {
            return null;
        }
        return latestAddr;
    }

    @Override
    public Address getUpdatedLetterAddress(HandBookMailQueue mailQueue) throws ServiceException {
        if (mailQueue == null || mailQueue.getPersonId() == null) {
            return null;
        }
        List addrLst = this.getPersonAddresses(CommonEntityKeyFactory.createPersonIdEntityKey(mailQueue.getPersonId().toString()));
        List confidentialAddressCategoryList = this.getConfAddrCategoriesByPersonId(CommonEntityKeyFactory.createPersonIdEntityKey(mailQueue.getPersonId().toString()));
        Address latestAddr = MailingAddressHelper.selectAddressForMailing(confidentialAddressCategoryList, addrLst);
        if (latestAddr == null || this.isLetterAddressSame(latestAddr, mailQueue)) {
            return null;
        }
        return latestAddr;
    }

    @Override
    public Address getUndeliverableMailUpdatedLetterAddress(CommsLogEntry log) throws ServiceException {
        Address letterAddress;
        if (log == null || log.getPersonId() == null) {
            return null;
        }
        List addressList = this.getPersonAddresses(CommonEntityKeyFactory.createPersonIdEntityKey(log.getPersonId().toString()));
        List confidentialAddressCategoryList = this.getConfAddrCategoriesByPersonId(CommonEntityKeyFactory.createPersonIdEntityKey(log.getPersonId().toString()));
        Address addressToUseNow = MailingAddressHelper.selectAddressForMailing(confidentialAddressCategoryList, addressList);
        if (!ObjectUtils.equals((Object)addressToUseNow, (Object)(letterAddress = log.getAddress()))) {
            return addressToUseNow;
        }
        ArrayList<Address> newAddressList = new ArrayList<Address>();
        for (Address newAddress : addressList) {
            if (newAddress.equals(letterAddress)) continue;
            newAddressList.add(newAddress);
        }
        return MailingAddressHelper.selectAddressForMailing(newAddressList);
    }

    protected List getTraitHistory(VPIDEntityKey vpidEntityKey, boolean onlyGetTraitsThatESRSubmitted) throws ServiceException {
        if (!onlyGetTraitsThatESRSubmitted) {
            return this.getPsDelegateService().getIdentityTraitsUpdateHistory(vpidEntityKey);
        }
        return this.getPsDelegateService().getSubmittedIdentityTraitsUpdateHistory(vpidEntityKey);
    }

    private boolean isLetterAddressSame(Address latestAddr, CommsLogEntry log) {
        return ObjectUtils.equals((Object)latestAddr, (Object)log.getAddress());
    }

    private boolean isLetterAddressSame(Address latestAddr, HandBookMailQueue mailQueue) throws ServiceException {
        return ObjectUtils.equals((Object)latestAddr, (Object)mailQueue.getAddress());
    }

    private boolean requiresEECalculation(Set changes) {
        if (changes == null) {
            return false;
        }
        for (DemographicsChangeEvent demographicsChangeEvent : changes) {
            if (!demographicsChangeEvent.getChangeType().equals(DemographicsChangeType.DATE_OF_DEATH_CHANGE)) continue;
            return true;
        }
        return false;
    }

    private SSNVerificationDetail getSSNVerificationDetail(SSASSNVerificationData ssnVerificationData) throws ServiceException {
        SSNVerificationDetail verificationDetail = null;
        try {
            verificationDetail = this.getSsnVerificationDetailDAO().getSSNVerificationDetailByHECInternalId(ssnVerificationData.getHECInternalID());
        }
        catch (DAOException e) {
            throw new ServiceException("Could not get SSNVerification Detail by HEC Internal Id: " + ssnVerificationData.getHECInternalID(), (Throwable)e);
        }
        return verificationDetail;
    }

    @Override
    public Set getSubmittedIdentityTraitsChangeTimes(EntityKey personID) throws ServiceException {
        return this.doGetIdentityTraitsChangeTimes(personID, true);
    }

    @Override
    public HistoricalInfo getSubmittedIdentityTraitsHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        return this.doGetIdentityTraitsHistoryByChangeTime(event, true);
    }

    public HistoryDAO getInsuranceHistoryDAO() {
        return this.insuranceHistoryDAO;
    }

    public void setInsuranceHistoryDAO(HistoryDAO insuranceHistoryDAO) {
        this.insuranceHistoryDAO = insuranceHistoryDAO;
    }

    @Override
    public Person processDeathRecordFromIdm(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person result = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        Validate.notNull((Object)((Object)result), (String)"A veteran on file must not be null.");
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)result);
        this.validateEnrollmentDetermination(result);
        VAFacility sendingFacility = incoming.getDeathRecord() != null ? incoming.getDeathRecord().getFacilityReceived() : null;
        this.getDemographicRuleService().processDemographicInfo(sendingFacility, incoming, result, false, true);
        this.getEligibilityEnrollmentService().assessEEImpact(result, false);
        this.getEventRuleService().manageMessageEvents(result);
        result = this.getPersonService().save(result);
        return result;
    }

    @Override
    public Person processDateOfDeathFromIdm(Person onFile, Date dateOfDeath) throws ServiceException {
        Validate.notNull((Object)dateOfDeath, (String)"The Date of Death must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null");
        Person incoming = (Person)((Object)onFile.clone());
        this.validateEnrollmentDetermination(onFile);
        DemographicRuleService service = this.getDemographicRuleService();
        service.attachDeathRecordFromIdm(incoming, dateOfDeath);
        VAFacility sendingFacility = incoming.getDeathRecord() != null ? incoming.getDeathRecord().getFacilityReceived() : null;
        service.processDemographicInfo(sendingFacility, incoming, onFile, false, true);
        this.getEligibilityEnrollmentService().assessEEImpact(onFile, false);
        this.getEventRuleService().manageMessageEvents(onFile);
        return this.getPersonService().save(onFile);
    }

    public boolean isAddressDataChanged(Address incoming, Address result) {
        if (result != null) {
            Address cloneAddr = (Address)result.clone();
            cloneAddr.setChangeSource(incoming.getChangeSource());
            cloneAddr.setChangeSite(incoming.getChangeSite());
            return !AbstractEntity.matchesDomainValues((AbstractEntity)incoming, (AbstractEntity)cloneAddr);
        }
        return true;
    }

    @Override
    public void sendDodUpdate(TriggerEvent triggerEvent) throws ServiceException {
        ProcessTriggerEvent event = (ProcessTriggerEvent)triggerEvent;
        try {
            Person person = null;
            PersonEntityKey key = event.getPersonId();
            if (key != null) {
                person = this.getPersonService().getPerson(key);
            }
            this.getPersonService().updateProfileForDeathEvent(person);
        }
        catch (ServiceException e) {
            throw new ServiceException("Error retrieving a person from the ProcessTriggerEvent", (Throwable)e);
        }
    }
}

