/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.CorrespondenceStatus;
import gov.va.med.esr.common.model.lookup.CorrespondenceType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.esr.common.persistent.comms.CorrespondenceDAO;
import gov.va.med.esr.common.persistent.history.CorrespondenceHistoryDAO;
import gov.va.med.esr.service.CorrespondenceService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class CorrespondenceServiceImpl
extends AbstractComponent
implements CorrespondenceService {
    private static final long serialVersionUID = 8534346603323475694L;
    private LookupService lookupService = null;
    private PersonService personService = null;
    public static final String FIND_ADDRESS_H_BY_ID = "correspondenceQuery_findHistoryAddressById";
    public static final String PARAM_ADD_ID = "addressHId";
    private CorrespondenceDAO correspondenceDAO = null;
    private CommsTemplateDAO templDAO = null;
    private DemographicService demographicService;
    private CorrespondenceHistoryDAO correspondenceHistoryDAO = null;

    @Override
    public void triggerNewCMSCorrespondence(Correspondence correspondence, ComLetterTemplateType.Code formNumber) throws ServiceException {
        CommsTemplate templ = null;
        try {
            templ = (CommsTemplate)this.templDAO.findTemplateListByFormNumber(formNumber.getCode()).get(0);
            correspondence.setLetterTemplate(templ);
            correspondence.setCorrespondenceStatus((CorrespondenceStatus)this.getLookupService().getByCode(CorrespondenceStatus.class, CorrespondenceStatus.PENDING_TRANSMISSION_TO_CMS.getCode()));
            correspondence.setCorrespondenceType((CorrespondenceType)this.getLookupService().getByCode(CorrespondenceType.class, CorrespondenceType.CMS_MAILING.getCode()));
            correspondence.setStatusDate(new Date());
            this.getCorrespondenceDAO().saveObject((Object)correspondence);
        }
        catch (DAOException ex) {
            this.logger.error((Object)"DAO Exception during triggerNewCorrespondence", (Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
    }

    @Override
    public void associateACALetterType(Correspondence correspondence, ComLetterTemplateType.Code formNumber) throws ServiceException {
        CommsTemplate templ = null;
        try {
            templ = (CommsTemplate)this.templDAO.findTemplateListByFormNumber(formNumber.getCode()).get(0);
            correspondence.setLetterTemplate(templ);
            correspondence.setCorrespondenceStatus((CorrespondenceStatus)this.getLookupService().getByCode(CorrespondenceStatus.class, CorrespondenceStatus.SENT_TO_CMS.getCode()));
            correspondence.setCorrespondenceType((CorrespondenceType)this.getLookupService().getByCode(CorrespondenceType.class, CorrespondenceType.CMS_MAILING.getCode()));
            correspondence.setStatusDate(new Date());
            this.getCorrespondenceDAO().saveObject((Object)correspondence);
        }
        catch (DAOException ex) {
            this.logger.error((Object)"DAO Exception during triggerNewCorrespondence", (Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
    }

    @Override
    public void updateACACorrespondence(Correspondence correspondence, CorrespondenceStatus.Code status, String errMsg) throws ServiceException {
        try {
            if (status != null && status.equals((Object)CorrespondenceStatus.SENT_TO_CMS) && correspondence.getMailingAddress() != null) {
                this.getDemographicService().saveAddress(correspondence.getMailingAddress());
                correspondence.setAddressId(this.getCorrespondenceDAO().findAddressHistoryIdByPersonId(correspondence.getPersonId()));
            }
            if (status != null) {
                correspondence.setCorrespondenceStatus((CorrespondenceStatus)this.getLookupService().getByCode(CorrespondenceStatus.class, status.getCode()));
            }
            correspondence.setStatusDate(new Date());
            correspondence.setErrorDescription(errMsg);
            this.getCorrespondenceDAO().saveObject((Object)correspondence);
        }
        catch (DAOException ex) {
            this.logger.error((Object)"DAO Exception during Update ACA Correspondence", (Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
    }

    @Override
    public CommsTemplate getTemplateByForm(ComLetterTemplateType.Code formNumber) throws ServiceException {
        try {
            return (CommsTemplate)this.templDAO.findTemplateListByFormNumber(formNumber.getCode()).get(0);
        }
        catch (DAOException e) {
            this.logger.error((Object)"DAO Exception during getTemplateByForm", (Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public ArrayList<Correspondence> getPendingPersonCorrespondence(BigDecimal personId, ComLetterTemplateType.Code formNumber) throws ServiceException {
        try {
            ArrayList<Correspondence> results = this.getCorrespondenceDAO().findPendingCorrespondenceByForm(personId, formNumber.getCode());
            if (results != null && results.size() > 0) {
                return results;
            }
        }
        catch (DAOException ex) {
            this.logger.error((Object)"DAO Exception during getPendingPersonCorrespondence", (Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
        return null;
    }

    @Override
    public ArrayList<Correspondence> getSentPersonCorrespondence(BigDecimal personId, ComLetterTemplateType.Code formNumber) throws ServiceException {
        try {
            ArrayList<Correspondence> results = this.getCorrespondenceDAO().findSentCorrespondenceByForm(personId, formNumber.getCode());
            if (results != null && results.size() > 0) {
                return results;
            }
        }
        catch (DAOException ex) {
            this.logger.error((Object)"DAO Exception during getSentPersonCorrespondence", (Throwable)ex);
            throw new ServiceException((Throwable)ex);
        }
        return null;
    }

    @Override
    public boolean shouldSuppressMailCorrespondence(Person person) throws ServiceException {
        return false;
    }

    @Override
    public void cancelCorrespondence(BigDecimal correspondenceId) throws ServiceException {
        try {
            Correspondence corr = this.getCorrespondenceDAO().findById(correspondenceId);
            this.updateACACorrespondence(corr, CorrespondenceStatus.CANCEL_BY_HEC, "Pending Mail Correspondence Cancelled by ES User");
        }
        catch (DAOException e) {
            this.logger.error((Object)"DAO Exception during cancelCorrespondence", (Throwable)e);
        }
    }

    @Override
    public Correspondence getCorrespondenceWithHistory(BigDecimal correspondenceId) throws ServiceException {
        try {
            Correspondence corr = this.getCorrespondenceDAO().findById(correspondenceId);
            if (corr.getAddressId() != null) {
                Address mailedAddress = null;
                try {
                    mailedAddress = this.getCorrespondenceDAO().getHistoricalAddress(corr.getAddressId());
                }
                catch (Exception ex) {
                    this.logger.error((Object)"DAO Exception during getyCorrespondence", (Throwable)ex);
                }
                corr.setMailingAdress(mailedAddress);
            }
            ArrayList<Correspondence> corrHistory = new ArrayList<Correspondence>(this.getCorrespondenceHistoryDAO().getCorrespondenceHistory(correspondenceId));
            corr.setStatusHistory(corrHistory);
            return corr;
        }
        catch (DAOException e) {
            this.logger.error((Object)"DAO Exception during getCorrespondence", (Throwable)e);
            return null;
        }
    }

    @Override
    public void remailCorrespondence(BigDecimal correspondenceId) throws ServiceException {
        try {
            Correspondence orig = this.getCorrespondenceDAO().findById(correspondenceId);
            Correspondence remail = new Correspondence();
            remail.setEffectiveDate(orig.getEffectiveDate());
            remail.setPersonId(orig.getPersonId());
            this.triggerNewCMSCorrespondence(remail, ComLetterTemplateType.Code.getByCode(orig.getLetterTemplate().getCommsTemplateFormNumber()));
        }
        catch (DAOException e) {
            this.logger.error((Object)"DAO Exception during remailCorrespondence", (Throwable)e);
        }
    }

    @Override
    public ArrayList<Correspondence> getPersonCorrespondence(BigDecimal personId, ArrayList<ComLetterTemplateType.Code> formNumbers) throws ServiceException {
        try {
            ArrayList<Correspondence> allResults = new ArrayList<Correspondence>();
            for (int i = 0; i < formNumbers.size(); ++i) {
                ArrayList<Correspondence> results = this.getCorrespondenceDAO().findAllCorrespondenceByForm(personId, formNumbers.get(i).getCode());
                if (results == null || results.size() <= 0) continue;
                allResults.addAll(results);
            }
            return allResults;
        }
        catch (Exception ex) {
            this.logger.error((Object)"DAO Exception during getPendingPersonCorrespondence", (Throwable)ex);
            return null;
        }
    }

    public CorrespondenceDAO getCorrespondenceDAO() {
        return this.correspondenceDAO;
    }

    public void setCorrespondenceDAO(CorrespondenceDAO correspondenceDAO) {
        this.correspondenceDAO = correspondenceDAO;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public CommsTemplateDAO getTemplDAO() {
        return this.templDAO;
    }

    public void setTemplDAO(CommsTemplateDAO templDAO) {
        this.templDAO = templDAO;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    public CorrespondenceHistoryDAO getCorrespondenceHistoryDAO() {
        return this.correspondenceHistoryDAO;
    }

    public void setCorrespondenceHistoryDAO(CorrespondenceHistoryDAO correspondenceHistoryDAO) {
        this.correspondenceHistoryDAO = correspondenceHistoryDAO;
    }
}

