/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.trigger.BulletinTriggerEvent;
import gov.va.med.esr.service.trigger.BulletinTriggerIdentity;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerableService;
import gov.va.med.fw.util.InvalidConfigurationException;

public class CommsBulletinMessageProcessor
extends AbstractComponent
implements TriggerableService {
    private PersonService personService = null;
    private CommsEmailBulletinService commsEmailBulletinService = null;

    public void trigger(TriggerEvent triggerEvent) throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Received a trigger event " + triggerEvent));
        }
        BulletinTriggerEvent bulletinTriggerEvent = (BulletinTriggerEvent)triggerEvent;
        Person person = this.getPerson(bulletinTriggerEvent);
        BulletinTriggerIdentity bulletinTriggerIdentity = (BulletinTriggerIdentity)bulletinTriggerEvent.getTriggerIdentity();
        this.commsEmailBulletinService.sendEmailBulletin(bulletinTriggerIdentity.getDataType(), bulletinTriggerEvent.getFieldMap(), person);
    }

    private Person getPerson(BulletinTriggerEvent bulletinTriggerEvent) throws ServiceException {
        try {
            Person person = null;
            if (bulletinTriggerEvent.getIdentityTraits() != null) {
                person = this.personService.find(bulletinTriggerEvent.getIdentityTraits());
            } else {
                PersonEntityKey key = bulletinTriggerEvent.getPersonId();
                if (key != null) {
                    person = this.personService.getPerson(key);
                }
            }
            return person;
        }
        catch (ServiceException e) {
            throw new ServiceException("Error retrieving a person from the BulletinTriggerEvent", (Throwable)e);
        }
    }

    public void afterPropertiesSet() {
        if (this.personService == null) {
            throw new InvalidConfigurationException("personService must be set on " + ((Object)((Object)this)).getClass().getName());
        }
        if (this.commsEmailBulletinService == null) {
            throw new InvalidConfigurationException("commsEmailBulletinService must be set on " + ((Object)((Object)this)).getClass().getName());
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public CommsEmailBulletinService getCommsEmailBulletinService() {
        return this.commsEmailBulletinService;
    }

    public void setCommsEmailBulletinService(CommsEmailBulletinService commsEmailBulletinService) {
        this.commsEmailBulletinService = commsEmailBulletinService;
    }
}

