/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.messaging.ArchivedMessageLogEntry;
import gov.va.med.esr.common.model.messaging.ArchivedMessageLogEntryLite;
import gov.va.med.esr.common.model.messaging.MessageLogEntry;
import gov.va.med.esr.common.model.messaging.SiteIdentity;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.messaging.ArchivedMessageLogEntryDAO;
import gov.va.med.esr.common.persistent.messaging.MessageLogEntryDAO;
import gov.va.med.esr.service.ArchivedMessagingService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.esr.service.UniqueIdentifierGenerator;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.trigger.CommonTrigger;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.RetransmitTriggerEvent;
import gov.va.med.fw.cache.EntityCacheManager;
import gov.va.med.fw.cache.TriggerEventCacheManager;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class ArchivedMessagingServiceImpl
extends AbstractRuleAwareServiceImpl
implements ArchivedMessagingService {
    private static final long serialVersionUID = -1936162067559837119L;
    private static final String RETRANSMIT_EVENT = "messaging.retransmit";
    private UniqueIdentifierGenerator generator = null;
    private MessageLogEntryDAO messageLogEntryDAO = null;
    private ArchivedMessageLogEntryDAO archivedMessageLogEntryDAO = null;
    private TriggerRouter triggerRouter = null;
    private TriggerEventCacheManager triggerEventCacheManager;
    private EntityCacheManager entityCacheManager;

    public TriggerEventCacheManager getTriggerEventCacheManager() {
        return this.triggerEventCacheManager;
    }

    public void setTriggerEventCacheManager(TriggerEventCacheManager triggerEventCacheManager) {
        this.triggerEventCacheManager = triggerEventCacheManager;
    }

    public EntityCacheManager getEntityCacheManager() {
        return this.entityCacheManager;
    }

    public void setEntityCacheManager(EntityCacheManager entityCacheManager) {
        this.entityCacheManager = entityCacheManager;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    public UniqueIdentifierGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(UniqueIdentifierGenerator generator) {
        this.generator = generator;
    }

    public MessageLogEntryDAO getMessageLogEntryDAO() {
        return this.messageLogEntryDAO;
    }

    public void setArchivedMessageLogEntryDAO(ArchivedMessageLogEntryDAO archivedMessageLogEntryDAO) {
        this.archivedMessageLogEntryDAO = archivedMessageLogEntryDAO;
    }

    public ArchivedMessageLogEntryDAO getArchivedMessageLogEntryDAO() {
        return this.archivedMessageLogEntryDAO;
    }

    public void setMessageLogEntryDAO(MessageLogEntryDAO messageLogEntryDAO) {
        this.messageLogEntryDAO = messageLogEntryDAO;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.messageLogEntryDAO, (String)"MessageLogEntryDAO is required");
        Validate.notNull((Object)this.triggerRouter, (String)"triggerRouter is required");
        Validate.notNull((Object)this.triggerEventCacheManager, (String)"triggerEventCacheManager is required");
        Validate.notNull((Object)this.entityCacheManager, (String)"entityCacheManager is required");
    }

    @Override
    public String generateControlIdentifier() throws ServiceException {
        return this.generator.generate().toString();
    }

    @Override
    public SiteIdentity getIdentity(Person person, VAFacility vaFacility) throws ServiceException {
        Validate.notNull((Object)((Object)vaFacility), (String)"VAFacility can not be null");
        SiteIdentity siteId2 = null;
        if (person != null) {
            Set sites = this.findSitesOfRecord(person);
            for (SiteIdentity siteId2 : sites) {
                if (!siteId2.getVaFacility().getCode().equals(vaFacility.getCode())) continue;
                return siteId2;
            }
        }
        siteId2 = new SiteIdentity();
        siteId2.setVaFacility(vaFacility);
        return siteId2;
    }

    @Override
    public Set getMatchingTraits(PersonIdentityTraits identityTraits) throws ServiceException {
        return this.getPsDelegateService().unattendedSearch(identityTraits);
    }

    @Override
    public void logMessage(MessageLogEntry entry) throws ServiceException {
        try {
            if (entry.getEntityKey() == null) {
                this.messageLogEntryDAO.saveObject((Object)entry);
            } else {
                MessageLogEntry cachedEntry = (MessageLogEntry)((Object)this.messageLogEntryDAO.getByKey(entry.getEntityKey()));
                cachedEntry.setAckDate(entry.getAckDate());
                cachedEntry.setAckType(entry.getAckType());
                cachedEntry.setErrorText(entry.getErrorText());
                cachedEntry.setInternalErrorText(entry.getInternalErrorText());
                cachedEntry.setStatus(entry.getStatus());
                this.messageLogEntryDAO.saveObject((Object)cachedEntry);
            }
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to log message ", (Throwable)ex);
        }
    }

    @Override
    public ArchivedMessageLogEntry getMessageLogEntryById(BigDecimal id) throws ServiceException {
        ArchivedMessageLogEntry mle = null;
        try {
            mle = this.archivedMessageLogEntryDAO.getById(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry by id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public ArchivedMessageLogEntryLite getMessageLogEntryLiteById(BigDecimal id) throws ServiceException {
        ArchivedMessageLogEntryLite mle = null;
        try {
            mle = this.archivedMessageLogEntryDAO.getMessageLogEntryLiteById(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry lite by id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public ArchivedMessageLogEntry getMessageLogEntry(String id) throws ServiceException {
        ArchivedMessageLogEntry mle = null;
        try {
            mle = this.archivedMessageLogEntryDAO.getByControlId(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry by id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public ArchivedMessageLogEntry getMessageLogEntryByBatchControlNumber(String id) throws ServiceException {
        ArchivedMessageLogEntry mle = null;
        try {
            mle = this.archivedMessageLogEntryDAO.getByBatchControlId(id);
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to get message log entry by batch id " + id, (Throwable)e);
        }
        return mle;
    }

    @Override
    public Set findSitesOfRecord(Person person) throws ServiceException {
        return person == null ? new HashSet() : this.getPsDelegateService().getSites(person.getVPIDEntityKey());
    }

    public List search(SearchQueryInfo criteria) throws ServiceException {
        List list = null;
        try {
            list = this.archivedMessageLogEntryDAO.find(criteria);
        }
        catch (DAOException ex) {
            throw new ServiceException("Failed to get the Messages matchong the criteria", (Throwable)ex);
        }
        return list;
    }

    @Override
    public void triggerRetransmission(BigDecimal identifier) throws ServiceException {
        RetransmitTriggerEvent event = new RetransmitTriggerEvent(identifier, true);
        event.setName(RETRANSMIT_EVENT);
        this.triggerRouter.processTriggerEvent((TriggerEvent)event);
    }

    @Override
    public void triggerQRYZ07(Person person, VAFacility facility, Integer incomeYear, boolean handleAfterCommit) throws ServiceException {
        Validate.notNull((Object)((Object)facility), (String)"Facility can not be null");
        Validate.notNull((Object)incomeYear, (String)"Income Year can not be null");
        Validate.notNull((Object)((Object)person), (String)"Person can not be null");
        HashSet<VAFacility> sites = new HashSet<VAFacility>(1);
        sites.add(facility);
        IncomeYearTriggerEvent incomeEvent = new IncomeYearTriggerEvent(CommonTrigger.DestinationType.MESSAGING, CommonTrigger.TargetType.VISTA, CommonTrigger.DispatchType.QUERY, PersonTrigger.DataType.FULL_DATA);
        incomeEvent.setIncomeYear(incomeYear);
        incomeEvent.setPersonId(person.getPersonEntityKey());
        incomeEvent.setIdentityTraits(person.getIdentityTraits());
        incomeEvent.setTargetSites(sites);
        if (handleAfterCommit) {
            HashSet<IncomeYearTriggerEvent> events = new HashSet<IncomeYearTriggerEvent>(1);
            events.add(incomeEvent);
            this.triggerEventCacheManager.storeTriggerEvents(events);
        } else {
            this.triggerRouter.processTriggerEvent((TriggerEvent)incomeEvent);
        }
    }

    @Override
    public void triggerQRYZ07(Person person, VAFacility facility, Integer incomeYear) throws ServiceException {
        this.triggerQRYZ07(person, facility, incomeYear, false);
    }

    @Override
    public VAFacility findSiteLastTransmittedMsg(EntityKey personId) throws ServiceException {
        try {
            String siteCode = this.archivedMessageLogEntryDAO.findSiteLastTransmittedMsg(personId);
            if (siteCode != null) {
                return this.getLookupService().getVaFacilityByCode(siteCode);
            }
            return null;
        }
        catch (DAOException e) {
            throw new ServiceException("Failed to Retrieve the Site that last trsmitted the Message", (Throwable)e);
        }
    }

    @Override
    public boolean hasProcessedInboundMessage(String messageControlNumber, String stationNumber) throws ServiceException {
        try {
            return this.archivedMessageLogEntryDAO.hasProcessedInboundMessage(messageControlNumber, stationNumber);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to execute DAO", (Throwable)e);
        }
    }

    @Override
    public List findVoaAaAckLogEntryByPersonId(EntityKey personId) throws ServiceException {
        try {
            return this.archivedMessageLogEntryDAO.findVoaAaAckLogEntryByPersonId(personId);
        }
        catch (DAOException e) {
            throw new ServiceException("Unable to execute DAO", (Throwable)e);
        }
    }
}

