/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.service.AssociationRuleService;
import gov.va.med.esr.common.rule.service.ClinicalDeterminationRuleService;
import gov.va.med.esr.common.rule.service.CommunicationRuleService;
import gov.va.med.esr.common.rule.service.ContactInfoRuleService;
import gov.va.med.esr.common.rule.service.DemographicRuleService;
import gov.va.med.esr.common.rule.service.EGTRuleService;
import gov.va.med.esr.common.rule.service.EligibilityEnrollmentRuleService;
import gov.va.med.esr.common.rule.service.EligibilityFactorRuleService;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.common.rule.service.FinancialInfoRuleService;
import gov.va.med.esr.common.rule.service.InsuranceRuleService;
import gov.va.med.esr.common.rule.service.MergeRuleService;
import gov.va.med.esr.common.rule.service.MilitaryRuleService;
import gov.va.med.esr.common.rule.service.POWRuleService;
import gov.va.med.esr.common.rule.service.ProcessVBARuleService;
import gov.va.med.esr.common.rule.service.PurpleHeartRuleService;
import gov.va.med.esr.common.rule.service.RegistryRuleService;
import gov.va.med.esr.common.rule.service.RuleValidationService;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.impl.AbstractHelperServiceImpl;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.service.EntityNotChangedException;
import gov.va.med.fw.service.transaction.TransactionTimestampManager;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.Validate;

public abstract class AbstractRuleAwareServiceImpl
extends AbstractHelperServiceImpl {
    public static final String ENROLLMENT_DETERMINATION_NOT_PRESENT_KEY = "ENROLLMENT_DETERMINATION_NOT_PRESENT";
    private ClinicalDeterminationRuleService clinicalDeterminationRuleService = null;
    private CommunicationRuleService communicationRuleService = null;
    private ContactInfoRuleService contactInfoRuleService = null;
    private DemographicRuleService demographicRuleService = null;
    private EGTRuleService egtRuleService = null;
    private EligibilityFactorRuleService eligibilityFactorRuleService = null;
    private EventRuleService eventRuleService = null;
    private FinancialInfoRuleService financialInfoRuleService = null;
    private InsuranceRuleService insuranceRuleService = null;
    private MilitaryRuleService militaryRuleService = null;
    private AssociationRuleService associationRuleService = null;
    private POWRuleService powRuleService = null;
    private ProcessVBARuleService processVBARuleService = null;
    private PurpleHeartRuleService purpleHeartRuleService = null;
    private EligibilityEnrollmentRuleService enrollmentRuleService = null;
    private MergeRuleService mergeRuleService = null;
    private RegistryRuleService registryRuleService = null;
    private RuleValidationService ruleValidationService = null;
    private TransactionTimestampManager timestampManager;
    private PSDelegateService psDelegateService;
    private CommsEmailBulletinService bulletinService;

    protected AbstractRuleAwareServiceImpl() {
    }

    protected void validateEnrollmentDetermination(Person onFile) throws ValidationServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on-file Person must not be null.");
        if (!onFile.isEnrolled()) {
            ValidationMessages validationMessages = new ValidationMessages();
            validationMessages.add(new ValidationMessage(ENROLLMENT_DETERMINATION_NOT_PRESENT_KEY));
            throw new ValidationServiceException(validationMessages);
        }
    }

    protected boolean determinePsdDemographicUpdate(Person incoming, Person onFile) {
        boolean psdDemographicUpdate = false;
        boolean bl = psdDemographicUpdate = !AbstractEntity.matchesDomainValues((Collection)incoming.getAddresses(), (Collection)onFile.getAddresses()) || !AbstractEntity.matchesDomainValues((Collection)incoming.getEmails(), (Collection)onFile.getEmails()) || !AbstractEntity.matchesDomainValues((Collection)incoming.getPhones(), (Collection)onFile.getPhones()) || !AbstractEntity.matchesDomainValues((Collection)incoming.getAssociations(), (Collection)onFile.getAssociations()) || !AbstractEntity.matchesDomainValues((AbstractEntity)incoming.getDeathRecord(), (AbstractEntity)onFile.getDeathRecord());
        if (psdDemographicUpdate) {
            onFile.setDemographicUpdateDate(new Date(this.getTimestampManager().getTransactionTimestamp().getTime()));
        }
        return psdDemographicUpdate;
    }

    protected void ensureEntityChanged(AbstractEntity incoming, AbstractEntity onFile) throws EntityNotChangedException {
        if (AbstractEntity.matchesDomainValues((AbstractEntity)incoming, (AbstractEntity)onFile)) {
            String entityClassName = "null";
            if (incoming != null || onFile != null) {
                entityClassName = incoming != null ? incoming.getClass().getName() : onFile.getClass().getName();
            }
            throw new EntityNotChangedException("The incoming and onFile " + entityClassName + " entities match each other and have not changed.");
        }
    }

    protected void ensureEntityChanged(Collection incoming, Collection onFile) throws EntityNotChangedException {
        if (AbstractEntity.matchesDomainValues((Collection)incoming, (Collection)onFile)) {
            throw new EntityNotChangedException("The incoming and onFile  entity collections match each other and have not changed.");
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.associationRuleService, (String)"Association rule serivice is required");
        Validate.notNull((Object)this.clinicalDeterminationRuleService, (String)"Clinial Determination rule serivice is required");
        Validate.notNull((Object)this.contactInfoRuleService, (String)"Contact Info rule serivice is required");
        Validate.notNull((Object)this.demographicRuleService, (String)"Demographic rule serivice is required");
        Validate.notNull((Object)this.egtRuleService, (String)"EGT rule serivice is required");
        Validate.notNull((Object)this.eligibilityFactorRuleService, (String)"Eligibility Factor rule serivice is required");
        Validate.notNull((Object)this.enrollmentRuleService, (String)"Enrollment rule serivice is required");
        Validate.notNull((Object)this.financialInfoRuleService, (String)"Financial rule serivice is required");
        Validate.notNull((Object)this.insuranceRuleService, (String)"Insurance rule serivice is required");
        Validate.notNull((Object)this.militaryRuleService, (String)"Military rule serivice is required");
        Validate.notNull((Object)this.powRuleService, (String)"POW rule serivice is required");
        Validate.notNull((Object)this.processVBARuleService, (String)"Process VBA rule serivice is required");
        Validate.notNull((Object)this.purpleHeartRuleService, (String)"Purple Heart rule serivice is required");
        Validate.notNull((Object)this.psDelegateService, (String)"psDelegateService is required");
    }

    public ClinicalDeterminationRuleService getClinicalDeterminationRuleService() {
        return this.clinicalDeterminationRuleService;
    }

    public void setClinicalDeterminationRuleService(ClinicalDeterminationRuleService clinicalDeterminationRuleService) {
        this.clinicalDeterminationRuleService = clinicalDeterminationRuleService;
    }

    public EligibilityEnrollmentRuleService getEnrollmentRuleService() {
        return this.enrollmentRuleService;
    }

    public void setEnrollmentRuleService(EligibilityEnrollmentRuleService enrollmentRuleService) {
        this.enrollmentRuleService = enrollmentRuleService;
    }

    public ContactInfoRuleService getContactInfoRuleService() {
        return this.contactInfoRuleService;
    }

    public void setContactInfoRuleService(ContactInfoRuleService contactInfoRuleService) {
        this.contactInfoRuleService = contactInfoRuleService;
    }

    public DemographicRuleService getDemographicRuleService() {
        return this.demographicRuleService;
    }

    public void setDemographicRuleService(DemographicRuleService demographicRuleService) {
        this.demographicRuleService = demographicRuleService;
    }

    public EGTRuleService getEgtRuleService() {
        return this.egtRuleService;
    }

    public void setEgtRuleService(EGTRuleService egtRuleService) {
        this.egtRuleService = egtRuleService;
    }

    public EligibilityFactorRuleService getEligibilityFactorRuleService() {
        return this.eligibilityFactorRuleService;
    }

    public void setEligibilityFactorRuleService(EligibilityFactorRuleService eligibilityFactorRuleService) {
        this.eligibilityFactorRuleService = eligibilityFactorRuleService;
    }

    public EventRuleService getEventRuleService() {
        return this.eventRuleService;
    }

    public void setEventRuleService(EventRuleService eventRuleService) {
        this.eventRuleService = eventRuleService;
    }

    public FinancialInfoRuleService getFinancialInfoRuleService() {
        return this.financialInfoRuleService;
    }

    public void setFinancialInfoRuleService(FinancialInfoRuleService financialInfoRuleService) {
        this.financialInfoRuleService = financialInfoRuleService;
    }

    public InsuranceRuleService getInsuranceRuleService() {
        return this.insuranceRuleService;
    }

    public void setInsuranceRuleService(InsuranceRuleService insuranceRuleService) {
        this.insuranceRuleService = insuranceRuleService;
    }

    public MilitaryRuleService getMilitaryRuleService() {
        return this.militaryRuleService;
    }

    public void setMilitaryRuleService(MilitaryRuleService militaryRuleService) {
        this.militaryRuleService = militaryRuleService;
    }

    public AssociationRuleService getAssociationRuleService() {
        return this.associationRuleService;
    }

    public void setAssociationRuleService(AssociationRuleService associationRuleService) {
        this.associationRuleService = associationRuleService;
    }

    public POWRuleService getPowRuleService() {
        return this.powRuleService;
    }

    public void setPowRuleService(POWRuleService powRuleService) {
        this.powRuleService = powRuleService;
    }

    public ProcessVBARuleService getProcessVBARuleService() {
        return this.processVBARuleService;
    }

    public void setProcessVBARuleService(ProcessVBARuleService processVBARuleService) {
        this.processVBARuleService = processVBARuleService;
    }

    public PurpleHeartRuleService getPurpleHeartRuleService() {
        return this.purpleHeartRuleService;
    }

    public void setPurpleHeartRuleService(PurpleHeartRuleService purpleHeartRuleService) {
        this.purpleHeartRuleService = purpleHeartRuleService;
    }

    public MergeRuleService getMergeRuleService() {
        return this.mergeRuleService;
    }

    public void setMergeRuleService(MergeRuleService mergeRuleService) {
        this.mergeRuleService = mergeRuleService;
    }

    public RegistryRuleService getRegistryRuleService() {
        return this.registryRuleService;
    }

    public void setRegistryRuleService(RegistryRuleService registryRuleService) {
        this.registryRuleService = registryRuleService;
    }

    public CommunicationRuleService getCommunicationRuleService() {
        return this.communicationRuleService;
    }

    public void setCommunicationRuleService(CommunicationRuleService communicationRuleService) {
        this.communicationRuleService = communicationRuleService;
    }

    public RuleValidationService getRuleValidationService() {
        return this.ruleValidationService;
    }

    public void setRuleValidationService(RuleValidationService ruleValidationService) {
        this.ruleValidationService = ruleValidationService;
    }

    public TransactionTimestampManager getTimestampManager() {
        return this.timestampManager;
    }

    public void setTimestampManager(TransactionTimestampManager timestampManager) {
        this.timestampManager = timestampManager;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public CommsEmailBulletinService getBulletinService() {
        return this.bulletinService;
    }

    public void setBulletinService(CommsEmailBulletinService bulletinService) {
        this.bulletinService = bulletinService;
    }
}

