/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.SelfIdentifiedGenderIdentity;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.util.StringUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class IdmServiceVO
extends AbstractEntity {
    private static final long serialVersionUID = -963101290677483931L;
    public static final String UPDATE_STATUS_ACCEPTED = "ACCEPTED";
    public static final String UPDATE_STATUS_PENDING = "PENDING";
    public static final String UPDATE_STATUS_REJECTED = "REJECTED";
    public static final int POTENTIAL_MATCH = 1;
    public static final int EXACT_MATCH = 2;
    public static final String HOME_PHONE_TYPE_CODE = PhoneType.CODE_HOME.getCode();
    private Set names = new HashSet();
    private BirthRecord birthRecord;
    private DeathRecord deathRecord;
    private Gender gender;
    private SelfIdentifiedGenderIdentity sigi;
    private SSN ssn;
    private VPIDEntityKey vpid;
    private String mothersMaidenName;
    private String IDState = null;
    Set addresses = null;
    private Set phones = null;
    private VAFacility preferredFacilty;
    private boolean addAPerson;
    private boolean deathEvent;
    private String patientType;
    private boolean isVeteran;
    private boolean isServiceConnected;
    private int idmMatchType;

    protected void buildToString(ToStringBuilder builder) {
        builder.append("names", (Object)this.names);
        builder.append("birthRecord", (Object)this.birthRecord);
        builder.append("deathRecord", (Object)this.deathRecord);
        builder.append("gender", (Object)this.gender);
        builder.append("ssn", (Object)this.ssn);
        builder.append("vpid", (Object)this.vpid);
        builder.append("preferredFacility", (Object)this.preferredFacilty);
        builder.append("addresses", (Object)this.addresses);
        builder.append("patientType", (Object)this.patientType);
        builder.append("isVeteran", this.isVeteran);
        builder.append("isServiceConnected", this.isServiceConnected);
        builder.append("idmMatchType", this.idmMatchType);
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public SelfIdentifiedGenderIdentity getSigi() {
        return this.sigi;
    }

    public void setSigi(SelfIdentifiedGenderIdentity sigi) {
        this.sigi = sigi;
    }

    public Set getNames() {
        return this.names;
    }

    public Name getLegalName() {
        return this.names != null ? Name.getNameOfType(this.names, NameType.LEGAL_NAME.getName()) : null;
    }

    public void addName(Name name) {
        this.names.add(name);
    }

    public void setNames(Set names) {
        this.names = names;
    }

    public SSN getSsn() {
        return this.ssn;
    }

    public String getSsnText() {
        return this.ssn != null ? this.ssn.getFormattedSsnText() : null;
    }

    public void setSsn(SSN ssn) {
        this.ssn = ssn;
    }

    public BirthRecord getBirthRecord() {
        return this.birthRecord;
    }

    public void setBirthRecord(BirthRecord birthRecord) {
        this.birthRecord = birthRecord;
    }

    public DeathRecord getDeathRecord() {
        return this.deathRecord;
    }

    public void setDeathRecord(DeathRecord deathRecord) {
        this.deathRecord = deathRecord;
    }

    public boolean getDeathEvent() {
        return this.deathEvent;
    }

    public void setDeathEvent(boolean deathEvent) {
        this.deathEvent = deathEvent;
    }

    public VPIDEntityKey getVpid() {
        return this.vpid;
    }

    public void setVpid(VPIDEntityKey vpid) {
        this.vpid = vpid;
    }

    public boolean isServiceConnected() {
        return this.isServiceConnected;
    }

    public void setServiceConnected(boolean isServiceConnected) {
        this.isServiceConnected = isServiceConnected;
    }

    public boolean isVeteran() {
        return this.isVeteran;
    }

    public void setVeteran(boolean isVeteran) {
        this.isVeteran = isVeteran;
    }

    public String getPatientType() {
        return this.patientType;
    }

    public void setPatientType(String patientType) {
        this.patientType = patientType;
    }

    public Set getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Set addresses) {
        this.addresses = addresses;
    }

    public void addAddress(Address address) {
        Validate.notNull((Object)address, (String)"Null address specified.");
        if (this.addresses == null) {
            this.addresses = new HashSet();
        }
        this.addresses.add(address);
    }

    public Address getAddressByType(String addressTypeName) {
        if (this.addresses != null && this.addresses.size() > 0) {
            return Address.getAddressOfType(this.addresses, addressTypeName);
        }
        return null;
    }

    public void addPhone(Phone phone) {
        Validate.notNull((Object)((Object)phone), (String)"Null phone specified.");
        if (this.phones == null) {
            this.phones = new HashSet();
        }
        this.phones.add(phone);
    }

    public Phone getPhoneByType(String phoneTypeName) {
        if (this.phones != null && this.phones.size() > 0) {
            return Phone.getPhoneOfType(this.phones, phoneTypeName);
        }
        return null;
    }

    public Phone getHomePhone() {
        Phone homePhone = null;
        if (this.phones != null && this.phones.size() > 0) {
            for (Phone phone : this.phones) {
                if (!phone.getType().getCode().equals(HOME_PHONE_TYPE_CODE) || homePhone != null && (phone.getChangeDate() == null || homePhone.getChangeDate() == null || !phone.getChangeDate().after(homePhone.getChangeDate()))) continue;
                homePhone = phone;
            }
        }
        return homePhone;
    }

    public boolean containsOnlySSN() {
        String ssn = this.getSsn() != null ? this.getSsn().getSsnText() : null;
        String firstName = this.getLegalName() != null ? this.getLegalName().getGivenName() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        Gender gender = this.getGender();
        boolean result = false;
        if (this.vpid == null && StringUtils.isNotBlank((String)ssn) && StringUtils.isBlank((String)firstName) && StringUtils.isBlank((String)lastName) && dob == null && gender == null) {
            result = true;
        }
        return result;
    }

    public boolean hasOfficialSSN() {
        SSNType myType = this.getSsn() != null ? this.getSsn().getType() : null;
        return myType != null && SSNType.CODE_ACTIVE.getCode().equals(myType.getCode());
    }

    public boolean containsOnlyFullName() {
        String ssn = this.getSsn() != null ? this.getSsn().getSsnText() : null;
        String firstName = this.getLegalName() != null ? this.getLegalName().getGivenName() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        Gender gender = this.getGender();
        boolean result = false;
        if (this.vpid == null && StringUtils.isBlank((String)ssn) && StringUtils.isNotBlank((String)firstName) && StringUtils.isNotBlank((String)lastName) && dob == null && gender == null) {
            result = true;
        }
        return result;
    }

    public boolean containsAtLeastFullName() {
        String firstName = this.getLegalName() != null ? this.getLegalName().getGivenName() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        boolean result = false;
        if (StringUtils.isNotBlank((String)firstName) && StringUtils.isNotBlank((String)lastName)) {
            result = true;
        }
        return result;
    }

    public boolean containsOnlyLastNameAndDOB() {
        String ssn = this.getSsn() != null ? this.getSsn().getSsnText() : null;
        String firstName = this.getLegalName() != null ? this.getLegalName().getGivenName() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        Gender gender = this.getGender();
        boolean result = false;
        if (this.vpid == null && StringUtils.isBlank((String)ssn) && StringUtils.isBlank((String)firstName) && StringUtils.isNotBlank((String)lastName) && dob != null && gender == null) {
            result = true;
        }
        return result;
    }

    public boolean containsAtLeastLastNameAndDOB() {
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        boolean result = false;
        if (StringUtils.isNotBlank((String)lastName) && dob != null) {
            result = true;
        }
        return result;
    }

    public boolean containsSsnDOBGender() {
        String ssn = this.getSsn() != null ? this.getSsn().getSsnText() : null;
        String lastName = this.getLegalName() != null ? this.getLegalName().getFamilyName() : null;
        ImpreciseDate dob = this.getBirthRecord() != null ? this.getBirthRecord().getBirthDate() : null;
        Gender gender = this.getGender();
        boolean result = false;
        if (this.vpid == null && StringUtils.isBlank((String)lastName) && StringUtils.isNotBlank((String)ssn) && dob != null && gender != null) {
            result = true;
        }
        return result;
    }

    public String getMothersMaidenName() {
        return this.mothersMaidenName;
    }

    public void setMothersMaidenName(String mothersMaidenName) {
        this.mothersMaidenName = mothersMaidenName;
    }

    public boolean equals(Object o) {
        super.getLogger();
        return super.equals(o);
    }

    public String getIDState() {
        return this.IDState;
    }

    public void setIDState(String state) {
        this.IDState = state;
    }

    public VAFacility getPreferredFacilty() {
        return this.preferredFacilty;
    }

    public void setPreferredFacilty(VAFacility preferredFacilty) {
        this.preferredFacilty = preferredFacilty;
    }

    public boolean isAddAPerson() {
        return this.addAPerson;
    }

    public void setAddAPerson(boolean addAPerson) {
        this.addAPerson = addAPerson;
    }

    public int getIdmMatchType() {
        return this.idmMatchType;
    }

    public void setIdmMatchType(int idmMatchType) {
        this.idmMatchType = idmMatchType;
    }

    public Set getPhones() {
        return this.phones;
    }

    public void setPhones(Set phones) {
        this.phones = phones;
    }
}

