/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.messaging.xml;

import gov.va.med.esr.messaging.xml.ClassPathEntityResolver;
import gov.va.med.esr.messaging.xml.ClassPathURIResolver;
import gov.va.med.fw.util.StopWatchLogger;
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.util.builder.Validator;
import gov.va.med.fw.util.builder.ValidatorException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlFormatter
extends AbstractBuilder
implements Builder,
Validator {
    private static final long serialVersionUID = -8695546825091545853L;
    private static final String PARAMETER_SCHEMA_LOCATION = "{urn:esr-vha-gov:internal:xslt:hl7-messages}schemaLocation";
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final ClassPathEntityResolver ENTITY_RESOLVER = new ClassPathEntityResolver();
    private static final ClassPathURIResolver URI_RESOLVER = new ClassPathURIResolver();
    private Templates templates = null;
    private String schemaLocation;
    private String xsltLocation;
    private ErrorHandler errorHandler = null;
    private String schemaLanguage = null;
    private String xmlSchema = null;
    private boolean preLoadTransformer = false;

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public String getXsltLocation() {
        return this.xsltLocation;
    }

    public void setXsltLocation(String xsltLocation) {
        this.xsltLocation = xsltLocation;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    public String getXmlSchema() {
        return this.xmlSchema;
    }

    public void setXmlSchema(String xmlSchema) {
        this.xmlSchema = xmlSchema;
    }

    public boolean isPreLoadTransformer() {
        return this.preLoadTransformer;
    }

    public void setPreLoadTransformer(boolean preLoadTransformer) {
        this.preLoadTransformer = preLoadTransformer;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.isPreLoadTransformer()) {
            this.templates = this.getTemplates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String build(String input) throws BuilderException {
        Validate.notNull((Object)input, (String)"input must be a non-null string");
        String transformedString = null;
        StopWatchLogger watch = null;
        if (this.logger.isDebugEnabled() && (watch = new StopWatchLogger(ClassUtils.getShortClassName(((Object)((Object)this)).getClass()) + ".format")) != null) {
            watch.start();
        }
        try {
            DocumentFactory factory;
            DocumentFactory documentFactory = factory = DocumentFactory.getInstance();
            synchronized (documentFactory) {
                Document document = factory.createDocument();
                Namespace namespace = new Namespace("", "Message");
                Element root = factory.createElement(new QName("message", namespace));
                root.setText(input);
                document.setRootElement(root);
                Transformer transformer = this.getTemplates().newTransformer();
                transformer.setParameter(PARAMETER_SCHEMA_LOCATION, this.schemaLocation);
                StringWriter writer = new StringWriter();
                transformer.transform(new StreamSource(new StringReader(document.asXML())), new StreamResult(writer));
                transformedString = writer.toString();
            }
            this.validate(transformedString);
        }
        catch (TransformerException e) {
            throw new BuilderException("Failed to transform the message", (Throwable)e);
        }
        catch (ValidatorException ve) {
            BuilderException be = new BuilderException("Failed to validate the xml document", (Throwable)ve);
            be.setData(transformedString);
            throw be;
        }
        if (this.logger.isDebugEnabled() && watch != null) {
            watch.stopAndLog("Total time to format " + this.getBeanName());
        }
        return transformedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(Object input) throws ValidatorException {
        if (input instanceof String) {
            try {
                XMLReader reader;
                XMLReader xMLReader = reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                synchronized (xMLReader) {
                    reader.setEntityResolver(ENTITY_RESOLVER);
                    reader.setFeature("http://xml.org/sax/features/namespaces", true);
                    reader.setFeature("http://xml.org/sax/features/validation", true);
                    reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                    reader.setProperty(this.getSchemaLanguage(), this.getXmlSchema());
                    reader.setErrorHandler(this.errorHandler);
                    reader.parse(new InputSource(new StringReader((String)input)));
                }
            }
            catch (SAXException e) {
                throw new ValidatorException("Failed to validate the xml document", (Throwable)e);
            }
            catch (IOException e) {
                throw new ValidatorException("Failed to load the schema", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Templates getTemplates() throws TransformerConfigurationException {
        if (this.templates == null) {
            InputStream istream = null;
            XmlFormatter xmlFormatter = this;
            synchronized (xmlFormatter) {
                try {
                    ClassPathResource xslt = new ClassPathResource(this.getXsltLocation());
                    istream = xslt.getInputStream();
                    this.templates = TRANSFORMER_FACTORY.newTemplates(new StreamSource(new BufferedInputStream(istream)));
                }
                catch (IOException e) {
                    throw new TransformerConfigurationException("Failed to get a template", e);
                }
            }
        }
        return this.templates;
    }

    static {
        TRANSFORMER_FACTORY.setURIResolver(URI_RESOLVER);
    }
}

