/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.messaging.xml;

import gov.va.med.esr.messaging.xml.HL7MessageException;
import gov.va.med.fw.service.AbstractComponent;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class HL7MessageErrorHandler
extends AbstractComponent
implements ErrorHandler {
    private static final String ignorableErrorPattern_enumeration = "cvc-enumeration-valid: Value '.*' is not facet-valid with respect to enumeration '\\[.*\\]'\\. It must be a value from the enumeration\\.";
    private static final String ignorableErrorPattern_datatype = "cvc-datatype-valid\\.1\\.2\\.2: '.*' is not a valid value of list type '.*'\\.";
    private static final String invalidValuePattern_generic = "cvc-type.3.1.3: The value '.*' of element '([a-zA-Z0-9]+(?:\\.[0-9]+)?)' is not valid\\.";
    private static final String invalidValuePattern_valueConstraint = "cvc-elt\\.5\\.2\\.2\\.2\\.2: The value '.*' of element '([a-zA-Z0-9]+(?:\\.[0-9]+)?)' does not match the \\{value constraint\\} value '(.*)'\\.";
    private static final String missingAttributePattern = "cvc-complex-type\\.4: Attribute '([a-zA-Z0-9]+)' must appear on element '[a-zA-Z0-9]+'\\.";
    private static final String missingElementPattern = "cvc-complex-type\\.2\\.4\\.a: Invalid content was found starting with element '[a-zA-Z0-9]+(?:\\.[0-9]+)?'\\. One of '\\{\"urn:esr-vha-gov:internal:hl7-messages\":([a-zA-Z0-9]+(?:\\.[0-9]+)?)(?:, \"urn:esr-vha-gov:internal:hl7-messages\":([a-zA-Z0-9]+(?:\\.[0-9]+)?))*\\}' is expected\\.";
    private MessageSource messageSource;
    private Set knownSegments;

    public Set getKnownSegments() {
        return this.knownSegments;
    }

    public void setKnownSegments(Set knownSegments) {
        this.knownSegments = knownSegments;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (!this.shouldIgnore(e)) {
            this.processInvalidValuePatternMatch(e);
            this.processMissingAttributePatternMatch(e);
            this.processMissingElementPatternMatch(e);
            this.processDefaultException(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw new HL7MessageException(e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        throw new HL7MessageException(e);
    }

    private boolean isSegment(String elementName) {
        return this.knownSegments != null && this.knownSegments.contains(elementName);
    }

    private String getMessage(String code) {
        return this.messageSource.getMessage(code, null, Locale.getDefault());
    }

    private String getMessage(String code, Object[] args) {
        return this.messageSource.getMessage(code, args, Locale.getDefault());
    }

    private void processDefaultException(SAXParseException e) throws SAXException {
        throw new HL7MessageException(this.getMessage("DEFAULT_MESSAGE"), e);
    }

    private void processInvalidValuePatternMatch(SAXParseException e) throws SAXException {
        Matcher matcher;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Testing for an invalid value pattern match");
            this.logger.debug((Object)"Pattern: cvc-type.3.1.3: The value '.*' of element '([a-zA-Z0-9]+(?:\\.[0-9]+)?)' is not valid\\.");
            this.logger.debug((Object)("Message: " + e.getMessage()));
        }
        if ((matcher = Pattern.compile(invalidValuePattern_generic).matcher(e.getMessage())).matches()) {
            String valueName = matcher.group(1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MATCH: Invalid value = " + valueName));
            }
            if (valueName != null) {
                try {
                    String errorMessage = this.getMessage("INVALID_" + valueName.toUpperCase() + "_VALUE");
                    throw new HL7MessageException(errorMessage, e);
                }
                catch (NoSuchMessageException nsme) {
                    String errorMessage = this.getMessage("DEFAULT_INVALID_VALUE_WITH_FIELD", new Object[]{valueName});
                    throw new HL7MessageException(errorMessage, e);
                }
            }
            String errorMessage = this.getMessage("DEFAULT_INVALID_VALUE");
            throw new HL7MessageException(errorMessage, e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Pattern: cvc-elt\\.5\\.2\\.2\\.2\\.2: The value '.*' of element '([a-zA-Z0-9]+(?:\\.[0-9]+)?)' does not match the \\{value constraint\\} value '(.*)'\\.");
            this.logger.debug((Object)("Message: " + e.getMessage()));
        }
        if ((matcher = Pattern.compile(invalidValuePattern_valueConstraint).matcher(e.getMessage())).matches()) {
            String valueName = matcher.group(1);
            String expectedValue = matcher.group(2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MATCH: Invalid value = " + valueName));
            }
            if ("hd.1".equals(valueName) && "MVR".equals(expectedValue)) {
                throw new HL7MessageException(this.getMessage("INVALID_MSH.3_VALUE"), e);
            }
            if ("hd.1".equals(valueName) && "EDB eGate".equals(expectedValue)) {
                throw new HL7MessageException(this.getMessage("INVALID_MSH.5_VALUE"), e);
            }
            if ("hd.1".equals(valueName) && "200".equals(expectedValue)) {
                throw new HL7MessageException(this.getMessage("INVALID_MSH.6_VALUE"), e);
            }
            String errorMessage = this.getMessage("DEFAULT_INVALID_VALUE");
            throw new HL7MessageException(errorMessage, e);
        }
    }

    private void processMissingAttributePatternMatch(SAXParseException e) throws SAXException {
        Matcher matcher;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Testing for missing attribute pattern match");
            this.logger.debug((Object)"Pattern: cvc-complex-type\\.4: Attribute '([a-zA-Z0-9]+)' must appear on element '[a-zA-Z0-9]+'\\.");
            this.logger.debug((Object)("Message: " + e.getMessage()));
        }
        if ((matcher = Pattern.compile(missingAttributePattern).matcher(e.getMessage())).matches()) {
            String attributeName = matcher.group(1);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("MATCH: Missing attribute = " + attributeName));
            }
            if ("fieldDelimiter".equals(attributeName)) {
                throw new HL7MessageException(this.getMessage("MISSING_FIELD_SEPARATOR"), e);
            }
            if ("componentDelimiter".equals(attributeName) || "subComponentDelimiter".equals(attributeName) || "repeatingFieldDelimiter".equals(attributeName) || "escapeCharacter".equals(attributeName)) {
                throw new HL7MessageException(this.getMessage("MISSING_ENCODING_CHARACTERS"), e);
            }
        }
    }

    private void processMissingElementPatternMatch(SAXParseException e) throws SAXException {
        Matcher matcher;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Testing for missing element pattern match");
            this.logger.debug((Object)"Pattern: cvc-complex-type\\.2\\.4\\.a: Invalid content was found starting with element '[a-zA-Z0-9]+(?:\\.[0-9]+)?'\\. One of '\\{\"urn:esr-vha-gov:internal:hl7-messages\":([a-zA-Z0-9]+(?:\\.[0-9]+)?)(?:, \"urn:esr-vha-gov:internal:hl7-messages\":([a-zA-Z0-9]+(?:\\.[0-9]+)?))*\\}' is expected\\.");
            this.logger.debug((Object)("Message: " + e.getMessage()));
        }
        if ((matcher = Pattern.compile(missingElementPattern).matcher(e.getMessage())).matches()) {
            for (int index = 1; index <= matcher.groupCount(); ++index) {
                String elementName = matcher.group(index);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("MATCH: Missing element = " + elementName));
                }
                if (elementName == null) continue;
                try {
                    String errorMessage = this.getMessage("MISSING_" + elementName.toUpperCase() + "_ELEMENT");
                    throw new HL7MessageException(errorMessage, e);
                }
                catch (NoSuchMessageException nsme) {
                    if (!this.isSegment(elementName)) continue;
                    String errorMessage = this.getMessage("DEFAULT_MISSING_SEGMENT");
                    throw new HL7MessageException(errorMessage, e);
                }
            }
            String errorMessage = this.getMessage("DEFAULT_MISSING_ELEMENT");
            throw new HL7MessageException(errorMessage, e);
        }
    }

    private boolean shouldIgnore(SAXParseException e) {
        String message;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Testing for an exception that can be ignored");
        }
        return this.shouldIgnore(ignorableErrorPattern_enumeration, message = e.getMessage()) || this.shouldIgnore(ignorableErrorPattern_datatype, message);
    }

    private boolean shouldIgnore(String pattern, String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Pattern: " + pattern));
            this.logger.debug((Object)("Message: " + message));
        }
        Matcher matcher = Pattern.compile(pattern).matcher(message);
        return matcher.matches();
    }
}

