/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.util;

import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.util.StringUtils;
import java.util.Set;

public class CommonNameHelper {
    public static Name getLegalName(Person person) {
        if (person == null) {
            return null;
        }
        Set names = person.getNames();
        if (names != null && names.size() > 0) {
            for (Name name : names) {
                String code;
                NameType type = name.getType();
                String string = code = type != null ? type.getCode() : null;
                if (!NameType.LEGAL_NAME.getName().equalsIgnoreCase(code)) continue;
                return name;
            }
        }
        return null;
    }

    public static String formatNameLastNameFirst(UserPrincipal principal) {
        String formattedName = CommonNameHelper.formatNameLastNameFirst(null, principal.getGivenName(), principal.getMiddleName(), principal.getFamilyName(), null);
        return StringUtils.isBlank((String)formattedName) ? principal.getName() : formattedName;
    }

    public static String formatNameLastNameFirst(Name name) {
        return CommonNameHelper.formatNameLastNameFirst(name.getPrefix(), name.getGivenName(), name.getMiddleName(), name.getFamilyName(), name.getSuffix());
    }

    public static String formatNameLastNameFirst(String prefix, String firstName, String middleName, String lastName, String suffix) {
        StringBuffer lastPart = new StringBuffer();
        CommonNameHelper.appendNamePiece(lastPart, lastName);
        CommonNameHelper.appendNamePiece(lastPart, suffix);
        StringBuffer firstPart = new StringBuffer();
        CommonNameHelper.appendNamePiece(firstPart, prefix);
        CommonNameHelper.appendNamePiece(firstPart, firstName);
        CommonNameHelper.appendNamePiece(firstPart, middleName);
        StringBuffer result = new StringBuffer(lastPart.toString());
        if (result.length() > 0 && firstPart.length() > 0) {
            result.append(", " + firstPart.toString());
        }
        return result.toString();
    }

    public static String formatNameFirstNameFirst(UserPrincipal principal) {
        String formattedName = CommonNameHelper.formatNameFirstNameFirst(null, principal.getGivenName(), principal.getMiddleName(), principal.getFamilyName(), null);
        return StringUtils.isBlank((String)formattedName) ? principal.getName() : formattedName;
    }

    public static String formatNameFirstNameFirst(Name name) {
        return CommonNameHelper.formatNameFirstNameFirst(name.getPrefix(), name.getGivenName(), name.getMiddleName(), name.getFamilyName(), name.getSuffix());
    }

    public static String formatNameFirstNameFirst(String prefix, String firstName, String middleName, String lastName, String suffix) {
        StringBuffer result = new StringBuffer();
        CommonNameHelper.appendNamePiece(result, prefix);
        CommonNameHelper.appendNamePiece(result, firstName);
        CommonNameHelper.appendNamePiece(result, middleName);
        CommonNameHelper.appendNamePiece(result, lastName);
        CommonNameHelper.appendNamePiece(result, suffix);
        return result.toString();
    }

    public static void appendNamePiece(StringBuffer buffer, String namePiece) {
        if (!StringUtils.isBlank((String)namePiece)) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(namePiece);
        }
    }
}

