/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.util;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.fw.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.time.DateUtils;

public class CommonDateUtils {
    public static final String MM = "MM";
    public static final String MMDD = "MM/dd";
    public static final String YYYY = "yyyy";
    public static final String MMYYYY = "MM/yyyy";
    public static final String MMDDYYYY = "MM/dd/yyyy";
    public static final String MMDDYYYYHHMM = "MM/dd/yyyy h:mma";
    public static final String MMDDYYYYHHMMSS = "MM/dd/yyyy h:mm:ssa";
    public static final String MMDDYYYYHHMM_EDIT = "MM/dd/yyyy HH:mm";
    public static final String MMDDYYYYHHMMSS_EDIT = "MM/dd/yyyy HH:mm:ss";
    private static final String PATTERN_MM = "([0-9]{1,2})()()()()()";
    private static final String PATTERN_MMDD = "([0-9]{1,2})/([0-9]{1,2})()()()()";
    private static final String PATTERN_YYYY = "()()([0-9]{4})()()()";
    private static final String PATTERN_MMYYYY = "([0-9]{1,2})/()([0-9]{4})()()()";
    private static final String PATTERN_MMDDYYYY = "([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})()()()";
    private static final String PATTERN_MMDDYYYYHHMM = "([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})\\s([0-9]{1,2}):([0-9]{1,2})()";
    private static final String PATTERN_MMDDYYYYHHMMSS = "([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})\\s([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})";
    private static final String[] IMPRECISE_DATE_PATTERNS = new String[]{"([0-9]{1,2})()()()()()", "([0-9]{1,2})/([0-9]{1,2})()()()()", "()()([0-9]{4})()()()", "([0-9]{1,2})/()([0-9]{4})()()()", "([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})()()()", "([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})\\s([0-9]{1,2}):([0-9]{1,2})()", "([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})\\s([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})"};
    private static final String[] PRECISE_DATE_PATTERNS = new String[]{"([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})()()()", "([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})\\s([0-9]{1,2}):([0-9]{1,2})()", "([0-9]{1,2})/([0-9]{1,2})/([0-9]{4})\\s([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})"};
    private static final int PATTERN_GROUP_MONTH = 1;
    private static final int PATTERN_GROUP_DAY = 2;
    private static final int PATTERN_GROUP_YEAR = 3;
    private static final int PATTERN_GROUP_HOUR = 4;
    private static final int PATTERN_GROUP_MINUTE = 5;
    private static final int PATTERN_GROUP_SECOND = 6;
    private static Integer YEAR_2009 = new Integer("2009");

    public static boolean isIncomeYear2009OrLatter(Integer incomeYear) {
        return incomeYear != null && incomeYear.compareTo(YEAR_2009) >= 0;
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isBlank((String)format)) {
            format = MMDDYYYY;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        sdf.setLenient(false);
        return sdf.format(date);
    }

    public static String formatWithTime(Date date, String format) {
        if (StringUtils.isBlank((String)format)) {
            format = MMDDYYYYHHMMSS;
        }
        return CommonDateUtils.format(date, format);
    }

    public static String format(ImpreciseDate date, String format) {
        String day;
        if (date == null) {
            return null;
        }
        if (date.isPrecise()) {
            return CommonDateUtils.format(date.getDate(), StringUtils.isEmpty((String)format) ? MMDDYYYY : format);
        }
        String string = date.getString();
        String year = string.substring(0, 4);
        String month = date.isMonthPrecise() ? string.substring(4, 6) : null;
        String string2 = day = date.isDayPrecise() ? string.substring(6, 8) : null;
        if (month != null) {
            if (day != null) {
                return month + "/" + day + "/" + year;
            }
            return month + "/" + year;
        }
        return year;
    }

    public static String formatWithTime(ImpreciseDate date, String format) {
        if (date == null) {
            return null;
        }
        if (date.isPrecise()) {
            return CommonDateUtils.formatWithTime(date.getDate(), format);
        }
        return CommonDateUtils.format(date, format);
    }

    public static String formatForDisplayWithTime(ImpreciseDate date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isBlank((String)format)) {
            format = date.isTimePresent() ? (date.isSecPresent() ? MMDDYYYYHHMMSS : MMDDYYYYHHMM) : MMDDYYYY;
        }
        return CommonDateUtils.formatWithTime(date, format);
    }

    public static String formatForEdit(ImpreciseDate date, String format) {
        if (date == null) {
            return null;
        }
        if (StringUtils.isBlank((String)format)) {
            format = date.isTimePresent() ? (date.isSecPresent() ? MMDDYYYYHHMMSS_EDIT : MMDDYYYYHHMM_EDIT) : MMDDYYYY;
        }
        return CommonDateUtils.formatWithTime(date, format);
    }

    public static String formatForEdit(Date date, String format) {
        if (StringUtils.isBlank((String)format)) {
            format = CommonDateUtils.isTimePresent(date) ? MMDDYYYYHHMM_EDIT : MMDDYYYY;
        }
        return CommonDateUtils.formatWithTime(date, format);
    }

    public static boolean isTimePresent(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(11) != 0 || cal.get(12) != 0 || cal.get(13) != 0;
    }

    public static boolean isDateBetween(Date dateToCheck, Date lowerDate, Date upperDate) {
        long upperTime;
        long lowTime;
        long checkTime = dateToCheck.getTime();
        if (lowerDate != null && checkTime < (lowTime = lowerDate.getTime())) {
            return false;
        }
        return upperDate == null || checkTime <= (upperTime = upperDate.getTime());
    }

    public static boolean isDateBetween(ImpreciseDate dateToCheck, ImpreciseDate lowerDate, ImpreciseDate upperDate) {
        if (lowerDate != null && dateToCheck.compareTo(lowerDate) < 0) {
            return false;
        }
        return upperDate == null || dateToCheck.compareTo(upperDate) <= 0;
    }

    public static boolean isDateAfter(ImpreciseDate dateToCheck, ImpreciseDate compareToDate) {
        return compareToDate != null && dateToCheck.compareTo(compareToDate) > 0;
    }

    public static boolean isDateBefore(ImpreciseDate dateToCheck, ImpreciseDate compareToDate) {
        return compareToDate != null && dateToCheck.compareTo(compareToDate) < 0;
    }

    public static ImpreciseDate getBeginningOfDay(ImpreciseDate date) {
        if (date == null) {
            return null;
        }
        Calendar beginDate = date.getCalendar();
        beginDate.set(11, 0);
        beginDate.set(12, 0);
        beginDate.set(13, 0);
        return new ImpreciseDate(beginDate);
    }

    public static ImpreciseDate getEndOfDay(ImpreciseDate date) {
        if (date == null) {
            return null;
        }
        Calendar endDate = date.getCalendar();
        endDate.set(11, 23);
        endDate.set(12, 59);
        endDate.set(13, 59);
        return new ImpreciseDate(endDate);
    }

    public static Date getDate(String dateString, boolean timePermitted) {
        if (StringUtils.isEmpty((String)dateString)) {
            return null;
        }
        Calendar calendar = CommonDateUtils.getCalendar(dateString, PRECISE_DATE_PATTERNS, false);
        if (!timePermitted && (calendar.isSet(11) || calendar.isSet(12))) {
            throw new IllegalArgumentException("The date can not contain hours or minutes: " + dateString);
        }
        return calendar.getTime();
    }

    public static Date getDate(String dateString) {
        return CommonDateUtils.getDate(dateString, false);
    }

    public static Long getDays(String fromDateString, String toDateString) {
        return CommonDateUtils.getDays(fromDateString, toDateString, false);
    }

    public static Long getDays(String fromDateString, String toDateString, boolean precise) {
        if (StringUtils.isEmpty((String)fromDateString)) {
            throw new IllegalArgumentException("The from date can not be null.");
        }
        if (StringUtils.isEmpty((String)toDateString)) {
            throw new IllegalArgumentException("The to date can not be null.");
        }
        ImpreciseDate fromDateImprecise = CommonDateUtils.getImpreciseDate(fromDateString);
        ImpreciseDate toDateImprecise = CommonDateUtils.getImpreciseDate(toDateString);
        return CommonDateUtils.getDays(fromDateImprecise, toDateImprecise, precise);
    }

    public static Long getDays(ImpreciseDate fromDate, ImpreciseDate toDate) {
        return CommonDateUtils.getDays(fromDate, toDate, false);
    }

    public static Long getDays(ImpreciseDate fromDate, ImpreciseDate toDate, boolean precise) {
        Validate.notNull((Object)fromDate, (String)"The from date can not be null.");
        Validate.notNull((Object)toDate, (String)"The to date can not be null.");
        if (precise && (fromDate.isImprecise() || toDate.isImprecise())) {
            return null;
        }
        Date fromDatePrecise = ImpreciseDateUtils.getDateWithDefault(fromDate);
        Date toDatePrecise = ImpreciseDateUtils.getDateWithDefault(toDate);
        return CommonDateUtils.getDays(fromDatePrecise, toDatePrecise);
    }

    public static Long getDays(Date fromDate, Date toDate) {
        if (toDate == null || fromDate == null) {
            return null;
        }
        GregorianCalendar fromCalenda = new GregorianCalendar();
        fromCalenda.setTime(fromDate);
        GregorianCalendar toCalendar = new GregorianCalendar();
        toCalendar.setTime(toDate);
        return CommonDateUtils.getDays(fromCalenda, toCalendar);
    }

    public static Long getDays(Calendar fromCalenda, Calendar toCalendar) {
        if (toCalendar == null || fromCalenda == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(fromCalenda.get(1), fromCalenda.get(2), fromCalenda.get(5));
        long fromDateMilliseconds = calendar.getTime().getTime();
        calendar.clear();
        calendar.set(toCalendar.get(1), toCalendar.get(2), toCalendar.get(5));
        long toDateMilliseconds = calendar.getTime().getTime();
        long msPerDay = 86400000L;
        long result = (toDateMilliseconds - fromDateMilliseconds) / msPerDay;
        return new Long(result + 1L);
    }

    public static ImpreciseDate getImpreciseDate(String dateString) {
        return CommonDateUtils.getImpreciseDate(dateString, false, false);
    }

    public static ImpreciseDate getImpreciseDate(String dateString, boolean timePermitted) {
        return CommonDateUtils.getImpreciseDate(dateString, timePermitted, false);
    }

    public static ImpreciseDate getImpreciseDate(String dateString, boolean timePermitted, boolean setCurrentYearAsDefault) {
        if (StringUtils.isEmpty((String)dateString)) {
            return null;
        }
        Calendar calendar = CommonDateUtils.getCalendar(dateString, IMPRECISE_DATE_PATTERNS, setCurrentYearAsDefault);
        ImpreciseDate returnDate = new ImpreciseDate(calendar);
        if (!timePermitted && returnDate.isTimePresent()) {
            throw new IllegalArgumentException("The imprecise date can not contain hours or minutes: " + dateString);
        }
        return returnDate;
    }

    private static Calendar getCalendar(String dateString, String[] datePatterns, boolean setCurrentYearAsDefault) {
        if (StringUtils.isEmpty((String)dateString)) {
            if (setCurrentYearAsDefault) {
                dateString = String.valueOf(CommonDateUtils.getCurrentYear());
            } else {
                return null;
            }
        }
        String trimmedDateString = dateString.trim();
        for (int i = 0; i < datePatterns.length; ++i) {
            String datePatternString = datePatterns[i];
            Matcher matcher = Pattern.compile(datePatternString).matcher(trimmedDateString);
            if (!matcher.matches()) continue;
            String year = matcher.group(3);
            String month = matcher.group(1);
            String day = matcher.group(2);
            String hour = matcher.group(4);
            String minute = matcher.group(5);
            String second = matcher.group(6);
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.clear();
            if (!StringUtils.isEmpty((String)year)) {
                calendar.set(1, CommonDateUtils.convertToInt(year));
            } else if (setCurrentYearAsDefault) {
                calendar.set(1, CommonDateUtils.getCurrentYear());
            }
            if (!StringUtils.isEmpty((String)month)) {
                calendar.set(2, CommonDateUtils.convertToInt(month) - 1);
            }
            if (!StringUtils.isEmpty((String)day)) {
                calendar.set(5, CommonDateUtils.convertToInt(day));
            }
            if (!StringUtils.isEmpty((String)hour)) {
                calendar.set(11, CommonDateUtils.convertToInt(hour));
            }
            if (!StringUtils.isEmpty((String)minute)) {
                calendar.set(12, CommonDateUtils.convertToInt(minute));
            }
            if (!StringUtils.isEmpty((String)second)) {
                calendar.set(13, CommonDateUtils.convertToInt(second));
            }
            return calendar;
        }
        throw new IllegalArgumentException("Invalid date format: " + dateString);
    }

    public static Date getDatePlusYears(String dateStr, int years) {
        ImpreciseDate impDate = CommonDateUtils.getImpreciseDate(dateStr);
        if (impDate == null) {
            return null;
        }
        Date date = ImpreciseDateUtils.getDateWithDefault(impDate);
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(date);
        cal.add(1, years);
        return cal.getTime();
    }

    public static int getCurrentYear() {
        return Calendar.getInstance().get(1);
    }

    public static Date getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        int day = calendar.get(5);
        calendar.clear();
        calendar.set(year, month, day);
        return calendar.getTime();
    }

    public static Date getCurrentDateTime() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            return DateUtils.isSameDay((Date)date1, (Date)date2);
        }
        return false;
    }

    private static int convertToInt(String string) {
        return new Integer(string);
    }
}

