/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.InsuranceInputData;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.service.InsuranceRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class InsuranceRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements InsuranceRuleService {
    private static final long serialVersionUID = 1089804822535342268L;
    private static final String POST_VOA_PROCESS = "POST_VOA_PROCESS";
    private String insuranceRuleParameters = null;
    private String processMedicaidFactorsRuleParameters = null;

    @Override
    public void manageMedicaidFactor(MedicaidFactor incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (incoming != null) {
            MedicaidFactor medicaidFactor = onFile.getMedicaidFactor();
            if (medicaidFactor == null) {
                medicaidFactor = new MedicaidFactor();
                onFile.setMedicaidFactor(medicaidFactor);
            }
            this.getMergeRuleService().mergeMedicaidFactor(incoming, medicaidFactor);
        } else {
            onFile.setMedicaidFactor(null);
        }
    }

    @Override
    public ValidationMessages manageInsurancePolicies(Set policies, Person onFile, VAFacility sendingFacility) throws ServiceException {
        return this.doProcessInsurancePolicies(policies, onFile, sendingFacility, "UI");
    }

    @Override
    public void processInsurancePolicies(Set policies, Person onFile, VAFacility sendingFacility) throws ServiceException {
        this.doProcessInsurancePolicies(policies, onFile, sendingFacility, null);
    }

    @Override
    public void postProcessVOASubmissions(Set policies, Person onFile, VAFacility sendingFacility) throws ServiceException {
        this.doProcessInsurancePolicies(policies, onFile, sendingFacility, POST_VOA_PROCESS);
    }

    @Override
    public void processMedicaidFactor(MedicaidFactor incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (incoming != null) {
            Person pristine = this.getPristinePerson(onFile);
            this.invokeRuleFlow(this.getRuleParameters(this.getProcessMedicaidFactorsRuleParameters()), (RuleDataAware)new PersonInputData(incoming.getPerson(), onFile, pristine, false));
        }
    }

    /*
     * Unable to fully structure code
     */
    private ValidationMessages doProcessInsurancePolicy(InsurancePolicy incoming, Person onFile, String caller, String validationMode, VAFacility sendingFacility) throws ServiceException {
        Validate.notNull((Object)onFile, (String)"A veteran on file must not be null");
        Validate.notNull((Object)incoming, (String)"An insurance policy must not be null");
        pristine = this.getPristinePerson(onFile);
        ruleService = this.getRuleValidationService();
        messages = ruleService.validateInsurancePolicy(incoming, onFile, pristine, "UI".equals(caller));
        if (messages != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
        v0 = this.getRuleParameters(this.getInsuranceRuleParameters());
        if ("UI".equals(caller)) ** GOTO lbl-1000
        if ("POST_VOA_PROCESS".equals(caller)) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = false;
        }
        messages = this.invokeRuleFlow(v0, (RuleDataAware)new InsuranceInputData(incoming, onFile, pristine, v1, sendingFacility), validationMode);
        return messages;
    }

    private ValidationMessages doProcessInsurancePolicy(InsurancePolicy incoming, Person onFile, String caller, VAFacility sendingFacility) throws ServiceException {
        return this.doProcessInsurancePolicy(incoming, onFile, caller, "ELIMINATION", sendingFacility);
    }

    private ValidationMessages doProcessInsurancePolicies(Set incoming, Person onFile, VAFacility sendingFacility, String caller) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        ValidationMessages messages = null;
        HashSet onFileInsurances = new HashSet(onFile.getInsurances());
        Set<VAFacility> reportSites = new HashSet<VAFacility>();
        if ("UI".equals(caller)) {
            reportSites.add(sendingFacility);
            Map incomingMap = this.getInsuranceMap(incoming);
            for (InsurancePolicy onFileInsPolicy : onFileInsurances) {
                if (!reportSites.contains((Object)onFileInsPolicy.getReportSite()) || incomingMap.get(onFileInsPolicy.getEntityKey()) != null) continue;
                onFile.removeInsurance(onFileInsPolicy);
            }
        } else {
            reportSites = this.getReportSites(incoming);
            if (reportSites.isEmpty()) {
                reportSites.add(sendingFacility);
            }
            for (InsurancePolicy onFileInsPolicy : onFileInsurances) {
                if (!reportSites.contains((Object)onFileInsPolicy.getReportSite()) || incoming != null && this.findMatchingElement((AbstractEntity)onFileInsPolicy, incoming) != null) continue;
                onFile.removeInsurance(onFileInsPolicy);
            }
        }
        if (incoming != null && !incoming.isEmpty()) {
            Map onFileMap = this.getInsuranceMap(onFile.getInsurances());
            for (InsurancePolicy policy : incoming) {
                if ("UI".equals(caller)) {
                    InsurancePolicy onFilePolicy;
                    String reportSite;
                    String string = reportSite = policy.getReportSite() != null ? policy.getReportSite().getStationNumber() : null;
                    if (!StringUtils.equals((String)reportSite, (String)VAFacility.CODE_HEC.getName()) && !VAFacility.CODE_MHV.getCode().equals(sendingFacility.getCode())) continue;
                    InsurancePolicy insurancePolicy = onFilePolicy = policy != null && policy.getEntityKey() != null ? (InsurancePolicy)onFileMap.get(policy.getEntityKey()) : null;
                    if (onFilePolicy != null && onFilePolicy.equals(policy)) continue;
                    messages = this.doProcessInsurancePolicy(policy, onFile, caller, "EXHAUSTIVE", sendingFacility);
                    continue;
                }
                messages = this.doProcessInsurancePolicy(policy, onFile, caller, sendingFacility);
            }
        }
        return messages;
    }

    private Set getReportSites(Set set) {
        HashSet<VAFacility> reportSites = new HashSet<VAFacility>();
        if (set != null) {
            for (InsurancePolicy policy : set) {
                reportSites.add(policy.getReportSite());
            }
        }
        return reportSites;
    }

    public String getInsuranceRuleParameters() {
        return this.insuranceRuleParameters;
    }

    public void setInsuranceRuleParameters(String insuranceRuleParameters) {
        this.insuranceRuleParameters = insuranceRuleParameters;
    }

    public String getProcessMedicaidFactorsRuleParameters() {
        return this.processMedicaidFactorsRuleParameters;
    }

    public void setProcessMedicaidFactorsRuleParameters(String processMedicaidFactorsRuleParameters) {
        this.processMedicaidFactorsRuleParameters = processMedicaidFactorsRuleParameters;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.insuranceRuleParameters, (String)"Insurance rule parameters property is required");
    }

    private Map getInsuranceMap(Set insurance) {
        HashMap<EntityKey, InsurancePolicy> map = new HashMap<EntityKey, InsurancePolicy>();
        if (insurance == null || insurance.isEmpty()) {
            return map;
        }
        for (InsurancePolicy insPolicy : insurance) {
            if (insPolicy.getEntityKey() == null) continue;
            map.put(insPolicy.getEntityKey(), insPolicy);
        }
        return map;
    }
}

