/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.rule.FinancialInput;
import gov.va.med.esr.common.rule.data.EEInputData;
import gov.va.med.esr.common.rule.data.FeeBasisInputData;
import gov.va.med.esr.common.rule.data.FinancialInputData;
import gov.va.med.esr.common.rule.data.PersonSignatureInputData;
import gov.va.med.esr.common.rule.service.FinancialInfoRuleService;
import gov.va.med.esr.common.rule.service.RuleValidationService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.esr.common.rule.service.impl.RuleValidationMessage;
import gov.va.med.esr.service.EEResultInfo;
import gov.va.med.esr.service.FinancialsHelperService;
import gov.va.med.esr.service.IVMFinancialInfo;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.trigger.TriggerEvent;
import gov.va.med.fw.service.trigger.TriggerRouter;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class FinancialInfoRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements FinancialInfoRuleService {
    private static final long serialVersionUID = -2012966224938820361L;
    private String financialInfoRuleParameters = null;
    private String determineIncTestFromEligRuleParameters = null;
    private String processPersonSignatureRuleParameters = null;
    private String feeBasisRuleParameters = null;
    private String processIVMFinancialsRuleParameters = null;
    private FinancialsHelperService financialsHelperService = null;
    private TriggerRouter triggerRouter = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.financialInfoRuleParameters, (String)"financialInfoRuleParameters property is required");
        Validate.notNull((Object)this.processPersonSignatureRuleParameters, (String)"processPersonSignatureRuleParameters property is required");
        Validate.notNull((Object)this.determineIncTestFromEligRuleParameters, (String)"determineIncTestFromEligRuleParameters property is required");
        Validate.notNull((Object)this.feeBasisRuleParameters, (String)"feeBasisRuleParameters property is required");
        Validate.notNull((Object)this.financialsHelperService, (String)"FinancialsHelperService property is required");
        Validate.notNull((Object)this.triggerRouter, (String)"TriggerRouter property is required");
    }

    public String getFinancialInfoRuleParameters() {
        return this.financialInfoRuleParameters;
    }

    public void setFinancialInfoRuleParameters(String incomeTestRuleParameters) {
        this.financialInfoRuleParameters = incomeTestRuleParameters;
    }

    public String getDetermineIncTestFromEligRuleParameters() {
        return this.determineIncTestFromEligRuleParameters;
    }

    public void setDetermineIncTestFromEligRuleParameters(String determineIncTestFromEligRuleParameters) {
        this.determineIncTestFromEligRuleParameters = determineIncTestFromEligRuleParameters;
    }

    public String getProcessPersonSignatureRuleParameters() {
        return this.processPersonSignatureRuleParameters;
    }

    public void setProcessPersonSignatureRuleParameters(String processPersonSignatureRuleParameters) {
        this.processPersonSignatureRuleParameters = processPersonSignatureRuleParameters;
    }

    public String getFeeBasisRuleParameters() {
        return this.feeBasisRuleParameters;
    }

    public void setFeeBasisRuleParameters(String feeBasisRuleParameters) {
        this.feeBasisRuleParameters = feeBasisRuleParameters;
    }

    public String getProcessIVMFinancialsRuleParameters() {
        return this.processIVMFinancialsRuleParameters;
    }

    public void setProcessIVMFinancialsRuleParameters(String processIVMFinancialsRuleParameters) {
        this.processIVMFinancialsRuleParameters = processIVMFinancialsRuleParameters;
    }

    public FinancialsHelperService getFinancialsHelperService() {
        return this.financialsHelperService;
    }

    public void setFinancialsHelperService(FinancialsHelperService financialsHelperService) {
        this.financialsHelperService = financialsHelperService;
    }

    public TriggerRouter getTriggerRouter() {
        return this.triggerRouter;
    }

    public void setTriggerRouter(TriggerRouter triggerRouter) {
        this.triggerRouter = triggerRouter;
    }

    @Override
    public Person processFinancialInfo(Integer incomeYear, VAFacility fromFacility, Person incoming, Person personOnFile) throws ServiceException {
        return this.processFinancialInfo(incomeYear, fromFacility, incoming, personOnFile, null);
    }

    @Override
    public Person processFinancialInfo(Integer incomeYear, VAFacility fromFacility, Person incoming, Person personOnFile, EEResultInfo info) throws ServiceException {
        return this.processFinancialInfo(incomeYear, fromFacility, incoming, personOnFile, info, false);
    }

    @Override
    public Person processIVMFinancials(Person incoming, Person onFile, IVMFinancialInfo ivmFinancialInfo) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null");
        Validate.notNull((Object)ivmFinancialInfo, (String)"IVM financial info must not be null");
        Validate.notNull((Object)ivmFinancialInfo.getIncomeYear(), (String)"income year must not be null");
        Person pristine = this.getPristinePerson(onFile);
        FinancialInputData inputData = new FinancialInputData(incoming, onFile, pristine, ivmFinancialInfo);
        RuleParameters ruleParams = this.getRuleParameters(this.getProcessIVMFinancialsRuleParameters());
        this.invokeRuleFlow(ruleParams, (RuleDataAware)inputData);
        return onFile;
    }

    @Override
    public Person processFinancialInfo(Integer incomeYear, VAFacility fromFacility, Person incoming, Person personOnFile, EEResultInfo info, boolean isDataFromZ07) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"Income year must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        Validate.notNull((Object)((Object)personOnFile), (String)"A current veteran must not be null");
        Validate.notNull((Object)((Object)fromFacility), (String)"A facility must not be null");
        Person pristine = this.getPristinePerson(personOnFile);
        FinancialInputData inputData = new FinancialInputData(incoming, personOnFile, pristine, incomeYear, fromFacility, false);
        RuleParameters ruleParams = this.getRuleParameters(this.getFinancialInfoRuleParameters());
        if (isDataFromZ07) {
            FinancialInput input = (FinancialInput)ruleParams.getRuleParameter("financialRuleParameter");
            input.setDataFromZ07(true);
        }
        if (VAFacility.CODE_MHV.getCode().equals(fromFacility.getCode())) {
            ((FinancialInput)ruleParams.getRuleParameter("financialRuleParameter")).setDeterminedPrimaryFlag(true);
        }
        this.invokeRuleFlow(ruleParams, (RuleDataAware)inputData);
        if (info != null) {
            info.setZ10Sent(inputData.isZ10Sent());
        }
        return personOnFile;
    }

    @Override
    public Person manageFinancialAssessment(Integer incomeYear, VAFacility fromFacility, Person incoming, Person personOnFile, EEResultInfo info) throws ServiceException {
        Validate.notNull((Object)((Object)personOnFile), (String)"A current veteran must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        Validate.notNull((Object)incomeYear, (String)"Income year must not be null");
        Person pristine = this.getPristinePerson(personOnFile);
        this.validateManageFinancialAssessment(incomeYear, incoming, personOnFile, pristine);
        FinancialInputData inputData = new FinancialInputData((Person)((Object)incoming.clone()), personOnFile, pristine, incomeYear, fromFacility, true);
        this.invokeRuleFlow(this.getRuleParameters(this.getFinancialInfoRuleParameters()), (RuleDataAware)inputData);
        if (info != null) {
            info.setZ10Sent(inputData.isZ10Sent());
        }
        return personOnFile;
    }

    @Override
    public Person manageFinancialAssessment(Integer incomeYear, VAFacility fromFacility, Person incoming, Person personOnFile) throws ServiceException {
        return this.manageFinancialAssessment(incomeYear, fromFacility, incoming, personOnFile, null);
    }

    @Override
    public Person manageSpouseInfo(Integer incomeYear, SpouseFinancials spouseFinancials, Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"Income year must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null");
        Validate.notNull((Object)((Object)spouseFinancials), (String)"Incoming spouse financials must not be null");
        FinancialStatement stmt = incoming.getFinancialStatement(incomeYear);
        FinancialStatement onFileStmt = onFile.getFinancialStatement(incomeYear);
        Validate.notNull((Object)((Object)spouseFinancials.getReportedOn()), (String)"Incoming spouse must not be null");
        ValidationMessages messages = this.getRuleValidationService().validateSpouseFinancials(incomeYear, spouseFinancials, incoming, onFile, true, true);
        if (messages != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
        if (onFileStmt == null) {
            onFileStmt = new FinancialStatement();
            onFileStmt.setIncomeYear(incomeYear);
            onFile.setFinancialStatement(incomeYear, onFileStmt);
        }
        this.getFinancialsHelperService().processSsn(spouseFinancials.getReportedOn());
        this.getMergeRuleService().mergeFinancialStatement(stmt, onFileStmt);
        Employment incomingEmployment = spouseFinancials.getReportedOn().getEmployment();
        Employment onFileEmployment = onFileStmt.getActiveSpouseFinancials() == null ? null : onFileStmt.getActiveSpouseFinancials().getReportedOn().getEmployment();
        this.getFinancialsHelperService().updateSpouseEmployment(incomingEmployment, onFileEmployment);
        this.getFinancialsHelperService().updatePseudoSsnClock(onFile, onFileStmt);
        this.triggerZ10(onFile);
        return onFile;
    }

    @Override
    public Person manageDependentFinancialInfo(Integer incomeYear, DependentFinancials dependentFinancials, Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"Income year must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"Incoming Person must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null");
        Validate.notNull((Object)((Object)dependentFinancials), (String)"Incoming dependent financials must not be null");
        Validate.notNull((Object)((Object)dependentFinancials.getReportedOn()), (String)"Incoming dependent must not be null");
        ValidationMessages messages = this.getRuleValidationService().validateDependentFinancials(incomeYear, dependentFinancials, incoming, onFile, true, true);
        if (messages != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
        FinancialStatement stmt = incoming.getFinancialStatement(incomeYear);
        FinancialStatement onFileStmt = onFile.getFinancialStatement(incomeYear);
        if (onFileStmt == null) {
            onFileStmt = new FinancialStatement();
            onFileStmt.setIncomeYear(incomeYear);
            onFile.setFinancialStatement(incomeYear, onFileStmt);
        }
        this.getFinancialsHelperService().processSsn(dependentFinancials.getReportedOn());
        this.getMergeRuleService().mergeFinancialStatement(stmt, onFileStmt);
        this.getFinancialsHelperService().updatePseudoSsnClock(onFile, onFileStmt);
        this.triggerZ10(onFile);
        return onFile;
    }

    @Override
    public Person managePendingAdjudicationStatus(Integer incomeYear, Person incoming, Person onFile, MeansTestStatus status) throws ServiceException {
        IncomeTest currentTest = onFile.getIncomeTest(incomeYear);
        if (currentTest != null) {
            this.financialsHelperService.adjudicateIncomeTest(currentTest, status);
        }
        return onFile;
    }

    public Person determineIncomeTestFromElig(Person incoming, Person onFile, Person pristine) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A current person must not be null");
        Validate.notNull((Object)((Object)pristine), (String)"A pristine person must not be null");
        EEInputData data = new EEInputData(incoming, onFile, pristine, false);
        this.invokeRuleFlow(this.getRuleParameters(this.getDetermineIncTestFromEligRuleParameters()), (RuleDataAware)data);
        return onFile;
    }

    @Override
    public Person determineIncomeTestFromElig(Person incoming, Person onFile, Person pristine, EnrollmentDetermination result) throws ServiceException {
        return this.determineIncomeTestFromElig(incoming, onFile, pristine, result, false, null);
    }

    @Override
    public Person determineIncomeTestFromElig(Person incoming, Person onFile, Person pristine, EnrollmentDetermination result, boolean isFromGUI, VAFacility sendingFacility) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A current person must not be null");
        Validate.notNull((Object)((Object)pristine), (String)"A pristine person must not be null");
        Validate.notNull((Object)((Object)result), (String)"An enrollment determination must not be null");
        EEInputData data = new EEInputData(incoming, onFile, pristine, result, isFromGUI, false, sendingFacility);
        data.setResultEnrollmentDetermination(result);
        this.invokeRuleFlow(this.getRuleParameters(this.getDetermineIncTestFromEligRuleParameters()), (RuleDataAware)data);
        return onFile;
    }

    @Override
    public SignatureImage managePersonSignature(SignatureImage signatureImage, Person onFile, String dfn) throws ServiceException {
        return this.doProcessPersonSignature(signatureImage, onFile, true, dfn);
    }

    @Override
    public Person managePersonSignatures(Set signatures, Person onFile, Map dfns) throws ServiceException {
        return this.doProcessPersonSignatures(signatures, onFile, true, dfns);
    }

    @Override
    public SignatureImage processPersonSignature(SignatureImage signatureImage, Person onFile, String dfn) throws ServiceException {
        return this.doProcessPersonSignature(signatureImage, onFile, false, dfn);
    }

    @Override
    public Person processPersonSignatures(Set signatures, Person onFile, Map dfns) throws ServiceException {
        return this.doProcessPersonSignatures(signatures, onFile, false, dfns);
    }

    private void validateManageFinancialAssessment(Integer incomeYear, Person incoming, Person onFile, Person pristine) throws ServiceException {
        if (incoming.getIncomeTest(incomeYear) != null && incoming.getFinancialStatement(incomeYear) != null) {
            FinancialStatement incomingStmt = incoming.getFinancialStatement(incomeYear);
            ValidationMessages messages = new ValidationMessages();
            RuleValidationService ruleValidationService = this.getRuleValidationService();
            messages.add(ruleValidationService.validateVeteranFinancials(incomeYear, incoming, onFile, pristine, false, true));
            if (this.isIncomeTestAddedEdited(messages)) {
                SpouseFinancials spouseFinancials = incomingStmt.getActiveSpouseFinancials();
                if (spouseFinancials != null) {
                    ValidationMessages valMsgs = ruleValidationService.validateSpouseFinancials(incomeYear, spouseFinancials, incoming, onFile, false, true);
                    messages.add(valMsgs, String.valueOf(spouseFinancials.hashCode()));
                }
                for (DependentFinancials dependentFinancials : incomingStmt.getDependentFinancials()) {
                    ValidationMessages valMsgs = ruleValidationService.validateDependentFinancials(incomeYear, dependentFinancials, incoming, onFile, false, true);
                    messages.add(valMsgs, String.valueOf(dependentFinancials.hashCode()));
                }
            }
            if (messages != null && !messages.isEmpty()) {
                throw new ValidationServiceException(messages);
            }
        }
    }

    private boolean isIncomeTestAddedEdited(ValidationMessages messages) {
        Iterator iter = messages.get();
        while (iter.hasNext()) {
            ValidationMessage message = (ValidationMessage)iter.next();
            String msgKey = message.getKey();
            if (!RuleValidationMessage.INCOME_TEST_CANNOT_BE_ADDED.getName().equals(msgKey) && !RuleValidationMessage.INCOME_TEST_CANNOT_BE_EDITED.getName().equals(msgKey) && !RuleValidationMessage.INCOME_TEST_CANNOT_BE_ADDED_OR_EDITED.getName().equals(msgKey)) continue;
            return false;
        }
        return true;
    }

    private SignatureImage doProcessPersonSignature(SignatureImage signatureImage, Person onFile, boolean isDataFromGUI, String dfn) throws ServiceException {
        Validate.notNull((Object)signatureImage, (String)"A signature image must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null");
        Person pristine = this.getPristinePerson(onFile);
        Person incoming = signatureImage.getPerson();
        PersonSignatureInputData data = new PersonSignatureInputData(incoming, onFile, pristine, signatureImage, isDataFromGUI);
        data.setDfn(dfn);
        this.invokeRuleFlow(this.getRuleParameters(this.getProcessPersonSignatureRuleParameters()), (RuleDataAware)data);
        SignatureImage processed = (SignatureImage)this.findMatchingElement((AbstractEntity)signatureImage, onFile.getSignatureImages());
        return processed;
    }

    private Person doProcessPersonSignatures(Set signatures, Person onFile, boolean isDataFromGUI, Map dfns) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        HashSet<SignatureImage> updatedSignatures = new HashSet<SignatureImage>();
        if (signatures == null || signatures.size() == 0) {
            onFile.removeAllSignatureImages();
        } else {
            for (SignatureImage signatureImage : signatures) {
                String dfn = dfns != null ? (String)dfns.get((Object)signatureImage.getSiteSubmittingImage()) : null;
                SignatureImage processed = isDataFromGUI ? this.managePersonSignature(signatureImage, onFile, dfn) : this.processPersonSignature(signatureImage, onFile, dfn);
                if (processed == null) continue;
                updatedSignatures.add(processed);
            }
            onFile.removeAllSignatureImages();
            Iterator i = updatedSignatures.iterator();
            while (i.hasNext()) {
                onFile.addSignatureImage((SignatureImage)i.next());
            }
        }
        return onFile;
    }

    @Override
    public Person processFeeBasis(VAFacility fromFacility, Person incomingPerson, Person personOnFile, boolean isDataFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)fromFacility), (String)"A facility must not be null");
        Validate.notNull((Object)((Object)incomingPerson), (String)"Incoming Person must not be null");
        Validate.notNull((Object)((Object)personOnFile), (String)"A current veteran must not be null");
        Person pristinePerson = this.getPristinePerson(personOnFile);
        Set onFileFeeBasis = personOnFile.getFeeBasis(fromFacility);
        Set incomingFeeBasis = incomingPerson.getFeeBasis(fromFacility);
        for (FeeBasis onFile : onFileFeeBasis) {
            if (this.findMatchingElement((AbstractEntity)onFile, incomingFeeBasis) != null) continue;
            personOnFile.removeFeeBasis(onFile);
        }
        for (FeeBasis incoming : incomingFeeBasis) {
            FeeBasis onFile = (FeeBasis)this.findMatchingElement((AbstractEntity)incoming, onFileFeeBasis);
            FeeBasisInputData inputData = new FeeBasisInputData(incomingPerson, personOnFile, pristinePerson, fromFacility, incoming, onFile, isDataFromGUI);
            this.invokeRuleFlow(this.getRuleParameters(this.getFeeBasisRuleParameters()), (RuleDataAware)inputData);
        }
        return personOnFile;
    }

    private void triggerZ10(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"Person can not be null");
        IncomeTest currentIncomeTest = this.getFinancialsHelperService().getCurrentIncomeTest(person);
        if (currentIncomeTest != null) {
            Integer incomeYear = currentIncomeTest.getIncomeYear();
            IncomeTestSource incomeTestSource = currentIncomeTest.getSource();
            if (!(incomeYear == null || incomeTestSource != null && StringUtils.equals((String)IncomeTestSource.CODE_IVM.getCode(), (String)incomeTestSource.getCode()))) {
                IncomeYearTriggerEvent incomeEvent = IncomeYearTriggerEvent.notifyVistaForFinancial(incomeYear);
                incomeEvent.setPersonId(person.getPersonEntityKey());
                incomeEvent.setIdentityTraits(person.getIdentityTraits());
                this.triggerRouter.processTriggerEvent((TriggerEvent)incomeEvent);
            }
        }
    }
}

