/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.ConsistencyCheckInputData;
import gov.va.med.esr.common.rule.service.ConsistencyCheckException;
import gov.va.med.esr.common.rule.service.ConsistencyCheckRuleService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.model.lookup.SeverityType;
import gov.va.med.fw.rule.AbstractRuleValidationService;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.rule.SimpleValidatableRule;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.Validatable;
import gov.va.med.fw.validation.ValidationFieldMessage;
import gov.va.med.fw.validation.ValidationMessages;
import java.util.Iterator;
import org.apache.commons.lang.Validate;

public class ConsistencyCheckRuleServiceImpl
extends AbstractRuleValidationService
implements ConsistencyCheckRuleService {
    private static final long serialVersionUID = 4602943090051490156L;
    private LookupService lookupService;
    private String consistencyCheckRuleParameters;

    @Override
    public void processConsistencyChecksForMessage(Person person, PersonTriggerEvent triggerEvent, Message message, MessageType.Code type) throws ServiceException {
        this.executeConsistencyChecks(person, triggerEvent, message, type);
    }

    @Override
    public void processConsistencyChecksForOutboundZ04(Person person, PersonTriggerEvent triggerEvent, Message message) throws ServiceException {
        this.executeConsistencyChecks(person, triggerEvent, message, MessageType.CODE_ORUZ04_TO_SITE);
    }

    @Override
    public void processConsistencyChecksForOutboundZ05(Person person, PersonTriggerEvent triggerEvent, Message message) throws ServiceException {
        this.executeConsistencyChecks(person, triggerEvent, message, MessageType.CODE_ORUZ05_TO_SITE);
    }

    @Override
    public void processConsistencyChecksForOutboundZ06(Person person, PersonTriggerEvent triggerEvent, Message message) throws ServiceException {
        this.executeConsistencyChecks(person, triggerEvent, message, MessageType.CODE_ORUZ06_TO_SITE);
    }

    @Override
    public void processConsistencyChecksForOutboundZ10(Person person, PersonTriggerEvent triggerEvent, Message message) throws ServiceException {
        this.executeConsistencyChecks(person, triggerEvent, message, MessageType.CODE_ORUZ10_TO_SITE);
    }

    private MessageType getMessageType(MessageType.Code messageTypeCode) throws ServiceException {
        return this.getLookupService().getMessageTypeByCode(messageTypeCode.getCode());
    }

    @Override
    public void processConsistencyChecksForOutboundZ11(Person person, PersonTriggerEvent triggerEvent, Message message) throws ServiceException {
        this.executeConsistencyChecks(person, triggerEvent, message, MessageType.CODE_ORUZ11_TO_SITE);
    }

    private void executeConsistencyChecks(Person person, PersonTriggerEvent triggerEvent, Message message, MessageType.Code messageTypeCode) throws ServiceException {
        this.executeConsistencyChecks(person, triggerEvent, message, this.getMessageType(messageTypeCode));
    }

    private void executeConsistencyChecks(Person person, PersonTriggerEvent triggerEvent, Message message, MessageType messageType) throws ServiceException {
        Validate.notNull((Object)((Object)messageType), (String)"MessageType can not be null");
        ConsistencyCheckInputData data = new ConsistencyCheckInputData(person, triggerEvent, message, messageType);
        RuleParameters params = this.getRuleParameters(this.consistencyCheckRuleParameters);
        ValidationMessages msgs = this.validate((Validatable)new SimpleValidatableRule("EXHAUSTIVE", params, (RuleDataAware)data));
        if (msgs != null && !msgs.isEmpty()) {
            ConsistencyCheckException e = new ConsistencyCheckException(msgs);
            ValidationFieldMessage msg = null;
            Iterator itr = msgs.get();
            while (itr.hasNext()) {
                msg = (ValidationFieldMessage)itr.next();
                if (!SeverityType.ERROR.equals((Object)msg.getSeverity())) continue;
                e.setBlocking(true);
                break;
            }
            throw e;
        }
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.consistencyCheckRuleParameters, (String)"consistencyCheckRuleParameters property is required");
        Validate.notNull((Object)this.lookupService, (String)"lookupService property is required");
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public String getConsistencyCheckRuleParameters() {
        return this.consistencyCheckRuleParameters;
    }

    public void setConsistencyCheckRuleParameters(String consistencyCheckRuleParameters) {
        this.consistencyCheckRuleParameters = consistencyCheckRuleParameters;
    }
}

