/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.rule.SpouseFinancialInput;
import gov.va.med.esr.common.rule.data.SpouseFinancialsInputData;
import gov.va.med.esr.common.rule.parameter.AbstractFinancialInputParameter;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;

public class SpouseFinancialInputParameter
extends AbstractFinancialInputParameter
implements SpouseFinancialInput {
    private static final long serialVersionUID = -5654960855600888352L;

    @Override
    public boolean isDemographicUpdate() {
        return this.getSpouseFinancialInputData() != null ? this.getSpouseFinancialInputData().isDemographicUpdate() : false;
    }

    @Override
    public BigDecimal getAssetAmount(AssetType.Code expenseType) {
        BigDecimal amount = this.getAssetAmount(this.getIncomingSpouseFinancials(), expenseType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    @Override
    public BigDecimal getIncomeAmount(IncomeType.Code expenseType) {
        BigDecimal amount = this.getIncomeAmount(this.getIncomingSpouseFinancials(), expenseType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    @Override
    public BigDecimal getExpenseAmount(ExpenseType.Code expenseType) {
        BigDecimal amount = this.getExpenseAmount(this.getIncomingSpouseFinancials(), expenseType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    @Override
    public BigDecimal getDebtAmount() {
        SpouseFinancials spouseFinancials = this.getIncomingSpouseFinancials();
        return spouseFinancials != null && spouseFinancials.getDebt() != null ? spouseFinancials.getDebt().getAmount() : new BigDecimal(0.0);
    }

    @Override
    public BigDecimal getSpousalContributionAmount() {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        return stmt != null && stmt.getContributionToSpouse() != null ? stmt.getContributionToSpouse() : new BigDecimal(0.0);
    }

    @Override
    public Boolean getContributedToSpouseInd() {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        if (stmt != null) {
            return stmt.getContributedToSpouseInd();
        }
        return null;
    }

    @Override
    public boolean isContributionInRange(double lower, double upper) {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        if (stmt != null && stmt.getContributionToSpouse() != null) {
            return this.isInRange(stmt.getContributionToSpouse(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isIncomeInRange(double lower, double upper) {
        SpouseFinancials spouseFinancials = this.getIncomingSpouseFinancials();
        if (spouseFinancials != null && spouseFinancials.getIncome() != null) {
            return this.isIncomeInRange(spouseFinancials.getIncome().values(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isExpenseInRange(double lower, double upper) {
        SpouseFinancials spouseFinancials = this.getIncomingSpouseFinancials();
        if (spouseFinancials != null && spouseFinancials.getExpenses() != null) {
            return this.isExpenseInRange(spouseFinancials.getExpenses().values(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isAssetInRange(double lower, double upper) {
        SpouseFinancials spouseFinancials = this.getIncomingSpouseFinancials();
        if (spouseFinancials != null && spouseFinancials.getAssets() != null) {
            return this.isAssetInRange(spouseFinancials.getAssets().values(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isDebtInRange(double lower, double upper) {
        return this.isInRange(this.getDebtAmount(), lower, upper);
    }

    @Override
    public String getSpouseGivenName() {
        String givenName = this.getRelationGivenName(this.getSpouse());
        return StringUtils.isNotEmpty((String)givenName) ? givenName : null;
    }

    @Override
    public String getSpouseFamilyName() {
        String familyName = this.getRelationFamilyName(this.getSpouse());
        return StringUtils.isNotEmpty((String)familyName) ? familyName : null;
    }

    @Override
    public Date getSpouseDateOfBirth() {
        return this.getRelationBirthDate(this.getSpouse());
    }

    @Override
    public String getSpouseSSN() {
        return this.getRelationSSN(this.getSpouse());
    }

    @Override
    public boolean isSpouseSSNUsed() {
        return this.isRelationSSNUsed(this.getIncomingSpouseFinancials());
    }

    @Override
    public boolean hasSpouseData() {
        return this.getSpouse() != null;
    }

    public boolean isFinancialInformationProvidedForSpouse() {
        return this.getIncomingSpouseFinancials() != null;
    }

    @Override
    public Boolean getSpouseLivesWithVeteran() {
        SpouseFinancials fianacial = this.getIncomingSpouseFinancials();
        return fianacial.getLivedWithPatient();
    }

    @Override
    public boolean isSpouseLivesWithVeteran() {
        SpouseFinancials spf = this.getIncomingSpouseFinancials();
        if (spf != null && spf.getLivedWithPatient() != null) {
            return spf.getLivedWithPatient();
        }
        return false;
    }

    @Override
    public Date getMarriageDate() {
        return this.getSpouse() != null ? ImpreciseDateUtils.getDateWithDefault(this.getSpouse().getMarriageDate()) : null;
    }

    @Override
    public Date getSpouseInactiveDate() {
        return this.getRelationInActiveDate(this.getSpouse());
    }

    private Spouse getSpouse() {
        SpouseFinancials sf = this.getIncomingSpouseFinancials();
        return sf != null ? sf.getReportedOn() : null;
    }

    protected SpouseFinancials getIncomingSpouseFinancials() {
        return this.getSpouseFinancialInputData().getIncomingSpouseFinancials();
    }

    protected SpouseFinancialsInputData getSpouseFinancialInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        return ruleDataAware instanceof SpouseFinancialsInputData ? (SpouseFinancialsInputData)ruleDataAware : null;
    }
}

