/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.batchprocess.SSASSNVerificationData;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.SSAMessage;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.persistent.person.SSNVerificationDetailDAO;
import gov.va.med.esr.common.rule.SSNVerificationResponseInput;
import gov.va.med.esr.common.rule.data.SSNVerificationResponseInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;

public class SSNVerificationResponseInputParameter
extends BaseParameter
implements SSNVerificationResponseInput {
    private static final long serialVersionUID = -4097456271790178726L;
    private String ssnVerificationDetailDAOName;
    private String genericDAOName;
    private static final int LAST_NAME_LENGTH = 13;
    private static final int FIRST_NAME_LENGTH = 10;
    private static final int MIDDLE_NAME_LENGTH = 7;
    private static final int WHOLE_LENGTH = -1;

    public SSNVerificationDetailDAO getSsnVerificationDetailDAO() throws ServiceException {
        return (SSNVerificationDetailDAO)this.getComponent(this.ssnVerificationDetailDAOName);
    }

    public void setSsnVerificationDetailDAOName(String ssnVerificationDetailDAOName) {
        this.ssnVerificationDetailDAOName = ssnVerificationDetailDAOName;
    }

    public DAOOperations getGenericDAO() throws ServiceException {
        return (DAOOperations)this.getComponent(this.genericDAOName);
    }

    public void setGenericDAOName(String genericDAOName) {
        this.genericDAOName = genericDAOName;
    }

    @Override
    public boolean isSSNVerificationForSpouseOrDependent() throws ServiceException {
        return ((SSASSNVerificationData)this.getIncomingData()).isSsnVerificationForSpouseOrDependent();
    }

    @Override
    public String getVerificationCode() {
        String verificationCode = ((SSASSNVerificationData)this.getIncomingData()).getVerificationCode();
        return StringUtils.isEmpty((String)verificationCode) ? null : verificationCode;
    }

    @Override
    public boolean isHECIdMatched() throws ServiceException {
        return ((SSASSNVerificationData)this.getIncomingData()).isHECInternalIdMatched();
    }

    @Override
    public void setVerificationStatus(String statusCode) throws ServiceException {
        if (this.getSSNVerificationInputData() != null) {
            SSAVerificationStatus verificationStatus = this.getLookupService().getSSAVerificationStatusByCode(statusCode);
            SSASSNVerificationData resultSSNVerificationData = this.getSSNVerificationInputData().getResultSSNVerificationData();
            resultSSNVerificationData.setSsaVerificationStatus(verificationStatus);
        }
    }

    @Override
    public void setSSAMessage(String ssaMessageCode) throws ServiceException {
        if (this.getSSNVerificationInputData() != null) {
            SSAMessage ssaMessage = this.getLookupService().getSSAMessageByCode(ssaMessageCode);
            SSASSNVerificationData resultSSNVerificationData = this.getSSNVerificationInputData().getResultSSNVerificationData();
            resultSSNVerificationData.setSsaMessage(ssaMessage);
        }
    }

    @Override
    public void addToSSNVerificationQueue() throws ServiceException {
        if (!this.isSSNVerificationForSpouseOrDependent()) {
            this.getHelperService().addToSSNVerificationQueue(this.getResultPerson());
        }
    }

    public Person getPersonForSpouseOrDependent() throws ServiceException {
        return this.getResultPerson();
    }

    @Override
    public void updateSSNVerificationResult() throws ServiceException {
        if (this.getSSNVerificationInputData() != null) {
            SSASSNVerificationData resultSSNVerification = this.getSSNVerificationInputData().getResultSSNVerificationData();
            if (this.isSSNVerificationForSpouseOrDependent()) {
                resultSSNVerification.setSsnVerificationForSpouseOrDependent(this.isSSNVerificationForSpouseOrDependent());
                resultSSNVerification.setSsnId(((SSASSNVerificationData)this.getIncomingData()).getSsnId());
            }
        }
    }

    private SSNVerificationResponseInputData getSSNVerificationInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof SSNVerificationResponseInputData) {
            return (SSNVerificationResponseInputData)ruleDataAware;
        }
        return null;
    }

    private Relation getRelation() {
        return this.getSSNVerificationInputData() != null ? this.getSSNVerificationInputData().getRelation() : null;
    }

    @Override
    public boolean isIdentityTraitsChanged() {
        boolean identityChanged = false;
        SSASSNVerificationData incomingSSNVerifData = (SSASSNVerificationData)this.getIncomingData();
        if (incomingSSNVerifData.isSsnVerificationForSpouseOrDependent()) {
            identityChanged = this.isSpouseOrDependentIdentityTraitsChanged(incomingSSNVerifData, this.getRelation());
        } else {
            Person person = this.getPristinePerson();
            identityChanged = this.isVeteranIdentityTraitsChanged(incomingSSNVerifData, person);
        }
        return identityChanged;
    }

    private boolean isVeteranIdentityTraitsChanged(SSASSNVerificationData sSNVerifData, Person person) {
        ImpreciseDate dob = person.getBirthRecord() != null ? person.getBirthRecord().getBirthDate() : null;
        return this.isIdentityTraitsChanged(person.getLegalName(), dob, person.getGender(), person.getOfficialSsn(), sSNVerifData);
    }

    private boolean isSpouseOrDependentIdentityTraitsChanged(SSASSNVerificationData sSNVerifData, Relation relation) {
        return relation != null ? this.isIdentityTraitsChanged(relation.getName(), relation.getDob(), relation.getGender(), relation.getOfficialSsn(), sSNVerifData) : false;
    }

    private boolean isIdentityTraitsChanged(Name name, ImpreciseDate dob, Gender gender, SSN ssn, SSASSNVerificationData sSNVerifData) {
        boolean identityChanged = false;
        if (!(SSNVerificationResponseInputParameter.equalsIgnoreCaseIgnoreBlanks(sSNVerifData.getFirstName(), name.getGivenName(), 10) && SSNVerificationResponseInputParameter.equalsIgnoreCaseIgnoreBlanks(sSNVerifData.getLastName(), name.getFamilyName(), 13) && SSNVerificationResponseInputParameter.equalsIgnoreCaseIgnoreBlanks(sSNVerifData.getMiddleInitial(), name.getMiddleName(), 7) && ImpreciseDateUtils.impreciseDatesEqualWithoutTime(sSNVerifData.getDateOfBirth(), dob) && SSNVerificationResponseInputParameter.equalsIgnoreCaseIgnoreBlanks(sSNVerifData.getGender(), gender != null ? gender.getCode() : null, -1) && SSNVerificationResponseInputParameter.equalsIgnoreCaseIgnoreBlanks(sSNVerifData.getSsn(), ssn.getSsnText(), -1))) {
            identityChanged = true;
        }
        return identityChanged;
    }

    public static boolean equalsIgnoreCaseIgnoreBlanks(String str1, String str2, int compareLength) {
        if (StringUtils.isBlank((String)str1) && StringUtils.isBlank((String)str2)) {
            return true;
        }
        String org1 = compareLength != -1 ? StringUtils.substring((String)str1, (int)0, (int)compareLength) : str1;
        String org2 = compareLength != -1 ? StringUtils.substring((String)str2, (int)0, (int)compareLength) : str2;
        return StringUtils.equalsIgnoreCase((String)org1, (String)org2);
    }
}

